/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.chart.util.ctk.StateAdapter;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import java.util.Vector;

public class ConstantStringToDoubleTransformStrategy
extends StateAdapter
implements StringToDoubleTransformStrategyInterface {
    protected double outputMin;
    protected double outputMax;
    protected String[] values;
    protected Vector valueVector = new Vector();
    protected boolean modified = true;
    protected double strideValue;

    @Override
    public double getValue(String in) {
        int index;
        int valueCount = this.valueVector.size();
        if (valueCount == 0) {
            return Double.NaN;
        }
        if (this.modified) {
            this.strideValue = (this.outputMax - this.outputMin) / (double)valueCount;
            this.modified = false;
        }
        return (index = this.valueVector.indexOf(in)) < 0 ? Double.NaN : (double)index * this.strideValue + this.outputMin + this.strideValue / 2.0;
    }

    @Override
    public void setValues(String[] values) {
        this.valueVector.removeAllElements();
        if (values != null) {
            for (int ii = 0; ii < values.length; ++ii) {
                if (values[ii] == null || this.valueVector.contains(values[ii])) continue;
                this.valueVector.addElement(values[ii]);
            }
        }
        this.values = values;
        this.update();
    }

    public String[] getValues() {
        return this.values;
    }

    @Override
    public void setOutputMin(double value) {
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        if (value != this.outputMin) {
            this.outputMin = value;
            this.update();
        }
    }

    @Override
    public void setOutputMax(double value) {
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        if (value != this.outputMax) {
            this.outputMax = value;
            this.update();
        }
    }

    @Override
    public double getOutputMin() {
        return this.outputMin;
    }

    @Override
    public double getOutputMax() {
        return this.outputMax;
    }

    protected void update() {
        this.modified = true;
        this.stateChanged();
    }
}

