/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.chart.util.ctk.CTKEventMulticaster;
import com.sas.graphics.chart.util.ctk.StateEvent;
import com.sas.graphics.chart.util.ctk.StateListener;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTickStrategyInterface;
import java.util.Vector;

public class ConstantDoubleTickStrategy
implements DoubleTickStrategyInterface {
    protected double min;
    protected double max;
    protected int numOfTicks;
    protected double[] values;
    protected Vector specialTicks;
    StateListener stateListeners;

    @Override
    public double[] getValues() {
        int count = this.getSize();
        int stSize = this.specialTicks == null ? 0 : this.specialTicks.size();
        this.values = new double[count + stSize];
        double xform = this.max - this.min;
        if (count >= 2) {
            for (int i = 0; i < count; ++i) {
                double ratio = (double)i / ((double)count - 1.0);
                this.values[i] = this.min + ratio * xform;
            }
        } else if (count == 1) {
            this.values[0] = xform / 2.0;
        }
        for (int ii = 0; ii < stSize; ++ii) {
            this.values[count + ii] = (Double)this.specialTicks.elementAt(ii);
        }
        return this.values;
    }

    @Override
    public void setMin(double value) {
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        if (this.min != value) {
            this.min = value;
            this.update();
        }
    }

    @Override
    public void setMax(double value) {
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        if (this.max != value) {
            this.max = value;
            this.update();
        }
    }

    @Override
    public void setTickCount(int num) {
        int n = num = num < 0 ? 1 : num;
        if (this.numOfTicks != num) {
            this.numOfTicks = num;
            this.update();
        }
    }

    @Override
    public int getSize() {
        return this.numOfTicks <= 0 ? 1 : this.numOfTicks;
    }

    @Override
    public double getValue(int ii) {
        if (ii < 0) {
            return Double.NaN;
        }
        if (this.values == null) {
            this.getValues();
        }
        if (this.values == null || this.values.length < ii) {
            return Double.NaN;
        }
        return this.values[ii];
    }

    public void update() {
        this.stateChanged();
    }

    public void addTick(double tick) {
        if (Double.isNaN(tick)) {
            return;
        }
        if (this.specialTicks == null) {
            this.specialTicks = new Vector();
        }
        this.specialTicks.addElement(new Double(tick));
    }

    public void removeTick(double tick) {
        if (Double.isNaN(tick)) {
            return;
        }
        if (this.specialTicks == null) {
            return;
        }
        Double tick2 = new Double(tick);
        if (this.specialTicks.contains(tick2)) {
            this.specialTicks.removeElement(tick2);
        }
    }

    @Override
    public void addStateListener(StateListener l) {
        if (l != null) {
            this.stateListeners = CTKEventMulticaster.addStateListener(this.stateListeners, l);
        }
    }

    @Override
    public void removeStateListener(StateListener l) {
        if (l != null) {
            this.stateListeners = CTKEventMulticaster.removeStateListener(this.stateListeners, l);
        }
    }

    protected void stateChanged() {
        if (this.stateListeners != null) {
            this.stateListeners.stateUpdate(new StateEvent(this));
        }
    }
}

