/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.Overlay;
import com.sas.graphics.chart.util.ctk.SingleDataSourceClientInterface;
import com.sas.graphics.chart.util.ctk.VariableRanger;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.TransformStrategyInterface;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.Variable;
import java.util.Hashtable;

public abstract class SingleDataOverlay
extends Overlay
implements SingleDataSourceClientInterface {
    DataSourceInterface dataSource;
    protected Hashtable analysisVars;
    protected Hashtable classifierVars;
    protected final Object DATA_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSourceInterface setDataSource(DataSourceInterface data) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (data == null) {
                this.detachData();
            } else if (this.isValidData(data)) {
                this.attachData(data);
            }
            return this.dataSource;
        }
    }

    @Override
    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    protected boolean attachData(DataSourceInterface data) {
        if (this.dataSource != null) {
            this.detachData();
        }
        this.dataSource = data;
        return true;
    }

    protected void detachData() {
        this.dataSource = null;
    }

    public abstract boolean isValidData(DataSourceInterface var1);

    @Override
    public String toString() {
        return "SingleDataOverlay :" + super.toString();
    }

    protected void setAnalysisVariable(Object id, Variable v) {
        if (v == null) {
            this.removeAnalysisVariable(id);
            return;
        }
        if (this.analysisVars == null) {
            this.analysisVars = new Hashtable();
        }
        this.analysisVars.put(id, v);
    }

    protected void setClassifierVariable(Object id, Variable v) {
        if (v == null) {
            this.removeClassifierVariable(id);
            return;
        }
        if (this.classifierVars == null) {
            this.classifierVars = new Hashtable();
        }
        this.classifierVars.put(id, v);
    }

    protected Variable getAnalysisVariable(Object id) {
        if (this.analysisVars == null) {
            return null;
        }
        return (Variable)this.analysisVars.get(id);
    }

    protected Variable getClassifierVariable(Object id) {
        if (this.classifierVars == null) {
            return null;
        }
        return (Variable)this.classifierVars.get(id);
    }

    protected Variable removeAnalysisVariable(Object id) {
        if (this.analysisVars == null) {
            return null;
        }
        return (Variable)this.analysisVars.remove(id);
    }

    protected Variable removeClassifierVariable(Object id) {
        if (this.classifierVars == null) {
            return null;
        }
        return (Variable)this.classifierVars.remove(id);
    }

    protected void removeAllAnalysisVariable() {
        if (this.analysisVars == null) {
            return;
        }
        this.analysisVars.clear();
    }

    protected void removeAllClassifierVariable() {
        if (this.classifierVars == null) {
            return;
        }
        this.classifierVars.clear();
    }

    protected Variable newContinuousAxisVariable(Object id, Hashtable axisMappers, TransformStrategyInterface axisTransformStrategy, VariableRanger axisRanger) {
        Variable variable = this.dataSource.getVtkVariable(id);
        this.setAnalysisVariable(id, variable);
        DoubleStrategyMapper mapper = (DoubleStrategyMapper)axisMappers.get(id);
        if (variable instanceof NumericVariable) {
            if (!(mapper instanceof DoubleToDoubleStrategyMapper)) {
                mapper = new DoubleToDoubleStrategyMapper();
            }
            ((DoubleToDoubleStrategyMapper)mapper).input.connectFrom(((NumericVariable)variable).value);
        } else if (variable instanceof StringVariable) {
            if (!(mapper instanceof StringToDoubleStrategyMapper)) {
                mapper = new StringToDoubleStrategyMapper();
            }
            ((StringToDoubleStrategyMapper)mapper).input.connectFrom(((StringVariable)variable).value);
        }
        if (mapper == null) {
            axisMappers.remove(id);
        } else {
            axisMappers.put(id, mapper);
            SingleDataOverlay.setMapperTransformStrategy(mapper, axisTransformStrategy);
        }
        if (axisRanger != null) {
            axisRanger.setVariable(id, variable);
        }
        return variable;
    }
}

