/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.util.vtk.AMap;
import com.sas.graphics.util.vtk.ASelectResult;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.MapDetail;
import com.sas.graphics.util.vtk.SelectEntry;
import java.util.Vector;

public class SelectInfo {
    private ASelectResult selectResult;
    private int elementIndex;
    private int valueIndex;
    private Object cachedUserData;
    private Element cachedElement;
    private Element cachedUserDataElement;
    private VisualizationComponentInterface target;

    public static Object newInstance(ASelectResult selectResult, int index) {
        SelectInfo si = new SelectInfo(selectResult, index);
        if (!si.cacheData()) {
            return null;
        }
        try {
            si.target = (VisualizationComponentInterface)si.getUserDataAt(index);
        }
        catch (ClassCastException e) {
            return null;
        }
        if (si.target == null) {
            return null;
        }
        return si;
    }

    private SelectInfo(ASelectResult selectResult, int index) {
        this.selectResult = selectResult;
        this.elementIndex = index;
    }

    public int getIndex() {
        return this.elementIndex;
    }

    public ASelectResult getSelectResult() {
        return this.selectResult;
    }

    public Object getUserData() {
        return this.cachedUserData;
    }

    public Element getElement() {
        return this.cachedElement;
    }

    public Element getUserDataElement() {
        return this.cachedUserDataElement;
    }

    private boolean cacheData() {
        this.valueIndex = this.selectResult.getValueIndex();
        Vector path = this.selectResult.getPath();
        int size = path.size();
        for (int ii = size - 1; ii >= 0; --ii) {
            Object userData;
            Element element = ((SelectEntry)path.elementAt(ii)).getElement();
            if (this.cachedElement == null) {
                this.cachedElement = element;
            }
            if ((userData = element.getUserData()) == null) continue;
            this.cachedUserData = userData;
            this.cachedUserDataElement = element;
            if (this.cachedElement instanceof AMap) {
                MapDetail detail = (MapDetail)this.selectResult.getDetail();
                this.valueIndex = detail.getFace();
            }
            return true;
        }
        return false;
    }

    private Element getElementAt(int index) {
        Vector path = this.selectResult.getPath();
        int size = path.size();
        if (size > index && index >= 0) {
            return ((SelectEntry)path.elementAt(index)).getElement();
        }
        return null;
    }

    private Object getUserDataAt(int index) {
        Element element = this.getElementAt(index);
        if (element != null) {
            return element.getUserData();
        }
        return null;
    }

    public VisualizationComponentInterface getTarget() {
        return this.target;
    }

    public int getValueIndex() {
        return this.valueIndex;
    }
}

