/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.TickStrategyEvent;
import com.sas.graphics.chart.util.ctk.TickStrategyListener;
import com.sas.graphics.chart.util.ctk.TickStrategySource;
import com.sas.graphics.chart.util.ctk.TwoAxisOverlay;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.TickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.TransformStrategyInterface;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AxisStyle;
import com.sas.graphics.util.vtk.NumericVectorVariable;
import com.sas.graphics.util.vtk.jxd.RectangularAxis;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReferenceLineOverlay
extends TwoAxisOverlay {
    protected RectangularAxis referenceLine;
    protected DoubleStrategyMapper dependentMapper;
    protected DoubleStrategyMapper independentMapper;
    protected DoubleStrategyMapper referenceLineMapper;
    protected DoubleStrategyMapper attachedAxisValueMapper;
    protected Color lineColor;
    protected boolean lineEnabled;
    protected boolean majorTicksEnabled;
    protected boolean valuesEnabled;
    protected NumericVectorVariable attachAtVariable;
    protected int attachTo;
    protected double attachAt;
    protected double referenceLineOrigin;
    protected double referenceLineExtent;
    protected TickStrategyInterface independentAxisTickStrategy;
    protected TickStrategyInterface dependentAxisTickStrategy;
    protected Hashtable tickStrategies;
    protected TickStrategyListener overlayTickStrategyListener;

    protected ReferenceLineOverlay() {
    }

    public static Object newInstance() {
        ReferenceLineOverlay o = new ReferenceLineOverlay();
        o.init();
        return o;
    }

    public static final ReferenceLineOverlay newReferenceLineOverlay() {
        return (ReferenceLineOverlay)ReferenceLineOverlay.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.attachAtVariable = new NumericVectorVariable();
        this.setLineColor(Color.black);
        this.setLineEnabled(true);
        this.setMajorTicksEnabled(false);
        this.setValuesEnabled(false);
        this.setAttachTo(1);
        this.setAttachAt(0.0);
    }

    @Override
    public boolean isValidData(DataSourceInterface data) {
        return true;
    }

    @Override
    protected void makeNetwork() {
        if (this.networkRoot != null) {
            this.composite.removeAllElements();
            if (this.referenceLine == null && this.visualizationGraphics != null) {
                this.referenceLine = this.visualizationGraphics.newRectangularAxis();
            }
            if (this.dependentMapper == null || this.independentMapper == null) {
                this.dependentMapper = ReferenceLineOverlay.newMapper(this.dependentAxisTransformStrategy, this.dependentAxisTickStrategy);
                this.independentMapper = ReferenceLineOverlay.newMapper(this.independentAxisTransformStrategy, this.independentAxisTickStrategy);
                this.setDependentAxisMapper(DEPENDENT_AXIS, this.dependentMapper);
                this.setIndependentAxisMapper(INDEPENDENT_AXIS, this.independentMapper);
            }
            if (this.referenceLine != null) {
                int attachedAxisOrientation;
                int orientation;
                AxisInterface dependentAxis = this.getDependentAxis();
                AxisInterface independentAxis = this.getIndependentAxis();
                if (this.attachTo == 1) {
                    this.referenceLineMapper = this.independentMapper;
                    orientation = independentAxis.getOrientation();
                    this.attachedAxisValueMapper = this.dependentMapper;
                    attachedAxisOrientation = dependentAxis.getOrientation();
                } else {
                    this.referenceLineMapper = this.dependentMapper;
                    orientation = dependentAxis.getOrientation();
                    this.attachedAxisValueMapper = this.independentMapper;
                    attachedAxisOrientation = independentAxis.getOrientation();
                }
                if (!(this.attachedAxisValueMapper instanceof DoubleToDoubleStrategyMapper)) {
                    return;
                }
                ((DoubleToDoubleStrategyMapper)this.attachedAxisValueMapper).input.connectFrom(this.attachAtVariable.value);
                switch (orientation) {
                    default: {
                        if (attachedAxisOrientation == 3) {
                            this.referenceLine.transform.translateY.setValue(this.origin.y);
                            this.referenceLine.transform.translateZ.connectFrom(this.attachedAxisValueMapper);
                        } else {
                            this.referenceLine.transform.translateZ.setValue(this.origin.z);
                            this.referenceLine.transform.translateY.connectFrom(this.attachedAxisValueMapper);
                        }
                        this.referenceLineOrigin = this.origin.x;
                        this.referenceLineExtent = this.extent.x;
                        break;
                    }
                    case 2: {
                        if (attachedAxisOrientation == 3) {
                            this.referenceLine.transform.translateX.setValue(this.origin.x);
                            this.referenceLine.transform.translateZ.connectFrom(this.attachedAxisValueMapper);
                        } else {
                            this.referenceLine.transform.translateZ.setValue(this.origin.z);
                            this.referenceLine.transform.translateX.connectFrom(this.attachedAxisValueMapper);
                        }
                        this.referenceLineOrigin = this.origin.y;
                        this.referenceLineExtent = this.extent.y;
                        break;
                    }
                    case 3: {
                        if (attachedAxisOrientation == 2) {
                            this.referenceLine.transform.translateX.setValue(this.origin.x);
                            this.referenceLine.transform.translateY.connectFrom(this.attachedAxisValueMapper);
                        } else {
                            this.referenceLine.transform.translateY.setValue(this.origin.y);
                            this.referenceLine.transform.translateX.connectFrom(this.attachedAxisValueMapper);
                        }
                        this.referenceLineOrigin = this.origin.z;
                        this.referenceLineExtent = this.extent.z;
                    }
                }
                this.referenceLine.setOrigin(this.referenceLineOrigin);
                this.referenceLine.setLength(this.referenceLineExtent);
                AxisStyle as = this.referenceLine.getStyle();
                as.setAxisLineColor(this.lineColor);
                if (this.majorTicksEnabled) {
                    this.referenceLine.labelOffset.connectFrom(this.referenceLineMapper.uniqueValue);
                } else {
                    this.referenceLine.labelOffset.disconnect();
                }
                if (this.valuesEnabled) {
                    this.referenceLine.labels.connectFrom(this.referenceLineMapper.label);
                } else {
                    this.referenceLine.labels.disconnect();
                }
            }
            this.composite.addElement(this.referenceLine);
        }
    }

    protected static DoubleStrategyMapper newMapper(TransformStrategyInterface transformStrategy, TickStrategyInterface tickStrategy) {
        DoubleStrategyMapper mapper = null;
        if (transformStrategy != null) {
            if (transformStrategy instanceof DoubleToDoubleTransformStrategyInterface) {
                mapper = new DoubleToDoubleStrategyMapper();
                ((DoubleToDoubleStrategyMapper)mapper).setTransformStrategy((DoubleToDoubleTransformStrategyInterface)transformStrategy);
                if (tickStrategy instanceof DoubleTickStrategyInterface) {
                    ((DoubleToDoubleStrategyMapper)mapper).setTickStrategy((DoubleTickStrategyInterface)tickStrategy);
                }
            } else if (transformStrategy instanceof StringToDoubleTransformStrategyInterface) {
                mapper = new StringToDoubleStrategyMapper();
                ((StringToDoubleStrategyMapper)mapper).setTransformStrategy((StringToDoubleTransformStrategyInterface)transformStrategy);
                if (tickStrategy instanceof StringTickStrategyInterface) {
                    ((StringToDoubleStrategyMapper)mapper).setTickStrategy((StringTickStrategyInterface)tickStrategy);
                }
            }
        }
        return mapper;
    }

    @Override
    protected void detachVisualizationGraphics() {
        this.referenceLine = null;
        super.detachVisualizationGraphics();
    }

    public void setMajorTicksEnabled(boolean b) {
        this.majorTicksEnabled = b;
    }

    public boolean getMajorTicksEnabled() {
        return this.majorTicksEnabled;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineEnabled(boolean b) {
        this.lineEnabled = b;
    }

    public boolean getLineEnabled() {
        return this.lineEnabled;
    }

    public void setValuesEnabled(boolean b) {
        this.valuesEnabled = b;
    }

    public boolean getValuesEnabled() {
        return this.valuesEnabled;
    }

    public void setAttachAt(double axisValue) {
        this.attachAt = axisValue;
        this.attachAtVariable.connectFrom(new double[]{this.attachAt});
    }

    public double getAttachAt() {
        return this.attachAt;
    }

    public void setAttachTo(int axisID) {
        switch (axisID) {
            case 0: 
            case 1: {
                this.attachTo = axisID;
            }
        }
    }

    public int getAttachTo() {
        return this.attachTo;
    }

    @Override
    public Vec3d getMaximumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return new Vec3d();
    }

    @Override
    public String toString() {
        return "ReferenceLineOverlay :" + super.toString();
    }

    @Override
    protected AxisInterface attachAxis(Object id, AxisInterface axis) {
        if ((axis = super.attachAxis(id, axis)) instanceof TickStrategySource) {
            if (this.overlayTickStrategyListener == null) {
                this.overlayTickStrategyListener = new OverlayTickStrategyListener();
            }
            ((TickStrategySource)((Object)axis)).addTickStrategyListener(this.overlayTickStrategyListener);
        }
        return axis;
    }

    @Override
    protected AxisInterface detachAxis(Object id) {
        AxisInterface axis = super.detachAxis(id);
        if (axis instanceof TickStrategySource && this.overlayTickStrategyListener != null) {
            ((TickStrategySource)((Object)axis)).removeTickStrategyListener(this.overlayTickStrategyListener);
        }
        return axis;
    }

    public TickStrategyInterface setTickStrategy(Object id, TickStrategyInterface xStrategy) {
        this.setTickStrategy2(id, xStrategy);
        if (id == INDEPENDENT_AXIS) {
            this.independentAxisTickStrategy = xStrategy;
            this.updateTickStrategyOnIndependentAxisMappers();
        } else if (id == DEPENDENT_AXIS) {
            this.dependentAxisTickStrategy = xStrategy;
            this.updateTickStrategyOnDependentAxisMappers();
        }
        return xStrategy;
    }

    public TickStrategyInterface setTickStrategy2(Object id, TickStrategyInterface tickStrategy) {
        if (id == null) {
            return null;
        }
        if (tickStrategy == null) {
            if (this.tickStrategies != null) {
                this.tickStrategies.remove(id);
            }
        } else {
            if (this.tickStrategies == null) {
                this.tickStrategies = new Hashtable();
            }
            this.tickStrategies.put(id, tickStrategy);
        }
        return tickStrategy;
    }

    protected static void setMapperTickStrategy(StrategyMapper mapper, TickStrategyInterface strategy) {
        if (mapper != null && strategy != null) {
            if (strategy instanceof DoubleTickStrategyInterface && mapper instanceof DoubleToDoubleStrategyMapper) {
                ((DoubleToDoubleStrategyMapper)mapper).setTickStrategy((DoubleTickStrategyInterface)strategy);
            } else if (strategy instanceof StringTickStrategyInterface && mapper instanceof StringToDoubleStrategyMapper) {
                ((StringToDoubleStrategyMapper)mapper).setTickStrategy((StringTickStrategyInterface)strategy);
            }
        }
    }

    public TickStrategyInterface getTickStrategy(Object id) {
        return this.tickStrategies != null ? (TickStrategyInterface)this.tickStrategies.get(id) : null;
    }

    @Override
    protected void setDependentAxisMapper(Object id, DoubleStrategyMapper mapper) {
        super.setDependentAxisMapper(id, mapper);
        ReferenceLineOverlay.setMapperTickStrategy(mapper, this.dependentAxisTickStrategy);
    }

    protected void updateTickStrategyOnDependentAxisMappers() {
        Enumeration keys = this.dependentAxisMappers.keys();
        while (keys.hasMoreElements()) {
            ReferenceLineOverlay.setMapperTickStrategy(this.getDependentAxisMapper(keys.nextElement()), this.dependentAxisTickStrategy);
        }
    }

    @Override
    protected void setIndependentAxisMapper(Object id, DoubleStrategyMapper mapper) {
        super.setIndependentAxisMapper(id, mapper);
        ReferenceLineOverlay.setMapperTickStrategy(mapper, this.independentAxisTickStrategy);
    }

    protected void updateTickStrategyOnIndependentAxisMappers() {
        Enumeration keys = this.independentAxisMappers.keys();
        while (keys.hasMoreElements()) {
            ReferenceLineOverlay.setMapperTickStrategy(this.getIndependentAxisMapper(keys.nextElement()), this.independentAxisTickStrategy);
        }
    }

    protected class OverlayTickStrategyListener
    implements TickStrategyListener {
        protected OverlayTickStrategyListener() {
        }

        @Override
        public void tickStrategyUpdate(TickStrategyEvent e) {
            if (e == null) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof AxisInterface && ReferenceLineOverlay.this.axes != null && ReferenceLineOverlay.this.axes.contains(source)) {
                boolean hit = false;
                Enumeration keys = ReferenceLineOverlay.this.axes.keys();
                while (keys.hasMoreElements()) {
                    Object id = keys.nextElement();
                    if (source != ReferenceLineOverlay.this.axes.get(id)) continue;
                    ReferenceLineOverlay.this.setTickStrategy(id, e.getTickStrategy());
                    hit = true;
                }
                if (hit) {
                    return;
                }
            }
            ReferenceLineOverlay.this.setTickStrategy(source, e.getTickStrategy());
        }
    }
}

