/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.ProbeInfo;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Prober
implements MouseListener,
MouseMotionListener {
    protected VisualizationComponentInterface client;
    protected ProbeInfo probeInfo;
    protected int style;
    protected boolean enabled = true;
    boolean continuousUpdateEnabled;
    int lastSelectionIndex;
    protected DisplayUpdateListener displayUpdateListener;

    public void Prober() {
        this.lastSelectionIndex = -1;
    }

    public void setContinuousUpdateEnabled(boolean b) {
        this.continuousUpdateEnabled = b;
    }

    public void setEnabled(boolean b) {
        if (this.enabled && !b) {
            this.clearProbe();
        }
        this.enabled = b;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setProbeStyle(int style) {
        switch (style) {
            case 0: 
            case 1: 
            case 2: {
                this.style = style;
            }
        }
    }

    public int getProbeStyle() {
        return this.style;
    }

    public Prober(VisualizationComponentInterface client) {
        this.client = client;
        this.style = 1;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.drawProbe(event);
        event.getComponent().repaint();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.clearProbe();
        event.getComponent().repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.clearProbe();
        event.getComponent().repaint();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    protected void drawProbe(MouseEvent event) {
        if (!this.enabled) {
            return;
        }
        if (this.client != null) {
            int index = this.client.getSelectionIndex();
            if (this.continuousUpdateEnabled || this.lastSelectionIndex != index) {
                if (this.displayUpdateListener != null) {
                    this.displayUpdateListener.disable();
                }
                this.lastSelectionIndex = index;
                if (index != -1) {
                    ProbeInfo oldProbeInfo = this.probeInfo;
                    this.probeInfo = this.client.newProbeInfo(this.style, event.getX(), event.getY());
                    if (this.probeInfo != null) {
                        this.client.getVisualizationGraphics().drawVisualizationInfo(this.probeInfo);
                    }
                    if (this.displayUpdateListener != null) {
                        this.displayUpdateListener.enable();
                    }
                } else {
                    this.clearProbe();
                }
            }
        }
    }

    protected void clearProbe() {
        this.lastSelectionIndex = -1;
        if (this.probeInfo != null && this.client != null) {
            if (this.displayUpdateListener != null) {
                this.displayUpdateListener.disable();
            }
            this.probeInfo = null;
            this.client.getVisualizationGraphics().drawVisualizationInfo(null);
        }
        if (this.displayUpdateListener != null) {
            this.displayUpdateListener.enable();
        }
    }

    public ActionListener getDisplayUpdateListener() {
        if (this.displayUpdateListener == null) {
            this.displayUpdateListener = new DisplayUpdateListener();
        }
        return this.displayUpdateListener;
    }

    protected class DisplayUpdateListener
    implements ActionListener {
        boolean enabled = true;

        protected DisplayUpdateListener() {
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                Prober.this.lastSelectionIndex = -1;
            }
        }
    }
}

