/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.CTKEventMulticaster;
import com.sas.graphics.chart.util.ctk.ChartComponent;
import com.sas.graphics.chart.util.ctk.RangeEvent;
import com.sas.graphics.chart.util.ctk.RangeListener;
import com.sas.graphics.chart.util.ctk.RangeNodeInterface;
import com.sas.graphics.chart.util.ctk.TransformStrategyEvent;
import com.sas.graphics.chart.util.ctk.TransformStrategyListener;
import com.sas.graphics.chart.util.ctk.TransformStrategySource;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.StrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleTransformStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.TransformStrategyInterface;
import com.sas.graphics.util.Vec3d;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Overlay
extends ChartComponent {
    public static final Integer DATA_VALUE = new Integer(Integer.MIN_VALUE);
    protected Hashtable axes;
    protected Hashtable ranges;
    protected Hashtable rangeListeners;
    protected Hashtable transformStrategies;
    protected TransformStrategyListener overlayTransformStrategyListener;
    protected final Object AXIS_LOCK = new Object();

    public AxisInterface setAxis(Object id, AxisInterface axis) {
        this.detachAxis(id);
        if (axis != null) {
            return this.attachAxis(id, axis);
        }
        return axis;
    }

    public AxisInterface getAxis(Object id) {
        return this.axes != null ? (AxisInterface)this.axes.get(id) : null;
    }

    protected RangeNodeInterface setRange(Object id, RangeNodeInterface range) {
        RangeListener listener;
        if (id == null) {
            return null;
        }
        if (this.ranges == null) {
            this.ranges = new Hashtable();
        }
        if (range == null) {
            this.ranges.remove(id);
        } else {
            this.ranges.put(id, range);
        }
        if (this.rangeListeners != null && (listener = (RangeListener)this.rangeListeners.get(id)) != null) {
            listener.rangeUpdate(new RangeEvent((Object)this, range));
        }
        return range;
    }

    protected RangeNodeInterface getRange(Object id) {
        if (id == null || this.ranges == null) {
            return null;
        }
        return (RangeNodeInterface)this.ranges.get(id);
    }

    protected RangeListener addRangeListener(Object id, RangeListener rangeListener) {
        if (id == null || rangeListener == null) {
            return null;
        }
        if (this.rangeListeners == null) {
            this.rangeListeners = new Hashtable();
        }
        RangeListener rangeListenerMultiCaster = (RangeListener)this.rangeListeners.get(id);
        rangeListenerMultiCaster = CTKEventMulticaster.addRangeListener(rangeListenerMultiCaster, rangeListener);
        this.rangeListeners.put(id, rangeListenerMultiCaster);
        RangeNodeInterface range = this.getRange(id);
        if (range != null) {
            rangeListener.rangeUpdate(new RangeEvent((Object)this, range));
        }
        return rangeListener;
    }

    protected RangeListener removeRangeListener(Object id, RangeListener rangeListener) {
        if (id == null || rangeListener == null || this.rangeListeners == null) {
            return null;
        }
        RangeListener rangeListenerMultiCaster = (RangeListener)this.rangeListeners.get(id);
        if (rangeListenerMultiCaster == null) {
            return null;
        }
        if ((rangeListenerMultiCaster = CTKEventMulticaster.removeRangeListener(rangeListenerMultiCaster, rangeListener)) == null) {
            this.rangeListeners.remove(id);
        } else {
            this.rangeListeners.put(id, rangeListener);
        }
        return rangeListener;
    }

    protected RangeListener getRangeListeners(Object id) {
        if (id == null || this.rangeListeners == null) {
            return null;
        }
        return (RangeListener)this.rangeListeners.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AxisInterface attachAxis(Object id, AxisInterface axis) {
        Object object = this.AXIS_LOCK;
        synchronized (object) {
            if (this.axes == null) {
                this.axes = new Hashtable();
            }
            this.axes.put(id, axis);
            if (axis instanceof TransformStrategySource) {
                if (this.overlayTransformStrategyListener == null) {
                    this.overlayTransformStrategyListener = new OverlayTransformStrategyListener();
                }
                ((TransformStrategySource)((Object)axis)).addTransformStrategyListener(this.overlayTransformStrategyListener);
            }
            if (axis instanceof RangeListener) {
                this.addRangeListener(id, (RangeListener)((Object)axis));
            }
        }
        return axis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AxisInterface detachAxis(Object id) {
        Object object = this.AXIS_LOCK;
        synchronized (object) {
            AxisInterface axis;
            AxisInterface axisInterface = axis = this.axes != null ? (AxisInterface)this.axes.remove(id) : null;
            if (axis instanceof TransformStrategySource && this.overlayTransformStrategyListener != null) {
                ((TransformStrategySource)((Object)axis)).removeTransformStrategyListener(this.overlayTransformStrategyListener);
            }
            if (axis instanceof RangeListener) {
                this.removeRangeListener(id, (RangeListener)((Object)axis));
            }
            return axis;
        }
    }

    public TransformStrategyInterface setTransformStrategy(Object id, TransformStrategyInterface transformStrategy) {
        if (id == null) {
            return null;
        }
        if (transformStrategy == null) {
            if (this.transformStrategies != null) {
                this.transformStrategies.remove(id);
            }
        } else {
            if (this.transformStrategies == null) {
                this.transformStrategies = new Hashtable();
            }
            this.transformStrategies.put(id, transformStrategy);
        }
        return transformStrategy;
    }

    protected static void setMapperTransformStrategy(StrategyMapper mapper, TransformStrategyInterface strategy) {
        if (mapper != null && strategy != null) {
            if (strategy instanceof DoubleToDoubleTransformStrategyInterface && mapper instanceof DoubleToDoubleStrategyMapper) {
                ((DoubleToDoubleStrategyMapper)mapper).setTransformStrategy((DoubleToDoubleTransformStrategyInterface)strategy);
            } else if (strategy instanceof StringToDoubleTransformStrategyInterface && mapper instanceof StringToDoubleStrategyMapper) {
                ((StringToDoubleStrategyMapper)mapper).setTransformStrategy((StringToDoubleTransformStrategyInterface)strategy);
            }
        }
    }

    public TransformStrategyInterface getTransformStrategy(Object id) {
        return this.transformStrategies != null ? (TransformStrategyInterface)this.transformStrategies.get(id) : null;
    }

    @Override
    public Vec3d getMaximumExtent() {
        return new Vec3d(Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    public String toString() {
        return "Overlay :" + super.toString();
    }

    protected class OverlayTransformStrategyListener
    implements TransformStrategyListener {
        protected OverlayTransformStrategyListener() {
        }

        @Override
        public void transformStrategyUpdate(TransformStrategyEvent e) {
            if (e == null) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof AxisInterface && Overlay.this.axes != null && Overlay.this.axes.contains(source)) {
                boolean hit = false;
                Enumeration keys = Overlay.this.axes.keys();
                while (keys.hasMoreElements()) {
                    Object id = keys.nextElement();
                    if (source != Overlay.this.axes.get(id)) continue;
                    Overlay.this.setTransformStrategy(id, e.getTransformStrategy());
                    hit = true;
                }
                if (hit) {
                    return;
                }
            }
            Overlay.this.setTransformStrategy(source, e.getTransformStrategy());
        }
    }
}

