/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.VisualizationComponent;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.ColorPipe;
import com.sas.graphics.util.vtk.LegendStyle;
import com.sas.graphics.util.vtk.StringPipe;
import java.awt.Color;
import java.awt.Font;

public class Legend
extends VisualizationComponent {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public com.sas.graphics.util.vtk.jxd.Legend vtkLegend;
    protected int entryCount;
    protected int orientation;
    protected Color borderColor;
    protected String title;

    public static Object newInstance() {
        return Legend.newLegend();
    }

    public static Legend newLegend() {
        Legend o = new Legend();
        o.init();
        return o;
    }

    protected Legend() {
    }

    @Override
    protected void init() {
        super.init();
        this.vtkLegend = new com.sas.graphics.util.vtk.jxd.Legend();
        this.setOrientation(0);
        this.setBorderVisible(false);
        this.borderColor = Color.black;
    }

    @Override
    protected void makeNetwork() {
        this.composite.removeAllElements();
        if (this.networkRoot != null && this.vtkLegend != null) {
            Vec3d o = new Vec3d(this.origin.x, this.origin.y, this.origin.z);
            Vec3d e = new Vec3d(this.extent.x, this.extent.y, this.extent.z);
            if (e.y < 0.0) {
                o.y += e.y;
                e.y = -e.y;
            }
            this.vtkLegend.transform.translateX.setValue(o.x);
            this.vtkLegend.transform.translateY.setValue(o.y);
            this.vtkLegend.transform.translateZ.setValue(o.z);
            this.vtkLegend.borderColor.setValue(this.borderColor);
            this.vtkLegend.title.setValue(this.title == null ? "" : this.title);
            this.vtkLegend.setWidth(e.x);
            this.vtkLegend.setHeight(e.y);
            this.composite.addElement(this.vtkLegend);
        }
    }

    public void setLegendStyle(LegendStyle ls) {
        this.vtkLegend.setStyle(ls);
        this.invalidateGraphics();
    }

    public LegendStyle getLegendStyle() {
        return this.vtkLegend.getStyle();
    }

    protected void setValues(ColorPipe values) {
        if (values == null) {
            this.vtkLegend.colors.disconnect();
        } else {
            this.vtkLegend.colors.connectFrom(values);
        }
        this.invalidate();
    }

    public void setLabels(StringPipe values) {
        if (values == null) {
            this.vtkLegend.labels.disconnect();
        } else {
            this.vtkLegend.labels.connectFrom(values);
        }
        this.invalidate();
    }

    public void setTitle(String newTitle) {
        String string = this.title = newTitle == null ? "" : newTitle;
        if (this.vtkLegend != null) {
            this.vtkLegend.title.setValue(this.title);
        }
        this.invalidateGraphics();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean setOrientation(int o) {
        switch (o) {
            case 0: {
                this.vtkLegend.setLayoutByRow(true);
                return true;
            }
            case 1: {
                this.vtkLegend.setLayoutByRow(false);
                return true;
            }
        }
        return false;
    }

    public int getOrientation() {
        return this.vtkLegend.isLayoutByRow() ? 0 : 1;
    }

    public void setContinuous(boolean v) {
        this.vtkLegend.setContinuous(v);
    }

    public boolean getContinuous() {
        return this.vtkLegend.isContinuous();
    }

    public void setBackgroundColor(Color color) {
        LegendStyle ls = this.getLegendStyle();
        ls.setBackgroundColor(color);
        this.setLegendStyle(ls);
    }

    public Color getBackgroundColor() {
        return this.getLegendStyle().getBackgroundColor();
    }

    public void setBorderVisible(boolean v) {
        LegendStyle ls = this.getLegendStyle();
        ls.setBorderOn(v);
        this.setLegendStyle(ls);
    }

    public Color setBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color newBorderColor) {
        Color color = this.borderColor = newBorderColor == null ? Color.black : newBorderColor;
        if (this.vtkLegend != null) {
            this.vtkLegend.borderColor.setValue(this.borderColor);
            this.invalidateGraphics();
        }
    }

    public void setTitleVisible(boolean v) {
        LegendStyle ls = this.getLegendStyle();
        ls.setTitleOn(v);
        this.setLegendStyle(ls);
    }

    public void setLabelsVisible(boolean v) {
        LegendStyle ls = this.getLegendStyle();
        ls.setLabelsOn(v);
        this.setLegendStyle(ls);
    }

    public void setBackgroundVisible(boolean v) {
        LegendStyle ls = this.getLegendStyle();
        ls.setBackgroundOn(v);
        this.setLegendStyle(ls);
    }

    public boolean getBorderVisible() {
        return this.getLegendStyle().isBorderOn();
    }

    public boolean getTitleVisible() {
        return this.getLegendStyle().isTitleOn();
    }

    public boolean getValuesVisible() {
        return this.getLegendStyle().isLabelsOn();
    }

    public boolean getBackgroundVisible() {
        return this.getLegendStyle().isBackgroundOn();
    }

    @Override
    public Vec3d setOrigin(Vec3d origin) {
        return super.setOrigin(origin);
    }

    @Override
    public Vec3d setExtent(Vec3d extent) {
        return super.setExtent(extent);
    }

    @Override
    public Vec3d getMaximumExtent() {
        return this.getMinimumExtent();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return this.getMinimumExtent();
    }

    @Override
    public Vec3d getMinimumExtent() {
        if (this.visualizationGraphics != null) {
            Font valueFont = this.vtkLegend.getStyle().getLabelStyle().getFont();
            double y = this.visualizationGraphics.getTextHeight(valueFont) * 3.0;
            double x = this.visualizationGraphics.getStringWidth(valueFont, "M") * 65.0;
            return new Vec3d(x, y, 0.0);
        }
        return new Vec3d(350.0, 150.0, 0.0);
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return this.getMinimumExtent();
    }
}

