/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.DateInformat;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.StringPipe;
import com.sas.graphics.util.vtk.StringStaticTableConnection;
import com.sas.table.StaticRowTemplateTableInterface;

public class DateStaticTableVariable
extends NumericVariable {
    private StringStaticTableConnection connection = new StringStaticTableConnection();

    @Override
    protected int getRawValueCount() {
        return this.connection.getValueCount();
    }

    public void connectFrom(StaticRowTemplateTableInterface data, int variableIndex) {
        this.connection.connectFrom(data, variableIndex);
        this.connectFrom();
    }

    public void connectFrom(StaticRowTemplateTableInterface data, String variableLabel) {
        this.connection.connectFrom(data, variableLabel);
        this.connectFrom();
    }

    @Override
    protected void connectFrom() {
        this.setRawValuePipe(new String2Date(this.connection), this.connection.getValueCount());
        super.connectFrom();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
        super.disconnect();
    }

    @Override
    public boolean isMissing(int index) {
        return this.connection.isMissing(index);
    }

    private static class String2Date
    implements NumericPipe {
        private StringPipe ip;
        private final DateInformat dateFormatter = new DateInformat();

        public String2Date(StringPipe inputPipe) {
            this.ip = inputPipe;
        }

        @Override
        public double getValue(int i) throws MissingValueException {
            try {
                return this.dateFormatter.getValue(this.ip.getValue(i));
            }
            catch (Exception e) {
                throw new MissingValueException();
            }
        }

        @Override
        public void init(AInitAction initAction) {
            this.ip.init(initAction);
        }

        @Override
        public void reset(AResetAction resetAction) {
            this.ip.reset(resetAction);
        }

        @Override
        public Formatter getFormatter() {
            return null;
        }
    }
}

