/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateInformat {
    private SimpleDateFormat formatter;
    private String[] patterns = new String[]{"ddMMM", "ddMMMyy", "ddMMMyyyy"};
    private String userPattern;
    private TimeZone timeZone = new SimpleTimeZone(0, "GMT");

    public DateInformat() {
        this.userPattern = null;
        this.formatter = new SimpleDateFormat(this.patterns[1]);
        this.formatter.setTimeZone(this.timeZone);
    }

    public DateInformat(String pattern) {
        this.userPattern = pattern;
        this.formatter = new SimpleDateFormat(this.userPattern);
        this.formatter.setTimeZone(this.timeZone);
    }

    public double getValue(String dateString) throws ParseException {
        int colonIndex = dateString.indexOf(":");
        String s = this.process(colonIndex == -1 ? dateString : dateString.substring(0, colonIndex));
        int length = s.length();
        if (this.userPattern == null) {
            if (length <= 5) {
                this.formatter.applyPattern(this.patterns[0]);
            } else if (length <= 7) {
                this.formatter.applyPattern(this.patterns[1]);
            } else if (length <= 9) {
                this.formatter.applyPattern(this.patterns[2]);
            } else {
                this.formatter.applyPattern(this.patterns[1]);
            }
        }
        Date date = this.formatter.parse(s);
        return this.convert(date.getTime());
    }

    private double convert(long javaDateValue) {
        return javaDateValue / 86400000L + 3653L;
    }

    private String process(String value) {
        String s = value.trim();
        int length = s.length();
        StringBuffer temp = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                temp.append(c);
                continue;
            }
            if (!Character.isLetter(c)) continue;
            temp.append(c);
        }
        return temp.toString();
    }
}

