/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.Axis;
import com.sas.graphics.chart.util.ctk.DataSourceInterface;
import com.sas.graphics.chart.util.ctk.OverlayInterface;
import com.sas.graphics.chart.util.ctk.PipedProbeInterface;
import com.sas.graphics.chart.util.ctk.ProbeInfo;
import com.sas.graphics.chart.util.ctk.ProbeInterface;
import com.sas.graphics.chart.util.ctk.RangeNodeInterface;
import com.sas.graphics.chart.util.ctk.TwoAxisOverlay;
import com.sas.graphics.chart.util.ctk.VariableRanger;
import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.StringToDoubleStrategyMapper;
import com.sas.graphics.util.vtk.NumericVariable;
import com.sas.graphics.util.vtk.StringVariable;
import com.sas.graphics.util.vtk.Variable;
import java.util.Vector;

public abstract class CategoryResponseOverlay
extends TwoAxisOverlay {
    public static final Integer BYGROUP = OverlayInterface.VariableRoles.BYGROUP;
    public static final Integer GROUP = OverlayInterface.VariableRoles.GROUP;
    public static final Integer CATEGORY = OverlayInterface.VariableRoles.CATEGORY;
    public static final Integer RESPONSE = OverlayInterface.VariableRoles.RESPONSE;
    protected StringVariable bygroup;
    protected StringVariable group;
    protected StringVariable subgroup;
    protected StringVariable category;
    protected Variable response;
    protected RangeNodeInterface responseRange;
    protected DoubleStrategyMapper groupCategoryMapper;
    protected DoubleStrategyMapper responseMapper;
    protected VariableRanger dependentAxisRanger;
    protected VariableRanger independentAxisRanger;
    protected Vector independentAxisVariableOrder;

    @Override
    protected void init() {
        super.init();
        this.dependentAxisRanger = new VariableRanger();
        this.independentAxisRanger = new VariableRanger();
        this.independentAxisVariableOrder = new Vector();
        this.independentAxisVariableOrder.addElement(BYGROUP);
        this.independentAxisVariableOrder.addElement(GROUP);
        this.independentAxisVariableOrder.addElement(CATEGORY);
    }

    public boolean setCategoryAxis(Axis axis) {
        return this.setIndependentAxis(axis);
    }

    public boolean setResponseAxis(Axis axis) {
        return this.setDependentAxis(axis);
    }

    @Override
    protected boolean attachData(DataSourceInterface data) {
        boolean valid = super.attachData(data);
        if (valid && this.dataSource != null) {
            this.acquireVariables();
            return true;
        }
        this.doNotUseDataSourceValues();
        return false;
    }

    protected void acquireVariables() {
        DataSourceInterface dataSource = this.getDataSource();
        if (dataSource != null) {
            Variable _bygroup = dataSource.getVtkVariable(OverlayInterface.VariableRoles.BYGROUP);
            Variable _group = dataSource.getVtkVariable(OverlayInterface.VariableRoles.GROUP);
            Variable _subgroup = dataSource.getVtkVariable(OverlayInterface.VariableRoles.SUBGROUP);
            Variable _category = dataSource.getVtkVariable(OverlayInterface.VariableRoles.CATEGORY);
            this.bygroup = _bygroup instanceof StringVariable ? (StringVariable)_bygroup : null;
            this.group = _group instanceof StringVariable ? (StringVariable)_group : null;
            this.subgroup = _subgroup instanceof StringVariable ? (StringVariable)_subgroup : null;
            StringVariable stringVariable = this.category = _category instanceof StringVariable ? (StringVariable)_category : null;
            if (this.category != null) {
                this.setClassifierVariable(OverlayInterface.VariableRoles.BYGROUP, this.bygroup);
                this.setClassifierVariable(OverlayInterface.VariableRoles.GROUP, this.group);
                this.setClassifierVariable(OverlayInterface.VariableRoles.SUBGROUP, this.subgroup);
                this.setClassifierVariable(OverlayInterface.VariableRoles.CATEGORY, this.category);
                this.independentAxisRanger.clear();
                this.independentAxisRanger.setHierarchialOrder(this.independentAxisVariableOrder);
                this.independentAxisRanger.setVariable(BYGROUP, this.bygroup);
                this.independentAxisRanger.setVariable(GROUP, this.group);
                this.independentAxisRanger.setVariable(CATEGORY, this.category);
                this.setRange(INDEPENDENT_AXIS, this.independentAxisRanger.getRange());
                if (!(this.bygroup != null && this.group != null && this.category != null || this.group != null && this.category != null || this.category == null)) {
                    this.groupCategoryMapper = new StringToDoubleStrategyMapper();
                    ((StringToDoubleStrategyMapper)this.groupCategoryMapper).input.connectFrom(this.category.value);
                    this.setIndependentAxisMapper(CATEGORY, this.groupCategoryMapper);
                }
                this.dependentAxisRanger.clear();
                this.response = this.newResponseAxisVariable(RESPONSE);
                this.responseMapper = this.getDependentAxisMapper(RESPONSE);
                this.responseRange = this.dependentAxisRanger.getRange();
                this.setRange(DEPENDENT_AXIS, this.responseRange);
            }
        }
    }

    @Override
    protected void detachData() {
        this.doNotUseDataSourceValues();
        super.detachData();
    }

    @Override
    protected void doNotUseDataSourceValues() {
        super.doNotUseDataSourceValues();
        this.category = null;
        this.subgroup = null;
        this.group = null;
        this.bygroup = null;
        this.response = null;
        this.setClassifierVariable(OverlayInterface.VariableRoles.BYGROUP, null);
        this.setClassifierVariable(OverlayInterface.VariableRoles.GROUP, null);
        this.setClassifierVariable(OverlayInterface.VariableRoles.CATEGORY, null);
        this.setAnalysisVariable(OverlayInterface.VariableRoles.RESPONSE, null);
        this.independentAxisRanger.clear();
        this.dependentAxisRanger.clear();
        this.setRange(INDEPENDENT_AXIS, null);
        this.setRange(DEPENDENT_AXIS, null);
    }

    protected Variable newResponseAxisVariable(Object id) {
        return this.newResponseAxisVariable(id, true);
    }

    protected Variable newResponseAxisVariable(Object id, boolean updateRanger) {
        return this.newContinuousAxisVariable(id, this.dependentAxisMappers, this.dependentAxisTransformStrategy, updateRanger ? this.dependentAxisRanger : null);
    }

    @Override
    public ProbeInfo newProbeInfo(int x, int y) {
        if (this.probe instanceof PipedProbeInterface) {
            ((PipedProbeInterface)this.probe).removeAll();
        }
        return this.internalNewProbeInfo(this.probe, true, 1, x, y);
    }

    @Override
    public ProbeInfo newProbeInfo(int style, int x, int y) {
        if (this.probe instanceof PipedProbeInterface) {
            ((PipedProbeInterface)this.probe).removeAll();
        }
        return this.internalNewProbeInfo(this.probe, true, style, x, y);
    }

    @Override
    public ProbeInfo newProbeInfo(ProbeInterface probe, boolean addDataPipes, int x, int y) {
        return this.internalNewProbeInfo(probe, addDataPipes, 1, x, y);
    }

    @Override
    public ProbeInfo newProbeInfo(ProbeInterface probe, boolean addDataPipes, int style, int x, int y) {
        return this.internalNewProbeInfo(probe, addDataPipes, style, x, y);
    }

    protected ProbeInfo internalNewProbeInfo(ProbeInterface probe, boolean addDataPipes, int style, int x, int y) {
        if (this.selectInfo == null) {
            return null;
        }
        if (addDataPipes && probe instanceof PipedProbeInterface) {
            this.configureProbe((PipedProbeInterface)probe, style);
        }
        probe.setOrientation(0);
        probe.setDisplacement(25);
        return new ProbeInfo(probe, this.selectInfo.getValueIndex(), x, y);
    }

    public void configureProbe(PipedProbeInterface probe, int style) {
        StringVariable sv;
        if (1 == style || 2 == style) {
            if (this.bygroup != null && probe.getProbeEntry(this.bygroup.value) == null) {
                probe.addPipe(null, this.bygroup.value);
            }
            if (this.group != null && probe.getProbeEntry(this.group.value) == null) {
                probe.addPipe(null, this.group.value);
            }
            if (this.category != null && probe.getProbeEntry(this.category.value) == null) {
                probe.addPipe(null, this.category.value);
            }
            if (this.subgroup != null && probe.getProbeEntry(this.subgroup.value) == null) {
                probe.addPipe(null, this.subgroup.value);
            }
        }
        if (this.response instanceof NumericVariable) {
            NumericVariable nv = (NumericVariable)this.response;
            if (nv != null && probe.getProbeEntry(nv.value) == null) {
                probe.addPipe(null, nv.value);
            }
        } else if (this.response instanceof StringVariable && (sv = (StringVariable)this.response) != null && probe.getProbeEntry(sv.value) == null) {
            probe.addPipe(null, sv.value);
        }
    }
}

