/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.Axis;
import com.sas.graphics.chart.util.ctk.VisualizationComponentInterface;
import com.sas.graphics.chart.util.ctk.VisualizationConstraintInterface;
import com.sas.graphics.chart.util.ctk.VisualizationContainerInterface;
import com.sas.graphics.chart.util.ctk.VisualizationLayoutManager;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import java.util.Enumeration;
import java.util.Vector;

public class CategoryResponseLayoutManager
extends VisualizationLayoutManager {
    public static final int NORTHEAST = 0;
    public static final int NORTHWEST = 1;
    public static final int SOUTHEAST = 2;
    public static final int SOUTHWEST = 3;
    public static final int WESTNORTH = 4;
    public static final int WESTSOUTH = 5;
    public static final int EASTNORTH = 6;
    public static final int EASTSOUTH = 7;
    public static final double MIN_OFFSET = -0.1;
    public static final int THIN = 0;
    public static final int THICK = 1;
    public static final int ADJACENT = 0;
    public static final int OVERLAPPING = 1;
    protected int orientation = 0;
    protected int overlayThicknessMode = 0;
    protected int overlayIncrementMode = 1;

    @Override
    public void layoutContainer() {
        switch (this.orientation) {
            default: {
                this.layoutNorthEast();
                break;
            }
            case 1: {
                this.layoutNorthWest();
                break;
            }
            case 2: {
                this.layoutSouthEast();
                break;
            }
            case 3: {
                this.layoutSouthWest();
                break;
            }
            case 4: {
                this.layoutWestNorth();
                break;
            }
            case 5: {
                this.layoutWestSouth();
                break;
            }
            case 6: {
                this.layoutEastNorth();
                break;
            }
            case 7: {
                this.layoutEastSouth();
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int setOrientation(int orientation) {
        switch (orientation) {
            default: {
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.orientation = orientation;
            }
        }
        return orientation;
    }

    public int getOverlayThicknessMode() {
        return this.overlayThicknessMode;
    }

    public int setOverlayThicknessMode(int mode) {
        switch (mode) {
            default: {
                break;
            }
            case 0: 
            case 1: {
                this.overlayThicknessMode = mode;
            }
        }
        return this.overlayThicknessMode;
    }

    public int getOverlayIncrementMode() {
        return this.overlayIncrementMode;
    }

    public int setOverlayIncrementMode(int mode) {
        switch (mode) {
            default: {
                break;
            }
            case 0: 
            case 1: {
                this.overlayIncrementMode = mode;
            }
        }
        return this.overlayIncrementMode;
    }

    public CategoryResponseConstraintInterface newDefaultConstraint() {
        return new CategoryResponseConstraint();
    }

    @Override
    public Vec3d getMaximumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getPreferredExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumExtent() {
        return new Vec3d();
    }

    @Override
    public Vec3d getMinimumPartialExtent() {
        return new Vec3d();
    }

    protected void layoutNorthWest() {
    }

    protected void layoutSouthEast() {
    }

    protected void layoutSouthWest() {
    }

    protected void layoutNorthEast() {
        double overlayInc;
        CRInfo info = new CRInfo(this.getVisualizationContainer());
        if (info.categoryAxis == null || info.responseAxis == null) {
            return;
        }
        if (info.extent.x < 0.0) {
            info.origin.x += info.extent.x;
            info.extent.x = -info.extent.x;
        }
        if (info.extent.y < 0.0) {
            info.origin.y += info.extent.y;
            info.extent.y = -info.extent.y;
        }
        if (info.extent.z > 0.0) {
            info.origin.z += info.extent.z;
            info.extent.z = -info.extent.z;
        }
        ((Axis)info.categoryAxis).setOrientation(1);
        ((Axis)info.responseAxis).setOrientation(2);
        if (info.responseAxis2 != null) {
            ((Axis)info.responseAxis2).setOrientation(2);
        }
        Vec3d categoryAxisMinExtent = info.categoryAxis.getMinimumExtent();
        Vec3d responseAxisMinExtent = info.responseAxis.getMinimumExtent();
        Vec3d responseAxis2MinExtent = info.responseAxis2 != null ? info.responseAxis2.getMinimumExtent() : new Vec3d();
        Vec3d chartOrigin = new Vec3d();
        chartOrigin.x = info.origin.x + responseAxisMinExtent.x;
        chartOrigin.y = info.origin.y + categoryAxisMinExtent.y;
        chartOrigin.z = info.origin.z;
        Vec3d categoryOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d categoryExtent = new Vec3d();
        categoryExtent.x = info.extent.x - responseAxisMinExtent.x - responseAxis2MinExtent.x;
        categoryExtent.x *= 0.95;
        categoryExtent.y = -categoryAxisMinExtent.y;
        categoryExtent.z = 0.0;
        info.categoryAxis.setOrigin(categoryOrigin);
        info.categoryAxis.setExtent(categoryExtent);
        Vec3d responseOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d responseExtent = new Vec3d();
        responseExtent.x = -responseAxisMinExtent.x;
        responseExtent.y = info.extent.y - categoryAxisMinExtent.y;
        responseExtent.y *= 0.95;
        responseExtent.z = 0.0;
        info.responseAxis.setOrigin(responseOrigin);
        info.responseAxis.setExtent(responseExtent);
        Vec3d response2Origin = new Vec3d(chartOrigin.x + categoryExtent.x, chartOrigin.y, chartOrigin.z);
        Vec3d response2Extent = new Vec3d();
        response2Extent.x = responseAxis2MinExtent.x;
        response2Extent.y = info.extent.y - categoryAxisMinExtent.y;
        response2Extent.y *= 0.95;
        response2Extent.z = 0.0;
        if (info.responseAxis2 != null) {
            info.responseAxis2.setOrigin(response2Origin);
            info.responseAxis2.setExtent(response2Extent);
        }
        Vec3d overlayOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d overlayExtent = new Vec3d();
        overlayExtent.x = categoryExtent.x;
        overlayExtent.y = responseExtent.y;
        int size = info.overlays.size() + (info.grid != null ? 1 : 0);
        if (size == 0) {
            return;
        }
        double d = overlayInc = this.overlayIncrementMode == 0 ? info.extent.z / (double)size : info.extent.z / 2000.0;
        overlayExtent.z = this.overlayThicknessMode == 0 ? 0.0 : (this.overlayIncrementMode == 0 ? info.extent.z / (double)size * 0.95 : info.extent.z);
        BoundingBox clipBounds = new BoundingBox();
        clipBounds.setCenter(new Vec3d(overlayOrigin.x + overlayExtent.x / 2.0, overlayOrigin.y + overlayExtent.y / 2.0, 0.0));
        clipBounds.setSize(new Vec3d(overlayExtent.x, overlayExtent.y, 0.0));
        if (info.grid != null) {
            info.grid.setOrigin(overlayOrigin);
            info.grid.setExtent(overlayExtent);
            double xoff = 0.0;
            double yoff = 0.0;
            info.grid.setClipBounds(clipBounds);
            overlayOrigin.z -= overlayInc;
        }
        size = info.overlays.size();
        for (int ii = 0; ii < size; ++ii) {
            VisualizationComponentInterface o = (VisualizationComponentInterface)info.overlays.elementAt(ii);
            o.setOrigin(overlayOrigin);
            o.setExtent(overlayExtent);
            if (clipBounds != null) {
                o.setClipBounds(clipBounds);
            }
            overlayOrigin.z -= overlayInc;
        }
        if (info.grid != null) {
            // empty if block
        }
        if (info.orphans != null) {
            Enumeration orphans = info.orphans.elements();
            Vec3d zeros = new Vec3d();
            while (orphans.hasMoreElements()) {
                VisualizationComponentInterface o = (VisualizationComponentInterface)orphans.nextElement();
                o.setOrigin(zeros);
                o.setExtent(zeros);
            }
        }
    }

    protected void layoutEastSouth() {
        double overlayInc;
        CRInfo info = new CRInfo(this.getVisualizationContainer());
        if (info.categoryAxis == null || info.responseAxis == null) {
            return;
        }
        if (info.extent.x < 0.0) {
            info.origin.x += info.extent.x;
            info.extent.x = -info.extent.x;
        }
        if (info.extent.y > 0.0) {
            info.origin.y += info.extent.y;
            info.extent.y = -info.extent.y;
        }
        if (info.extent.z > 0.0) {
            info.origin.z += info.extent.z;
            info.extent.z = -info.extent.z;
        }
        double microAdjustZ = -(info.extent.z / 1000.0);
        ((Axis)info.responseAxis).setOrientation(1);
        ((Axis)info.categoryAxis).setOrientation(2);
        if (info.responseAxis2 != null) {
            ((Axis)info.responseAxis2).setOrientation(2);
        }
        Vec3d categoryAxisMinExtent = info.responseAxis.getMinimumExtent();
        Vec3d responseAxisMinExtent = info.categoryAxis.getMinimumExtent();
        Vec3d responseAxis2MinExtent = info.responseAxis2 != null ? info.responseAxis2.getMinimumExtent() : new Vec3d();
        Vec3d chartOrigin = new Vec3d();
        chartOrigin.x = info.origin.x + responseAxisMinExtent.x;
        chartOrigin.y = info.origin.y - categoryAxisMinExtent.y;
        chartOrigin.z = info.origin.z;
        Vec3d categoryOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z + microAdjustZ);
        Vec3d categoryExtent = new Vec3d();
        categoryExtent.x = info.extent.x - responseAxisMinExtent.x - responseAxis2MinExtent.x;
        categoryExtent.x *= 0.9;
        categoryExtent.y = categoryAxisMinExtent.y;
        categoryExtent.z = 0.0;
        info.responseAxis.setOrigin(categoryOrigin);
        info.responseAxis.setExtent(categoryExtent);
        Vec3d responseOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z + microAdjustZ);
        Vec3d responseExtent = new Vec3d();
        responseExtent.x = -responseAxisMinExtent.x;
        responseExtent.y = info.extent.y + categoryAxisMinExtent.y;
        responseExtent.y *= 0.95;
        responseExtent.z = 0.0;
        info.categoryAxis.setOrigin(responseOrigin);
        info.categoryAxis.setExtent(responseExtent);
        Vec3d response2Origin = new Vec3d(chartOrigin.x + categoryExtent.x, chartOrigin.y, chartOrigin.z + microAdjustZ);
        Vec3d response2Extent = new Vec3d();
        response2Extent.x = responseAxis2MinExtent.x;
        response2Extent.y = info.extent.y + categoryAxisMinExtent.y;
        response2Extent.y *= 0.95;
        response2Extent.z = 0.0;
        if (info.responseAxis2 != null) {
            info.responseAxis2.setOrigin(response2Origin);
            info.responseAxis2.setExtent(response2Extent);
        }
        Vec3d overlayOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d overlayExtent = new Vec3d();
        overlayExtent.x = categoryExtent.x;
        overlayExtent.y = responseExtent.y;
        int size = info.overlays.size() + (info.grid != null ? 1 : 0);
        if (size == 0) {
            return;
        }
        double d = overlayInc = this.overlayIncrementMode == 0 ? info.extent.z / (double)size : -microAdjustZ;
        overlayExtent.z = this.overlayThicknessMode == 0 ? 0.0 : (this.overlayIncrementMode == 0 ? info.extent.z / (double)size * 0.95 : info.extent.z);
        BoundingBox clipBounds = new BoundingBox();
        clipBounds.setCenter(new Vec3d(overlayOrigin.x + 1.0 + overlayExtent.x / 2.0, overlayOrigin.y - 1.0 + overlayExtent.y / 2.0, 0.0));
        clipBounds.setSize(new Vec3d(overlayExtent.x + 1.0, -overlayExtent.y + 1.0, 0.0));
        if (info.grid != null) {
            info.grid.setOrigin(overlayOrigin);
            info.grid.setExtent(overlayExtent);
            double xoff = 0.0;
            double yoff = 0.0;
            info.grid.setClipBounds(clipBounds);
            overlayOrigin.z -= overlayInc;
        }
        size = info.overlays.size();
        for (int ii = 0; ii < size; ++ii) {
            VisualizationComponentInterface o = (VisualizationComponentInterface)info.overlays.elementAt(ii);
            o.setOrigin(overlayOrigin);
            o.setExtent(overlayExtent);
            if (clipBounds != null) {
                o.setClipBounds(clipBounds);
            }
            overlayOrigin.z -= overlayInc;
        }
        categoryOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, overlayOrigin.z);
        responseOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, overlayOrigin.z);
        info.responseAxis.setOrigin(categoryOrigin);
        info.categoryAxis.setOrigin(responseOrigin);
        if (info.orphans != null) {
            Enumeration orphans = info.orphans.elements();
            Vec3d zeros = new Vec3d();
            while (orphans.hasMoreElements()) {
                VisualizationComponentInterface o = (VisualizationComponentInterface)orphans.nextElement();
                o.setOrigin(zeros);
                o.setExtent(zeros);
            }
        }
    }

    protected void layoutEastNorth() {
        double overlayInc;
        CRInfo info = new CRInfo(this.getVisualizationContainer());
        if (info.categoryAxis == null || info.responseAxis == null) {
            return;
        }
        if (info.extent.x < 0.0) {
            info.origin.x += info.extent.x;
            info.extent.x = -info.extent.x;
        }
        if (info.extent.y < 0.0) {
            info.origin.y += info.extent.y;
            info.extent.y = -info.extent.y;
        }
        if (info.extent.z > 0.0) {
            info.origin.z += info.extent.z;
            info.extent.z = -info.extent.z;
        }
        double microAdjustZ = -(info.extent.z / 1000.0);
        ((Axis)info.responseAxis).setOrientation(1);
        ((Axis)info.categoryAxis).setOrientation(2);
        if (info.responseAxis2 != null) {
            ((Axis)info.responseAxis2).setOrientation(2);
        }
        Vec3d categoryAxisMinExtent = info.responseAxis.getMinimumExtent();
        Vec3d responseAxisMinExtent = info.categoryAxis.getMinimumExtent();
        Vec3d responseAxis2MinExtent = info.responseAxis2 != null ? info.responseAxis2.getMinimumExtent() : new Vec3d();
        Vec3d chartOrigin = new Vec3d();
        chartOrigin.x = info.origin.x + responseAxisMinExtent.x;
        chartOrigin.y = info.origin.y + categoryAxisMinExtent.y;
        chartOrigin.z = info.origin.z;
        Vec3d categoryOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z + microAdjustZ);
        Vec3d categoryExtent = new Vec3d();
        categoryExtent.x = info.extent.x - responseAxisMinExtent.x - responseAxis2MinExtent.x;
        categoryExtent.x *= 0.95;
        categoryExtent.y = -categoryAxisMinExtent.y;
        categoryExtent.z = 0.0;
        info.responseAxis.setOrigin(categoryOrigin);
        info.responseAxis.setExtent(categoryExtent);
        Vec3d responseOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z + microAdjustZ);
        Vec3d responseExtent = new Vec3d();
        responseExtent.x = -responseAxisMinExtent.x;
        responseExtent.y = info.extent.y - categoryAxisMinExtent.y;
        responseExtent.y *= 0.95;
        responseExtent.z = 0.0;
        info.categoryAxis.setOrigin(responseOrigin);
        info.categoryAxis.setExtent(responseExtent);
        Vec3d response2Origin = new Vec3d(chartOrigin.x + categoryExtent.x, chartOrigin.y, chartOrigin.z + microAdjustZ);
        Vec3d response2Extent = new Vec3d();
        response2Extent.x = responseAxis2MinExtent.x;
        response2Extent.y = info.extent.y - categoryAxisMinExtent.y;
        response2Extent.y *= 0.95;
        response2Extent.z = 0.0;
        if (info.responseAxis2 != null) {
            info.responseAxis2.setOrigin(response2Origin);
            info.responseAxis2.setExtent(response2Extent);
        }
        Vec3d overlayOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d overlayExtent = new Vec3d();
        overlayExtent.x = categoryExtent.x;
        overlayExtent.y = responseExtent.y;
        int size = info.overlays.size() + (info.grid != null ? 1 : 0);
        if (size == 0) {
            return;
        }
        double d = overlayInc = this.overlayIncrementMode == 0 ? info.extent.z / (double)size : -microAdjustZ;
        overlayExtent.z = this.overlayThicknessMode == 0 ? 0.0 : (this.overlayIncrementMode == 0 ? info.extent.z / (double)size * 0.95 : info.extent.z);
        BoundingBox clipBounds = new BoundingBox();
        clipBounds.setCenter(new Vec3d(overlayOrigin.x + 1.0 + overlayExtent.x / 2.0, overlayOrigin.y - 1.0 + overlayExtent.y / 2.0, 0.0));
        clipBounds.setSize(new Vec3d(overlayExtent.x + 1.0, overlayExtent.y + 1.0, 0.0));
        if (info.grid != null) {
            info.grid.setOrigin(overlayOrigin);
            info.grid.setExtent(overlayExtent);
            double xoff = 0.0;
            double yoff = 0.0;
            double a = overlayExtent.z;
            info.grid.setClipBounds(clipBounds);
            overlayOrigin.z -= overlayInc;
        }
        size = info.overlays.size();
        for (int ii = 0; ii < size; ++ii) {
            VisualizationComponentInterface o = (VisualizationComponentInterface)info.overlays.elementAt(ii);
            o.setOrigin(overlayOrigin);
            o.setExtent(overlayExtent);
            if (clipBounds != null) {
                o.setClipBounds(clipBounds);
            }
            overlayOrigin.z -= overlayInc;
        }
        if (info.grid != null) {
            // empty if block
        }
        categoryOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, overlayOrigin.z);
        responseOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, overlayOrigin.z);
        info.responseAxis.setOrigin(categoryOrigin);
        info.categoryAxis.setOrigin(responseOrigin);
        if (info.orphans != null) {
            Enumeration orphans = info.orphans.elements();
            Vec3d zeros = new Vec3d();
            while (orphans.hasMoreElements()) {
                VisualizationComponentInterface o = (VisualizationComponentInterface)orphans.nextElement();
                o.setOrigin(zeros);
                o.setExtent(zeros);
            }
        }
    }

    protected void layoutWestSouth() {
    }

    protected void layoutWestNorth() {
        double overlayInc;
        CRInfo info = new CRInfo(this.getVisualizationContainer());
        if (info.categoryAxis == null || info.responseAxis == null) {
            return;
        }
        if (info.extent.x < 0.0) {
            info.origin.x += info.extent.x;
            info.extent.x = -info.extent.x;
        }
        if (info.extent.y < 0.0) {
            info.origin.y += info.extent.y;
            info.extent.y = -info.extent.y;
        }
        if (info.extent.z < 0.0) {
            info.origin.z += info.extent.z;
            info.extent.z = -info.extent.z;
        }
        ((Axis)info.responseAxis).setOrientation(1);
        ((Axis)info.categoryAxis).setOrientation(2);
        if (info.responseAxis2 != null) {
            ((Axis)info.responseAxis2).setOrientation(2);
        }
        Vec3d categoryAxisMinExtent = info.responseAxis.getMinimumExtent();
        Vec3d responseAxisMinExtent = info.categoryAxis.getMinimumExtent();
        Vec3d responseAxis2MinExtent = info.responseAxis2 != null ? info.responseAxis2.getMinimumExtent() : new Vec3d();
        Vec3d chartOrigin = new Vec3d();
        chartOrigin.x = info.origin.x + (info.extent.x - responseAxisMinExtent.x - responseAxis2MinExtent.x) * 0.05;
        chartOrigin.y = info.origin.y + categoryAxisMinExtent.y;
        chartOrigin.z = info.origin.z;
        Vec3d categoryOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d categoryExtent = new Vec3d();
        categoryExtent.x = info.extent.x - responseAxisMinExtent.x - responseAxis2MinExtent.x;
        categoryExtent.x *= 0.95;
        categoryExtent.y = -categoryAxisMinExtent.y;
        categoryExtent.z = 0.0;
        Vec3d cc = new Vec3d(categoryOrigin.x + categoryExtent.x, categoryOrigin.y, categoryOrigin.z);
        Vec3d dd = new Vec3d(-categoryExtent.x, categoryExtent.y, categoryExtent.z);
        info.responseAxis.setOrigin(cc);
        info.responseAxis.setExtent(dd);
        Vec3d responseOrigin = new Vec3d(chartOrigin.x + categoryExtent.x, chartOrigin.y, chartOrigin.z);
        Vec3d responseExtent = new Vec3d();
        responseExtent.x = responseAxisMinExtent.x;
        responseExtent.y = info.extent.y - categoryAxisMinExtent.y;
        responseExtent.y *= 0.95;
        responseExtent.z = 0.0;
        info.categoryAxis.setOrigin(responseOrigin);
        info.categoryAxis.setExtent(responseExtent);
        Vec3d response2Origin = new Vec3d(chartOrigin.x + categoryExtent.x, chartOrigin.y, chartOrigin.z);
        Vec3d response2Extent = new Vec3d();
        response2Extent.x = responseAxis2MinExtent.x;
        response2Extent.y = info.extent.y - categoryAxisMinExtent.y;
        response2Extent.y *= 0.95;
        response2Extent.z = 0.0;
        if (info.responseAxis2 != null) {
            info.responseAxis2.setOrigin(response2Origin);
            info.responseAxis2.setExtent(response2Extent);
        }
        Vec3d overlayOrigin = new Vec3d(chartOrigin.x, chartOrigin.y, chartOrigin.z);
        Vec3d overlayExtent = new Vec3d();
        overlayExtent.x = categoryExtent.x;
        overlayExtent.y = responseExtent.y;
        int size = info.overlays.size() + (info.grid != null ? 1 : 0);
        if (size == 0) {
            return;
        }
        double d = overlayInc = this.overlayIncrementMode == 0 ? info.extent.z / (double)size : info.extent.z / 2000.0;
        overlayExtent.z = this.overlayThicknessMode == 0 ? 0.0 : (this.overlayIncrementMode == 0 ? info.extent.z / (double)size * 0.95 : info.extent.z);
        BoundingBox clipBounds = new BoundingBox();
        clipBounds.setCenter(new Vec3d(overlayOrigin.x + overlayExtent.x / 2.0, overlayOrigin.y + overlayExtent.y / 2.0, 0.0));
        clipBounds.setSize(new Vec3d(overlayExtent.x, overlayExtent.y, 0.0));
        if (info.grid != null) {
            info.grid.setOrigin(overlayOrigin);
            info.grid.setExtent(overlayExtent);
            double xoff = 0.0;
            double yoff = 0.0;
            info.grid.setClipBounds(clipBounds);
            overlayOrigin.z -= overlayInc;
        }
        size = info.overlays.size();
        for (int ii = 0; ii < size; ++ii) {
            VisualizationComponentInterface o = (VisualizationComponentInterface)info.overlays.elementAt(ii);
            o.setOrigin(overlayOrigin);
            o.setExtent(overlayExtent);
            if (clipBounds != null) {
                o.setClipBounds(clipBounds);
            }
            overlayOrigin.z -= overlayInc;
        }
        if (info.grid != null) {
            // empty if block
        }
        if (info.orphans != null) {
            Enumeration orphans = info.orphans.elements();
            Vec3d zeros = new Vec3d();
            while (orphans.hasMoreElements()) {
                VisualizationComponentInterface o = (VisualizationComponentInterface)orphans.nextElement();
                o.setOrigin(zeros);
                o.setExtent(zeros);
            }
        }
    }

    protected class CRInfo {
        public VisualizationComponentInterface categoryAxis;
        public VisualizationComponentInterface responseAxis;
        public VisualizationComponentInterface responseAxis2;
        public VisualizationComponentInterface grid;
        public Vector overlays = new Vector();
        public Vector orphans;
        public VisualizationContainerInterface container;
        public Vec3d extent;
        public Vec3d origin;

        public CRInfo(VisualizationContainerInterface sourceContainer) {
            this.container = sourceContainer;
            this.extent = this.container.getExtent();
            this.origin = this.container.getOrigin();
            Enumeration components = this.container.visualizationComponents();
            if (components == null) {
                return;
            }
            while (components.hasMoreElements()) {
                VisualizationComponentInterface vc = (VisualizationComponentInterface)components.nextElement();
                if (vc == null) continue;
                VisualizationConstraintInterface vx = CategoryResponseLayoutManager.this.vContainer.getVisualizationConstraint(vc);
                if (vx != null && vx instanceof CategoryResponseConstraintInterface) {
                    int xxx = ((CategoryResponseConstraintInterface)vx).getType();
                    switch (((CategoryResponseConstraintInterface)vx).getType()) {
                        default: {
                            this.addOrphan(vc);
                            break;
                        }
                        case 1: {
                            this.overlays.addElement(vc);
                            break;
                        }
                        case 4: {
                            if (this.responseAxis == null) {
                                this.responseAxis = vc;
                                break;
                            }
                            this.addOrphan(vc);
                            break;
                        }
                        case 5: {
                            if (this.responseAxis2 == null) {
                                this.responseAxis2 = vc;
                                break;
                            }
                            this.addOrphan(vc);
                            break;
                        }
                        case 3: {
                            if (this.categoryAxis == null) {
                                this.categoryAxis = vc;
                                break;
                            }
                            this.addOrphan(vc);
                            break;
                        }
                        case 2: {
                            if (this.grid == null) {
                                this.grid = vc;
                                break;
                            }
                            this.addOrphan(vc);
                            break;
                        }
                    }
                    continue;
                }
                this.addOrphan(vc);
            }
        }

        protected void addOrphan(Object orphan) {
            if (this.orphans == null) {
                this.orphans = new Vector();
            }
            this.orphans.addElement(orphan);
        }
    }

    public static class CategoryResponseConstraint
    implements CategoryResponseConstraintInterface {
        protected int type = 0;
        protected int position = -1;

        @Override
        public void setType(int type) {
            switch (type) {
                default: {
                    this.type = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.type = type;
                }
            }
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public void setPosition(int pos) {
            this.position = pos;
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public VisualizationConstraintInterface copy() {
            CategoryResponseConstraint copy = new CategoryResponseConstraint();
            copy.type = this.type;
            copy.position = this.position;
            return copy;
        }
    }

    public static interface CategoryResponseConstraintInterface
    extends VisualizationConstraintInterface {
        public static final int BEST_GUESS = 0;
        public static final int OVERLAY = 1;
        public static final int GRID = 2;
        public static final int CATEGORY_AXIS = 3;
        public static final int RESPONSE_AXIS = 4;
        public static final int RESPONSE_AXIS_2 = 5;

        public void setType(int var1);

        public int getType();

        public void setPosition(int var1);

        public int getPosition();
    }
}

