/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk;

import com.sas.graphics.chart.util.ctk.Axis;
import com.sas.graphics.chart.util.ctk.AxisInterface;
import com.sas.graphics.chart.util.ctk.CategoryResponseLayoutManager;
import com.sas.graphics.chart.util.ctk.GridOverlay;
import com.sas.graphics.chart.util.ctk.MultiAxisTickAdjuster;
import com.sas.graphics.chart.util.ctk.MultiAxisTickSpaceAdjuster;
import com.sas.graphics.chart.util.ctk.TwoAxisOverlay;
import com.sas.graphics.chart.util.ctk.VisualizationContainer;

public class CategoryResponseChart
extends VisualizationContainer {
    protected Axis categoryAxis;
    protected Axis responseAxis;
    protected Axis response2Axis;
    protected MultiAxisTickAdjuster axisTickAdjuster;
    protected MultiAxisTickSpaceAdjuster axisTickSpaceAdjuster;
    protected CategoryResponseLayoutManager chartAreaLayoutManager;
    protected CategoryResponseLayoutManager.CategoryResponseConstraintInterface constraints;
    protected TwoAxisOverlay grid;

    protected CategoryResponseChart() {
    }

    public static Object newInstance() {
        CategoryResponseChart o = new CategoryResponseChart();
        o.init();
        return o;
    }

    public static final CategoryResponseChart newCategoryResponseChart() {
        return (CategoryResponseChart)CategoryResponseChart.newInstance();
    }

    @Override
    protected void init() {
        super.init();
        this.responseAxis = Axis.newAxis();
        this.categoryAxis = Axis.newAxis();
        this.responseAxis.getAxisStyle().getLabelStyle().setFit(true);
        this.responseAxis.getAxisStyle().getLabelStyle().setStagger(true);
        this.axisTickAdjuster = new MultiAxisTickAdjuster(new AxisInterface[]{this.responseAxis, this.categoryAxis});
        this.axisTickSpaceAdjuster = new MultiAxisTickSpaceAdjuster(new AxisInterface[]{this.responseAxis, this.categoryAxis});
        this.chartAreaLayoutManager = new CategoryResponseLayoutManager();
        this.constraints = this.chartAreaLayoutManager.newDefaultConstraint();
        this.setVisualizationLayoutManager(this.chartAreaLayoutManager);
        this.setGrid(GridOverlay.newGridOverlay());
        this.constraints.setType(4);
        this.add(this.responseAxis, this.constraints);
        this.constraints.setType(3);
        this.add(this.categoryAxis, this.constraints);
        this.northEastOrientation();
    }

    public void addOverlay(TwoAxisOverlay overlay) {
        overlay.setDependentAxis(this.responseAxis);
        overlay.setIndependentAxis(this.categoryAxis);
        this.constraints.setType(1);
        this.add(overlay, this.constraints);
        overlay.addMouseListener(this.axisTickAdjuster);
        overlay.addMouseMotionListener(this.axisTickAdjuster);
        overlay.addMouseListener(this.axisTickSpaceAdjuster);
        overlay.addMouseMotionListener(this.axisTickSpaceAdjuster);
    }

    public void removeOverlay(TwoAxisOverlay overlay) {
        overlay.setDependentAxis(null);
        overlay.setIndependentAxis(null);
        this.remove(overlay);
        overlay.removeMouseListener(this.axisTickAdjuster);
        overlay.removeMouseMotionListener(this.axisTickAdjuster);
        overlay.removeMouseListener(this.axisTickSpaceAdjuster);
        overlay.removeMouseMotionListener(this.axisTickSpaceAdjuster);
    }

    public void addOverlay2(TwoAxisOverlay overlay) {
        if (this.response2Axis == null) {
            this.setSecondResponseAxis(Axis.newAxis());
        }
        overlay.setDependentAxis(this.response2Axis);
        overlay.setIndependentAxis(this.categoryAxis);
        this.constraints.setType(1);
        this.add(overlay, this.constraints);
    }

    public void northEastOrientation() {
        this.chartAreaLayoutManager.setOrientation(0);
    }

    public void eastNorthOrientation() {
        this.chartAreaLayoutManager.setOrientation(6);
    }

    public void eastSouthOrientation() {
        this.chartAreaLayoutManager.setOrientation(7);
    }

    public void westNorthOrientation() {
        this.chartAreaLayoutManager.setOrientation(4);
    }

    public void southEastOrientation() {
        this.chartAreaLayoutManager.setOrientation(2);
    }

    public Axis getCategoryAxis() {
        return this.categoryAxis;
    }

    public Axis getResponseAxis() {
        return this.responseAxis;
    }

    public Axis setCategoryAxis(Axis newAxis) {
        return null;
    }

    public Axis setResponseAxis(Axis newAxis) {
        return null;
    }

    public Axis setSecondResponseAxis(Axis newAxis) {
        if (this.response2Axis == null) {
            this.response2Axis = newAxis;
            this.constraints.setType(5);
            this.add(this.response2Axis, this.constraints);
            this.axisTickAdjuster.addAxis(this.response2Axis);
            this.axisTickSpaceAdjuster.addAxis(this.response2Axis);
            return this.response2Axis;
        }
        return null;
    }

    public void setGrid(TwoAxisOverlay _grid) {
        if (this.grid != null) {
            this.remove(this.grid);
            this.grid.removeMouseListener(this.axisTickAdjuster);
            this.grid.removeMouseMotionListener(this.axisTickAdjuster);
            this.grid.removeMouseListener(this.axisTickSpaceAdjuster);
            this.grid.removeMouseMotionListener(this.axisTickSpaceAdjuster);
            this.grid = null;
        }
        if (_grid != null) {
            this.grid = _grid;
            this.grid.setDependentAxis(this.responseAxis);
            this.grid.setIndependentAxis(this.categoryAxis);
            this.constraints.setType(2);
            this.add(this.grid, this.constraints);
            this.grid.addMouseListener(this.axisTickAdjuster);
            this.grid.addMouseMotionListener(this.axisTickAdjuster);
            this.grid.addMouseListener(this.axisTickSpaceAdjuster);
            this.grid.addMouseMotionListener(this.axisTickSpaceAdjuster);
        }
    }

    public TwoAxisOverlay getGrid() {
        return this.grid;
    }
}

