/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.GlobalInfoTable;
import com.sas.collection.DictionaryInterface;
import com.sas.collection.PropertyBag;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.collection.PropertyBagChangedListenerList;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.graphics.chart.bean.PropertyClassInterface;
import com.sas.security.SecuritySupport;
import com.sas.util.Enum;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class StyleAdapter
implements PropertyBagInterface,
PropertyClassInterface,
Serializable {
    static final long serialVersionUID = -7610893931152064811L;
    private PropertyBagInterface propertyBagDeligate;
    private PropertyBagInterface propertyBagAncestor;
    private PropertyBagChangedListener propertyBagDeligateListener;
    private PropertyBagChangedListener propertyBagAncestorListener;
    private int eventGate;
    private boolean eventPending;
    private PropertyBagChangedListenerList propertyBagChangedListeners;
    private Vector monitoredProperties;

    public StyleAdapter() {
        this(null, null);
    }

    public StyleAdapter(PropertyBagInterface delegate) {
        this(delegate, null);
    }

    public StyleAdapter(PropertyBagInterface delegate, PropertyBagInterface ancestor) {
        this.propertyBagDeligate = delegate == null ? new PropertyBag() : delegate;
        this.propertyBagDeligateListener = new MyPropertyBagDeligateChangedListener();
        this.propertyBagDeligate.addPropertyBagChangedListener(this.propertyBagDeligateListener);
        if (ancestor != null) {
            this.propertyBagAncestor = ancestor;
            this.propertyBagAncestorListener = new MyPropertyBagAncestorChangedListener();
            this.propertyBagAncestor.addPropertyBagChangedListener(this.propertyBagAncestorListener);
        }
    }

    public void setPropertyBagAncestor(PropertyBagInterface newAncestor) {
        if (newAncestor != this.propertyBagAncestor) {
            if (this.propertyBagAncestor != null) {
                this.propertyBagAncestor.removePropertyBagChangedListener(this.propertyBagAncestorListener);
            }
            this.propertyBagAncestor = newAncestor;
            if (this.propertyBagAncestor != null) {
                if (this.propertyBagAncestorListener == null) {
                    this.propertyBagAncestorListener = new MyPropertyBagAncestorChangedListener();
                }
                this.propertyBagAncestor.addPropertyBagChangedListener(this.propertyBagAncestorListener);
            }
            this.firePropertyBagChanged();
        }
    }

    public PropertyBagInterface getPropertyBagAncestor() {
        return this.propertyBagAncestor;
    }

    public void setPropertyBagDelegate(PropertyBagInterface newDelegate) {
        if (newDelegate != this.propertyBagDeligate) {
            this.propertyBagDeligate.removePropertyBagChangedListener(this.propertyBagDeligateListener);
            this.propertyBagDeligate = newDelegate == null ? new PropertyBag() : newDelegate;
            this.propertyBagDeligate.addPropertyBagChangedListener(this.propertyBagDeligateListener);
            this.firePropertyBagChanged();
        }
    }

    public PropertyBagInterface getPropertyBagDelegate() {
        return this.propertyBagDeligate;
    }

    public void setPropertyBagDeligate(PropertyBagInterface newDelegate) {
        this.setPropertyBagDelegate(newDelegate);
    }

    public PropertyBagInterface getPropertyBagDeligate() {
        return this.getPropertyBagDelegate();
    }

    @Override
    public abstract Class getPropertyClass(String var1);

    protected void nonNullSet(String propertyID, Object newValue) {
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.set(propertyID, newValue);
    }

    public void set(String key, Object property) {
        if (property instanceof Enum) {
            this.propertyBagDeligate.set(key, (Object)EnumObject.toEnumObject((Enum)property));
        } else {
            this.propertyBagDeligate.set(key, property);
        }
    }

    public void remove(String key) {
        this.propertyBagDeligate.remove(key);
    }

    public void removeAll() {
        this.propertyBagDeligate.removeAll();
    }

    public void set(StaticPropertyBagInterface other) {
        this.propertyBagDeligate.set(other);
    }

    public void merge(StaticPropertyBagInterface other) {
        this.propertyBagDeligate.merge(other);
    }

    public int count() {
        return this.propertyBagDeligate.count();
    }

    public boolean containsKey(String key) {
        return this.propertyBagDeligate.containsKey(key) ? true : (this.propertyBagAncestor != null ? this.propertyBagAncestor.containsKey(key) : false);
    }

    public Object get(String key) {
        Object obj;
        try {
            Object ancestorObj;
            obj = this.propertyBagDeligate.get(key);
            if (obj instanceof EnumObject) {
                obj = EnumObject.toEnum((EnumObject)obj);
            } else if (obj instanceof StyleAdapter && this.propertyBagAncestor != null && this.propertyBagAncestor.containsKey(key) && (ancestorObj = this.propertyBagAncestor.get(key)) instanceof StyleAdapter) {
                Class<?> styleAdapterClass = obj.getClass();
                try {
                    StyleAdapter styleAdapterWrapper = (StyleAdapter)styleAdapterClass.newInstance();
                    styleAdapterWrapper.setPropertyBagAncestor((PropertyBagInterface)ancestorObj);
                    styleAdapterWrapper.setPropertyBagDeligate((PropertyBagInterface)obj);
                    obj = styleAdapterWrapper;
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        catch (NoSuchElementException e) {
            if (this.propertyBagAncestor != null) {
                obj = this.propertyBagAncestor.get(key);
            }
            throw e;
        }
        return obj;
    }

    public Object get(String key, Object defaultValue) {
        try {
            return this.get(key);
        }
        catch (NoSuchElementException e) {
            return defaultValue;
        }
    }

    public DictionaryInterface toDictionary(DictionaryInterface initialDictionary) {
        if (this.propertyBagAncestor != null) {
            initialDictionary = this.propertyBagAncestor.toDictionary(initialDictionary);
        }
        return this.propertyBagDeligate.toDictionary(initialDictionary);
    }

    public String[] listKeys() {
        int ii;
        if (this.propertyBagAncestor == null) {
            return this.propertyBagDeligate.listKeys();
        }
        String[] keys1 = this.propertyBagAncestor.listKeys();
        String[] keys2 = this.propertyBagDeligate.listKeys();
        Vector<String> merge = new Vector<String>(keys1.length + keys2.length);
        for (ii = 0; ii < keys1.length; ++ii) {
            if (merge.contains(keys1[ii])) continue;
            merge.addElement(keys1[ii]);
        }
        for (ii = 0; ii < keys2.length; ++ii) {
            if (merge.contains(keys2[ii])) continue;
            merge.addElement(keys2[ii]);
        }
        String[] keys = new String[merge.size()];
        for (int ii2 = 0; ii2 < keys.length; ++ii2) {
            keys[ii2] = (String)merge.elementAt(ii2);
        }
        return keys;
    }

    public Object clone() throws CloneNotSupportedException {
        StyleAdapter other = (StyleAdapter)super.clone();
        other.propertyBagDeligate = (PropertyBagInterface)this.propertyBagDeligate.clone();
        if (this.propertyBagAncestor != null) {
            other.propertyBagAncestor = (PropertyBagInterface)this.propertyBagAncestor.clone();
        }
        return other;
    }

    protected void firePropertyBagChanged() {
        this.notifyPropertyBagChanged(new PropertyBagChangedEvent((Object)this, null, null, null, null));
    }

    protected void firePropertyBagChanged(PropertyBagChangedEvent event) {
        this.notifyPropertyBagChanged(event);
    }

    public void addPropertyBagChangedListener(PropertyBagChangedListener listener) {
        if (this.propertyBagChangedListeners == null) {
            this.propertyBagChangedListeners = new PropertyBagChangedListenerList();
        }
        this.propertyBagChangedListeners.add(listener);
    }

    public void removePropertyBagChangedListener(PropertyBagChangedListener listener) {
        if (this.propertyBagChangedListeners != null) {
            this.propertyBagChangedListeners.remove(listener);
        }
    }

    protected void notifyPropertyBagChanged(PropertyBagChangedEvent event) {
        this.eventPending = true;
        if (this.eventGate > 0) {
            return;
        }
        if (this.propertyBagChangedListeners == null) {
            return;
        }
        this.eventPending = false;
        for (PropertyBagChangedListener listener : this.propertyBagChangedListeners.getListeners()) {
            listener.propertyBagChanged(event);
        }
    }

    protected boolean anyPropertyBagChangedListeners() {
        return this.eventGate == 0 && this.propertyBagChangedListeners != null && this.propertyBagChangedListeners.count() > 0;
    }

    public void disableEvents() {
        ++this.eventGate;
    }

    public synchronized void enableEvents() {
        this._enableEvents(true);
    }

    public synchronized void enableEvents(boolean firePendingEvent) {
        this._enableEvents(firePendingEvent);
    }

    private void _enableEvents(boolean firePendingEvent) {
        if (this.eventGate > 0) {
            --this.eventGate;
            if (this.eventPending && this.anyPropertyBagChangedListeners()) {
                this.eventPending = false;
                if (firePendingEvent) {
                    this.firePropertyBagChanged();
                }
            }
        }
    }

    public void setMonitoredProperties(Vector newSet) {
        this.monitoredProperties = newSet == null ? null : (Vector)newSet.clone();
    }

    public Vector getMonitoredProperties() {
        return this.monitoredProperties == null ? null : (Vector)this.monitoredProperties.clone();
    }

    public void addToMonitoredProperties(String propertyName) {
        if (propertyName != null) {
            if (this.monitoredProperties == null) {
                this.monitoredProperties = new Vector();
            }
            this.monitoredProperties.addElement(propertyName);
        }
    }

    public void removeFromMonitoredProperties(String propertyName) {
        if (propertyName != null && this.monitoredProperties != null) {
            this.monitoredProperties.removeElement(propertyName);
        }
    }

    private class MyPropertyBagDeligateChangedListener
    implements PropertyBagChangedListener,
    Serializable {
        private MyPropertyBagDeligateChangedListener() {
        }

        public void propertyBagChanged(PropertyBagChangedEvent e) {
            Object newValue;
            Vector monitoredProperties;
            String propertyName = e.getPropertyName();
            if (propertyName != null && (monitoredProperties = StyleAdapter.this.getMonitoredProperties()) != null && !monitoredProperties.contains(propertyName)) {
                return;
            }
            Object oldValue = e.getOldValue();
            if (oldValue instanceof EnumObject) {
                oldValue = EnumObject.toEnum((EnumObject)oldValue);
            }
            if ((newValue = e.getNewValue()) instanceof EnumObject) {
                newValue = EnumObject.toEnum((EnumObject)newValue);
            }
            PropertyBagChangedEvent newEvent = new PropertyBagChangedEvent((Object)StyleAdapter.this, propertyName, oldValue, newValue, e.howChanged());
            StyleAdapter.this.firePropertyBagChanged(newEvent);
        }
    }

    private class MyPropertyBagAncestorChangedListener
    implements PropertyBagChangedListener,
    Serializable {
        private MyPropertyBagAncestorChangedListener() {
        }

        public void propertyBagChanged(PropertyBagChangedEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName != null) {
                Vector monitoredProperties = StyleAdapter.this.getMonitoredProperties();
                if (monitoredProperties != null && !monitoredProperties.contains(propertyName)) {
                    return;
                }
                if (StyleAdapter.this.propertyBagDeligate.containsKey(propertyName)) {
                    return;
                }
            }
            PropertyBagChangedEvent newEvent = new PropertyBagChangedEvent((Object)StyleAdapter.this, propertyName, e.getOldValue(), e.getNewValue(), e.howChanged());
            StyleAdapter.this.firePropertyBagChanged(newEvent);
        }
    }

    public static class EnumObject
    implements Serializable {
        private String enumClassName;
        private int enumValue;

        public static EnumObject toEnumObject(Enum enumer) {
            EnumObject enumObject = new EnumObject();
            enumObject.enumClassName = enumer.getClass().getName();
            enumObject.enumValue = enumer.getValue();
            return enumObject;
        }

        public static Enum toEnum(EnumObject enumObject) {
            Enum enumer = null;
            if (enumObject != null) {
                try {
                    Class enumClass = GlobalInfoTable._loadClass((String)enumObject.enumClassName);
                    int enumValue = enumObject.enumValue;
                    try {
                        Method getEnum_Method = SecuritySupport.securitySupport.getMethod(enumClass, "getEnum", new Class[]{Integer.TYPE});
                        try {
                            enumer = (Enum)SecuritySupport.securitySupport.invokeMethod(getEnum_Method, null, new Object[]{new Integer(enumValue)});
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return enumer;
        }
    }
}

