/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.PublicClonable;
import com.sas.awt.CompositeInterface;
import com.sas.awt.Container;
import com.sas.awt.Label;
import com.sas.awt.Panel;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.PropertyBagChangedEvent;
import com.sas.collection.PropertyBagChangedListener;
import com.sas.graphics.chart.bean.ContentsStyle;
import com.sas.graphics.chart.bean.DependentVariable;
import com.sas.graphics.chart.bean.RB;
import com.sas.graphics.chart.bean.StatisticTypes;
import com.sas.graphics.chart.bean.Variable;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinition;
import com.sas.graphics.chart.util.ctk.AnalysisVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinition;
import com.sas.graphics.chart.util.ctk.ClassifierVariableDefinitionInterface;
import com.sas.graphics.chart.util.ctk.VariableDefinition;
import com.sas.graphics.chart.util.ctk.VariableDefinitionInterface;
import com.sas.util.EventGateInterface;
import com.sas.util.Util;
import com.sas.visuals.FullPaintInterface;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class ChartContainer
extends Container
implements ObjectInputValidation,
CompositeInterface,
FullPaintInterface,
PublicClonable {
    static final long serialVersionUID = 5829610433868136549L;
    public static final String RB_KEY = "ChartContainer.";
    public static final String TITLE1 = "title1";
    public static final String TITLE2 = "title2";
    public static final String TITLE3 = "title3";
    public static final String TITLE4 = "title4";
    public static final String FOOTNOTE1 = "footnote1";
    public static final String FOOTNOTE2 = "footnote2";
    protected static final String[] titleProperties = new String[]{"title1", "title2", "title3", "title4"};
    protected static final String[] footnoteProperties = new String[]{"footnote1", "footnote2"};
    public static int defaultWidth = 320;
    public static int defaultHeight = 240;
    protected static int minWidth = 160;
    protected static int minHeight = 120;
    protected ContentsStyle defaultContentsStyle;
    private transient java.awt.Container graphContainer;
    private transient java.awt.Container chartContainer;
    private transient java.awt.Container legendContainer;
    private transient java.awt.Container titleContainer;
    private transient java.awt.Container footnoteContainer;
    private transient Vector charts;
    private transient Vector legends;
    private transient Hashtable titles;
    private transient Hashtable footnotes;
    private transient Hashtable labelInfo;
    private transient MyLabelChangeListener labelChangeListener;
    private transient int paintGate;
    private transient boolean paintPending;
    private transient Hashtable statisticTypes2Ctkstatistics;
    protected static final String VERSION_1_DOT_2 = "Version: 1.2";
    private transient Storage storage;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "valid"}, {"Expert", "true"}}, {{"Name", "validator"}, {"Expert", "true"}}, {{"Name", "errorHandler"}, {"Expert", "true"}}, {{"Name", "layout"}, {"Hidden", "true"}}, {{"Name", "components"}, {"Hidden", "true"}}, {{"Name", "componentCount"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.ebi.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    private void init() {
        this.paintGate = 0;
        this.paintPending = false;
        this.charts = new Vector();
        this.legends = new Vector();
        this.titles = new Hashtable();
        this.footnotes = new Hashtable();
        this.labelChangeListener = new MyLabelChangeListener();
        this.labelInfo = new Hashtable();
        this.graphContainer = new NoUpdatePanel();
        this.graphContainer.setLayout(new GridBagLayout());
        this.titleContainer = new Container();
        this.titleContainer.setLayout(new GridBagLayout());
        this.chartContainer = new Container();
        this.chartContainer.setLayout(new GridBagLayout());
        this.legendContainer = new Container();
        this.legendContainer.setLayout(new GridBagLayout());
        this.footnoteContainer = new Container();
        this.footnoteContainer.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 5;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 11;
        this.graphContainer.add((Component)this.titleContainer, constraints);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.gridwidth = 5;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 15;
        this.graphContainer.add((Component)this.footnoteContainer, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 5;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        this.graphContainer.add((Component)this.chartContainer, constraints);
        constraints.gridx = 2;
        constraints.gridy = 4;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 15;
        this.graphContainer.add((Component)this.legendContainer, constraints);
        this.setLayout(new GridBagLayout());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        this.add((Component)this.graphContainer, constraints);
        this.statisticTypes2Ctkstatistics = new Hashtable();
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.AUTOMATIC, new Integer(12));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.MEAN, new Integer(1));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.FREQ, new Integer(2));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.PERCENTAGE_FREQ, new Integer(3));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.CUMULATIVE_FREQ, new Integer(4));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.CUMULATIVE_PERCENTAGE_FREQ, new Integer(5));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.SUM, new Integer(6));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.PERCENTAGE_SUM, new Integer(7));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.CUMULATIVE_SUM, new Integer(8));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.CUMULATIVE_PERCENTAGE_SUM, new Integer(9));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.MIN, new Integer(10));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.MAX, new Integer(11));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.FIRST, new Integer(12));
        this.statisticTypes2Ctkstatistics.put(StatisticTypes.LAST, new Integer(0));
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
        this.setIDEDnDDropBarrier(true);
        this.setIDEDnDDropTarget(false);
    }

    protected void invalidateAll() {
        int ii;
        int count;
        if (this.charts != null) {
            count = this.charts.size();
            for (ii = 0; ii < count; ++ii) {
                ((Component)this.charts.elementAt(ii)).invalidate();
            }
        }
        if (this.legends != null) {
            count = this.legends.size();
            for (ii = 0; ii < count; ++ii) {
                ((Component)this.legends.elementAt(ii)).invalidate();
            }
        }
        this.titleContainer.invalidate();
        this.footnoteContainer.invalidate();
        this.chartContainer.invalidate();
        this.legendContainer.invalidate();
        this.graphContainer.invalidate();
    }

    protected void refresh() {
        this.invalidateAll();
        this.paintPending = true;
        if (this.isFullPaintEnabled()) {
            this.graphContainer.validate();
            this.graphContainer.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        this.paintPending = true;
        if (this.isFullPaintEnabled()) {
            this.paintPending = false;
            super.paint(g);
        }
    }

    public boolean isFullPaintEnabled() {
        return this.paintGate == 0;
    }

    @Override
    public void disableFullPaint() {
        if (this.isFullPaintEnabled()) {
            int ii;
            int count;
            if (this.charts != null) {
                count = this.charts.size();
                for (ii = 0; ii < count; ++ii) {
                    Object chart = this.charts.elementAt(ii);
                    if (!(chart instanceof FullPaintInterface)) continue;
                    ((FullPaintInterface)chart).disableFullPaint();
                }
            }
            if (this.legends != null) {
                count = this.legends.size();
                for (ii = 0; ii < count; ++ii) {
                    Object legend = this.legends.elementAt(ii);
                    if (!(legend instanceof FullPaintInterface)) continue;
                    ((FullPaintInterface)legend).disableFullPaint();
                }
            }
        }
        ++this.paintGate;
    }

    @Override
    public synchronized void enableFullPaint() {
        this._enableFullPaint(true);
    }

    public synchronized void enableFullPaint(boolean updateNow) {
        this._enableFullPaint(updateNow);
    }

    private void _enableFullPaint(boolean updateNow) {
        if (!this.isFullPaintEnabled()) {
            this.paintGate = Math.max(0, this.paintGate - 1);
            if (this.isFullPaintEnabled()) {
                int ii;
                int count;
                if (this.charts != null) {
                    count = this.charts.size();
                    for (ii = 0; ii < count; ++ii) {
                        Object chart = this.charts.elementAt(ii);
                        if (!(chart instanceof FullPaintInterface)) continue;
                        ((FullPaintInterface)chart).enableFullPaint();
                    }
                }
                if (this.legends != null) {
                    count = this.legends.size();
                    for (ii = 0; ii < count; ++ii) {
                        Object legend = this.legends.elementAt(ii);
                        if (!(legend instanceof FullPaintInterface)) continue;
                        ((FullPaintInterface)legend).enableFullPaint();
                    }
                }
                if (this.paintPending) {
                    this.paintPending = false;
                    if (updateNow) {
                        if (!this.isValid()) {
                            this.validate();
                        }
                        this.repaint();
                    }
                }
            }
        }
    }

    protected void stylePropertyBagChanged(PropertyBagChangedEvent e) {
        this.repaint();
    }

    public ContentsStyle getDefaultContentsStyle() {
        return this.defaultContentsStyle;
    }

    public void setDefaultContentsStyle(ContentsStyle newValue) {
        if (newValue == this.defaultContentsStyle) {
            return;
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        ContentsStyle oldValue = this.defaultContentsStyle;
        this.defaultContentsStyle = newValue;
        this.repaint();
        this.firePropertyChange("defaultContentsStyle", oldValue, newValue);
    }

    public synchronized void setTitle(Label newTitle, int position) {
        if (position < 1 || position > titleProperties.length) {
            throw new IllegalArgumentException();
        }
        Label oldTitle = this.getTitle(position);
        this._setLabel(this.titleContainer, this.titles, newTitle, position);
        newTitle = this.getTitle(position);
        if (Util.unequal((Object)oldTitle, (Object)newTitle)) {
            this.firePropertyChange(titleProperties[position - 1], oldTitle, newTitle);
        }
    }

    private void _setLabel(java.awt.Container container, Hashtable list, Label label, int position) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = position;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        Integer key = new Integer(position);
        Label oldLabel = (Label)list.get(key);
        if (oldLabel != label) {
            if (oldLabel != null) {
                label.removePropertyChangeListener(this.labelChangeListener);
                container.remove(oldLabel);
                list.remove(key);
                this.labelInfo.remove(oldLabel);
            }
            if (label != null) {
                Hashtable<String, Serializable> labelProperties = new Hashtable<String, Serializable>();
                labelProperties.put("container", container);
                labelProperties.put("constraints", constraints);
                this.labelInfo.put(label, labelProperties);
                list.put(key, label);
                label.addPropertyChangeListener(this.labelChangeListener);
                if (label.getText() != null && label.getText().length() > 0) {
                    container.add((Component)label, constraints);
                }
            }
        }
    }

    public synchronized Label getTitle(int position) {
        if (position < 1 || position > titleProperties.length) {
            throw new IllegalArgumentException();
        }
        Label title = null;
        if (this.titles != null) {
            Integer key = new Integer(position);
            title = (Label)this.titles.get(key);
        }
        if (title == null) {
            title = new Label("");
            title.initialize();
            title.setName("Title " + position);
            title.setResizeToFit(true);
            this._setLabel(this.titleContainer, this.titles, title, position);
        }
        return title;
    }

    public synchronized void setFootnote(Label newFootnote, int position) {
        if (position < 1 || position > footnoteProperties.length) {
            throw new IllegalArgumentException();
        }
        Label oldFootnote = this.getFootnote(position);
        this._setLabel(this.footnoteContainer, this.footnotes, newFootnote, position);
        newFootnote = this.getFootnote(position);
        if (Util.unequal((Object)oldFootnote, (Object)newFootnote)) {
            this.firePropertyChange(footnoteProperties[position - 1], oldFootnote, newFootnote);
        }
    }

    public synchronized Label getFootnote(int position) {
        if (position < 1 || position > footnoteProperties.length) {
            throw new IllegalArgumentException();
        }
        Label footnote = null;
        if (this.footnotes != null) {
            Integer key = new Integer(position);
            footnote = (Label)this.footnotes.get(key);
        }
        if (footnote == null) {
            footnote = new Label("");
            footnote.initialize();
            footnote.setName("Footnote " + position);
            footnote.setResizeToFit(true);
            this._setLabel(this.footnoteContainer, this.footnotes, footnote, position);
        }
        return footnote;
    }

    protected void setInChartContainer(Component comp) {
        this._setInContainer(this.chartContainer, this.charts, comp);
    }

    protected void addToChartContainer(Component comp, GridBagConstraints constraints) {
        this._addToContainer(this.chartContainer, this.charts, comp, constraints);
    }

    protected void removeFromChartContainer(Component comp) {
        this._removeFromContainer(this.chartContainer, this.charts, comp);
    }

    protected void removeAllFromChartContainer() {
        this._removeAllFromContainer(this.chartContainer, this.charts);
    }

    protected void setInLegendContainer(Component comp) {
        this._setInContainer(this.legendContainer, this.legends, comp);
    }

    protected void addToLegendContainer(Component comp, GridBagConstraints constraints) {
        this._addToContainer(this.legendContainer, this.legends, comp, constraints);
    }

    protected void removeFromLegendContainer(Component comp) {
        this._removeFromContainer(this.legendContainer, this.legends, comp);
    }

    protected void removeAllFromLegendContainer() {
        this._removeAllFromContainer(this.legendContainer, this.legends);
    }

    private void _setInContainer(java.awt.Container container, Vector list, Component component) {
        container.removeAll();
        list.removeAllElements();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        this._addToContainer(container, list, component, constraints);
        this.validate();
    }

    private void _addToContainer(java.awt.Container container, Vector list, Component component, GridBagConstraints constraints) {
        if (constraints == null) {
            throw new IllegalArgumentException();
        }
        if (component != null) {
            container.add(component, constraints);
            list.addElement(component);
        }
    }

    private void _removeFromContainer(java.awt.Container container, Vector list, Component component) {
        list.removeElement(component);
        container.remove(component);
    }

    private void _removeAllFromContainer(java.awt.Container container, Vector list) {
        list.removeAllElements();
        container.removeAll();
    }

    protected VariableDefinitionInterface _conveyVariableToVariableDefinition(Variable variable, VariableDefinitionInterface variableDefinition) {
        if (variableDefinition == null) {
            variableDefinition = new VariableDefinition();
        }
        if (variableDefinition instanceof EventGateInterface) {
            ((EventGateInterface)variableDefinition).disableEvents();
        }
        if (variable != null) {
            String informat;
            String format;
            String userlabel;
            variableDefinition.setName(null);
            if (!variable.isAutomatic()) {
                int index;
                String label;
                String name = variable.getColumnName();
                if (name != null && name.length() > 0) {
                    variableDefinition.setName(name);
                }
                if ((label = variable.getColumnLabel()) != null && label.length() > 0) {
                    variableDefinition.setLabel(label);
                }
                if ((index = variable.getColumnIndex()) > 0) {
                    variableDefinition.setIndex(new Integer(index));
                }
            }
            if ((userlabel = variable.getUserLabel()) != null && userlabel.length() > 0) {
                variableDefinition.setUserLabel(userlabel);
            }
            if ((format = variable.getFormat()) != null && format.length() > 0) {
                variableDefinition.setFormat(format);
            }
            if ((informat = variable.getInformat()) != null && informat.length() > 0) {
                variableDefinition.setInformat(informat);
            }
        }
        if (variableDefinition instanceof EventGateInterface) {
            ((EventGateInterface)variableDefinition).enableEvents();
        }
        return variableDefinition;
    }

    protected ClassifierVariableDefinitionInterface _conveyVariableToVariableDefinition(Variable variable, ClassifierVariableDefinitionInterface variableDefinition) {
        if (variableDefinition == null) {
            variableDefinition = new ClassifierVariableDefinition();
        }
        if (variableDefinition instanceof EventGateInterface) {
            ((EventGateInterface)variableDefinition).disableEvents();
        }
        this._conveyVariableToVariableDefinition(variable, (VariableDefinitionInterface)variableDefinition);
        if (variableDefinition instanceof EventGateInterface) {
            ((EventGateInterface)variableDefinition).enableEvents();
        }
        return variableDefinition;
    }

    protected AnalysisVariableDefinitionInterface _conveyVariableToVariableDefinition(Variable variable, AnalysisVariableDefinitionInterface variableDefinition) {
        if (variableDefinition == null) {
            variableDefinition = new AnalysisVariableDefinition();
        }
        if (variableDefinition instanceof EventGateInterface) {
            ((EventGateInterface)variableDefinition).disableEvents();
        }
        this._conveyVariableToVariableDefinition(variable, (VariableDefinitionInterface)variableDefinition);
        if (variable instanceof DependentVariable) {
            StatisticTypes statisticType = ((DependentVariable)variable).getStatistic();
            variableDefinition.setStatistic(this._statisticTypes2CtkStatistics(statisticType));
        }
        if (variableDefinition instanceof EventGateInterface) {
            ((EventGateInterface)variableDefinition).enableEvents();
        }
        return variableDefinition;
    }

    protected Integer _statisticTypes2CtkStatistics(StatisticTypes statisticType) {
        return statisticType == null ? new Integer(0) : (Integer)this.statisticTypes2Ctkstatistics.get((Object)statisticType);
    }

    @Override
    public void validateObject() {
        this.disableFullPaint();
        this.removeAll();
        this.setDefaultValues();
        super.validateObject();
        this.restore();
        System.gc();
        this.enableFullPaint();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(VERSION_1_DOT_2);
        this._writeVer1Dot2(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            String version = (String)in.readObject();
            this.storage = VERSION_1_DOT_2.equals(version) ? this._readVer1Dot2(in) : null;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void _writeVer1Dot2(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getTitle(1));
        out.writeObject(this.getTitle(2));
        out.writeObject(this.getTitle(3));
        out.writeObject(this.getTitle(4));
        out.writeObject(this.getFootnote(1));
        out.writeObject(this.getFootnote(2));
    }

    private Storage _readVer1Dot2(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Storage storage = new Storage();
        storage.title1 = (Label)in.readObject();
        storage.title2 = (Label)in.readObject();
        storage.title3 = (Label)in.readObject();
        storage.title4 = (Label)in.readObject();
        storage.footnote1 = (Label)in.readObject();
        storage.footnote2 = (Label)in.readObject();
        return storage;
    }

    protected void restore() {
        if (this.storage == null) {
            return;
        }
        this._setLabel(this.titleContainer, this.titles, this.storage.title1, 1);
        this._setLabel(this.titleContainer, this.titles, this.storage.title2, 2);
        this._setLabel(this.titleContainer, this.titles, this.storage.title3, 3);
        this._setLabel(this.titleContainer, this.titles, this.storage.title4, 4);
        this._setLabel(this.footnoteContainer, this.footnotes, this.storage.footnote1, 1);
        this._setLabel(this.footnoteContainer, this.footnotes, this.storage.footnote2, 2);
        this.storage = null;
    }

    public static class NoUpdatePanel
    extends Panel {
        @Override
        public void update(Graphics g) {
            this.paint(g);
        }
    }

    private class Storage {
        public Label title1;
        public Label title2;
        public Label title3;
        public Label title4;
        public Label footnote1;
        public Label footnote2;

        private Storage() {
        }
    }

    private class MyLabelChangeListener
    implements PropertyChangeListener {
        private MyLabelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("text".equals(propertyName)) {
                boolean delete;
                String oldText = (String)evt.getOldValue();
                String newText = (String)evt.getNewValue();
                if (oldText != null && oldText.length() < 1) {
                    oldText = null;
                }
                if (newText != null && newText.length() < 1) {
                    newText = null;
                }
                boolean add = oldText == null && newText != null;
                boolean bl = delete = oldText != null && newText == null;
                if (add || delete) {
                    Label label = (Label)evt.getSource();
                    Hashtable labelProperties = (Hashtable)ChartContainer.this.labelInfo.get(label);
                    java.awt.Container container = (java.awt.Container)labelProperties.get("container");
                    if (add) {
                        GridBagConstraints constraints = (GridBagConstraints)labelProperties.get("constraints");
                        container.add((Component)label, constraints);
                    } else {
                        container.remove(label);
                    }
                }
            }
        }
    }

    private class StylePropertyBagChangedListener
    implements PropertyBagChangedListener {
        private StylePropertyBagChangedListener() {
        }

        public void propertyBagChanged(PropertyBagChangedEvent e) {
            ChartContainer.this.stylePropertyBagChanged(e);
        }
    }
}

