/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.bean;

import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.bean.AxisStyle;
import com.sas.graphics.chart.bean.RB;
import com.sas.util.Util;
import java.io.Serializable;

public class Axis
extends Component
implements Serializable {
    static final long serialVersionUID = 1458169367770867883L;
    public static final String RB_KEY = "Axis.";
    public static final String STYLE = "style";
    public static final String DEFAULT_STYLE = "defaultStyle";
    protected AxisStyle _baseAxisStyle;
    private AxisStyle _defaultAxisStyle;
    private AxisStyle _axisStyle;
    private AxisStyle defaultAxisStyle;
    private AxisStyle axisStyle;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", STYLE}, {"Short description", RB.getStringResource(RB_KEY, "style.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "style.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Axis() {
    }

    public Axis(AxisStyle newAxisStyle) {
        this();
        this.axisStyle = newAxisStyle;
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.init();
    }

    private void init() {
        this._baseAxisStyle = this._initBaseStyle();
        this._defaultAxisStyle = this._newAxisStyle();
        this._axisStyle = this._newAxisStyle();
        this._defaultAxisStyle.setPropertyBagDelegate(this._newAxisStyle());
        this._defaultAxisStyle.setPropertyBagAncestor(this._baseAxisStyle);
        this._axisStyle.setPropertyBagAncestor(this._defaultAxisStyle);
        if (this.axisStyle != null) {
            this._axisStyle.setPropertyBagDelegate(this.axisStyle);
        } else {
            this._axisStyle.setPropertyBagDelegate(this._newAxisStyle());
        }
    }

    protected AxisStyle _newAxisStyle() {
        return new AxisStyle();
    }

    private AxisStyle _initBaseStyle() {
        return this._initBaseStyle(this._newAxisStyle());
    }

    protected AxisStyle _initBaseStyle(AxisStyle baseStyle) {
        return baseStyle;
    }

    public void setStyle(AxisStyle newStyle) {
        if (this.axisStyle == newStyle) {
            return;
        }
        AxisStyle oldStyle = this.getStyle();
        this.axisStyle = newStyle;
        this._axisStyle.setPropertyBagDelegate(this.axisStyle == null ? new AxisStyle() : this.axisStyle);
        newStyle = this.getStyle();
        if (Util.unequal((Object)oldStyle, (Object)newStyle)) {
            this.firePropertyChange(STYLE, oldStyle, newStyle);
        }
    }

    public AxisStyle getStyle() {
        return (AxisStyle)this._axisStyle.getPropertyBagDeligate();
    }

    public void setDefaultStyle(AxisStyle newStyle) {
        if (this.axisStyle == newStyle) {
            return;
        }
        AxisStyle oldStyle = this.getDefaultStyle();
        this.defaultAxisStyle = newStyle;
        this._defaultAxisStyle.setPropertyBagDelegate(this.defaultAxisStyle == null ? new AxisStyle() : this.defaultAxisStyle);
        newStyle = this.getDefaultStyle();
        if (Util.unequal((Object)oldStyle, (Object)newStyle)) {
            this.firePropertyChange(DEFAULT_STYLE, oldStyle, newStyle);
        }
    }

    public AxisStyle getDefaultStyle() {
        return (AxisStyle)this._defaultAxisStyle.getPropertyBagDeligate();
    }

    public final AxisStyle getEffectiveStyle() {
        return this._axisStyle;
    }
}

