/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.RB;
import com.sas.util.Util;
import java.awt.Color;
import java.io.Serializable;
import java.util.Map;

public class TextStyle
extends Component
implements Serializable {
    static final long serialVersionUID = -4991443216071554165L;
    public static final String RB_KEY = "TextStyle.";
    protected com.sas.graphics.util.visualize.TextStyle textStyle;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "fontFamily"}, {"Short description", RB.getStringResource(RB_KEY, "fontFamily.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "fontFamily.pd.txt")}}, {{"Name", "bold"}, {"Short description", RB.getStringResource(RB_KEY, "bold.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "bold.pd.txt")}}, {{"Name", "italic"}, {"Short description", RB.getStringResource(RB_KEY, "italic.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "italic.pd.txt")}}, {{"Name", "color"}, {"Short description", RB.getStringResource(RB_KEY, "color.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "color.pd.txt")}}, {{"Name", "size"}, {"Short description", RB.getStringResource(RB_KEY, "size.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "size.pd.txt")}}, {{"Name", "minChars"}, {"Short description", RB.getStringResource(RB_KEY, "minChars.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "minChars.pd.txt")}}, {{"Name", "maxChars"}, {"Short description", RB.getStringResource(RB_KEY, "maxChars.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "maxChars.pd.txt")}}, {{"Name", "sizeRange"}, {"Short description", RB.getStringResource(RB_KEY, "sizeRange.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "sizeRange.pd.txt")}}, {{"Name", "fixedSize"}, {"Short description", RB.getStringResource(RB_KEY, "fixedSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "fixedSize.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public TextStyle() {
        this.textStyle = new com.sas.graphics.util.visualize.TextStyle();
    }

    public TextStyle(TextStyle textStyleIn) {
        this.textStyle = new com.sas.graphics.util.visualize.TextStyle(textStyleIn.textStyle);
    }

    public TextStyle(String fontFamilyIn, boolean boldIn, boolean italicIn, Color colorIn, double sizeIn, int maxCharsIn) {
        fontFamilyIn = this.upcaseFontFamily(fontFamilyIn);
        this.textStyle = new com.sas.graphics.util.visualize.TextStyle(fontFamilyIn, boldIn, italicIn, colorIn, sizeIn, maxCharsIn);
    }

    protected TextStyle(com.sas.graphics.util.visualize.TextStyle textStyleIn) {
        this.textStyle = textStyleIn;
    }

    public String getFontFamily() {
        return this.upcaseFontFamily(this.textStyle.getFontFamily());
    }

    public void setFontFamily(String fontFamilyIn) {
        String oldValue = this.getFontFamily();
        if (Util.equal((Object)fontFamilyIn, (Object)oldValue)) {
            return;
        }
        this.textStyle.setFontFamily(this.upcaseFontFamily(fontFamilyIn));
        this.firePropertyChange("fontFamily", oldValue, fontFamilyIn);
    }

    public boolean isBold() {
        return this.textStyle.getBold();
    }

    public void setBold(boolean boldIn) {
        boolean oldValue = this.isBold();
        if (boldIn == oldValue) {
            return;
        }
        this.textStyle.setBold(boldIn);
        this.firePropertyChange("bold", new Boolean(oldValue), new Boolean(boldIn));
    }

    public boolean isItalic() {
        return this.textStyle.getItalic();
    }

    public void setItalic(boolean italicIn) {
        boolean oldValue = this.isItalic();
        if (italicIn == oldValue) {
            return;
        }
        this.textStyle.setItalic(italicIn);
        this.firePropertyChange("italic", new Boolean(oldValue), new Boolean(italicIn));
    }

    public void setSize(double size) {
        double oldValue = this.getSize();
        if (size == oldValue) {
            return;
        }
        if (size < 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "size.ex.txt"));
        }
        this.textStyle.setSize(size);
        this.firePropertyChange("size", new Double(oldValue), new Double(size));
    }

    public double getSize() {
        return this.textStyle.getSize();
    }

    public void setSizeRange(double range) {
        double oldValue = this.getSizeRange();
        if (range == this.textStyle.getSizeRange()) {
            return;
        }
        if (range < 0.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "sizeRange.ex.txt"));
        }
        this.textStyle.setSizeRange(range);
        this.firePropertyChange("sizeRange", new Double(oldValue), new Double(range));
    }

    public double getSizeRange() {
        return this.textStyle.getSizeRange();
    }

    public void setFixedSize(boolean scale) {
        boolean oldValue = this.isFixedSize();
        if (scale == oldValue) {
            return;
        }
        this.textStyle.setScalable(!scale);
        this.firePropertyChange("fixedSize", new Boolean(oldValue), new Boolean(scale));
    }

    public boolean isFixedSize() {
        return !this.textStyle.isScalable();
    }

    public void setMinChars(int size) {
        int oldValue = this.getMinChars();
        if (size == oldValue) {
            return;
        }
        if (size < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "minChars.ex.txt"));
        }
        this.textStyle.setMinChars(size);
        this.firePropertyChange("minChars", new Integer(oldValue), new Integer(size));
    }

    public int getMinChars() {
        return this.textStyle.getMinChars();
    }

    public void setMaxChars(int size) {
        int oldValue = this.getMaxChars();
        if (size == oldValue) {
            return;
        }
        if (size < 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "maxChars.ex.txt"));
        }
        this.textStyle.setMaxChars(size);
        this.firePropertyChange("maxChars", new Integer(oldValue), new Integer(size));
    }

    public int getMaxChars() {
        return this.textStyle.getMaxChars();
    }

    public Color getColor() {
        return this.textStyle.getColor();
    }

    public void setColor(Color colorIn) {
        Color oldValue = this.getColor();
        if (Util.equal((Object)colorIn, (Object)oldValue)) {
            return;
        }
        this.textStyle.setColor(colorIn);
        this.firePropertyChange("color", oldValue, colorIn);
    }

    public Map getAttributes() {
        return this.textStyle.getAttributes();
    }

    public void setAttributes(Map attribIn) {
        Map oldValue = this.getAttributes();
        if (Util.equal((Object)attribIn, (Object)oldValue)) {
            return;
        }
        this.textStyle.setAttributes(attribIn);
        this.firePropertyChange("attributes", oldValue, attribIn);
    }

    protected String upcaseFontFamily(String fontFamily) {
        String newFamily = fontFamily;
        if (fontFamily == null) {
            return null;
        }
        if (fontFamily.equalsIgnoreCase("sansserif")) {
            newFamily = "SansSerif";
        } else if (fontFamily.equalsIgnoreCase("dialog")) {
            newFamily = "Dialog";
        } else if (fontFamily.equalsIgnoreCase("serif")) {
            newFamily = "Serif";
        } else if (fontFamily.equalsIgnoreCase("monospaced")) {
            newFamily = "Monospaced";
        } else if (fontFamily.equalsIgnoreCase("dialoginput")) {
            newFamily = "DialogInput";
        }
        return newFamily;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextStyle)) {
            return false;
        }
        TextStyle t = (TextStyle)obj;
        return Util.equal((Object)this.getFontFamily(), (Object)t.getFontFamily()) && this.isBold() == t.isBold() && this.isItalic() == t.isItalic() && this.getSize() == t.getSize() && this.getSizeRange() == t.getSizeRange() && this.isFixedSize() == t.isFixedSize() && this.getMinChars() == t.getMinChars() && this.getMaxChars() == t.getMaxChars() && this.getColor().equals(t.getColor());
    }
}

