/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.Color;
import com.sas.graphics.chart.JoinTypes;
import com.sas.graphics.chart.MarkerGeometryTypes;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.ScatterSampleData;
import com.sas.graphics.util.visualize.Variable;
import java.io.Serializable;

public class Scatter
extends Color
implements Serializable {
    static final long serialVersionUID = -7209653911850594100L;
    public static final String RB_KEY = "Scatter.";
    protected com.sas.graphics.util.visualize.Scatter scatter = new com.sas.graphics.util.visualize.Scatter(RB.getStringResource("Scatter.", "defaultTitle.txt"));

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "markerType"}, {"Short description", RB.getStringResource(RB_KEY, "markerType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "markerType.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedMarkerGeometryTypesEditor"}}, {{"Name", "markerSize"}, {"Short description", RB.getStringResource(RB_KEY, "markerSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "markerSize.pd.txt")}}, {{"Name", "absoluteMarkerSize"}, {"Short description", RB.getStringResource(RB_KEY, "absMarkerSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absMarkerSize.pd.txt")}}, {{"Name", "joinType"}, {"Short description", RB.getStringResource(RB_KEY, "joinType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "joinType.pd.txt")}, {"Property editor class", "com.sas.graphics.chart.ModifiedJoinTypesEditor"}}, {{"Name", "joinSize"}, {"Short description", RB.getStringResource(RB_KEY, "joinSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "joinSize.pd.txt")}}, {{"Name", "absoluteJoinSize"}, {"Short description", RB.getStringResource(RB_KEY, "absJoinSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absJoinSize.pd.txt")}}, {{"Name", "absoluteSize"}, {"Short description", RB.getStringResource(RB_KEY, "absoluteSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "absoluteSize.pd.txt")}}, {{"Name", "mapShapes"}, {"Short description", RB.getStringResource(RB_KEY, "mapShapes.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "mapShapes.pd.txt")}, {"Hidden", "true"}}, {{"Name", "mapJoins"}, {"Short description", RB.getStringResource(RB_KEY, "mapJoins.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "mapJoins.pd.txt")}, {"Hidden", "true"}}, {{"Name", "categoryVariableName"}, {"Hidden", "true"}}, {{"Name", "subGroupVariableName"}, {"Hidden", "true"}}, {{"Name", "groupVariableName"}, {"Hidden", "true"}}, {{"Name", "response2VariableName"}, {"Hidden", "true"}}, {{"Name", "responseHeightVariableName"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Scatter() {
        this.colorCityscape = this.scatter;
        this.cityscape = this.scatter;
        this.visualization = this.scatter;
    }

    @Override
    public void initialize() {
        if (this.sample == null) {
            this.sample = new ScatterSampleData();
        }
        super.initialize();
    }

    public MarkerGeometryTypes getMarkerType() {
        return MarkerGeometryTypes.getEnum(this.scatter.getMarkerType());
    }

    public void setMarkerType(MarkerGeometryTypes markerType) {
        if (markerType.getValue() == this.scatter.getMarkerType()) {
            return;
        }
        MarkerGeometryTypes oldValue = this.getMarkerType();
        this.scatter.setMarkerType(markerType.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("markerType", (Object)oldValue, (Object)markerType);
    }

    public double getMarkerSize() {
        return this.scatter.getMarkerSize();
    }

    public void setMarkerSize(double markerSize) {
        double oldValue = this.getMarkerSize();
        if (markerSize == oldValue) {
            return;
        }
        if (markerSize < 0.0 || markerSize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "markerSize.ex.txt"));
        }
        this.scatter.setMarkerSize(markerSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("markerSize", new Double(oldValue), new Double(markerSize));
    }

    public JoinTypes getJoinType() {
        return JoinTypes.getEnum(this.scatter.getJoinType());
    }

    public void setJoinType(JoinTypes joinType) {
        if (joinType.getValue() == this.scatter.getJoinType()) {
            return;
        }
        JoinTypes oldValue = this.getJoinType();
        this.scatter.setJoinType(joinType.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("joinType", (Object)oldValue, (Object)joinType);
    }

    public double getJoinSize() {
        return this.scatter.getJoinSize();
    }

    public void setJoinSize(double joinSize) {
        double oldValue = this.getJoinSize();
        if (joinSize == oldValue) {
            return;
        }
        if (joinSize < 0.0 || joinSize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "joinSize.ex.txt"));
        }
        this.scatter.setJoinSize(joinSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("joinSize", new Double(oldValue), new Double(joinSize));
    }

    public boolean isAbsoluteSize() {
        return this.scatter.isAbsoluteSize();
    }

    public void setAbsoluteSize(boolean absolute) {
        boolean oldValue = this.isAbsoluteSize();
        if (absolute == oldValue) {
            return;
        }
        this.scatter.setAbsoluteSize(absolute);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteSize", new Boolean(oldValue), new Boolean(absolute));
    }

    public int getAbsoluteJoinSize() {
        return this.scatter.getAbsoluteJoinSize();
    }

    public void setAbsoluteJoinSize(int joinSize) {
        int oldValue = this.getAbsoluteJoinSize();
        if (joinSize == oldValue) {
            return;
        }
        if (joinSize < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absJoinSize.ex.txt"));
        }
        this.scatter.setAbsoluteJoinSize(joinSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteJoinSize", new Integer(oldValue), new Integer(joinSize));
    }

    public int getAbsoluteMarkerSize() {
        return this.scatter.getAbsoluteMarkerSize();
    }

    public void setAbsoluteMarkerSize(int size) {
        int oldValue = this.getAbsoluteMarkerSize();
        if (size == this.scatter.getAbsoluteMarkerSize()) {
            return;
        }
        if (size < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absMarkerSize.ex.txt"));
        }
        this.scatter.setAbsoluteMarkerSize(size);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteMarkerSize", new Integer(oldValue), new Integer(size));
    }

    public MarkerGeometryTypes[] getMapShapes() {
        int[] shapes = this.scatter.getMapShapes();
        if (shapes == null) {
            return null;
        }
        MarkerGeometryTypes[] map = new MarkerGeometryTypes[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            map[i] = MarkerGeometryTypes.getEnum(shapes[i]);
        }
        return map;
    }

    public void setMapShapes(MarkerGeometryTypes[] shapes) {
        if (shapes == null) {
            return;
        }
        int[] map = new int[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            map[i] = shapes[i] == null ? MarkerGeometryTypes.get("BOX").getValue() : (shapes[i].toString().equals("USER_DEFINED") ? MarkerGeometryTypes.get("BOX").getValue() : shapes[i].getValue());
        }
        this.scatter.setMapShapes(map);
        this.scatter.setMarkerType(MarkerGeometryTypes.get("USER_DEFINED").getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("mapShapes", null, shapes);
    }

    public JoinTypes[] getMapJoins() {
        int[] joins = this.scatter.getMapJoins();
        if (joins == null) {
            return null;
        }
        JoinTypes[] map = new JoinTypes[joins.length];
        for (int i = 0; i < joins.length; ++i) {
            map[i] = JoinTypes.getEnum(joins[i]);
        }
        return map;
    }

    public void setMapJoins(JoinTypes[] joins) {
        if (joins == null) {
            return;
        }
        int[] map = new int[joins.length];
        for (int i = 0; i < joins.length; ++i) {
            map[i] = joins[i] == null ? JoinTypes.get("NONE").getValue() : (joins[i].toString().equals("NEEDLE") ? JoinTypes.get("NONE").getValue() : (joins[i].toString().equals("USER_DEFINED") ? JoinTypes.get("NONE").getValue() : joins[i].getValue()));
        }
        this.scatter.setMapJoins(map);
        this.scatter.setJoinType(JoinTypes.get("USER_DEFINED").getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("mapJoins", null, joins);
    }

    @Override
    protected void resetNoneVariables() {
        Variable variable = this.scatter.getRowVariable();
        if (variable != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.scatter.getColumnVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.scatter.getHeightVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.scatter.getColorVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.scatter.getGroupVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Scatter clone = (Scatter)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.initialize();
            clone.setTitle(this.getTitle());
            clone.setTitleStyle(this.getTitleStyle());
            clone.setDepth(this.getDepth());
            clone.setMapColors(this.getMapColors());
            clone.setBackground(this.getBackground());
            clone.setBackgroundImage(this.getBackgroundImage());
            clone.setTransparent(this.isTransparent());
            clone.setOutlineColor(this.getOutlineColor());
            clone.setDataTipStyle(this.getDataTipStyle());
            clone.setResolution(this.getResolution());
            clone.setDatatipDoubleBuffered(this.isDatatipDoubleBuffered());
            clone.setMaxObservations(this.getMaxObservations());
            clone.setDisplayChartType(this.isDisplayChartType());
            clone.setShowStatistic(this.isShowStatistic());
            clone.setHidePopupMenu(this.isHidePopupMenu());
            clone.setPopupColumnInfoUsed(this.getPopupColumnInfoUsed());
            clone.setSwanStyleData(this.isSwanStyleData());
            clone.setBackplaneVisible(this.isBackplaneVisible());
            clone.setBackplaneColor(this.getBackplaneColor());
            clone.setRowVariable(this.getRowVariable());
            clone.setRowAxisStyle(this.getRowAxisStyle());
            clone.setColumnVariable(this.getColumnVariable());
            clone.setColumnAxisStyle(this.getColumnAxisStyle());
            clone.setHeightVariable(this.getHeightVariable());
            clone.setHeightAxisStyle(this.getHeightAxisStyle());
            clone.setColorVariable(this.getColorVariable());
            clone.setColorLegendStyle(this.getColorLegendStyle());
            clone.setGroupVariable(this.getGroupVariable());
            clone.setGroupLegendStyle(this.getGroupLegendStyle());
            clone.setMapShapes(this.getMapShapes());
            clone.setMapJoins(this.getMapJoins());
            clone.setMarkerType(this.getMarkerType());
            clone.setMarkerSize(this.getMarkerSize());
            clone.setJoinType(this.getJoinType());
            clone.setJoinSize(this.getJoinSize());
            clone.setAbsoluteSize(this.isAbsoluteSize());
            clone.setAbsoluteJoinSize(this.getAbsoluteJoinSize());
            clone.setAbsoluteMarkerSize(this.getAbsoluteMarkerSize());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }
}

