/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.PolarLegendPositionTypes;
import com.sas.graphics.chart.RB;
import java.io.Serializable;

public class PolarLegendStyle
extends LegendStyle
implements Serializable {
    static final long serialVersionUID = -4973112640754432146L;
    public static final String RB_KEY = "PolarLegendStyle.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "startAngle"}, {"Short description", RB.getStringResource(RB_KEY, "startAngle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "startAngle.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public PolarLegendStyle() {
        this.legendStyle = new com.sas.graphics.util.visualize.PolarLegendStyle();
    }

    public PolarLegendStyle(PolarLegendStyle styleIn) {
        this.legendStyle = styleIn.legendStyle;
    }

    public double getStartAngle() {
        return ((com.sas.graphics.util.visualize.PolarLegendStyle)this.legendStyle).getOrigin();
    }

    public void setStartAngle(double angle) {
        double oldValue = this.getStartAngle();
        if (angle == oldValue) {
            return;
        }
        if (angle < 0.0 || angle > 360.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "startAngle.ex.txt"));
        }
        ((com.sas.graphics.util.visualize.PolarLegendStyle)this.legendStyle).setOrigin(angle);
        this.firePropertyChange("startAngle", new Double(oldValue), new Double(angle));
    }

    public PolarLegendPositionTypes getPolarPosition() {
        return PolarLegendPositionTypes.getEnum(this.legendStyle.getPosition());
    }

    public void setPolarPosition(PolarLegendPositionTypes position) {
        if (position.getValue() == this.legendStyle.getPosition()) {
            return;
        }
        PolarLegendPositionTypes oldValue = this.getPolarPosition();
        this.legendStyle.setPosition(position.getValue());
        this.firePropertyChange("polarPosition", (Object)oldValue, (Object)position);
    }

    protected com.sas.graphics.util.visualize.PolarLegendStyle getLegendStyle() {
        return (com.sas.graphics.util.visualize.PolarLegendStyle)this.legendStyle;
    }

    protected void setLegendStyle(com.sas.graphics.util.visualize.PolarLegendStyle styleIn) {
        this.legendStyle = styleIn;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PolarLegendStyle)) {
            return false;
        }
        PolarLegendStyle p = (PolarLegendStyle)obj;
        return this.getStartAngle() == p.getStartAngle() && this.getPolarPosition().getValue() == p.getPolarPosition().getValue();
    }
}

