/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.AxisStyle;
import com.sas.graphics.chart.Chart;
import com.sas.graphics.chart.DependentVariable;
import com.sas.graphics.chart.DiscreteColorLegendStyle;
import com.sas.graphics.chart.GridStyle;
import com.sas.graphics.chart.IndependentVariable;
import com.sas.graphics.chart.JoinTypes;
import com.sas.graphics.chart.LegendStyle;
import com.sas.graphics.chart.MarkerGeometryTypes;
import com.sas.graphics.chart.OverlayTypes;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.TextStyle;
import com.sas.graphics.chart.Variable;
import com.sas.graphics.util.visualize.Blob;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;

public class Overlay
extends Chart
implements Serializable {
    static final long serialVersionUID = -5737658118360012280L;
    public static final String RB_KEY = "Overlay.";
    protected com.sas.graphics.util.visualize.Overlay overlay = new com.sas.graphics.util.visualize.Overlay(RB.getStringResource("Overlay.", "defaultTitle.txt"));

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "backplaneVisible"}, {"Short description", RB.getStringResource(RB_KEY, "backplaneVisible.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "backplaneVisible.pd.txt")}}, {{"Name", "backplaneColor"}, {"Short description", RB.getStringResource(RB_KEY, "backplaneColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "backplaneColor.pd.txt")}}, {{"Name", "columnVariable"}, {"Short description", RB.getStringResource(RB_KEY, "columnVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "columnVariable.pd.txt")}}, {{"Name", "columnAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "columnAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "columnAxisStyle.pd.txt")}}, {{"Name", "heightVariables"}, {"Short description", RB.getStringResource(RB_KEY, "heightVariables.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "heightVariables.pd.txt")}}, {{"Name", "heightAxisStyle"}, {"Short description", RB.getStringResource(RB_KEY, "heightAxisStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "heightAxisStyle.pd.txt")}}, {{"Name", "groupVariable"}, {"Short description", RB.getStringResource(RB_KEY, "groupVariable.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "groupVariable.pd.txt")}}, {{"Name", "groupLegendStyle"}, {"Short description", RB.getStringResource(RB_KEY, "groupLegendStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "groupLegendStyle.pd.txt")}}, {{"Name", "overlayType"}, {"Short description", RB.getStringResource(RB_KEY, "overlayType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "overlayType.pd.txt")}}, {{"Name", "markerType"}, {"Short description", RB.getStringResource(RB_KEY, "markerType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "markerType.pd.txt")}}, {{"Name", "markerSize"}, {"Short description", RB.getStringResource(RB_KEY, "markerSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "markerSize.pd.txt")}}, {{"Name", "joinType"}, {"Short description", RB.getStringResource(RB_KEY, "joinType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "joinType.pd.txt")}}, {{"Name", "joinSize"}, {"Short description", RB.getStringResource(RB_KEY, "joinSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "joinSize.pd.txt")}}, {{"Name", "geometrySize"}, {"Short description", RB.getStringResource(RB_KEY, "geometrySize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "geometrySize.pd.txt")}}, {{"Name", "absoluteSize"}, {"Hidden", "true"}}, {{"Name", "absoluteJoinSize"}, {"Hidden", "true"}}, {{"Name", "absoluteGeometrySize"}, {"Hidden", "true"}}, {{"Name", "absoluteMarkerSize"}, {"Hidden", "true"}}, {{"Name", "subGroupVariableName"}, {"Hidden", "true"}}, {{"Name", "responseColorVariableName"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Overlay() {
        this.visualization = this.overlay;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        block15: {
            Object source;
            block13: {
                AxisStyle axis;
                block14: {
                    String propertyName = pce.getPropertyName();
                    if (propertyName == null) {
                        return;
                    }
                    source = pce.getSource();
                    if (!(source instanceof AxisStyle)) break block13;
                    axis = (AxisStyle)source;
                    if (!Util.equal((Object)axis.axisStyle, (Object)this.overlay.getHeightLegendStyle())) break block14;
                    this.updateViewer(UPDATE_VISUALIZATION);
                    this.firePropertyChange("heightAxisStyle", null, source);
                    break block15;
                }
                if (!Util.equal((Object)axis.axisStyle, (Object)this.overlay.getColumnLegendStyle())) break block15;
                this.updateViewer(UPDATE_VISUALIZATION);
                this.firePropertyChange("columnAxisStyle", null, source);
                break block15;
            }
            if (source instanceof LegendStyle) {
                LegendStyle legend = (LegendStyle)source;
                if (Util.equal((Object)legend.legendStyle, (Object)this.overlay.getGroupLegendStyle())) {
                    this.updateViewer(UPDATE_VISUALIZATION);
                    this.firePropertyChange("groupLegendStyle", null, source);
                }
            } else if (source instanceof Variable) {
                Variable variable = (Variable)source;
                if (Util.equal((Object)variable.getVariable(), (Object)this.overlay.getColumnVariable())) {
                    this.setSummaryVariable("Category", variable.getName());
                    this.updateViewer(UPDATE_ALL);
                    this.firePropertyChange("columnVariable", null, source);
                } else if (Util.equal((Object)variable.getVariable(), (Object)this.overlay.getGroupVariable())) {
                    this.setSummaryVariable("Group", variable.getName());
                    this.updateViewer(UPDATE_ALL);
                    this.firePropertyChange("groupVariable", null, source);
                } else {
                    com.sas.graphics.util.visualize.DependentVariable[] heightVariables = this.overlay.getHeightVariables();
                    for (int i = 0; i < heightVariables.length; ++i) {
                        if (!Util.equal((Object)variable.getVariable(), (Object)heightVariables[i])) continue;
                        if (i == 0 && heightVariables[0] != null) {
                            this.setSummaryVariable("Response", heightVariables[0].getName());
                        } else if (i == 1 && heightVariables[1] != null) {
                            this.setSummaryVariable("ResponseColor", heightVariables[1].getName());
                        }
                        this.updateViewer(UPDATE_ALL);
                        this.firePropertyChange("heightVariable", null, source);
                    }
                }
            }
        }
        super.propertyChange(pce);
    }

    public IndependentVariable getColumnVariable() {
        IndependentVariable columnVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            columnVariable = null;
        } else {
            columnVariable = new IndependentVariable();
            columnVariable.setIndependentVariable(v);
            columnVariable.addPropertyChangeListener(this);
        }
        return columnVariable;
    }

    public void setColumnVariable(IndependentVariable columnVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (columnVariable == null) {
            this.overlay.setColumnVariable(null);
        } else {
            if (Util.equal((Object)columnVariable.getVariable(), (Object)this.overlay.getColumnVariable())) {
                return;
            }
            this.overlay.setColumnVariable(columnVariable.getIndependentVariable());
            this.setSummaryVariable("Category", columnVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("columnVariable", oldValue, columnVariable);
    }

    public AxisStyle getColumnAxisStyle() {
        AxisStyle columnAxisStyle = new AxisStyle();
        columnAxisStyle.axisStyle = this.overlay.getColumnLegendStyle();
        columnAxisStyle.addPropertyChangeListener(this);
        return columnAxisStyle;
    }

    @Override
    public void setForegroundColor(Color newColor) {
        if (newColor == null || newColor == this.getForeground()) {
            return;
        }
        super.setForegroundColor(newColor);
        AxisStyle tempAxisStyle = this.getColumnAxisStyle();
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        tempAxisStyle = this.getHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempGridStyle.setColor(newColor);
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
        DiscreteColorLegendStyle tempGroupLegendStyle = this.getGroupLegendStyle();
        tempValueStyle = tempGroupLegendStyle.getValueStyle();
        tempValueStyle.setColor(newColor);
        tempLabelStyle = tempGroupLegendStyle.getLabelStyle();
        tempLabelStyle.setColor(newColor);
    }

    @Override
    public void setFont(Font newFont) {
        super.setFont(newFont);
        if (newFont == null) {
            return;
        }
        boolean isBold = newFont.isBold();
        boolean isItalic = newFont.isItalic();
        String fontFamily = newFont.getFamily();
        int dotPlace = fontFamily.indexOf(".");
        if (dotPlace != -1) {
            fontFamily = fontFamily.substring(0, dotPlace);
        }
        AxisStyle tempAxisStyle = this.getColumnAxisStyle();
        GridStyle tempGridStyle = tempAxisStyle.getGridStyle();
        TextStyle tempValueStyle = tempAxisStyle.getValueStyle();
        TextStyle tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        tempAxisStyle = this.getHeightAxisStyle();
        tempGridStyle = tempAxisStyle.getGridStyle();
        tempValueStyle = tempAxisStyle.getValueStyle();
        tempLabelStyle = tempAxisStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
        DiscreteColorLegendStyle tempGroupLegendStyle = this.getGroupLegendStyle();
        tempValueStyle = tempGroupLegendStyle.getValueStyle();
        tempLabelStyle = tempGroupLegendStyle.getLabelStyle();
        tempLabelStyle.setBold(isBold);
        tempLabelStyle.setItalic(isItalic);
        tempLabelStyle.setFontFamily(fontFamily);
        tempValueStyle.setBold(isBold);
        tempValueStyle.setItalic(isItalic);
        tempValueStyle.setFontFamily(fontFamily);
    }

    public void setColumnAxisStyle(AxisStyle columnAxisStyle) {
        if (columnAxisStyle == null || Util.equal((Object)columnAxisStyle.axisStyle, (Object)this.overlay.getColumnLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.overlay.getColumnLegendStyle();
        this.overlay.setColumnLegendStyle(columnAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("columnAxisStyle", oldValue, columnAxisStyle);
    }

    public DependentVariable[] getHeightVariables() {
        DependentVariable[] heightVariables;
        com.sas.graphics.util.visualize.DependentVariable[] v = this.overlay.getHeightVariables();
        if (v == null) {
            heightVariables = null;
        } else {
            heightVariables = new DependentVariable[v.length];
            for (int i = 0; i < v.length; ++i) {
                heightVariables[i] = new DependentVariable();
                heightVariables[i].setDependentVariable(v[i]);
                heightVariables[i].addPropertyChangeListener(this);
            }
        }
        return heightVariables;
    }

    public void setHeightVariables(DependentVariable[] heightVariables) {
        if (heightVariables == null) {
            this.overlay.setHeightVariables(null);
        } else {
            com.sas.graphics.util.visualize.DependentVariable[] v = new com.sas.graphics.util.visualize.DependentVariable[heightVariables.length];
            for (int i = 0; i < heightVariables.length; ++i) {
                v[i] = heightVariables[i].getDependentVariable();
                if (i == 0 && heightVariables[0] != null) {
                    this.setSummaryVariable("Response", heightVariables[0].getName());
                    continue;
                }
                if (i != 1 || heightVariables[1] == null) continue;
                this.setSummaryVariable("ResponseColor", heightVariables[1].getName());
            }
            this.overlay.setHeightVariables(v);
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("heightVariables", null, heightVariables);
    }

    public AxisStyle getHeightAxisStyle() {
        AxisStyle heightAxisStyle = new AxisStyle();
        heightAxisStyle.axisStyle = this.overlay.getHeightLegendStyle();
        heightAxisStyle.addPropertyChangeListener(this);
        return heightAxisStyle;
    }

    public void setHeightAxisStyle(AxisStyle heightAxisStyle) {
        if (heightAxisStyle == null || Util.equal((Object)heightAxisStyle.axisStyle, (Object)this.overlay.getHeightLegendStyle())) {
            return;
        }
        AxisStyle oldValue = new AxisStyle();
        oldValue.axisStyle = this.overlay.getHeightLegendStyle();
        this.overlay.setHeightLegendStyle(heightAxisStyle.axisStyle);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("heightAxisStyle", oldValue, heightAxisStyle);
    }

    public IndependentVariable getGroupVariable() {
        IndependentVariable groupVariable;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            groupVariable = null;
        } else {
            groupVariable = new IndependentVariable();
            groupVariable.setIndependentVariable(v);
            groupVariable.addPropertyChangeListener(this);
        }
        return groupVariable;
    }

    public void setGroupVariable(IndependentVariable groupVariable) {
        IndependentVariable oldValue;
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            oldValue = null;
        } else {
            oldValue = new IndependentVariable();
            oldValue.setIndependentVariable(v);
        }
        if (groupVariable == null) {
            this.overlay.setGroupVariable(null);
        } else {
            if (Util.equal((Object)groupVariable.getVariable(), (Object)this.overlay.getGroupVariable())) {
                return;
            }
            this.overlay.setGroupVariable(groupVariable.getIndependentVariable());
            this.setSummaryVariable("Group", groupVariable.getName());
        }
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariable", oldValue, groupVariable);
    }

    public DiscreteColorLegendStyle getGroupLegendStyle() {
        DiscreteColorLegendStyle groupLegendStyle = new DiscreteColorLegendStyle();
        groupLegendStyle.setLegendStyle(this.overlay.getGroupLegendStyle());
        groupLegendStyle.addPropertyChangeListener(this);
        return groupLegendStyle;
    }

    public void setGroupLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        if (aLegendStyle == null || Util.equal((Object)aLegendStyle.getLegendStyle(), (Object)this.overlay.getGroupLegendStyle())) {
            return;
        }
        DiscreteColorLegendStyle oldValue = new DiscreteColorLegendStyle();
        oldValue.setLegendStyle(this.overlay.getGroupLegendStyle());
        this.overlay.setGroupLegendStyle(aLegendStyle.getLegendStyle());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("groupLegendStyle", oldValue, aLegendStyle);
    }

    public OverlayTypes getOverlayType() {
        return OverlayTypes.getEnum(this.overlay.getOverlayType());
    }

    public void setOverlayType(OverlayTypes overlayType) {
        if (overlayType.getValue() == this.overlay.getOverlayType()) {
            return;
        }
        OverlayTypes oldValue = this.getOverlayType();
        this.overlay.setOverlayType(overlayType.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("overlayType", (Object)oldValue, (Object)overlayType);
    }

    public double getGeometrySize() {
        return this.overlay.getGeometrySize();
    }

    public void setGeometrySize(double geometrySize) {
        double oldValue = this.getGeometrySize();
        if (geometrySize == oldValue) {
            return;
        }
        if (geometrySize < 0.0 || geometrySize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "geometrySize.ex.txt"));
        }
        this.overlay.setGeometrySize(geometrySize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("geometrySize", new Double(oldValue), new Double(geometrySize));
    }

    public MarkerGeometryTypes getMarkerType() {
        return MarkerGeometryTypes.getEnum(this.overlay.getMarkerType());
    }

    public void setMarkerType(MarkerGeometryTypes markerType) {
        if (markerType.getValue() == this.overlay.getMarkerType()) {
            return;
        }
        MarkerGeometryTypes oldValue = this.getMarkerType();
        this.overlay.setMarkerType(markerType.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("markerType", (Object)oldValue, (Object)markerType);
    }

    public double getMarkerSize() {
        return this.overlay.getMarkerSize();
    }

    public void setMarkerSize(double markerSize) {
        double oldValue = this.getMarkerSize();
        if (markerSize == oldValue) {
            return;
        }
        if (markerSize < 0.0 || markerSize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "markerSize.ex.txt"));
        }
        this.overlay.setMarkerSize(markerSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("markerSize", new Double(oldValue), new Double(markerSize));
    }

    public JoinTypes getJoinType() {
        return JoinTypes.getEnum(this.overlay.getJoinType());
    }

    public void setJoinType(JoinTypes joinType) {
        if (joinType.getValue() == this.overlay.getJoinType()) {
            return;
        }
        JoinTypes oldValue = this.getJoinType();
        this.overlay.setJoinType(joinType.getValue());
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("joinType", (Object)oldValue, (Object)joinType);
    }

    public double getJoinSize() {
        return this.overlay.getJoinSize();
    }

    public void setJoinSize(double joinSize) {
        double oldValue = this.getJoinSize();
        if (joinSize == oldValue) {
            return;
        }
        if (joinSize < 0.0 || joinSize > 1.0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "joinSize.ex.txt"));
        }
        this.overlay.setJoinSize(joinSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("joinSize", new Double(oldValue), new Double(joinSize));
    }

    public boolean isAbsoluteSize() {
        return this.overlay.isAbsoluteSize();
    }

    public void setAbsoluteSize(boolean absolute) {
        boolean oldValue = this.isAbsoluteSize();
        if (absolute == oldValue) {
            return;
        }
        this.overlay.setAbsoluteSize(absolute);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteSize", new Boolean(oldValue), new Boolean(absolute));
    }

    public int getAbsoluteJoinSize() {
        return this.overlay.getAbsoluteJoinSize();
    }

    public void setAbsoluteJoinSize(int joinSize) {
        int oldValue = this.getAbsoluteJoinSize();
        if (joinSize == oldValue) {
            return;
        }
        if (joinSize < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absJoinSize.ex.txt"));
        }
        this.overlay.setAbsoluteJoinSize(joinSize);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteJoinSize", new Integer(oldValue), new Integer(joinSize));
    }

    public int getAbsoluteGeometrySize() {
        return this.overlay.getAbsoluteGeometrySize();
    }

    public void setAbsoluteGeometrySize(int size) {
        int oldValue = this.getAbsoluteGeometrySize();
        if (size == oldValue) {
            return;
        }
        if (size < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absGeometrySize.ex.txt"));
        }
        this.overlay.setAbsoluteGeometrySize(size);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteGeometrySize", new Integer(oldValue), new Integer(size));
    }

    public int getAbsoluteMarkerSize() {
        return this.overlay.getAbsoluteMarkerSize();
    }

    public void setAbsoluteMarkerSize(int size) {
        int oldValue = this.getAbsoluteMarkerSize();
        if (size == oldValue) {
            return;
        }
        if (size < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "absMarkerSize.ex.txt"));
        }
        this.overlay.setAbsoluteMarkerSize(size);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("absoluteMarkerSize", new Integer(oldValue), new Integer(size));
    }

    public boolean isBackplaneVisible() {
        return this.overlay.isBackplaneVisible();
    }

    public void setBackplaneVisible(boolean visible) {
        boolean oldValue = this.isBackplaneVisible();
        if (visible == oldValue) {
            return;
        }
        this.overlay.setBackplaneVisible(visible);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("backplaneVisible", new Boolean(oldValue), new Boolean(visible));
    }

    public Color getBackplaneColor() {
        return this.overlay.getBackplaneColor();
    }

    public void setBackplaneColor(Color backplaneColorIn) {
        Color oldValue = this.getBackplaneColor();
        if (Util.equal((Object)backplaneColorIn, (Object)oldValue)) {
            return;
        }
        this.overlay.setBackplaneColor(backplaneColorIn);
        this.updateViewer(UPDATE_VISUALIZATION);
        this.firePropertyChange("backplaneColor", oldValue, backplaneColorIn);
    }

    public String getClickedColumn(boolean formatted) {
        return this.overlay.getClickedColumn(formatted);
    }

    public String getClickedHeight(boolean formatted) {
        return this.overlay.getClickedHeight(formatted);
    }

    public String getClickedGroup(boolean formatted) {
        return this.overlay.getClickedGroup(formatted);
    }

    @Override
    public String getCategoryVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setCategoryVariableName(String name) {
        String oldValue = this.getCategoryVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("categoryVariableName", oldValue, name);
    }

    @Override
    public String getXVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setXVariableName(String name) {
        String oldValue = this.getXVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getColumnVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setColumnVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Category", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("XVariableName", oldValue, name);
    }

    @Override
    public String getResponseVariableName() {
        com.sas.graphics.util.visualize.DependentVariable[] v = this.overlay.getHeightVariables();
        if (v == null || v[0] == null) {
            return "";
        }
        return v[0].getName();
    }

    @Override
    public void setResponseVariableName(String name) {
        String oldValue = this.getResponseVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable[] v = this.overlay.getHeightVariables();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable[]{new com.sas.graphics.util.visualize.DependentVariable()};
            v[0].setName(name);
            this.overlay.setHeightVariables(v);
        } else if (v[0] == null) {
            v[0] = new com.sas.graphics.util.visualize.DependentVariable();
            v[0].setName(name);
        } else {
            v[0].setName(name);
        }
        this.setSummaryVariable("Response", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("responseVariableName", oldValue, name);
    }

    @Override
    public String getResponse2VariableName() {
        com.sas.graphics.util.visualize.DependentVariable[] v = this.overlay.getHeightVariables();
        if (v == null || v.length < 2 || v[1] == null) {
            return "";
        }
        return v[1].getName();
    }

    @Override
    public void setResponse2VariableName(String name) {
        String oldValue = this.getResponse2VariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.DependentVariable[] v = this.overlay.getHeightVariables();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.DependentVariable[]{null, new com.sas.graphics.util.visualize.DependentVariable()};
            v[1].setName(name);
            this.overlay.setHeightVariables(v);
        } else if (v.length < 2) {
            com.sas.graphics.util.visualize.DependentVariable t = v[0];
            v = new com.sas.graphics.util.visualize.DependentVariable[]{t, new com.sas.graphics.util.visualize.DependentVariable()};
            v[1].setName(name);
            this.overlay.setHeightVariables(v);
        } else if (v[1] == null) {
            v[1] = new com.sas.graphics.util.visualize.DependentVariable();
            v[1].setName(name);
        } else {
            v[1].setName(name);
        }
        this.setSummaryVariable("ResponseColor", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("response2VariableName", oldValue, name);
    }

    @Override
    public String getGroupVariableName() {
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            return "";
        }
        return v.getName();
    }

    @Override
    public void setGroupVariableName(String name) {
        String oldValue = this.getGroupVariableName();
        if (Util.equal((Object)name, (Object)oldValue)) {
            return;
        }
        com.sas.graphics.util.visualize.IndependentVariable v = this.overlay.getGroupVariable();
        if (v == null) {
            v = new com.sas.graphics.util.visualize.IndependentVariable();
            v.setName(name);
            this.overlay.setGroupVariable(v);
        } else {
            v.setName(name);
        }
        this.setSummaryVariable("Group", name);
        this.updateViewer(UPDATE_ALL);
        this.firePropertyChange("groupVariableName", oldValue, name);
    }

    @Override
    protected void resetNoneVariables() {
        com.sas.graphics.util.visualize.DependentVariable[] heightVariables;
        com.sas.graphics.util.visualize.IndependentVariable variable = this.overlay.getColumnVariable();
        if (variable != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((variable = this.overlay.getGroupVariable()) != null && !variable.isAutomatic() && variable.getName() == null) {
            variable.setIndex(-1);
        }
        if ((heightVariables = this.overlay.getHeightVariables()) != null) {
            for (int i = 0; i < heightVariables.length; ++i) {
                if (heightVariables[i] == null || heightVariables[i].isAutomatic() || heightVariables[i].getName() != null) continue;
                heightVariables[i].setIndex(-1);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Overlay clone = (Overlay)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.initialize();
            clone.setTitle(this.getTitle());
            clone.setTitleStyle(this.getTitleStyle());
            clone.setDepth(this.getDepth());
            clone.setMapColors(this.getMapColors());
            clone.setBackground(this.getBackground());
            clone.setBackgroundImage(this.getBackgroundImage());
            clone.setTransparent(this.isTransparent());
            clone.setOutlineColor(this.getOutlineColor());
            clone.setDataTipStyle(this.getDataTipStyle());
            clone.setResolution(this.getResolution());
            clone.setDatatipDoubleBuffered(this.isDatatipDoubleBuffered());
            clone.setMaxObservations(this.getMaxObservations());
            clone.setDisplayChartType(this.isDisplayChartType());
            clone.setShowStatistic(this.isShowStatistic());
            clone.setHidePopupMenu(this.isHidePopupMenu());
            clone.setPopupColumnInfoUsed(this.getPopupColumnInfoUsed());
            clone.setSwanStyleData(this.isSwanStyleData());
            clone.setBackplaneVisible(this.isBackplaneVisible());
            clone.setBackplaneColor(this.getBackplaneColor());
            clone.setColumnVariable(this.getColumnVariable());
            clone.setColumnAxisStyle(this.getColumnAxisStyle());
            clone.setHeightVariables(this.getHeightVariables());
            clone.setHeightAxisStyle(this.getHeightAxisStyle());
            clone.setGroupVariable(this.getGroupVariable());
            clone.setGroupLegendStyle(this.getGroupLegendStyle());
            clone.setOverlayType(this.getOverlayType());
            clone.setGeometrySize(this.getGeometrySize());
            clone.setMarkerType(this.getMarkerType());
            clone.setMarkerSize(this.getMarkerSize());
            clone.setJoinType(this.getJoinType());
            clone.setJoinSize(this.getJoinSize());
            clone.setAbsoluteSize(this.isAbsoluteSize());
            clone.setAbsoluteGeometrySize(this.getAbsoluteGeometrySize());
            clone.setAbsoluteJoinSize(this.getAbsoluteJoinSize());
            clone.setAbsoluteMarkerSize(this.getAbsoluteMarkerSize());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public void setVariableHotspotsEnabled(boolean newValue) {
    }

    @Override
    public boolean isVariableHotspotsEnabled() {
        return false;
    }

    @Override
    public Blob[] getVariableHotspots() {
        return null;
    }
}

