/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.graphics.chart.Bar;
import com.sas.graphics.chart.Chart;
import com.sas.graphics.chart.DependentVariable;
import com.sas.graphics.chart.Overlay;
import com.sas.graphics.chart.Pie;
import com.sas.graphics.chart.Scatter;
import com.sas.graphics.chart.SegmentedBar;
import com.sas.util.Util;
import java.util.Locale;

public class ChartTransformer {
    public static final int BAR_CHART = 0;
    public static final int SEGMENTEDBAR_CHART = 1;
    public static final int SCATTER_CHART = 2;
    public static final int PIE_CHART = 3;
    public static final int OVERLAY_CHART = 4;

    public static Chart transform(Chart inChart, int newChartType) {
        Chart newChart = null;
        switch (newChartType) {
            case 0: {
                newChart = ChartTransformer.toBar(inChart);
                break;
            }
            case 1: {
                newChart = ChartTransformer.toSegmentedBar(inChart);
                break;
            }
            case 2: {
                newChart = ChartTransformer.toScatter(inChart);
                break;
            }
            case 3: {
                newChart = ChartTransformer.toPie(inChart);
                break;
            }
            case 4: {
                newChart = ChartTransformer.toOverlay(inChart);
            }
        }
        if (newChart != null) {
            ChartTransformer.stripChart(inChart);
        }
        return newChart;
    }

    static Chart toBar(Chart inChart) {
        if (!(inChart instanceof SegmentedBar || inChart instanceof Scatter || inChart instanceof Pie || inChart instanceof Overlay)) {
            return null;
        }
        Bar bar = new Bar();
        bar.initialize();
        ChartTransformer.copyChart(inChart, bar);
        if (inChart instanceof SegmentedBar) {
            SegmentedBar sBar = (SegmentedBar)inChart;
            bar.setRowVariable(sBar.getRowVariable());
            bar.setRowAxisStyle(sBar.getRowAxisStyle());
            bar.setColumnVariable(sBar.getColumnVariable());
            bar.setColumnAxisStyle(sBar.getColumnAxisStyle());
            bar.setHeightVariable(sBar.getHeightVariable());
            bar.setHeightAxisStyle(sBar.getHeightAxisStyle());
            bar.setGroupVariable(sBar.getGroupVariable());
            bar.setGroupAxisStyle(sBar.getGroupAxisStyle());
            bar.setColorVariable(null);
            bar.setBackplaneColor(sBar.getBackplaneColor());
            bar.setBackplaneVisible(sBar.isBackplaneVisible());
            bar.setGeometryType(sBar.getGeometryType());
            bar.setGeometrySize(sBar.getGeometrySize());
            bar.setVertical(sBar.isVertical());
        } else if (inChart instanceof Scatter) {
            Scatter scatter = (Scatter)inChart;
            bar.setRowVariable(scatter.getRowVariable());
            bar.setRowAxisStyle(scatter.getRowAxisStyle());
            bar.setColumnVariable(scatter.getColumnVariable());
            bar.setColumnAxisStyle(scatter.getColumnAxisStyle());
            bar.setHeightVariable(scatter.getHeightVariable());
            bar.setHeightAxisStyle(scatter.getHeightAxisStyle());
            bar.setColorVariable(scatter.getColorVariable());
            bar.setColorLegendStyle(scatter.getColorLegendStyle());
            bar.setGroupVariable(scatter.getGroupVariable());
            bar.setBackplaneColor(scatter.getBackplaneColor());
            bar.setBackplaneVisible(scatter.isBackplaneVisible());
        } else if (inChart instanceof Pie) {
            Pie pie = (Pie)inChart;
            bar.setColumnVariable(pie.getSectorVariable());
            bar.setHeightVariable(pie.getWeightVariable());
            bar.setColorVariable(pie.getHeightVariable());
            bar.setGroupVariable(null);
        } else if (inChart instanceof Overlay) {
            Overlay overlay = (Overlay)inChart;
            bar.setColumnVariable(overlay.getColumnVariable());
            bar.setColumnAxisStyle(overlay.getColumnAxisStyle());
            bar.setGroupVariable(overlay.getGroupVariable());
            DependentVariable[] dv = overlay.getHeightVariables();
            if (dv != null && dv.length > 0) {
                bar.setHeightVariable(dv[0]);
            }
            bar.setHeightAxisStyle(overlay.getHeightAxisStyle());
            bar.setColorVariable(null);
            bar.setBackplaneColor(overlay.getBackplaneColor());
            bar.setBackplaneVisible(overlay.isBackplaneVisible());
        }
        return bar;
    }

    static Chart toSegmentedBar(Chart inChart) {
        if (!(inChart instanceof Bar || inChart instanceof Scatter || inChart instanceof Pie || inChart instanceof Overlay)) {
            return null;
        }
        SegmentedBar sBar = new SegmentedBar();
        sBar.initialize();
        ChartTransformer.copyChart(inChart, sBar);
        if (inChart instanceof Bar) {
            Bar bar = (Bar)inChart;
            sBar.setRowVariable(bar.getRowVariable());
            sBar.setRowAxisStyle(bar.getRowAxisStyle());
            sBar.setColumnVariable(bar.getColumnVariable());
            sBar.setColumnAxisStyle(bar.getColumnAxisStyle());
            sBar.setHeightVariable(bar.getHeightVariable());
            sBar.setHeightAxisStyle(bar.getHeightAxisStyle());
            sBar.setGroupVariable(bar.getGroupVariable());
            sBar.setGroupAxisStyle(bar.getGroupAxisStyle());
            sBar.setSegmentVariable(null);
            sBar.setBackplaneColor(bar.getBackplaneColor());
            sBar.setBackplaneVisible(bar.isBackplaneVisible());
            sBar.setGeometryType(bar.getGeometryType());
            sBar.setGeometrySize(bar.getGeometrySize());
            sBar.setVertical(bar.isVertical());
        } else if (inChart instanceof Scatter) {
            Scatter scatter = (Scatter)inChart;
            sBar.setRowVariable(scatter.getRowVariable());
            sBar.setRowAxisStyle(scatter.getRowAxisStyle());
            sBar.setColumnVariable(scatter.getColumnVariable());
            sBar.setColumnAxisStyle(scatter.getColumnAxisStyle());
            sBar.setHeightVariable(scatter.getHeightVariable());
            sBar.setHeightAxisStyle(scatter.getHeightAxisStyle());
            sBar.setSegmentVariable(null);
            sBar.setGroupVariable(null);
            sBar.setBackplaneColor(scatter.getBackplaneColor());
            sBar.setBackplaneVisible(scatter.isBackplaneVisible());
        } else if (inChart instanceof Pie) {
            Pie pie = (Pie)inChart;
            sBar.setColumnVariable(pie.getSectorVariable());
            sBar.setHeightVariable(pie.getWeightVariable());
            sBar.setSegmentVariable(null);
            sBar.setGroupVariable(null);
        } else if (inChart instanceof Overlay) {
            Overlay overlay = (Overlay)inChart;
            sBar.setColumnVariable(overlay.getColumnVariable());
            sBar.setColumnAxisStyle(overlay.getColumnAxisStyle());
            sBar.setGroupVariable(overlay.getGroupVariable());
            DependentVariable[] dv = overlay.getHeightVariables();
            if (dv != null && dv.length > 0) {
                sBar.setHeightVariable(dv[0]);
            }
            sBar.setSegmentVariable(null);
            sBar.setHeightAxisStyle(overlay.getHeightAxisStyle());
            sBar.setBackplaneColor(overlay.getBackplaneColor());
            sBar.setBackplaneVisible(overlay.isBackplaneVisible());
        }
        return sBar;
    }

    static Chart toScatter(Chart inChart) {
        if (!(inChart instanceof SegmentedBar || inChart instanceof Overlay || inChart instanceof Bar || inChart instanceof Pie)) {
            return null;
        }
        Scatter scatter = new Scatter();
        scatter.initialize();
        ChartTransformer.copyChart(inChart, scatter);
        if (inChart instanceof Bar) {
            Bar bar = (Bar)inChart;
            scatter.setRowVariable(bar.getRowVariable());
            scatter.setRowAxisStyle(bar.getRowAxisStyle());
            scatter.setColumnVariable(bar.getColumnVariable());
            scatter.setColumnAxisStyle(bar.getColumnAxisStyle());
            scatter.setHeightVariable(bar.getHeightVariable());
            scatter.setHeightAxisStyle(bar.getHeightAxisStyle());
            scatter.setColorVariable(bar.getColorVariable());
            scatter.setColorLegendStyle(bar.getColorLegendStyle());
            scatter.setGroupVariable(bar.getGroupVariable());
            scatter.setBackplaneColor(bar.getBackplaneColor());
            scatter.setBackplaneVisible(bar.isBackplaneVisible());
        } else if (inChart instanceof SegmentedBar) {
            SegmentedBar sBar = (SegmentedBar)inChart;
            scatter.setRowVariable(sBar.getRowVariable());
            scatter.setRowAxisStyle(sBar.getRowAxisStyle());
            scatter.setColumnVariable(sBar.getColumnVariable());
            scatter.setColumnAxisStyle(sBar.getColumnAxisStyle());
            scatter.setHeightVariable(sBar.getHeightVariable());
            scatter.setHeightAxisStyle(sBar.getHeightAxisStyle());
            scatter.setColorVariable(null);
            scatter.setGroupVariable(sBar.getGroupVariable());
            scatter.setBackplaneColor(sBar.getBackplaneColor());
            scatter.setBackplaneVisible(sBar.isBackplaneVisible());
        } else if (inChart instanceof Pie) {
            Pie pie = (Pie)inChart;
            scatter.setColumnVariable(pie.getSectorVariable());
            scatter.setHeightVariable(pie.getWeightVariable());
            scatter.setColorVariable(pie.getHeightVariable());
        } else if (inChart instanceof Overlay) {
            Overlay overlay = (Overlay)inChart;
            scatter.setColumnVariable(overlay.getColumnVariable());
            scatter.setColumnAxisStyle(overlay.getColumnAxisStyle());
            DependentVariable[] dv = overlay.getHeightVariables();
            if (dv != null && dv.length > 0) {
                scatter.setHeightVariable(dv[0]);
            }
            scatter.setHeightAxisStyle(overlay.getHeightAxisStyle());
            scatter.setColorVariable(null);
            scatter.setBackplaneColor(overlay.getBackplaneColor());
            scatter.setBackplaneVisible(overlay.isBackplaneVisible());
        }
        return scatter;
    }

    static Chart toPie(Chart inChart) {
        if (!(inChart instanceof SegmentedBar || inChart instanceof Scatter || inChart instanceof Bar || inChart instanceof Overlay)) {
            return null;
        }
        Pie pie = new Pie();
        pie.initialize();
        ChartTransformer.copyChart(inChart, pie);
        if (inChart instanceof Bar) {
            Bar bar = (Bar)inChart;
            pie.setSectorVariable(bar.getColumnVariable());
            pie.setWeightVariable(bar.getHeightVariable());
            pie.setHeightVariable(bar.getColorVariable());
        } else if (inChart instanceof SegmentedBar) {
            SegmentedBar sBar = (SegmentedBar)inChart;
            pie.setSectorVariable(sBar.getColumnVariable());
            pie.setWeightVariable(sBar.getHeightVariable());
        } else if (inChart instanceof Scatter) {
            Scatter scatter = (Scatter)inChart;
            pie.setSectorVariable(scatter.getColumnVariable());
            pie.setWeightVariable(scatter.getHeightVariable());
            pie.setHeightVariable(scatter.getColorVariable());
        } else if (inChart instanceof Overlay) {
            Overlay overlay = (Overlay)inChart;
            pie.setSectorVariable(overlay.getColumnVariable());
            DependentVariable[] dv = overlay.getHeightVariables();
            if (dv != null && dv.length > 0) {
                pie.setWeightVariable(dv[0]);
            }
        }
        return pie;
    }

    static Chart toOverlay(Chart inChart) {
        if (!(inChart instanceof SegmentedBar || inChart instanceof Scatter || inChart instanceof Bar || inChart instanceof Pie)) {
            return null;
        }
        Overlay overlay = new Overlay();
        overlay.initialize();
        ChartTransformer.copyChart(inChart, overlay);
        if (inChart instanceof Bar) {
            Bar bar = (Bar)inChart;
            overlay.setColumnVariable(bar.getColumnVariable());
            overlay.setColumnAxisStyle(bar.getColumnAxisStyle());
            overlay.setHeightVariables(null);
            overlay.setHeightAxisStyle(bar.getHeightAxisStyle());
            overlay.setGroupVariable(null);
            overlay.setBackplaneColor(bar.getBackplaneColor());
            overlay.setBackplaneVisible(bar.isBackplaneVisible());
        } else if (inChart instanceof SegmentedBar) {
            SegmentedBar sBar = (SegmentedBar)inChart;
            overlay.setColumnVariable(sBar.getColumnVariable());
            overlay.setColumnAxisStyle(sBar.getColumnAxisStyle());
            overlay.setHeightVariables(null);
            overlay.setHeightAxisStyle(sBar.getHeightAxisStyle());
            overlay.setGroupVariable(null);
            overlay.setBackplaneColor(sBar.getBackplaneColor());
            overlay.setBackplaneVisible(sBar.isBackplaneVisible());
        } else if (inChart instanceof Scatter) {
            Scatter scatter = (Scatter)inChart;
            overlay.setColumnVariable(scatter.getColumnVariable());
            overlay.setColumnAxisStyle(scatter.getColumnAxisStyle());
            overlay.setHeightVariables(null);
            overlay.setHeightAxisStyle(scatter.getHeightAxisStyle());
            overlay.setGroupVariable(null);
            overlay.setBackplaneColor(scatter.getBackplaneColor());
            overlay.setBackplaneVisible(scatter.isBackplaneVisible());
        } else if (inChart instanceof Pie) {
            Pie pie = (Pie)inChart;
            overlay.setColumnVariable(pie.getSectorVariable());
            overlay.setHeightVariables(null);
            overlay.setGroupVariable(null);
        }
        return overlay;
    }

    private static void stripChart(Chart chart) {
        if (chart instanceof Bar) {
            Bar bar = (Bar)chart;
            bar.setRowVariable(null);
            bar.setColumnVariable(null);
            bar.setHeightVariable(null);
            bar.setGroupVariable(null);
            bar.setColorVariable(null);
            bar.setRowAxisStyle(null);
            bar.setColumnAxisStyle(null);
            bar.setHeightAxisStyle(null);
            bar.setGroupAxisStyle(null);
        } else if (chart instanceof SegmentedBar) {
            SegmentedBar sBar = (SegmentedBar)chart;
            sBar.setRowVariable(null);
            sBar.setColumnVariable(null);
            sBar.setHeightVariable(null);
            sBar.setGroupVariable(null);
            sBar.setRowAxisStyle(null);
            sBar.setColumnAxisStyle(null);
            sBar.setHeightAxisStyle(null);
            sBar.setGroupAxisStyle(null);
        } else if (chart instanceof Scatter) {
            Scatter scatter = (Scatter)chart;
            scatter.setRowVariable(null);
            scatter.setColumnVariable(null);
            scatter.setHeightVariable(null);
            scatter.setColorVariable(null);
            scatter.setGroupVariable(null);
            scatter.setRowAxisStyle(null);
            scatter.setColumnAxisStyle(null);
            scatter.setHeightAxisStyle(null);
            scatter.setColorLegendStyle(null);
        } else if (chart instanceof Pie) {
            Pie pie = (Pie)chart;
            pie.setSectorVariable(null);
            pie.setWeightVariable(null);
            pie.setHeightVariable(null);
        } else if (chart instanceof Overlay) {
            Overlay overlay = (Overlay)chart;
            overlay.setColumnVariable(null);
            overlay.setGroupVariable(null);
            overlay.setHeightVariables(null);
            overlay.setColumnAxisStyle(null);
            overlay.setHeightAxisStyle(null);
        }
    }

    static void copyChart(Chart inChart, Chart outChart) {
        outChart.setBounds(inChart.getHorizontalPosition(), inChart.getVerticalPosition(), inChart.getWidth(), inChart.getHeight());
        outChart.setModelInterface(inChart.getModelInterface());
        String defaultTitle = inChart.getDefaultTitle(Locale.getDefault());
        if (!Util.equal((Object)inChart.getTitle(), (Object)defaultTitle)) {
            outChart.setTitle(inChart.getTitle());
        }
        outChart.setTitleStyle(inChart.getTitleStyle());
        outChart.setTransparent(inChart.isTransparent());
        outChart.setHidePopupMenu(inChart.isHidePopupMenu());
        outChart.setFont(inChart.getFont());
        outChart.setForeground(inChart.getForeground());
        outChart.setBackground(inChart.getBackground());
        outChart.setBackgroundColor(inChart.getBackgroundColor());
        outChart.setOutlineColor(inChart.getOutlineColor());
        outChart.setBorder(inChart.getBorder());
        outChart.setDepth(inChart.getDepth());
        outChart.setDataTipStyle(inChart.getDataTipStyle());
        outChart.setResolution(inChart.getResolution());
        outChart.setDatatipDoubleBuffered(inChart.isDatatipDoubleBuffered());
        outChart.setMaxObservations(inChart.getMaxObservations());
        outChart.setDisplayChartType(inChart.isDisplayChartType());
        outChart.setShowStatistic(inChart.isShowStatistic());
    }
}

