/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart;

import com.sas.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.chart.AxisTypes;
import com.sas.graphics.chart.GridStyle;
import com.sas.graphics.chart.RB;
import com.sas.graphics.chart.RowNumberTypes;
import com.sas.graphics.chart.TextStyle;
import com.sas.util.Util;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class AxisStyle
extends Component
implements Serializable {
    static final long serialVersionUID = 2043975585817389145L;
    public static final String RB_KEY = "AxisStyle.";
    protected com.sas.graphics.util.visualize.AxisStyle axisStyle;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "labelStyle"}, {"Short description", RB.getStringResource(RB_KEY, "labelStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "labelStyle.pd.txt")}}, {{"Name", "valueStyle"}, {"Short description", RB.getStringResource(RB_KEY, "valueStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "valueStyle.pd.txt")}}, {{"Name", "gridStyle"}, {"Short description", RB.getStringResource(RB_KEY, "gridStyle.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "gridStyle.pd.txt")}}, {{"Name", "axisType"}, {"Short description", RB.getStringResource(RB_KEY, "axisType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "axisType.pd.txt")}}, {{"Name", "numRows"}, {"Short description", RB.getStringResource(RB_KEY, "numRows.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "numRows.pd.txt")}}, {{"Name", "axisColor"}, {"Short description", RB.getStringResource(RB_KEY, "axisColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "axisColor.pd.txt")}}, {{"Name", "fixedDataRange"}, {"Hidden", "true"}}, {{"Name", "dataMinValue"}, {"Hidden", "true"}}, {{"Name", "dataMaxValue"}, {"Hidden", "true"}}, {{"Name", "fixedIntervals"}, {"Hidden", "true"}}, {{"Name", "intervals"}, {"Hidden", "true"}}, {{"Name", "hideLabel"}, {"Short description", RB.getStringResource(RB_KEY, "hideLabel.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "hideLabel.pd.txt")}}, {{"Name", "valuesVisible"}, {"Short description", RB.getStringResource(RB_KEY, "valuesVisible.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "valuesVisible.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public AxisStyle() {
        this.axisStyle = new com.sas.graphics.util.visualize.AxisStyle();
    }

    public AxisStyle(AxisStyle styleIn) {
        this.axisStyle = new com.sas.graphics.util.visualize.AxisStyle(styleIn.axisStyle);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        Object source = pce.getSource();
        if (source instanceof TextStyle) {
            TextStyle style = (TextStyle)source;
            if (Util.equal((Object)style.textStyle, (Object)this.axisStyle.getLabelStyle())) {
                this.firePropertyChange("labelStyle", null, source);
            } else {
                this.firePropertyChange("valueStyle", null, source);
            }
        } else {
            this.firePropertyChange("gridStyle", null, source);
        }
    }

    public TextStyle getLabelStyle() {
        TextStyle textStyle = new TextStyle(this.axisStyle.getLabelStyle());
        textStyle.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        return textStyle;
    }

    public void setLabelStyle(TextStyle ts) {
        if (ts == null || Util.equal((Object)ts.textStyle, (Object)this.axisStyle.getLabelStyle())) {
            return;
        }
        TextStyle oldValue = new TextStyle(this.axisStyle.getLabelStyle());
        this.axisStyle.setLabelStyle(ts.textStyle);
        this.firePropertyChange("labelStyle", oldValue, ts);
    }

    public TextStyle getValueStyle() {
        TextStyle textStyle = new TextStyle(this.axisStyle.getValueStyle());
        textStyle.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        return textStyle;
    }

    public void setValueStyle(TextStyle ts) {
        if (ts == null || Util.equal((Object)ts.textStyle, (Object)this.axisStyle.getValueStyle())) {
            return;
        }
        TextStyle oldValue = new TextStyle(this.axisStyle.getValueStyle());
        this.axisStyle.setValueStyle(ts.textStyle);
        this.firePropertyChange("valueStyle", oldValue, ts);
    }

    public GridStyle getGridStyle() {
        GridStyle gridStyle = new GridStyle(this.axisStyle.getGrid());
        gridStyle.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        return gridStyle;
    }

    public void setGridStyle(GridStyle gs) {
        if (gs == null || Util.equal((Object)gs.gridStyle, (Object)this.axisStyle.getGrid())) {
            return;
        }
        GridStyle oldValue = new GridStyle(this.axisStyle.getGrid());
        this.axisStyle.setGrid(gs.gridStyle);
        this.firePropertyChange("gridStyle", oldValue, gs);
    }

    public AxisTypes getAxisType() {
        return AxisTypes.getEnum(this.axisStyle.getAxisType());
    }

    public void setAxisType(AxisTypes type) {
        if (type.getValue() == this.axisStyle.getAxisType()) {
            return;
        }
        AxisTypes oldValue = this.getAxisType();
        this.axisStyle.setAxisType(type.getValue());
        this.firePropertyChange("axisType", (Object)oldValue, (Object)type);
    }

    public Color getAxisColor() {
        return this.axisStyle.getAxisColor();
    }

    public void setAxisColor(Color color) {
        Color oldValue = this.getAxisColor();
        if (Util.equal((Object)color, (Object)oldValue)) {
            return;
        }
        this.axisStyle.setAxisColor(color);
        this.firePropertyChange("axisColor", oldValue, color);
    }

    public RowNumberTypes getNumRows() {
        return RowNumberTypes.getEnum(this.axisStyle.getNumRows());
    }

    public void setNumRows(RowNumberTypes num) {
        if (num.getValue() == this.axisStyle.getNumRows()) {
            return;
        }
        RowNumberTypes oldValue = this.getNumRows();
        this.axisStyle.setNumRows(num.getValue());
        this.firePropertyChange("numRows", (Object)oldValue, (Object)num);
    }

    public boolean isFixedDataRange() {
        return this.axisStyle.isFixedDataRange();
    }

    public void setFixedDataRange(boolean fixed) {
        boolean oldValue = this.isFixedDataRange();
        if (fixed == oldValue) {
            return;
        }
        this.axisStyle.setFixedDataRange(fixed);
        this.firePropertyChange("fixedDataRange", new Boolean(oldValue), new Boolean(fixed));
    }

    public double getDataMinValue() {
        return this.axisStyle.getDataMinValue();
    }

    public void setDataMinValue(double min) {
        double oldValue = this.getDataMinValue();
        if (min == oldValue) {
            return;
        }
        this.axisStyle.setDataMinValue(min);
        this.firePropertyChange("dataMinValue", new Double(oldValue), new Double(min));
    }

    public double getDataMaxValue() {
        return this.axisStyle.getDataMaxValue();
    }

    public void setDataMaxValue(double max) {
        double oldValue = this.getDataMaxValue();
        if (max == oldValue) {
            return;
        }
        this.axisStyle.setDataMaxValue(max);
        this.firePropertyChange("dataMaxValue", new Double(oldValue), new Double(max));
    }

    public int getIntervals() {
        return this.axisStyle.getIntervals();
    }

    public void setIntervals(int count) {
        int oldValue = this.getIntervals();
        if (count == oldValue) {
            return;
        }
        this.axisStyle.setIntervals(count);
        this.firePropertyChange("Intervals", new Integer(oldValue), new Integer(count));
    }

    public boolean isFixedIntervals() {
        return this.axisStyle.isFixedIntervals();
    }

    public void setFixedIntervals(boolean fixed) {
        boolean oldValue = this.isFixedIntervals();
        if (fixed == oldValue) {
            return;
        }
        this.axisStyle.setFixedIntervals(fixed);
        this.firePropertyChange("fixedIntervals", new Boolean(oldValue), new Boolean(fixed));
    }

    public boolean isHideLabel() {
        return this.axisStyle.isHideLabel();
    }

    public void setHideLabel(boolean hide) {
        boolean oldValue = this.isHideLabel();
        if (hide == oldValue) {
            return;
        }
        this.axisStyle.setHideLabel(hide);
        this.firePropertyChange("hideLabel", new Boolean(oldValue), new Boolean(hide));
    }

    public boolean isValuesVisible() {
        return this.axisStyle.isValuesVisible();
    }

    public void setValuesVisible(boolean hide) {
        boolean oldValue = this.isValuesVisible();
        if (hide == oldValue) {
            return;
        }
        this.axisStyle.setValuesVisible(hide);
        this.firePropertyChange("valuesVisible", new Boolean(oldValue), new Boolean(hide));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AxisStyle)) {
            return false;
        }
        AxisStyle a = (AxisStyle)obj;
        return this.getLabelStyle().equals(a.getLabelStyle()) && this.getValueStyle().equals(a.getValueStyle()) && this.getGridStyle().equals(a.getGridStyle()) && this.getAxisType().getValue() == a.getAxisType().getValue() && this.getAxisColor().equals(a.getAxisColor()) && this.getNumRows().getValue() == a.getNumRows().getValue() && this.isFixedDataRange() == a.isFixedDataRange() && this.getDataMinValue() == a.getDataMinValue() && this.getDataMaxValue() == a.getDataMaxValue() && this.getIntervals() == a.getIntervals() && this.isFixedIntervals() == a.isFixedIntervals() && this.isHideLabel() == a.isHideLabel();
    }
}

