/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics;

import com.sas.ModelInterface;
import com.sas.awt.Component;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.geometry.RectangularOrientation;
import com.sas.graphics.RB;
import com.sas.lang.DoubleData;
import com.sas.models.RangeCollection;
import com.sas.models.RangeCollectionInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class RangeView
extends Component
implements ContentsChangedListener,
Serializable {
    public static final String RB_KEY = "RangeView.";
    private static final String[] requiredInterfacesString = new String[]{"com.sas.models.RangeCollectionInterface"};
    static final long serialVersionUID = -7588107354384236006L;
    public static final int CLASSIC = 0;
    public static final int DIGITAL = 1;
    public static final int TWO_DIMENSION = 0;
    public static final int TWO_AND_A_HALF_DIMENSION = 1;
    public static final int ARROW = 0;
    public static final int SPEAR = 1;
    public static final int HARPOON = 2;
    public static final int NEEDLE = 3;
    public static final int LINE = 4;
    private static final int NUM_ARC_SEGMENTS = 100;
    private static final int NUM_ARC_POINTS = 101;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    static int defaultWidth = 260;
    static int defaultHeight = 150;
    static int defaultSpacing = 7;
    protected int graphType;
    protected int depth;
    protected boolean digitalOn;
    protected RangeCollectionInterface rangeCollection;
    protected double value;
    protected Font valueFont;
    protected Color valueColor;
    protected int valuePosition;
    protected String title;
    protected Font titleFont;
    protected Color titleColor;
    protected int titlePosition;
    protected Font labelsFont;
    protected Color labelsColor;
    protected Color outlineColor;
    protected Color hubColor;
    protected Color indicatorColor;
    protected int indicatorType;
    protected Dimension indicatorSize;
    Insets currentInsets;

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "graphType"}, {"Short description", RB.getStringResource(RB_KEY, "graphType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "graphType.pd.txt")}, {"Property editor class", "com.sas.beans.editors._RangeViewGraphTypeEditor"}}, {{"Name", "depth"}, {"Short description", RB.getStringResource(RB_KEY, "depth.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "depth.pd.txt")}, {"Property editor class", "com.sas.beans.editors._RangeViewDepthEditor"}}, {{"Name", "digitalSwitch"}, {"Short description", RB.getStringResource(RB_KEY, "digitalSwitch.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "digitalSwitch.pd.txt")}}, {{"Name", "rangeCollection"}, {"Short description", RB.getStringResource(RB_KEY, "rangeCollection.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "rangeCollection.pd.txt")}}, {{"Name", "value"}, {"Short description", RB.getStringResource(RB_KEY, "value.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "value.pd.txt")}}, {{"Name", "valueFont"}, {"Short description", RB.getStringResource(RB_KEY, "valueFont.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "valueFont.pd.txt")}}, {{"Name", "valueColor"}, {"Short description", RB.getStringResource(RB_KEY, "valueColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "valueColor.pd.txt")}}, {{"Name", "valuePosition"}, {"Short description", RB.getStringResource(RB_KEY, "valuePosition.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "valuePosition.pd.txt")}, {"Property editor class", "com.sas.beans.editors._RangeViewPosition"}}, {{"Name", "title"}, {"Short description", RB.getStringResource(RB_KEY, "title.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "title.pd.txt")}}, {{"Name", "titleFont"}, {"Short description", RB.getStringResource(RB_KEY, "titleFont.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "titleFont.pd.txt")}}, {{"Name", "titleColor"}, {"Short description", RB.getStringResource(RB_KEY, "titleColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "titleColor.pd.txt")}}, {{"Name", "titlePosition"}, {"Short description", RB.getStringResource(RB_KEY, "titlePosition.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "titlePosition.pd.txt")}, {"Property editor class", "com.sas.beans.editors._RangeViewPosition"}}, {{"Name", "labelsFont"}, {"Short description", RB.getStringResource(RB_KEY, "labelsFont.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "labelsFont.pd.txt")}}, {{"Name", "labelsColor"}, {"Short description", RB.getStringResource(RB_KEY, "labelsColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "labelsColor.pd.txt")}}, {{"Name", "outlineColor"}, {"Short description", RB.getStringResource(RB_KEY, "outlineColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "outlineColor.pd.txt")}}, {{"Name", "hubColor"}, {"Short description", RB.getStringResource(RB_KEY, "hubColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "hubColor.pd.txt")}}, {{"Name", "indicatorColor"}, {"Short description", RB.getStringResource(RB_KEY, "indicatorColor.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "indicatorColor.pd.txt")}}, {{"Name", "indicatorType"}, {"Short description", RB.getStringResource(RB_KEY, "indicatorType.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "indicatorType.pd.txt")}, {"Property editor class", "com.sas.beans.editors._RangeViewIndicatorEditor"}}, {{"Name", "indicatorSize"}, {"Short description", RB.getStringResource(RB_KEY, "indicatorSize.spd.txt")}, {"Description", RB.getStringResource(RB_KEY, "indicatorSize.pd.txt")}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "value";
        ebi.defaultOutputPropertyName = "value";
        ebi.shortDescription = RB.getStringResource(RB_KEY, "description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newWidth) {
        defaultWidth = newWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newHeight) {
        defaultHeight = newHeight;
    }

    public RangeView() {
        this.setModelInterface((ModelInterface)new RangeCollection());
        this.init();
    }

    public RangeView(RangeCollectionInterface custom) {
        this.setModelInterface((ModelInterface)new RangeCollection());
        this.init();
    }

    private void init() {
        this.graphType = 0;
        this.depth = 1;
        this.digitalOn = true;
        this.value = 0.0;
        this.valuePosition = 8;
        this.title = "";
        this.titlePosition = 8;
        this.indicatorType = 0;
        this.indicatorSize = new Dimension(8, 100);
        this.outlineColor = null;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public Dimension computePreferredSize() {
        return new Dimension(defaultWidth, defaultHeight);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        String supName = super.getFont().getName();
        if (this.valueFont == null) {
            this.valueFont = new Font(supName, 1, 20);
        }
        if (this.titleFont == null) {
            this.titleFont = new Font(supName, 1, 20);
        }
        if (this.labelsFont == null) {
            this.labelsFont = new Font(supName, 0, 12);
        }
        if (super.getForeground() != null) {
            if (this.valueColor == null) {
                this.valueColor = super.getForeground();
            }
            if (this.titleColor == null) {
                this.titleColor = super.getForeground();
            }
            if (this.labelsColor == null) {
                this.labelsColor = super.getForeground();
            }
            if (this.hubColor == null) {
                this.hubColor = super.getForeground();
            }
            if (this.indicatorColor == null) {
                this.indicatorColor = super.getForeground();
            }
        } else {
            if (this.valueColor == null) {
                this.valueColor = Color.black;
            }
            if (this.titleColor == null) {
                this.titleColor = Color.black;
            }
            if (this.labelsColor == null) {
                this.labelsColor = Color.black;
            }
            if (this.hubColor == null) {
                this.hubColor = Color.black;
            }
            if (this.indicatorColor == null) {
                this.indicatorColor = Color.black;
            }
        }
    }

    public Insets getInsets() {
        Insets borderInsets = this.getBorder().getInsets();
        if (this.currentInsets == null) {
            this.currentInsets = new Insets(0, 0, 0, 0);
        }
        Insets insets = new Insets(this.currentInsets.top, this.currentInsets.left, this.currentInsets.bottom, this.currentInsets.right);
        if (this.currentInsets.top < borderInsets.top) {
            insets.top = borderInsets.top;
        }
        if (this.currentInsets.bottom < borderInsets.bottom) {
            insets.bottom = borderInsets.bottom;
        }
        if (this.currentInsets.left < borderInsets.left) {
            insets.left = borderInsets.left;
        }
        if (this.currentInsets.right < borderInsets.right) {
            insets.right = borderInsets.right;
        }
        return insets;
    }

    public int getGraphType() {
        return this.graphType;
    }

    public void setGraphType(int newType) {
        if (newType == this.graphType) {
            return;
        }
        if (newType != 0 && newType != 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidType.ex.txt"));
        }
        int holder = this.graphType;
        this.graphType = newType;
        this.repaint();
        this.firePropertyChange("graphType", new Integer(holder), new Integer(newType));
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int newDepth) {
        if (newDepth == this.depth) {
            return;
        }
        if (newDepth != 0 && newDepth != 1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidDepth.ex.txt"));
        }
        int holder = this.depth;
        this.depth = newDepth;
        this.repaint();
        this.firePropertyChange("depth", new Integer(holder), new Integer(newDepth));
    }

    public RangeCollectionInterface getRange() {
        return this.rangeCollection;
    }

    public void setRange(RangeCollectionInterface newRangeCollection) {
        if (newRangeCollection instanceof ModelInterface) {
            this.setModelInterface((ModelInterface)newRangeCollection);
        } else {
            if (newRangeCollection == this.rangeCollection) {
                return;
            }
            RangeCollectionInterface holder = this.rangeCollection;
            this.rangeCollection = newRangeCollection;
            if (this.rangeCollection != null) {
                this.rangeCollection.removeContentsChangedListener((ContentsChangedListener)this);
            }
            if (newRangeCollection != null) {
                newRangeCollection.addContentsChangedListener((ContentsChangedListener)this);
            }
            this.repaint();
            this.firePropertyChange("rangeCollection", holder, newRangeCollection);
        }
    }

    @Override
    public void setModelInterface(ModelInterface newRangeCollection) {
        if (!(newRangeCollection instanceof RangeCollectionInterface)) {
            return;
        }
        if (newRangeCollection == this.rangeCollection) {
            if (this.getModelInterface() != newRangeCollection) {
                super.setModelInterface(newRangeCollection);
            }
            return;
        }
        super.setModelInterface(newRangeCollection);
        if (this.rangeCollection != null) {
            this.rangeCollection.removeContentsChangedListener((ContentsChangedListener)this);
        }
        if (newRangeCollection != null && newRangeCollection instanceof ContentsChangedSource) {
            ((ContentsChangedSource)newRangeCollection).addContentsChangedListener((ContentsChangedListener)this);
        }
        RangeCollectionInterface holder = this.rangeCollection;
        this.rangeCollection = (RangeCollectionInterface)newRangeCollection;
        this.repaint();
        this.firePropertyChange("rangeCollection", holder, newRangeCollection);
    }

    public boolean getDigitalOn() {
        return this.digitalOn;
    }

    public void setDigitalOn(boolean newValue) {
        if (newValue == this.digitalOn) {
            return;
        }
        boolean holder = this.digitalOn;
        this.digitalOn = newValue;
        this.repaint();
        this.firePropertyChange("digitalOn", new Boolean(holder), new Boolean(newValue));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double newValue) {
        if (newValue == this.value) {
            return;
        }
        double holder = this.value;
        this.value = newValue;
        this.repaint();
        this.firePropertyChange("value", new Double(holder), new Double(newValue));
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font newFont) {
        if (newFont.equals(this.valueFont)) {
            return;
        }
        Font holder = this.valueFont;
        this.valueFont = newFont;
        this.repaint();
        this.firePropertyChange("valueFont", holder, newFont);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(Color newColor) {
        if (newColor == null || newColor.equals(this.valueColor)) {
            return;
        }
        Color holder = this.valueColor;
        this.valueColor = newColor;
        this.repaint();
        this.firePropertyChange("valueColor", holder, newColor);
    }

    public int getValuePosition() {
        return this.valuePosition;
    }

    public void setValuePosition(int newPosition) {
        if (newPosition == this.valuePosition) {
            return;
        }
        if (!RectangularOrientation.validate((int)newPosition)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidValue.ex.txt"));
        }
        int holder = this.valuePosition;
        this.valuePosition = newPosition;
        this.repaint();
        this.firePropertyChange("valuePosition", new Integer(holder), new Integer(newPosition));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        if (newTitle.equals(this.title)) {
            return;
        }
        String holder = this.title;
        this.title = newTitle;
        this.repaint();
        this.firePropertyChange("title", holder, newTitle);
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font newFont) {
        if (newFont.equals(this.titleFont)) {
            return;
        }
        Font holder = this.titleFont;
        this.titleFont = newFont;
        this.repaint();
        this.firePropertyChange("titleFont", holder, newFont);
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color newColor) {
        if (newColor == null || newColor.equals(this.titleColor)) {
            return;
        }
        Color holder = this.titleColor;
        this.titleColor = newColor;
        this.repaint();
        this.firePropertyChange("titleColor", holder, newColor);
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(int newPosition) {
        if (newPosition == this.titlePosition) {
            return;
        }
        if (!RectangularOrientation.validate((int)newPosition)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidTitle.ex.txt"));
        }
        int holder = this.titlePosition;
        this.titlePosition = newPosition;
        this.repaint();
        this.firePropertyChange("titlePosition", new Integer(holder), new Integer(newPosition));
    }

    public Font getLabelsFont() {
        return this.labelsFont;
    }

    public void setLabelsFont(Font newFont) {
        if (newFont.equals(this.labelsFont)) {
            return;
        }
        Font holder = this.labelsFont;
        this.labelsFont = newFont;
        this.repaint();
        this.firePropertyChange("labelsFont", holder, newFont);
    }

    public Color getLabelsColor() {
        return this.labelsColor;
    }

    public void setLabelsColor(Color newColor) {
        if (newColor == null || newColor.equals(this.labelsColor)) {
            return;
        }
        Color holder = this.labelsColor;
        this.labelsColor = newColor;
        this.repaint();
        this.firePropertyChange("labelsColor", holder, newColor);
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color newColor) {
        if (newColor != null && newColor.equals(this.outlineColor)) {
            return;
        }
        Color holder = this.outlineColor;
        this.outlineColor = newColor;
        this.repaint();
        this.firePropertyChange("outlineColor", holder, newColor);
    }

    public Color getHubColor() {
        return this.hubColor;
    }

    public void setHubColor(Color newColor) {
        if (newColor == null || newColor.equals(this.hubColor)) {
            return;
        }
        Color holder = this.hubColor;
        this.hubColor = newColor;
        this.repaint();
        this.firePropertyChange("hubColor", holder, newColor);
    }

    public Color getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorColor(Color newColor) {
        if (newColor == null || newColor.equals(this.indicatorColor)) {
            return;
        }
        Color holder = this.indicatorColor;
        this.indicatorColor = newColor;
        this.repaint();
        this.firePropertyChange("indicatorColor", holder, newColor);
    }

    public int getIndicatorType() {
        return this.indicatorType;
    }

    public void setIndicatorType(int newType) {
        if (newType == this.indicatorType) {
            return;
        }
        if (newType != 0 && newType != 1 && newType != 2 && newType != 3 && newType != 4) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndicatorType.ex.txt"));
        }
        int holder = this.indicatorType;
        this.indicatorType = newType;
        this.repaint();
        this.firePropertyChange("indicatorType", new Integer(holder), new Integer(newType));
    }

    public Dimension getIndicatorSize() {
        return this.indicatorSize;
    }

    public void setIndicatorSize(Dimension newSize) {
        if (newSize.equals(this.indicatorSize)) {
            return;
        }
        if (newSize.width <= 0 || newSize.width > 10 || newSize.height <= 0 || newSize.height > 100) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndicatorSize.ex.txt"));
        }
        Dimension holder = this.indicatorSize;
        this.indicatorSize = newSize;
        this.repaint();
        this.firePropertyChange("indicatorSize", holder, newSize);
    }

    public int getIndicatorWidth() {
        return this.indicatorSize.width;
    }

    public void setIndicatorWidth(int newWidth) {
        if (newWidth == this.indicatorSize.width) {
            return;
        }
        if (newWidth <= 0 || newWidth > 10) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndicatorWidth.ex.txt"));
        }
        int holder = this.indicatorSize.width;
        this.indicatorSize.width = newWidth;
        this.repaint();
        this.firePropertyChange("indicatorSize", new Integer(holder), new Integer(newWidth));
    }

    public int getIndicatorHeight() {
        return this.indicatorSize.height;
    }

    public void setIndicatorHeight(int newHeight) {
        if (newHeight == this.indicatorSize.height) {
            return;
        }
        if (newHeight <= 0 || newHeight > 100) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidIndicatorHeight.ex.txt"));
        }
        int holder = this.indicatorSize.height;
        this.indicatorSize.height = newHeight;
        this.repaint();
        this.firePropertyChange("indicatorSize", new Integer(holder), new Integer(newHeight));
    }

    public void contentsChanged(ContentsChangedEvent cev) {
        this.repaint();
    }

    @Override
    public void paint(Graphics gc) {
        super.paint(gc);
        if (this.graphType == 0) {
            this.buildClassicWidget(gc);
        } else if (this.graphType == 1) {
            this.buildDigitalWidget(gc);
        }
    }

    private void buildClassicWidget(Graphics gc) {
        int j;
        int i;
        int yorigin;
        int vheight;
        int height;
        int lwidth;
        int[] x = new int[101];
        int[] y = new int[101];
        int valueDescent = 0;
        int labelDescent = 0;
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        if (rect.width == 0) {
            rect.width = defaultWidth;
        }
        if (rect.height == 0) {
            rect.height = defaultHeight;
        }
        rect.width = rect.width - insets.left - insets.right;
        rect.height = rect.height - insets.top - insets.bottom;
        boolean addHeights = false;
        FontMetrics lfm = gc.getFontMetrics(this.titleFont);
        int titleSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        lfm = gc.getFontMetrics(this.valueFont);
        int valueSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        lfm = gc.getFontMetrics(this.labelsFont);
        int rangeSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        if (this.title != null) {
            lfm = gc.getFontMetrics(this.titleFont);
            lwidth = lfm.stringWidth(this.title);
            height = lfm.getAscent();
            if (this.title.length() == 0) {
                lwidth = 0;
                height = 0;
            }
            int space = lfm.charWidth(' ');
            labelDescent = lfm.getDescent();
            FontMetrics vfm = gc.getFontMetrics(this.valueFont);
            int vwidth = vfm.stringWidth(DoubleData.toString((double)this.value));
            vheight = vfm.getAscent();
            valueDescent = vfm.getDescent();
            yorigin = lwidth == 0 ? ((this.valuePosition & 8) != 0 ? vheight + valueSpacing : rangeSpacing) : ((this.titlePosition & 8) != 0 ? ((this.valuePosition & 8) != 0 ? Math.max(height, vheight) + Math.max(valueSpacing, titleSpacing) : height + titleSpacing) : ((this.valuePosition & 8) != 0 ? vheight + valueSpacing : rangeSpacing));
            if (lwidth != 0) {
                if ((this.valuePosition & 4) != 0 && (this.titlePosition & 8) != 0 || (this.valuePosition & 8) != 0 && (this.titlePosition & 4) != 0) {
                    addHeights = true;
                }
                i = (this.titlePosition & 8) != 0 ? ((this.valuePosition & 8) != 0 ? rect.height - Math.max(labelDescent, valueDescent) - Math.max(titleSpacing, valueSpacing) : rect.height - labelDescent - titleSpacing) : ((this.titlePosition & 4) != 0 ? ((this.valuePosition & 4) != 0 ? Math.max(height, vheight) + Math.max(titleSpacing, valueSpacing) : height + titleSpacing) : rect.height / 2 + height / 2);
                j = (this.titlePosition & 1) != 0 ? 0 : ((this.titlePosition & 2) != 0 ? (this.valuePosition == this.titlePosition ? rect.width - (lwidth + space) - vwidth : rect.width - lwidth) : (this.valuePosition == this.titlePosition ? (rect.width - (lwidth + space) - vwidth) / 2 : (rect.width - lwidth) / 2));
                gc.setColor(this.titleColor);
                gc.setFont(this.titleFont);
                j += insets.left;
                i += insets.top;
                if (this.valuePosition == this.titlePosition) {
                    gc.drawString(this.title + " ", j, i);
                } else {
                    gc.drawString(this.title, j, i);
                }
            }
            i = (this.valuePosition & 8) != 0 ? ((this.titlePosition & 8) != 0 ? rect.height - Math.max(valueDescent, labelDescent) - Math.max(valueSpacing, titleSpacing) : rect.height - valueDescent - valueSpacing) : ((this.valuePosition & 4) != 0 ? ((this.titlePosition & 4) != 0 && lwidth != 0 ? Math.max(height, vheight) + Math.max(titleSpacing, valueSpacing) : vheight + valueSpacing) : rect.height / 2 + vheight / 2);
            j = (this.valuePosition & 1) != 0 ? (this.valuePosition == this.titlePosition && lwidth != 0 ? lwidth + space : 0) : ((this.valuePosition & 2) != 0 ? rect.width - vwidth : (this.valuePosition == this.titlePosition && lwidth != 0 ? (rect.width - (lwidth + space) - vwidth) / 2 + (lwidth + space) : (rect.width - vwidth) / 2));
            gc.setColor(this.valueColor);
            gc.setFont(this.valueFont);
            gc.drawString(DoubleData.toString((double)this.value), j += insets.left, i += insets.top);
        } else {
            yorigin = rangeSpacing;
            height = 0;
            vheight = 0;
        }
        int numRange = this.rangeCollection.getSegmentCount();
        if (numRange == 0) {
            return;
        }
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        double delta = valueN - value0;
        int[] seg = new int[numRange + 1];
        seg[0] = 0;
        for (i = 1; i < numRange; ++i) {
            seg[i] = (int)((this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue() - value0) / delta * 100.0 + 0.5);
            if (seg[i] >= seg[i - 1]) continue;
            seg[i] = seg[i - 1] + 1;
        }
        seg[numRange] = 100;
        lfm = gc.getFontMetrics(this.labelsFont);
        String label = DoubleData.toString((double)value0);
        lwidth = lfm.stringWidth(label);
        int lheight = lfm.getAscent();
        int realRangeSpacing = rangeSpacing / 3;
        yorigin = yorigin + lheight + rangeSpacing * 2;
        double xradScale = 0.9;
        int totalSpacing = 0;
        if ((this.titlePosition & 4) != 0) {
            totalSpacing = (this.valuePosition & 4) != 0 ? Math.max(titleSpacing, valueSpacing) : titleSpacing;
        } else if ((this.valuePosition & 4) != 0) {
            totalSpacing = valueSpacing;
        }
        height = addHeights ? height + vheight + labelDescent : Math.max(height, vheight) + labelDescent;
        double theta = Math.PI;
        delta = 0.031415926535897934;
        int xradius = (int)(xradScale * (double)(rect.width / 2 - lwidth));
        int yradius = rect.height - height - 3 * (lheight + realRangeSpacing) - rangeSpacing * 2;
        if (yradius > 0) {
            double dy;
            double dx;
            Polygon poly;
            int yoffset;
            int xoffset;
            int xorigin;
            if (this.depth == 1) {
                xorigin = (rect.width - xradius / 8) / 2;
                yradius -= xradius / 16;
            } else {
                xorigin = rect.width / 2;
            }
            for (i = 0; i < 101; ++i) {
                x[i] = (int)((double)xradius * Math.cos(theta) + 0.5 + (double)xorigin);
                y[i] = (int)((double)rect.height - ((double)yradius * Math.sin(theta) + 0.5 + (double)yorigin));
                theta -= delta;
            }
            y[0] = rect.height - yorigin;
            y[100] = rect.height - yorigin;
            if (this.depth == 1) {
                xoffset = (int)((float)xradius / 8.0f);
                yoffset = (int)((float)xoffset / 2.0f);
            } else {
                xoffset = 0;
                yoffset = 0;
            }
            gc.setColor(this.labelsColor);
            gc.setFont(this.labelsFont);
            j = Math.max(0, x[0] - lwidth / 2) + insets.left;
            i = y[0] + lheight + rangeSpacing + insets.top;
            gc.drawString(label, j, i);
            for (i = 1; i < numRange; ++i) {
                label = DoubleData.toString((double)this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue());
                lwidth = lfm.stringWidth(label);
                if (x[seg[i]] < xorigin) {
                    j = Math.max(0, x[seg[i]] - lwidth - 2) + insets.left;
                    gc.drawString(label, j, y[seg[i]] + insets.top);
                    continue;
                }
                if (x[seg[i]] == xorigin && this.depth == 0) {
                    j = Math.max(0, x[seg[i]] - lwidth / 2) + insets.left;
                    gc.drawString(label, j, y[seg[i]] - 2 + insets.top);
                    continue;
                }
                j = Math.min(rect.width - lwidth, x[seg[i]] + xoffset) + insets.left;
                gc.drawString(label, j, y[seg[i]] - yoffset - 2 + insets.top);
            }
            label = DoubleData.toString((double)valueN);
            lwidth = lfm.stringWidth(label);
            j = Math.min(rect.width - lwidth, x[100] - lwidth / 2) + insets.left;
            i = y[100] + lheight + rangeSpacing + insets.top;
            gc.drawString(label, j, i);
            if (this.depth == 1) {
                for (i = 0; i < 100; ++i) {
                    for (j = 1; j <= numRange && i >= seg[j]; ++j) {
                    }
                    gc.setColor(((Color)this.rangeCollection.getSegment(j - 1).get("COLOR")).darker());
                    poly = new Polygon();
                    poly.addPoint(x[i] + insets.left, y[i] + insets.top);
                    poly.addPoint(x[i] + xoffset + insets.left, y[i] - yoffset + insets.top);
                    poly.addPoint(x[i + 1] + xoffset + insets.left, y[i + 1] - yoffset + insets.top);
                    poly.addPoint(x[i + 1] + insets.left, y[i + 1] + insets.top);
                    gc.fillPolygon(poly);
                }
                if (this.outlineColor != null) {
                    gc.setColor(this.outlineColor);
                    poly = new Polygon();
                    for (i = 0; i < 101; ++i) {
                        poly.addPoint(x[i] + xoffset + insets.left, y[i] - yoffset + insets.top);
                    }
                    poly.addPoint(x[100] + insets.left, y[100] + insets.top);
                    gc.drawPolygon(poly);
                    for (i = 0; i <= numRange; ++i) {
                        gc.drawLine(x[seg[i]] + insets.left, y[seg[i]] + insets.top, x[seg[i]] + xoffset + insets.left, y[seg[i]] - yoffset + insets.top);
                    }
                }
            }
            for (i = 0; i < numRange; ++i) {
                gc.setColor((Color)this.rangeCollection.getSegment(i).get("COLOR"));
                poly = new Polygon();
                poly.addPoint(xorigin + insets.left, rect.height - yorigin + insets.top);
                for (j = seg[i]; j <= seg[i + 1]; ++j) {
                    poly.addPoint(x[j] + insets.left, y[j] + insets.top);
                }
                gc.fillPolygon(poly);
                if (this.outlineColor != null) {
                    gc.setColor(this.outlineColor);
                    gc.drawPolygon(poly);
                }
                --j;
            }
            if (this.value <= value0) {
                theta = Math.PI;
                dx = xradius;
                dy = 0.0;
            } else if (this.value >= valueN) {
                theta = 0.0;
                dx = xradius;
                dy = 0.0;
            } else {
                double di = (this.value - value0) / (valueN - value0) * 100.0;
                if (di + 1.0 > 100.0) {
                    di = 99.0;
                }
                dx = (double)x[(int)di + 1] * (di - (double)((int)di)) + (double)x[(int)di] * (1.0 - (di - (double)((int)di))) - (double)xorigin;
                dy = (double)rect.height - ((double)y[(int)di + 1] * (di - (double)((int)di)) + (double)y[(int)di] * (1.0 - (di - (double)((int)di))) + (double)yorigin);
                theta = dx == 0.0 ? 1.5707963267948966 : Math.atan(dy / dx);
                if (theta > Math.PI) {
                    theta -= Math.PI;
                } else if (theta < 0.0) {
                    theta += Math.PI;
                }
            }
            gc.setColor(this.indicatorColor);
            int width = xradius * this.indicatorSize.width / 100;
            height = (int)(Math.sqrt(dx * dx + dy * dy) * (double)this.indicatorSize.height / 100.0);
            if (this.indicatorType == 2) {
                height = (int)((double)height * 0.945);
            } else if (this.indicatorType != 4) {
                height = (int)((double)height * 0.9);
            }
            poly = new Polygon();
            Dimension rotPoint = this.rotatePoint(0, -width / 2, theta);
            poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
            rotPoint = this.indicatorType == 0 || this.indicatorType == 1 ? this.rotatePoint((int)((double)height * 1.05), -width / 2, theta) : this.rotatePoint(height, -width / 2, theta);
            poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
            rotPoint = this.indicatorType == 0 || this.indicatorType == 1 ? this.rotatePoint((int)((double)height * 1.05), width / 2, theta) : this.rotatePoint(height, width / 2, theta);
            poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
            rotPoint = this.rotatePoint(0, width / 2, theta);
            poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
            gc.fillPolygon(poly);
            poly = new Polygon();
            switch (this.indicatorType) {
                case 0: {
                    rotPoint = this.rotatePoint((int)((double)height / 0.9), 0, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, width, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, -width, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    gc.fillPolygon(poly);
                    break;
                }
                case 1: {
                    rotPoint = this.rotatePoint((int)((double)height / 0.9), 0, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, width, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint((int)((double)height * 0.95), 0, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, -width, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    gc.fillPolygon(poly);
                    break;
                }
                case 2: {
                    rotPoint = this.rotatePoint((int)((double)height / 0.945), 0, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint((int)((double)height * 0.95), width, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, 0, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint((int)((double)height * 0.95), -width, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    gc.fillPolygon(poly);
                    break;
                }
                case 3: {
                    rotPoint = this.rotatePoint((int)((double)height / 0.9), 0, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, width / 2, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    rotPoint = this.rotatePoint(height, -width / 2, theta);
                    poly.addPoint(rotPoint.width + xorigin + insets.left, rect.height - (yorigin + rotPoint.height) + insets.top);
                    gc.fillPolygon(poly);
                    break;
                }
            }
            gc.setColor(this.hubColor);
            poly = new Polygon();
            for (i = 0; i < 101; ++i) {
                poly.addPoint((x[i] - xorigin) / 5 + xorigin + insets.left, rect.height - ((rect.height - y[i] - yorigin) / 5 + yorigin - xradius * this.indicatorSize.width / 100 / 2) + insets.top);
            }
            gc.fillPolygon(poly);
            if (this.outlineColor != null) {
                gc.setColor(this.outlineColor);
                gc.drawPolygon(poly);
            }
        }
    }

    private void buildDigitalWidget(Graphics gc) {
        int ymax;
        int ymin;
        int y;
        int i;
        int vheight;
        int height;
        int lwidth;
        int valueDescent = 0;
        int labelDescent = 0;
        boolean addHeights = false;
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        if (rect.width == 0) {
            rect.width = defaultWidth;
        }
        if (rect.height == 0) {
            rect.height = defaultHeight;
        }
        rect.width = rect.width - insets.left - insets.right;
        rect.height = rect.height - insets.top - insets.bottom;
        FontMetrics lfm = gc.getFontMetrics(this.titleFont);
        int titleSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        lfm = gc.getFontMetrics(this.valueFont);
        int valueSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        lfm = gc.getFontMetrics(this.labelsFont);
        int rangeSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        if (this.title != null && (this.title.length() != 0 && this.digitalOn || !this.digitalOn)) {
            int j;
            int vwidth;
            lfm = gc.getFontMetrics(this.titleFont);
            lwidth = lfm.stringWidth(this.title);
            height = lfm.getAscent();
            int space = 0;
            if (!this.digitalOn) {
                lfm.charWidth(' ');
            }
            labelDescent = lfm.getDescent();
            valueDescent = 0;
            if (this.title.length() == 0) {
                height = 0;
                lwidth = 0;
            }
            if (this.digitalOn) {
                vwidth = 0;
                vheight = 0;
            } else {
                FontMetrics vfm = gc.getFontMetrics(this.valueFont);
                vwidth = vfm.stringWidth(DoubleData.toString((double)this.value));
                vheight = vfm.getAscent();
                valueDescent = vfm.getDescent();
            }
            if (lwidth != 0) {
                if (((this.valuePosition & 4) != 0 && (this.titlePosition & 8) != 0 || (this.valuePosition & 8) != 0 && (this.titlePosition & 4) != 0) && !this.digitalOn) {
                    addHeights = true;
                }
                i = (this.titlePosition & 8) != 0 ? ((this.valuePosition & 8) != 0 ? rect.height - Math.max(valueDescent, labelDescent) - Math.max(valueSpacing, titleSpacing) : rect.height - labelDescent - titleSpacing) : ((this.titlePosition & 4) != 0 ? ((this.valuePosition & 4) != 0 ? Math.max(height, vheight) + Math.max(valueSpacing, titleSpacing) : height + titleSpacing) : rect.height / 2 + height / 2);
                j = (this.titlePosition & 1) != 0 ? 0 : ((this.titlePosition & 2) != 0 ? (this.valuePosition == this.titlePosition ? rect.width - (lwidth + space) - vwidth : rect.width - lwidth) : (this.valuePosition == this.titlePosition ? (rect.width - (lwidth + space) - vwidth) / 2 : (rect.width - lwidth) / 2));
                gc.setColor(this.titleColor);
                gc.setFont(this.titleFont);
                j += insets.left;
                i += insets.top;
                if (this.valuePosition == this.titlePosition && !this.digitalOn) {
                    gc.drawString(this.title + " ", j, i);
                } else {
                    gc.drawString(this.title, j, i);
                }
            }
            if (!this.digitalOn) {
                i = (this.valuePosition & 8) != 0 ? ((this.titlePosition & 8) != 0 ? rect.height - Math.max(labelDescent, valueDescent) - Math.max(valueSpacing, titleSpacing) : rect.height - valueDescent - valueSpacing) : ((this.valuePosition & 4) != 0 ? ((this.titlePosition & 4) != 0 && lwidth != 0 ? Math.max(height, vheight) + Math.max(valueSpacing, titleSpacing) : vheight + valueSpacing) : rect.height / 2 + vheight / 2);
                j = (this.valuePosition & 1) != 0 ? (this.valuePosition == this.titlePosition && lwidth != 0 ? lwidth + space : 0) : ((this.valuePosition & 2) != 0 ? rect.width - vwidth : (this.valuePosition == this.titlePosition && lwidth != 0 ? (rect.width - (lwidth + space) - vwidth) / 2 + (lwidth + space) : (rect.width - vwidth) / 2));
                gc.setColor(this.valueColor);
                gc.setFont(this.valueFont);
                gc.drawString(DoubleData.toString((double)this.value), j += insets.left, i += insets.top);
            }
        } else {
            height = 0;
            vheight = 0;
            titleSpacing = 0;
        }
        int numRange = this.rangeCollection.getSegmentCount();
        if (numRange == 0) {
            return;
        }
        if (this.title.length() == 0) {
            titleSpacing = 0;
        }
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        double delta = valueN - value0;
        double barWidth = 0.8 * (double)rect.width;
        int[] seg = new int[numRange + 1];
        seg[0] = (int)(-barWidth / 2.0);
        for (i = 1; i < numRange; ++i) {
            seg[i] = (int)((this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue() - value0) / delta * barWidth - barWidth / 2.0);
            if (seg[i] > seg[i - 1]) continue;
            seg[i] = seg[i - 1] + 1;
        }
        seg[numRange] = (int)(barWidth / 2.0);
        lfm = gc.getFontMetrics(this.labelsFont);
        String label = DoubleData.toString((double)value0);
        lwidth = lfm.stringWidth(label);
        int lheight = lfm.getAscent();
        if ((this.titlePosition & 4) != 0) {
            y = height + lheight + titleSpacing + rangeSpacing;
            ymin = rect.height - rangeSpacing * 2;
            if (!this.digitalOn && (this.valuePosition & 8) != 0) {
                ymin = ymin - vheight - valueDescent - valueSpacing + rangeSpacing;
            } else if (!this.digitalOn && vheight > height) {
                y = y + (vheight - height) + (valueSpacing - titleSpacing);
            }
            ymax = y;
        } else {
            y = lheight + rangeSpacing;
            ymin = rect.height - height - labelDescent - titleSpacing - rangeSpacing;
            if (this.title.length() == 0) {
                ymin -= rangeSpacing;
            }
            if (!this.digitalOn && (this.valuePosition & 4) != 0) {
                y = y + vheight + valueDescent + valueSpacing;
                ymin += rangeSpacing;
            } else if (!this.digitalOn && vheight > height) {
                ymin = ymin - (vheight - height) - (valueSpacing - titleSpacing);
            }
            ymax = y - rangeSpacing;
        }
        gc.setColor(this.labelsColor);
        gc.setFont(this.labelsFont);
        if (!this.digitalOn && (double)y + 0.03 * (double)rect.height + (double)rangeSpacing < (double)ymin || this.digitalOn) {
            int x;
            String rangeLabel;
            if ((double)y + 0.03 * (double)rect.height + (double)rangeSpacing + 0.01 * (double)rect.height > (double)ymin && (double)y + 0.03 * (double)rect.height + (double)rangeSpacing > (double)ymin && this.digitalOn) {
                return;
            }
            y = insets.top + y;
            for (int k = 0; k < numRange; ++k) {
                rangeLabel = DoubleData.toString((double)this.rangeCollection.getSegment(k).getMinimumNumber().doubleValue());
                lwidth = lfm.stringWidth(rangeLabel);
                x = Math.max(0, seg[k] - lwidth / 2 + rect.width / 2);
                gc.drawString(rangeLabel, x += insets.left, y);
            }
            rangeLabel = DoubleData.toString((double)valueN);
            lwidth = lfm.stringWidth(rangeLabel);
            x = (int)Math.min((double)(rect.width - lwidth), barWidth / 2.0 - (double)(lwidth / 2) + (double)(rect.width / 2));
            x = insets.left + x;
            gc.drawString(rangeLabel, x, y);
            y -= insets.top;
            y = (int)((double)y + 0.03 * (double)rect.height + (double)rangeSpacing);
            if (this.digitalOn) {
                ymax = Math.min((int)((double)y + 0.1 * (double)rect.height), ymin);
                if (ymax == ymin && y > ymin) {
                    return;
                }
            } else {
                ymax = ymin;
            }
            for (int k = 0; k < numRange; ++k) {
                Color buttonColor = (Color)this.rangeCollection.getSegment(k).get("COLOR");
                this.buildButton(seg[k], -ymax + rect.height, seg[k + 1], -y + rect.height, buttonColor, gc);
            }
            int thumb = (int)((this.value - value0) / (valueN - value0) * barWidth - barWidth / 2.0);
            if ((double)thumb > barWidth / 2.0) {
                thumb = (int)(barWidth / 2.0);
            } else if ((double)thumb < -barWidth / 2.0) {
                thumb = (int)(-barWidth / 2.0);
            }
            this.buildButton((int)((double)thumb - 0.02 * (double)rect.width), rect.height - y, (int)((double)thumb + 0.02 * (double)rect.width), (int)((double)rect.height - ((double)y - 0.03 * (double)rect.height)), this.indicatorColor, gc);
            this.buildButton((int)((double)thumb - 0.01 * (double)rect.width), rect.height - ymax, (int)((double)thumb + 0.01 * (double)rect.width), rect.height - y, this.indicatorColor, gc);
            if (this.digitalOn) {
                if ((ymax = (int)((double)ymax + 0.03 * (double)rect.height)) < ymin) {
                    this.buildButton(seg[0], rect.height - ymin, seg[numRange], rect.height - ymax, Color.gray, gc);
                }
                int border = 0;
                if (this.depth == 1) {
                    border = Math.min(seg[numRange] - seg[0], ymin - ymax);
                    border = (double)border < 0.06 * ((double)rect.width * 0.8) ? (int)((double)border * 0.25) : (int)(0.015 * ((double)rect.width * 0.8));
                }
                String str = DoubleData.toString((double)this.value);
                ymax = -ymax + rect.height;
                ymin = -ymin + rect.height;
                int digitalHeight = ymax - ymin;
                if (this.depth == 1) {
                    ymax -= border;
                    ymin += border;
                }
                this.buildNumber((int)(-0.49 * barWidth + (double)border), (int)((double)ymin + 0.01 * (double)digitalHeight), (int)(0.49 * barWidth - (double)border), (int)((double)ymax - 0.01 * (double)digitalHeight), str, true, gc);
            }
        }
    }

    private int buildButton(int xmin, int ymin, int xmax, int ymax, Color buttonColor, Graphics gc) {
        int border = 0;
        int xborder = 0;
        int yborder = 0;
        Rectangle rect = this.getBounds();
        if (rect.width == 0) {
            rect.width = defaultWidth;
        }
        if (rect.height == 0) {
            rect.height = defaultHeight;
        }
        Insets insets = this.getInsets();
        rect.width = rect.width - insets.left - insets.right;
        rect.height = rect.height - insets.top - insets.bottom;
        xmin += rect.width / 2;
        xmax += rect.width / 2;
        int temp = ymin;
        ymin = rect.height - ymax;
        ymax = rect.height - temp;
        if (this.depth == 1) {
            border = Math.min(xmax - xmin, ymax - ymin);
            border = (double)border < 0.06 * ((double)rect.width * 0.8) ? (int)((double)border * 0.25) : (int)(0.015 * ((double)rect.width * 0.8));
            xborder = yborder = border;
            Color borderColor = Color.darkGray;
            ymax += insets.top;
            Polygon bevel = new Polygon();
            gc.setColor(borderColor);
            bevel.addPoint(xmin += insets.left, ymin += insets.top);
            bevel.addPoint(xmax += insets.left, ymin);
            bevel.addPoint(xmax - xborder, ymin + yborder);
            bevel.addPoint(xmin + xborder, ymin + yborder);
            gc.fillPolygon(bevel);
            gc.setColor(Color.lightGray);
            bevel = new Polygon();
            bevel.addPoint(xmin, ymin);
            bevel.addPoint(xmin + xborder, ymin + yborder);
            bevel.addPoint(xmin + xborder, ymax - yborder);
            bevel.addPoint(xmin, ymax);
            gc.fillPolygon(bevel);
            bevel = new Polygon();
            bevel.addPoint(xmin + xborder, ymax - yborder);
            bevel.addPoint(xmax - xborder, ymax - yborder);
            bevel.addPoint(xmax, ymax);
            bevel.addPoint(xmin, ymax);
            gc.fillPolygon(bevel);
            gc.setColor(Color.darkGray);
            bevel = new Polygon();
            bevel.addPoint(xmax - xborder, ymin + yborder);
            bevel.addPoint(xmax, ymin);
            bevel.addPoint(xmax, ymax);
            bevel.addPoint(xmax - xborder, ymax - yborder);
            gc.fillPolygon(bevel);
        }
        Polygon poly = new Polygon();
        gc.setColor(buttonColor);
        poly.addPoint(xmin + xborder, ymin + yborder);
        poly.addPoint(xmax - xborder, ymin + yborder);
        poly.addPoint(xmax - xborder, ymax - yborder);
        poly.addPoint(xmin + xborder, ymax - yborder);
        gc.fillPolygon(poly);
        if (this.outlineColor != null) {
            gc.setColor(this.outlineColor);
            poly = new Polygon();
            poly.addPoint(xmin, ymin);
            poly.addPoint(xmax, ymin);
            poly.addPoint(xmax, ymax);
            poly.addPoint(xmin, ymax);
            gc.drawPolygon(poly);
        }
        return 1;
    }

    private int buildNumber(int xo, int yo, int xmax, int ymax, String str, boolean flag, Graphics gc) {
        int i;
        double len = 0.0;
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '.' || str.charAt(i) == '1') {
                len += 0.5;
                continue;
            }
            len += 1.0;
        }
        double xsize = xmax - xo;
        double delta = xsize / len;
        double ysize = ymax - yo;
        if (1.4 * delta > ysize) {
            delta = ysize / 1.5;
            xo = (int)((double)xo + (xsize - delta * len) / 2.0);
        }
        int width = (int)(0.6 * delta);
        int height = width / 3;
        double half = (double)height / 2.0;
        if (flag) {
            yo = (int)((double)yo + (ysize - (double)(2 * width + height)) / 2.0);
        }
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '-') {
                this.buildLed((int)((double)xo + half), yo + width, width, height, this.valueColor, 0, gc);
                xo = (int)((double)xo + delta);
                continue;
            }
            char tempChar = str.charAt(i);
            if (tempChar == '.') {
                this.buildDot(xo, yo, height, height, this.valueColor, gc);
                xo = (int)((double)xo + delta / 2.0);
                continue;
            }
            if (tempChar < '3' || tempChar == '6' || tempChar == '8' || tempChar == 'E' || tempChar == 'e') {
                this.buildLed(xo, (int)((double)yo + half), height, width, this.valueColor, 1, gc);
            }
            if (tempChar < '2' || tempChar > '3' && tempChar != '7') {
                this.buildLed(xo, (int)((double)(yo + width) + half), height, width, this.valueColor, 1, gc);
            }
            if (tempChar != '1' && tempChar != '4' && tempChar != '7' && tempChar != '9') {
                this.buildLed((int)((double)xo + half), yo, width, height, this.valueColor, 0, gc);
            }
            if (tempChar > '1' && tempChar != '7') {
                this.buildLed((int)((double)xo + half), yo + width, width, height, this.valueColor, 0, gc);
            }
            if (tempChar != '1' && tempChar != '4' && tempChar != '6') {
                this.buildLed((int)((double)xo + half), yo + 2 * width, width, height, this.valueColor, 0, gc);
            }
            if (tempChar == '0' || tempChar > '2' && tempChar != 'E' && tempChar != 'e') {
                this.buildLed(xo + width, (int)((double)yo + half), height, width, this.valueColor, 1, gc);
            }
            if (tempChar < '5' && tempChar != '1' || tempChar > '6' && tempChar != 'E' && tempChar != 'e') {
                this.buildLed(xo + width, (int)((double)(yo + width) + half), height, width, this.valueColor, 1, gc);
            }
            xo = tempChar == '1' ? (int)((double)xo + delta / 2.0) : (int)((double)xo + delta);
        }
        return 1;
    }

    private int buildLed(int xo, int yo, int width, int height, Color buttonColor, int orientation, Graphics gc) {
        double[] x = new double[6];
        double[] y = new double[6];
        double halfwidth = (double)width / 2.0;
        double halfheight = (double)height / 2.0;
        double fudge = halfwidth * 0.1;
        Insets insets = this.getInsets();
        if (orientation == 0) {
            double xoff = (double)width / 8.0;
            double yoff = xoff / 2.0;
            x[0] = (double)xo + halfheight + fudge;
            y[0] = yo;
            x[1] = (double)xo + fudge;
            y[1] = (double)yo + halfheight;
            x[2] = (double)xo + halfheight + fudge;
            y[2] = yo + height;
            x[3] = (double)(xo + width) - halfheight - fudge;
            y[3] = yo + height;
            x[4] = (double)(xo + width) - fudge;
            y[4] = (double)yo + halfheight;
            x[5] = (double)(xo + width) - halfheight - fudge;
            y[5] = yo;
            Polygon poly = new Polygon();
            gc.setColor(this.valueColor);
            Rectangle rect = this.getBounds();
            if (rect.width == 0) {
                rect.width = defaultWidth;
            }
            if (rect.height == 0) {
                rect.height = defaultHeight;
            }
            rect.width = rect.width - insets.left - insets.right;
            rect.height = rect.height - insets.top - insets.bottom;
            if (this.depth == 1) {
                int j = 5;
                int i = 0;
                while (i < 6) {
                    int xCorr = rect.width / 2;
                    int yCorr = rect.height;
                    Polygon shadowPoly = new Polygon();
                    shadowPoly.addPoint((int)(x[j] + (double)xCorr) + insets.left, (int)((double)yCorr - y[j]) + insets.top);
                    shadowPoly.addPoint((int)(x[i] + (double)xCorr) + insets.left, (int)((double)yCorr - y[i]) + insets.top);
                    shadowPoly.addPoint((int)(x[i] + xoff + (double)xCorr) + insets.left, (int)((double)yCorr - (y[i] + yoff)) + insets.top);
                    shadowPoly.addPoint((int)(x[j] + xoff + (double)xCorr) + insets.left, (int)((double)yCorr - (y[j] + yoff)) + insets.top);
                    gc.setColor(Color.lightGray);
                    gc.fillPolygon(shadowPoly);
                    j = i++;
                }
            }
            gc.setColor(this.valueColor);
            for (int i = 0; i < 6; ++i) {
                poly.addPoint((int)(x[i] + (double)(rect.width / 2)) + insets.left, (int)((double)rect.height - y[i]) + insets.top);
            }
            gc.fillPolygon(poly);
        } else {
            double xoff = (double)height / 8.0;
            double yoff = xoff / 2.0;
            x[0] = xo;
            y[0] = (double)yo + halfwidth + fudge;
            x[1] = xo;
            y[1] = (double)(yo + height) - halfwidth - fudge;
            x[2] = (double)xo + halfwidth;
            y[2] = (double)(yo + height) - fudge;
            x[3] = xo + width;
            y[3] = (double)(yo + height) - halfwidth - fudge;
            x[4] = xo + width;
            y[4] = (double)yo + halfwidth + fudge;
            x[5] = (double)xo + halfwidth;
            y[5] = (double)yo + fudge;
            Polygon poly = new Polygon();
            gc.setColor(this.valueColor);
            Rectangle rect = this.getBounds();
            if (rect.width == 0) {
                rect.width = defaultWidth;
            }
            if (rect.height == 0) {
                rect.height = defaultHeight;
            }
            rect.width = rect.width - insets.left - insets.right;
            rect.height = rect.height - insets.top - insets.bottom;
            if (this.depth == 1) {
                int j = 5;
                int i = 0;
                while (i < 6) {
                    int xCorr = rect.width / 2;
                    int yCorr = rect.height;
                    Polygon shadowPoly = new Polygon();
                    shadowPoly.addPoint((int)(x[j] + (double)xCorr) + insets.left, (int)((double)yCorr - y[j]) + insets.top);
                    shadowPoly.addPoint((int)(x[i] + (double)xCorr) + insets.left, (int)((double)yCorr - y[i]) + insets.top);
                    shadowPoly.addPoint((int)(x[i] + xoff + (double)xCorr) + insets.left, (int)((double)yCorr - (y[i] + yoff)) + insets.top);
                    shadowPoly.addPoint((int)(x[j] + xoff + (double)xCorr) + insets.left, (int)((double)yCorr - (y[j] + yoff)) + insets.top);
                    gc.setColor(Color.lightGray);
                    gc.fillPolygon(shadowPoly);
                    j = i++;
                }
            }
            gc.setColor(this.valueColor);
            for (int i = 0; i < 6; ++i) {
                poly.addPoint((int)(x[i] + (double)(rect.width / 2)) + insets.left, (int)((double)rect.height - y[i]) + insets.top);
            }
            gc.fillPolygon(poly);
        }
        return 1;
    }

    private int buildDot(int xo, int yo, int height, int width, Color buttonColor, Graphics gc) {
        int[] x = new int[8];
        int[] y = new int[8];
        Insets insets = this.getInsets();
        int q = width / 4;
        int xoff = (int)((double)width / 3.0);
        int yoff = (int)((double)xoff / 2.0);
        x[0] = xo;
        y[0] = yo + q;
        x[1] = xo;
        y[1] = yo + height - q;
        x[2] = xo + q;
        y[2] = yo + height;
        x[3] = xo + width - q;
        y[3] = yo + height;
        x[4] = xo + width;
        y[4] = yo + height - q;
        x[5] = xo + width;
        y[5] = yo + q;
        x[6] = xo + width - q;
        y[6] = yo;
        x[7] = xo + q;
        y[7] = yo;
        Polygon poly = new Polygon();
        Rectangle rect = this.getBounds();
        if (rect.width == 0) {
            rect.width = defaultWidth;
        }
        if (rect.height == 0) {
            rect.height = defaultHeight;
        }
        rect.width = rect.width - insets.left - insets.right;
        rect.height = rect.height - insets.top - insets.bottom;
        if (this.depth == 1) {
            int j = 7;
            gc.setColor(Color.lightGray);
            int i = 0;
            while (i < 8) {
                Polygon shadowPoly = new Polygon();
                shadowPoly.addPoint(x[j] + rect.width / 2 + insets.left, rect.height - y[j] + insets.top);
                shadowPoly.addPoint(x[i] + rect.width / 2 + insets.left, rect.height - y[i] + insets.top);
                shadowPoly.addPoint(x[i] + xoff + rect.width / 2 + insets.left, rect.height - (y[i] + yoff) + insets.top);
                shadowPoly.addPoint(x[j] + xoff + rect.width / 2 + insets.left, rect.height - (y[j] + yoff) + insets.top);
                gc.fillPolygon(shadowPoly);
                j = i++;
            }
        }
        for (int i = 0; i < 8; ++i) {
            poly.addPoint(x[i] + rect.width / 2 + insets.left, rect.height - y[i] + insets.top);
        }
        gc.setColor(this.valueColor);
        gc.fillPolygon(poly);
        return 1;
    }

    private void buildSpeedometerWidget(Graphics gc) {
        int j;
        int i;
        int yorigin;
        int vheight;
        int height;
        int lwidth;
        int tempDepth = this.depth;
        this.depth = 0;
        int valueDescent = 0;
        int labelDescent = 0;
        boolean addHeights = false;
        Rectangle rect = this.getBounds();
        if (rect.width == 0) {
            rect.width = defaultWidth;
        }
        if (rect.height == 0) {
            rect.height = defaultHeight;
        }
        int[] x = new int[101];
        int[] y = new int[101];
        FontMetrics lfm = gc.getFontMetrics(this.titleFont);
        int titleSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        lfm = gc.getFontMetrics(this.valueFont);
        int valueSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        lfm = gc.getFontMetrics(this.labelsFont);
        int rangeSpacing = Math.max(defaultSpacing, lfm.getHeight() / 3);
        if (this.title != null && (this.title.length() != 0 && this.digitalOn || !this.digitalOn)) {
            int vwidth;
            lfm = gc.getFontMetrics(this.titleFont);
            lwidth = lfm.stringWidth(this.title);
            height = lfm.getAscent();
            int space = lfm.charWidth(' ');
            labelDescent = lfm.getDescent();
            valueDescent = 0;
            if (this.title.length() == 0) {
                height = 0;
                lwidth = 0;
            }
            if (this.digitalOn) {
                vwidth = 0;
                vheight = 0;
            } else {
                FontMetrics vfm = gc.getFontMetrics(this.valueFont);
                vwidth = vfm.stringWidth(DoubleData.toString((double)this.value));
                vheight = vfm.getAscent();
                valueDescent = vfm.getDescent();
            }
            yorigin = lwidth == 0 ? ((this.valuePosition & 8) != 0 ? vheight + valueSpacing : rangeSpacing) : ((this.titlePosition & 8) != 0 ? ((this.valuePosition & 8) != 0 ? Math.max(height, vheight) + Math.max(titleSpacing, valueSpacing) : height + titleSpacing) : ((this.valuePosition & 8) != 0 ? vheight + valueSpacing : rangeSpacing));
            if (lwidth != 0) {
                if (((this.valuePosition & 4) != 0 && (this.titlePosition & 8) != 0 || (this.valuePosition & 8) != 0 && (this.titlePosition & 4) != 0) && !this.digitalOn) {
                    addHeights = true;
                }
                i = (this.titlePosition & 8) != 0 ? ((this.valuePosition & 8) != 0 ? rect.height - Math.max(valueDescent, labelDescent) - Math.max(valueSpacing, titleSpacing) : rect.height - labelDescent - titleSpacing) : ((this.titlePosition & 4) != 0 ? ((this.valuePosition & 4) != 0 ? Math.max(height, vheight) + Math.max(valueSpacing, titleSpacing) : height + titleSpacing) : rect.height / 2 + height / 2);
                j = (this.titlePosition & 1) != 0 ? 0 : ((this.titlePosition & 2) != 0 ? (this.valuePosition == this.titlePosition ? rect.width - (lwidth + space) - vwidth : rect.width - lwidth) : (this.valuePosition == this.titlePosition ? (rect.width - (lwidth + space) - vwidth) / 2 : (rect.width - lwidth) / 2));
                gc.setColor(this.titleColor);
                gc.setFont(this.titleFont);
                if (this.valuePosition == this.titlePosition && !this.digitalOn) {
                    gc.drawString(this.title + " ", j, i);
                } else {
                    gc.drawString(this.title, j, i);
                }
            }
            if (!this.digitalOn) {
                i = (this.valuePosition & 8) != 0 ? ((this.titlePosition & 8) != 0 ? rect.height - Math.max(labelDescent, valueDescent) - Math.max(valueSpacing, titleSpacing) : rect.height - valueDescent - valueSpacing) : ((this.valuePosition & 4) != 0 ? ((this.titlePosition & 4) != 0 && lwidth != 0 ? Math.max(height, vheight) + Math.max(valueSpacing, titleSpacing) : vheight + valueSpacing) : rect.height / 2 + vheight / 2);
                j = (this.valuePosition & 1) != 0 ? (this.valuePosition == this.titlePosition && lwidth != 0 ? lwidth + space : 0) : ((this.valuePosition & 2) != 0 ? rect.width - vwidth : (this.valuePosition == this.titlePosition && lwidth != 0 ? (rect.width - (lwidth + space) - vwidth) / 2 + (lwidth + space) : (rect.width - vwidth) / 2));
                gc.setColor(this.valueColor);
                gc.setFont(this.valueFont);
                gc.drawString(DoubleData.toString((double)this.value), j, i);
            }
        } else {
            height = 0;
            vheight = 0;
            yorigin = rangeSpacing;
        }
        int numRange = this.rangeCollection.getSegmentCount();
        if (numRange == 0) {
            return;
        }
        double value0 = this.rangeCollection.getSegment(0).getMinimumNumber().doubleValue();
        double valueN = this.rangeCollection.getSegment(numRange - 1).getMaximumNumber().doubleValue();
        double delta = valueN - value0;
        int[] seg = new int[numRange + 1];
        seg[0] = 0;
        for (i = 1; i < numRange; ++i) {
            seg[i] = (int)((this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue() - value0) / delta * 100.0 + 0.5);
            if (seg[i] > seg[i - 1]) continue;
            seg[i] = seg[i - 1] + 1;
        }
        seg[numRange] = 100;
        lfm = gc.getFontMetrics(this.labelsFont);
        String label = DoubleData.toString((double)value0);
        lwidth = lfm.stringWidth(label);
        int lheight = lfm.getAscent();
        int realRangeSpacing = lfm.getHeight() / 3;
        yorigin = yorigin + lheight + rangeSpacing;
        double xradScale = 0.9;
        int totalSpacing = 0;
        if ((this.titlePosition & 4) != 0) {
            totalSpacing = (this.valuePosition & 4) != 0 ? Math.max(titleSpacing, valueSpacing) : titleSpacing;
        } else if ((this.valuePosition & 4) != 0) {
            totalSpacing = valueSpacing;
        }
        if (addHeights) {
            height = height + vheight + labelDescent;
            xradScale = 0.7;
        }
        double theta = Math.PI;
        delta = 0.015707963267948967;
        int xmin = (int)(-0.4 * (double)rect.width);
        int xmax = (int)(0.25 * (double)rect.width);
        int xradius = (int)(xradScale * ((double)(xmax - xmin) - 0.07 * (double)rect.width));
        int yradius = rect.height - height - 2 * (lheight + realRangeSpacing) - rangeSpacing * 2 - realRangeSpacing;
        yradius = (int)((double)yradius / 1.2);
        int xorigin = xmax;
        for (i = 0; i < 101; ++i) {
            x[i] = (int)((double)xradius * Math.cos(theta) + 0.5 + (double)xorigin + (double)(rect.width / 2));
            y[i] = (int)((double)rect.height - ((double)yradius * Math.sin(theta) + 0.5 + (double)yorigin));
            theta -= delta;
        }
        x[100] = xorigin + rect.width / 2;
        y[0] = rect.height - yorigin;
        gc.setColor(this.labelsColor);
        gc.setFont(this.labelsFont);
        int k = 0;
        for (i = 0; i < numRange; ++i) {
            label = DoubleData.toString((double)this.rangeCollection.getSegment(i).getMinimumNumber().doubleValue());
            lwidth = lfm.stringWidth(label);
            j = Math.min((int)((double)(x[seg[i]] - rect.width / 2) * 0.95 + (double)(rect.width / 2)), (int)(0.5 * (double)rect.width - (double)lwidth - (double)xmax + (double)(rect.width / 2)));
            k = (int)((double)rect.height - ((double)(rect.height - (y[seg[i]] - yorigin)) * 0.98 - (double)(lheight * (rect.height - (y[seg[i]] - yorigin)) / yradius) + (double)realRangeSpacing) + (double)yorigin);
            if (i == 0) {
                k = y[0];
            }
            gc.drawString(label, j, k);
        }
        label = DoubleData.toString((double)valueN);
        lwidth = lfm.stringWidth(label);
        j = xorigin + rect.width / 2;
        i = y[100] + lheight;
        gc.drawString(label, j, i);
        Polygon poly = new Polygon();
        for (i = 0; i < numRange; ++i) {
            gc.setColor((Color)this.rangeCollection.getSegment(i).get("COLOR"));
            poly = new Polygon();
            for (j = seg[i]; j <= seg[i + 1]; ++j) {
                poly.addPoint(x[j], y[j]);
            }
            for (j = seg[i + 1]; j >= seg[i]; --j) {
                int tempX = (int)(((double)x[j] - (double)rect.width / 2.0 - (double)xorigin) * 1.2 + (double)rect.width / 2.0 + (double)xorigin);
                int tempY = (int)((double)rect.height - ((double)(rect.height - y[j] - yorigin) * 1.2 + (double)yorigin));
                poly.addPoint(tempX, tempY);
            }
            poly.addPoint(x[seg[i]], y[seg[i]]);
            gc.fillPolygon(poly);
            if (this.outlineColor != null) {
                gc.setColor(this.outlineColor);
                gc.drawPolygon(poly);
            }
            --j;
        }
        theta = (this.value - delta) * Math.PI / 2.0;
        i = (int)(1.2 * (double)xradius * Math.cos(theta + 1.5707963267948966));
        j = (int)(1.2 * (double)yradius * Math.sin(theta + 1.5707963267948966));
        if (this.digitalOn) {
            String valueString = DoubleData.toString((double)this.value);
            this.buildNumber(Math.max(xmin, (int)(-0.15 * (double)rect.width)), yorigin, (int)(0.45 * (double)rect.width), (int)((double)yorigin + 0.4 * (double)(yorigin + yradius)), valueString, false, gc);
        }
        this.depth = tempDepth;
    }

    private Dimension rotatePoint(int x, int y, double angle) {
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        Dimension rot = new Dimension();
        rot.width = (int)((double)x * cosTheta - (double)y * sinTheta);
        rot.height = (int)((double)x * sinTheta + (double)y * cosTheta);
        return rot;
    }
}

