/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics;

import com.sas.graphics.ComponentData;
import com.sas.graphics.ElasticHandles;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;

public class ElasticComponentList {
    static Hashtable componentList = null;
    static Component dropSite = null;
    static boolean multiSelected = false;

    public static void addComponent(Component comp) {
        if (componentList == null) {
            componentList = new Hashtable();
        }
        componentList.put(comp, new ComponentData());
    }

    public static void removeComponent(Component comp) {
        if (componentList != null) {
            componentList.remove(comp);
        }
        if (multiSelected) {
            Enumeration e = componentList.keys();
            while (e.hasMoreElements()) {
                int style;
                Component key = (Component)e.nextElement();
                ComponentData data = (ComponentData)componentList.get(key);
                if (data == null || (style = data.selectionType) != 2) continue;
                data.selectionType = 0;
                if (key.getParent() == null) continue;
                Rectangle b = ElasticHandles.getStyleBounds(key);
                ElasticComponentList.paintBox(key.getParent(), b);
            }
        }
        multiSelected = false;
        if (dropSite != null && dropSite.equals(comp)) {
            dropSite = null;
        }
    }

    public static void setDropSite(Component comp) {
        Rectangle b;
        ComponentData data;
        if (componentList == null) {
            return;
        }
        if (multiSelected) {
            Enumeration e = componentList.keys();
            while (e.hasMoreElements()) {
                int style;
                Component key = (Component)e.nextElement();
                ComponentData data2 = (ComponentData)componentList.get(key);
                if (data2 == null || (style = data2.selectionType) != 2) continue;
                data2.selectionType = 0;
                if (key.getParent() == null) continue;
                Rectangle b2 = ElasticHandles.getStyleBounds(key);
                ElasticComponentList.paintBox(key.getParent(), b2);
            }
        }
        multiSelected = false;
        if (dropSite != null && !dropSite.equals(comp)) {
            data = (ComponentData)componentList.get(dropSite);
            if (data != null) {
                data.selectionType = 0;
            }
            if (dropSite.getParent() != null) {
                b = ElasticHandles.getStyleBounds(dropSite);
                ElasticComponentList.paintBox(dropSite.getParent(), b);
            }
        }
        if (comp != null && componentList.containsKey(comp)) {
            data = (ComponentData)componentList.get(comp);
            if (data != null) {
                data.selectionType = 1;
            }
            if (!comp.equals(dropSite) && comp.getParent() != null) {
                b = ElasticHandles.getStyleBounds(comp);
                ElasticComponentList.paintBox(comp.getParent(), b);
            }
        }
        dropSite = comp;
    }

    public static void resetDropSite(Component comp) {
        if (comp != null && componentList.containsKey(comp)) {
            ComponentData data = (ComponentData)componentList.get(comp);
            if (data != null) {
                data.selectionType = 0;
            }
            if (comp.getParent() != null) {
                Rectangle b = ElasticHandles.getStyleBounds(comp);
                ElasticComponentList.paintBox(comp.getParent(), b);
            }
            if (comp.equals(dropSite)) {
                dropSite = null;
                Enumeration e = componentList.keys();
                Object primary = null;
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    data = (ComponentData)componentList.get(key);
                    if (data == null) continue;
                    int style = data.selectionType;
                    if ((style == 1 || style == 2) && primary == null) {
                        primary = key;
                    }
                    if (style != 1) continue;
                    dropSite = (Component)key;
                }
                if (dropSite == null) {
                    dropSite = primary;
                }
                if (dropSite != null && dropSite.getParent() != null) {
                    data = (ComponentData)componentList.get(dropSite);
                    if (data != null) {
                        data.selectionType = 1;
                    }
                    Rectangle b = ElasticHandles.getStyleBounds(dropSite);
                    ElasticComponentList.paintBox(dropSite.getParent(), b);
                }
            }
        }
    }

    public static void setNextDropSite(Component comp) {
        Rectangle b;
        ComponentData data;
        if (componentList == null) {
            return;
        }
        multiSelected = true;
        if (dropSite != null && !dropSite.equals(comp)) {
            data = (ComponentData)componentList.get(dropSite);
            if (data != null) {
                data.selectionType = 2;
            }
            if (dropSite.getParent() != null) {
                b = ElasticHandles.getStyleBounds(dropSite);
                ElasticComponentList.paintBox(dropSite.getParent(), b);
            }
        }
        if (comp != null && componentList.containsKey(comp)) {
            data = (ComponentData)componentList.get(comp);
            if (data != null) {
                data.selectionType = 1;
            }
            if (!comp.equals(dropSite) && comp.getParent() != null) {
                b = ElasticHandles.getStyleBounds(comp);
                ElasticComponentList.paintBox(comp.getParent(), b);
            }
        }
        dropSite = comp;
    }

    public static Object[] getSelectedObjects(Container container) {
        int count = 0;
        Object[] obArray = ElasticComponentList.getSelectedObjects();
        if (obArray == null || container == null) {
            return null;
        }
        int length = obArray.length;
        Object[] newArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            if (!(obArray[i] instanceof Component) || !container.isAncestorOf((Component)obArray[i])) continue;
            newArray[count++] = obArray[i];
        }
        return newArray;
    }

    public static Object[] getSelectedObjects() {
        if (componentList == null) {
            return null;
        }
        Enumeration e = componentList.keys();
        int count = 0;
        Object primary = null;
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ComponentData data = (ComponentData)componentList.get(key);
            if (data == null) continue;
            int style = data.selectionType;
            if (style == 1 || style == 2) {
                ++count;
            }
            if (style != 1) continue;
            primary = key;
        }
        if (count == 0) {
            return null;
        }
        Object[] obArray = new Object[count];
        int start = 0;
        if (primary != null) {
            obArray[0] = primary;
            start = 1;
        }
        e = componentList.keys();
        while (e.hasMoreElements()) {
            int style;
            Object key = e.nextElement();
            ComponentData data = (ComponentData)componentList.get(key);
            if (data == null || (style = data.selectionType) != 2) continue;
            obArray[start++] = key;
        }
        return obArray;
    }

    public static boolean isSelected(Component comp) {
        if (componentList == null || !componentList.containsKey(comp)) {
            return false;
        }
        ComponentData data = (ComponentData)componentList.get(comp);
        if (data != null) {
            int style = data.selectionType;
            return style != 0;
        }
        return false;
    }

    public static void paint(Component comp, Graphics g) {
        ComponentData data;
        if (componentList == null || !componentList.containsKey(comp)) {
            return;
        }
        int style = 0;
        if (comp instanceof ResizeToFitInterface && ((ResizeToFitInterface)comp).isResizeToFit()) {
            style = 8;
        }
        if ((data = (ComponentData)componentList.get(comp)) != null) {
            ElasticHandles.setStyle(data.selectionType | style);
        } else {
            ElasticHandles.setStyle(style);
        }
        ElasticHandles.paint(comp, g);
    }

    public static int getSelectionType(Component comp) {
        ComponentData data;
        if (ElasticComponentList.isValidComponent(comp) && (data = (ComponentData)componentList.get(comp)) != null) {
            return data.selectionType;
        }
        return 0;
    }

    public static boolean isValidComponent(Component comp) {
        if (componentList == null || comp == null) {
            return false;
        }
        return componentList.containsKey(comp);
    }

    public static Point getOffsets(Object o) {
        ComponentData data = (ComponentData)componentList.get(o);
        if (data != null) {
            Point p = new Point(data.dX, data.dY);
            return p;
        }
        return null;
    }

    public static void setOffsets(Point p, int hitType) {
        if (componentList == null || p == null) {
            return;
        }
        Enumeration e = componentList.keys();
        block10: while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ComponentData data = (ComponentData)componentList.get(key);
            if (data == null || !(key instanceof Component)) continue;
            Rectangle r = ((Component)key).getBounds();
            switch (hitType) {
                case -1: 
                case 1: {
                    data.dX = p.x - r.x;
                    data.dY = p.y - r.y;
                    continue block10;
                }
                case 2: {
                    data.dX = p.x - r.x;
                    data.dY = 0;
                    continue block10;
                }
                case 3: {
                    data.dX = p.x - r.x;
                    data.dY = p.y - r.y - r.height;
                    continue block10;
                }
                case 4: {
                    data.dX = p.x - r.x - r.width;
                    data.dY = p.y - r.y;
                    continue block10;
                }
                case 5: {
                    data.dX = p.x - r.x - r.width;
                    data.dY = 0;
                    continue block10;
                }
                case 6: {
                    data.dX = p.x - r.x - r.width;
                    data.dY = p.y - r.y - r.height;
                    continue block10;
                }
                case 7: {
                    data.dX = 0;
                    data.dY = p.y - r.y;
                    continue block10;
                }
                case 8: {
                    data.dX = 0;
                    data.dY = p.y - r.y - r.height;
                    continue block10;
                }
            }
            data.dX = 0;
            data.dY = 0;
        }
    }

    static void paintBox(final Component c, final Rectangle b) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.repaint(0L, b.x, b.y, b.width, b.height);
            }
        });
    }
}

