/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.util;

import com.sas.ComponentException;
import com.sas.util.ApplyInterface;
import com.sas.util.Command;
import com.sas.util.CommandManager;
import com.sas.visuals.BaseBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.MouseEvent;

public abstract class Util {
    static Font dialogFont = null;

    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return (anEvent.getModifiers() & 0x10) != 0 || (anEvent.getModifiers() & 0xC) == 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent anEvent) {
        return (anEvent.getModifiers() & 8) == 8;
    }

    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return (anEvent.getModifiers() & 4) == 4;
    }

    public static void setEnabledOnContainer(Container container, boolean enabled) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            children[i].setEnabled(enabled);
            if (!(children[i] instanceof Container)) continue;
            Util.setEnabledOnContainer((Container)children[i], enabled);
        }
    }

    public static void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        float width = x2 - x1;
        float height = y2 - y1;
        int interval = 3;
        if (width > 0.0f) {
            float slope = height / width;
            int x = x1;
            while ((float)x < width) {
                if (x % interval == 0) {
                    int y = (int)(slope * (float)(x - x1) + (float)y1);
                    g.drawLine(x, y, x, y);
                }
                ++x;
            }
        } else {
            int x = x1;
            int y = y1;
            while ((float)y < height) {
                if (y % interval == 0) {
                    g.drawLine(x, y, x, y);
                }
                ++y;
            }
        }
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height) {
        Util.drawFocusRect(g, x, y, width, height, true);
    }

    public static final void drawFocusRect(Graphics g, int x, int y, int width, int height, boolean useXOR) {
        int i;
        g.setColor(Color.black);
        if (useXOR) {
            g.setXORMode(Color.white);
        }
        for (i = 0; i < width; i += 2) {
            g.drawLine(x + i, y, x + i, y);
            g.drawLine(x + i, y + height - 1, x + i, y + height - 1);
        }
        for (i = 0; i < height; i += 2) {
            g.drawLine(x, y + i, x, y + i);
            g.drawLine(x + width - 1, y + i, x + width - 1, y + i);
        }
        if (useXOR) {
            g.setPaintMode();
        }
    }

    public static void drawString(Graphics g, String string, int x, int y, boolean enabled) {
        if (enabled) {
            g.drawString(string, x, y);
        } else {
            Color c = g.getColor();
            g.setColor(SystemColor.controlLtHighlight);
            g.drawString(string, x + 1, y + 1);
            g.setColor(SystemColor.textInactiveText);
            g.drawString(string, x, y);
            g.setColor(c);
        }
    }

    public static Image getColorImage(Component viewer, Color color, int width, int height) {
        Image image = viewer.createImage(width, height);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        return image;
    }

    public static void invertRect(Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.white);
        g.setXORMode(Color.black);
        g.fillRect(x, y, width, height);
        g.setPaintMode();
    }

    public static void invertRect(Graphics g, Rectangle rect) {
        Util.invertRect(g, rect.x, rect.y, rect.width, rect.height);
    }

    public static void center(Window window) {
        Dimension size = window.getSize();
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation(screenSize.width / 2 - size.width / 2, screenSize.height / 2 - size.height / 2);
    }

    public static void centerOver(Window window, Component component) {
        int amountOver;
        if (!component.isShowing()) {
            Util.center(window);
            return;
        }
        Point location = component.getLocationOnScreen();
        Dimension componentSize = component.getSize();
        location.x += componentSize.width / 2;
        location.y += componentSize.height / 2;
        Dimension size = window.getSize();
        int x = location.x - size.width / 2;
        int y = location.y - size.height / 2;
        Dimension screenSize = window.getToolkit().getScreenSize();
        if (x + size.width > screenSize.width && (amountOver = x + size.width - screenSize.width) > 0 && x - amountOver > 0) {
            x -= amountOver;
        }
        if (y + size.height > screenSize.height && (amountOver = y + size.height - screenSize.height) > 0 && y - amountOver > 0) {
            y -= amountOver;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void centerOverWindow(Window window, Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component == null) {
            throw new ComponentException("Dialog::centerOverWindow: Specified component is not in a Window");
        }
        Util.centerOver(window, component);
    }

    public static Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    public static Container getParent(Component comp, Class containerClass) {
        Container parentContainer = null;
        Component parent = comp;
        while (parent != null) {
            if (containerClass.isAssignableFrom(parent.getClass())) {
                parentContainer = (Container)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentContainer;
    }

    public static Font getDialogFont() {
        if (dialogFont == null) {
            dialogFont = new Font("Dialog", 0, 12);
        }
        return dialogFont;
    }

    public static void configureGroupBoxBorder(BaseBorder border, String borderTitle) {
        if (border == null) {
            return;
        }
        border.setStyle(3);
        border.setLightSource(10);
        border.setBorderWidth(2);
        border.setTextMargin(5);
        if (borderTitle != null) {
            border.setText(borderTitle);
        }
    }

    public static void addCommand(Menu menu, Command command, Object object) {
        CommandManager.addCommand((Menu)menu, (Command)command, (Object)object);
    }

    public static void addCommand(Menu menu, Command command) {
        Util.addCommand(menu, command, null);
    }

    public static void addCommands(Menu menu, Command[] commands) {
        Util.addCommands(menu, commands, null);
    }

    public static void addCommands(Menu menu, Command[] commands, Object object) {
        CommandManager.addCommands((Menu)menu, (Command[])commands, (Object)object);
    }

    public static void apply(Component rootComponent, ApplyInterface operation) {
        Util.applyImpl(rootComponent, operation);
    }

    private static int applyImpl(Component rootComponent, ApplyInterface operation) {
        int rc = operation.apply((Object)rootComponent);
        if (rootComponent instanceof Container && rc == 0) {
            Container container = (Container)rootComponent;
            Component[] components = container.getComponents();
            int iCount = components.length;
            for (int i = 0; i < iCount && (rc = Util.applyImpl(components[i], operation)) == 0; ++i) {
            }
        }
        return rc;
    }
}

