/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.Dialog;
import com.sas.awt.print.PageFormat;
import com.sas.awt.print.PageSetupDialog;
import com.sas.awt.print.PageableInterface;
import com.sas.awt.print.PrintException;
import com.sas.awt.print.PrintGraphics;
import com.sas.awt.print.PrintJobImpl;
import com.sas.awt.print.PrintableInterface;
import com.sas.awt.util.ChangeCursorCommand;
import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.util.ApplyInterface;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Window;
import java.awt.print.Printable;

public abstract class PrintJob
implements Printable {
    public static PrintJob getPrintJob(PrintGraphics g) {
        return new PrintJobImpl(g);
    }

    public abstract void setPrintable(PrintableInterface var1);

    public abstract void setPrintable(PrintableInterface var1, PageFormat var2);

    public abstract void setPageable(PageableInterface var1) throws NullPointerException;

    public static PageFormat pageDialog(PageFormat page) {
        return PrintJob.pageDialog(page, null, null, null);
    }

    public abstract void print() throws PrintException;

    public static PageFormat pageDialog(PageFormat page, Frame parent) {
        return PrintJob.pageDialog(page, parent, null, null);
    }

    public static PageFormat pageDialog(PageFormat page, Frame parent, OrderedCollection annotations, OrderedCollection toolbarAnnotations) {
        return PrintJob.pageDialog(page, parent, null, annotations, toolbarAnnotations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PageFormat pageDialog(PageFormat page, Frame appFrame, Window parent, OrderedCollection annotations, OrderedCollection toolbarAnnotations) {
        if (appFrame == null) {
            appFrame = new Frame();
        }
        ChangeCursorCommand changeCursorCommand = new ChangeCursorCommand(Cursor.getPredefinedCursor(3));
        Dialog d = null;
        try {
            if (parent == null) {
                Util.apply(appFrame, (ApplyInterface)changeCursorCommand);
            } else {
                Util.apply(parent, (ApplyInterface)changeCursorCommand);
            }
            d = new PageSetupDialog(appFrame);
            d.pack();
            ((PageSetupDialog)d).setPageFormat(page);
            try {
                if (parent == null) {
                    Util.centerOver(d, appFrame);
                } else {
                    Util.centerOver(d, parent);
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
            if (annotations != null) {
                ((PageSetupDialog)d).addCustomAnnotations(annotations);
            }
            if (toolbarAnnotations != null) {
                ((PageSetupDialog)d).addCustomToolbarAnnotationElements(toolbarAnnotations);
            }
            changeCursorCommand.undoAll();
            changeCursorCommand = null;
            d.setVisible(true);
            d.dispose();
        }
        finally {
            if (d != null) {
                d.dispose();
            }
            if (changeCursorCommand != null) {
                changeCursorCommand.undoAll();
            }
        }
        ((PageSetupDialog)d).removeCustomAnnotations();
        ((PageSetupDialog)d).removeCustomToolbarAnnotationElements();
        return ((PageSetupDialog)d).getSelectedButton() == 1 ? ((PageSetupDialog)d).getPageFormat() : page;
    }

    public abstract PageFormat defaultPage(PageFormat var1);

    public PageFormat defaultPage() {
        return this.defaultPage(new PageFormat());
    }
}

