/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.ModelInterface;
import com.sas.awt.Button;
import com.sas.awt.Choice;
import com.sas.awt.Container;
import com.sas.awt.Dialog;
import com.sas.awt.Label;
import com.sas.awt.Panel;
import com.sas.awt.TextField;
import com.sas.awt.print.Annotation;
import com.sas.awt.print.AnnotationView;
import com.sas.awt.print.CustomAnnotationDialog;
import com.sas.awt.print.PageFormat;
import com.sas.awt.print.Paper;
import com.sas.awt.print.RB;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.OrderedCollection;
import com.sas.measures.Length;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.MessageBoxErrorHandler;
import com.sas.util.validators.ValidationInterface;
import com.sas.util.validators.Validator;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.BaseBorder;
import com.sas.visuals.BorderedContainer;
import com.sas.visuals.ImageView;
import com.sas.visuals.RadioBox;
import com.sas.visuals.SpinBox;
import com.sas.visuals.SpinButton;
import com.sas.visuals.TabFolder;
import com.sas.visuals.TabbedView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Enumeration;

class PageSetupDialog
extends Dialog
implements FocusListener,
MouseListener,
ActionListener,
ItemListener,
AdjustmentListener {
    public static final String RB_KEY = "PageSetupDialog.";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 64;
    public static final int BUTTONS_OK_CANCEL = 65;
    protected int selectedButton = 0;
    protected Panel mainPanel;
    protected Button buttonOK;
    protected Button buttonCancel;
    protected Frame parent;
    protected TabbedView tabber;
    protected TabFolder page;
    protected TabFolder margins;
    protected TabFolder headerFooter;
    protected RadioBox orientationRB;
    protected RadioBox paperSizeRB;
    protected Label topLabel;
    protected Label bottomLabel;
    protected Label leftLabel;
    protected Label rightLabel;
    protected Label headerLabel;
    protected Label footerLabel;
    protected Label hLabel;
    protected Label fLabel;
    protected Label topUnitLabel;
    protected SpinBox topSpinBox;
    protected SpinBox bottomSpinBox;
    protected SpinBox leftSpinBox;
    protected SpinBox rightSpinBox;
    protected SpinBox headerSpinBox;
    protected SpinBox footerSpinBox;
    protected ImageView marginImage;
    protected TextField topField;
    protected TextField bottomField;
    protected TextField leftField;
    protected TextField rightField;
    protected TextField headerField;
    protected TextField footerField;
    protected SpinButton topSpin;
    protected SpinButton bottomSpin;
    protected SpinButton leftSpin;
    protected SpinButton rightSpin;
    protected SpinButton headerSpin;
    protected SpinButton footerSpin;
    protected Choice headerCombo;
    protected Choice footerCombo;
    protected Button customHeader;
    protected Button customFooter;
    protected Panel topPanel;
    protected Panel centerPanel;
    protected Panel bottomPanel;
    protected AnnotationView header;
    protected AnnotationView footer;
    protected OrderedCollection headerCollection;
    protected OrderedCollection footerCollection;
    protected OrderedCollection defaultHeaderCollection;
    protected OrderedCollection defaultFooterCollection;
    protected OrderedCollection customAnnotations;
    protected OrderedCollection customTools;
    protected OrderedCollection previousHeaderCollection;
    protected OrderedCollection previousFooterCollection;
    protected BorderedContainer headerContainer;
    protected BorderedContainer footerContainer;
    protected CustomAnnotationDialog customDialog;
    protected boolean customHeaderExists = false;
    protected boolean customFooterExists = false;

    public PageSetupDialog(Frame frame) {
        super(frame, RB.getStringResource(RB_KEY, "pageSetup.txt"), true);
        this.parent = frame;
        this.commonInit();
    }

    protected void commonInit() {
        this.setLayout(new BorderLayout());
        this.setInsets(6, 6, 6, 6);
        this.tabber = new TabbedView();
        this.tabber.initialize();
        this.add((Component)this.tabber, "Center");
        this.tabber.addActionListener(this);
        this.margins = new TabFolder(RB.getStringResource(RB_KEY, "margins.txt"));
        this.tabber.add(this.margins);
        java.awt.Container marginsContainer = this.tabber.getView(RB.getStringResource(RB_KEY, "margins.txt"));
        marginsContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 8, 0, true, false, false));
        Container mContainer = new Container();
        mContainer.setInsets(10, 10, 10, 10);
        mContainer.setLayout((LayoutManager)new AutoSizingGridLayout(6, 2, 8, 8, true, false, false));
        Container iContainer = new Container();
        iContainer.setInsets(10, 10, 10, 10);
        iContainer.setLayout(new BorderLayout());
        marginsContainer.add(mContainer);
        marginsContainer.add(iContainer);
        this.topLabel = new Label(RB.getStringResource(RB_KEY, "topLabel.txt"), 0);
        this.topLabel.initialize();
        this.bottomLabel = new Label(RB.getStringResource(RB_KEY, "bottomLabel.txt"), 0);
        this.bottomLabel.initialize();
        this.leftLabel = new Label(RB.getStringResource(RB_KEY, "leftLabel.txt"), 0);
        this.leftLabel.initialize();
        this.rightLabel = new Label(RB.getStringResource(RB_KEY, "rightLabel.txt"), 0);
        this.rightLabel.initialize();
        this.headerLabel = new Label(RB.getStringResource(RB_KEY, "headerLabel.txt"), 0);
        this.headerLabel.initialize();
        this.footerLabel = new Label(RB.getStringResource(RB_KEY, "footerLabel.txt"), 0);
        this.footerLabel.initialize();
        DoubleStringValidator dsv = new DoubleStringValidator();
        MessageBoxErrorHandler eh = new MessageBoxErrorHandler(this);
        DecimalFormat df = new DecimalFormat("0.0#" + RB.getStringResource(RB_KEY, "unitsAbbreviation.txt"));
        this.topSpinBox = new SpinBox();
        this.topSpinBox.initialize();
        this.topSpinBox.setNumberFormat(df);
        this.topSpinBox.setValidator((ValidationInterface)dsv);
        this.topSpinBox.setErrorHandler(eh);
        this.topSpinBox.setUnitIncrementNumber(new Double(0.25));
        this.topSpinBox.setMinimum(0);
        this.topSpinBox.setDoubleData(1.0);
        this.bottomSpinBox = new SpinBox();
        this.bottomSpinBox.initialize();
        this.bottomSpinBox.setNumberFormat(df);
        this.bottomSpinBox.setValidator((ValidationInterface)dsv);
        this.bottomSpinBox.setErrorHandler(eh);
        this.bottomSpinBox.setUnitIncrementNumber(new Double(0.25));
        this.bottomSpinBox.setMinimum(0);
        this.bottomSpinBox.setDoubleData(1.0);
        this.leftSpinBox = new SpinBox();
        this.leftSpinBox.initialize();
        this.leftSpinBox.setNumberFormat(df);
        this.leftSpinBox.setValidator((ValidationInterface)dsv);
        this.leftSpinBox.setErrorHandler(eh);
        this.leftSpinBox.setUnitIncrementNumber(new Double(0.25));
        this.leftSpinBox.setMinimum(0);
        this.leftSpinBox.setDoubleData(1.0);
        this.rightSpinBox = new SpinBox();
        this.rightSpinBox.initialize();
        this.rightSpinBox.setNumberFormat(df);
        this.rightSpinBox.setValidator((ValidationInterface)dsv);
        this.rightSpinBox.setErrorHandler(eh);
        this.rightSpinBox.setUnitIncrementNumber(new Double(0.25));
        this.rightSpinBox.setMinimum(0);
        this.rightSpinBox.setDoubleData(1.0);
        this.headerSpinBox = new SpinBox();
        this.headerSpinBox.initialize();
        this.headerSpinBox.setNumberFormat(df);
        this.headerSpinBox.setValidator((ValidationInterface)dsv);
        this.headerSpinBox.setErrorHandler(eh);
        this.headerSpinBox.setUnitIncrementNumber(new Double(0.25));
        this.headerSpinBox.setMinimum(0);
        this.headerSpinBox.setDoubleData(1.0);
        this.footerSpinBox = new SpinBox();
        this.footerSpinBox.initialize();
        this.footerSpinBox.setNumberFormat(df);
        this.footerSpinBox.setValidator((ValidationInterface)dsv);
        this.footerSpinBox.setErrorHandler(eh);
        this.footerSpinBox.setUnitIncrementNumber(new Double(0.25));
        this.footerSpinBox.setMinimum(0);
        this.footerSpinBox.setDoubleData(1.0);
        this.topField = (TextField)this.topSpinBox.getComponent(0);
        this.topField.addFocusListener(this);
        this.topSpin = (SpinButton)this.topSpinBox.getComponent(1);
        this.topSpin.addMouseListener(this);
        this.bottomField = (TextField)this.bottomSpinBox.getComponent(0);
        this.bottomField.addFocusListener(this);
        this.bottomSpin = (SpinButton)this.bottomSpinBox.getComponent(1);
        this.bottomSpin.addMouseListener(this);
        this.leftField = (TextField)this.leftSpinBox.getComponent(0);
        this.leftField.addFocusListener(this);
        this.leftSpin = (SpinButton)this.leftSpinBox.getComponent(1);
        this.leftSpin.addMouseListener(this);
        this.rightField = (TextField)this.rightSpinBox.getComponent(0);
        this.rightField.addFocusListener(this);
        this.rightSpin = (SpinButton)this.rightSpinBox.getComponent(1);
        this.rightSpin.addMouseListener(this);
        this.headerSpinBox.addAdjustmentListener(this);
        this.headerField = (TextField)this.headerSpinBox.getComponent(0);
        this.headerField.addFocusListener(this);
        this.headerSpin = (SpinButton)this.headerSpinBox.getComponent(1);
        this.headerSpin.addMouseListener(this);
        this.footerSpinBox.addAdjustmentListener(this);
        this.footerField = (TextField)this.footerSpinBox.getComponent(0);
        this.footerField.addFocusListener(this);
        this.footerSpin = (SpinButton)this.footerSpinBox.getComponent(1);
        this.footerSpin.addMouseListener(this);
        mContainer.add(this.topLabel);
        mContainer.add(this.topSpinBox);
        mContainer.add(this.bottomLabel);
        mContainer.add(this.bottomSpinBox);
        mContainer.add(this.leftLabel);
        mContainer.add(this.leftSpinBox);
        mContainer.add(this.rightLabel);
        mContainer.add(this.rightSpinBox);
        mContainer.add(this.headerLabel);
        mContainer.add(this.headerSpinBox);
        mContainer.add(this.footerLabel);
        mContainer.add(this.footerSpinBox);
        this.marginImage = new ImageView(PageSetupDialog.class, "res/margin_unselected.gif");
        this.marginImage.initialize();
        this.marginImage.setDisplayMode(0);
        iContainer.add(this.marginImage);
        this.page = new TabFolder(RB.getStringResource(RB_KEY, "page.txt"));
        this.tabber.add(this.page);
        this.orientationRB = new RadioBox();
        this.orientationRB.addItem(RB.getStringResource(RB_KEY, "portrait.txt"));
        this.orientationRB.addItem(RB.getStringResource(RB_KEY, "landscape.txt"));
        Util.configureGroupBoxBorder((BaseBorder)this.orientationRB.getBorder(), RB.getStringResource(RB_KEY, "orientation.txt"));
        this.orientationRB.setVerticalPosition(15);
        this.orientationRB.setHorizontalPosition(15);
        Insets insets = this.orientationRB.getInsets();
        insets.top += 6;
        insets.bottom += 6;
        insets.left += 6;
        insets.right += 6;
        this.orientationRB.setInsets(insets);
        this.paperSizeRB = new RadioBox();
        this.paperSizeRB.addItem(RB.getStringResource("Letter.txt"));
        this.paperSizeRB.addItem(RB.getStringResource("Legal.txt"));
        this.paperSizeRB.addItem(RB.getStringResource("A4.txt"));
        this.paperSizeRB.addItem(RB.getStringResource("A5.txt"));
        Util.configureGroupBoxBorder((BaseBorder)this.paperSizeRB.getBorder(), RB.getStringResource(RB_KEY, "paperSize.txt"));
        this.paperSizeRB.setVerticalPosition(15);
        this.paperSizeRB.setHorizontalPosition(125);
        insets = this.paperSizeRB.getInsets();
        insets.top += 6;
        insets.bottom += 6;
        insets.left += 6;
        insets.right += 6;
        this.paperSizeRB.setInsets(insets);
        java.awt.Container pageContainer = this.tabber.getView(RB.getStringResource(RB_KEY, "page.txt"));
        insets = this.page.getInsets();
        insets.top += 6;
        insets.bottom += 6;
        insets.left += 6;
        insets.right += 6;
        this.page.setInsets(insets);
        pageContainer.setLayout((LayoutManager)new AutoSizingGridLayout(1, 2, 8, 0, true, false, false));
        pageContainer.add(this.orientationRB);
        pageContainer.add(this.paperSizeRB);
        this.headerFooter = new TabFolder(RB.getStringResource(RB_KEY, "headerFooter.txt"));
        this.tabber.add(this.headerFooter);
        java.awt.Container headerFooterContainer = this.tabber.getView(RB.getStringResource(RB_KEY, "headerFooter.txt"));
        GridBagLayout headFootLayout = new GridBagLayout();
        GridBagConstraints headFootConstraints = new GridBagConstraints();
        headerFooterContainer.setLayout(headFootLayout);
        Panel topPanel = new Panel();
        topPanel.initialize();
        topPanel.setLayout(new BorderLayout());
        this.hLabel = new Label(RB.getStringResource(RB_KEY, "headerLabel.txt"), 0);
        this.hLabel.initialize();
        topPanel.add("North", this.hLabel);
        this.headerContainer = new BorderedContainer();
        this.headerContainer.initialize();
        BaseBorder headerBorder = new BaseBorder(4, 10);
        this.headerContainer.setBorder(headerBorder);
        this.headerContainer.setLayout(new BorderLayout());
        this.header = new AnnotationView();
        this.header.initialize();
        Annotation a = new Annotation(null, null, null);
        this.header.attachModel((ModelInterface)a);
        this.headerContainer.add("Center", this.header);
        topPanel.add("Center", this.headerContainer);
        this.defaultHeaderCollection = new OrderedCollection();
        this.defaultHeaderCollection.add((Object)new Annotation(null, null, null));
        this.defaultHeaderCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.page.txt"), null));
        this.defaultHeaderCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.date.txt"), null));
        this.defaultHeaderCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.dateTime.txt"), null));
        this.defaultHeaderCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.time.txt"), null));
        this.defaultFooterCollection = new OrderedCollection();
        this.defaultFooterCollection.add((Object)new Annotation(null, null, null));
        this.defaultFooterCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.page.txt"), null));
        this.defaultFooterCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.date.txt"), null));
        this.defaultFooterCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.dateTime.txt"), null));
        this.defaultFooterCollection.add((Object)new Annotation(null, RB.getStringResource(RB_KEY, "annotation.time.txt"), null));
        this.headerCombo = new Choice();
        this.headerCombo.initialize();
        this.headerCombo.addItemListener(this);
        try {
            this.headerCollection = (OrderedCollection)this.defaultHeaderCollection.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.headerCombo.setModelInterface((ModelInterface)this.headerCollection);
        topPanel.add("South", this.headerCombo);
        headFootConstraints.fill = 1;
        headFootConstraints.insets = new Insets(5, 10, 5, 10);
        headFootConstraints.weighty = 1.0;
        headFootConstraints.weightx = 1.0;
        headFootConstraints.gridheight = 4;
        headFootConstraints.gridwidth = 0;
        headFootLayout.setConstraints(topPanel, headFootConstraints);
        headerFooterContainer.add(topPanel);
        Panel centerPanel = new Panel();
        centerPanel.initialize();
        GridBagLayout centerGridBag = new GridBagLayout();
        GridBagConstraints centerGridConstraints = new GridBagConstraints();
        centerPanel.setLayout(centerGridBag);
        this.customHeader = new Button(Message.format((String)RB.getStringResource(RB_KEY, "customHeader.txt"), (Object)"       ", (Object)"       "));
        this.customHeader.addActionListener(this);
        centerGridConstraints.fill = 0;
        centerGridConstraints.weightx = 1.0;
        centerGridConstraints.insets = new Insets(0, 5, 0, 5);
        centerGridBag.setConstraints(this.customHeader, centerGridConstraints);
        centerPanel.add(this.customHeader);
        centerGridConstraints.gridwidth = 0;
        this.customFooter = new Button(Message.format((String)RB.getStringResource(RB_KEY, "customFooter.txt"), (Object)"       ", (Object)"       "));
        this.customFooter.addActionListener(this);
        centerGridBag.setConstraints(this.customFooter, centerGridConstraints);
        centerPanel.add(this.customFooter);
        headFootConstraints.weighty = 0.0;
        headFootConstraints.gridheight = 1;
        headFootLayout.setConstraints(centerPanel, headFootConstraints);
        headerFooterContainer.add(centerPanel);
        Panel bottomPanel = new Panel();
        bottomPanel.initialize();
        bottomPanel.setLayout(new BorderLayout());
        this.fLabel = new Label(RB.getStringResource(RB_KEY, "footerLabel.txt"), 0);
        this.fLabel.initialize();
        bottomPanel.add("North", this.fLabel);
        this.footerContainer = new BorderedContainer();
        this.footerContainer.initialize();
        BaseBorder footerBorder = new BaseBorder(4, 10);
        this.footerContainer.setBorder(headerBorder);
        this.footerContainer.setLayout(new BorderLayout());
        this.footer = new AnnotationView();
        this.footer.initialize();
        this.footer.attachModel((ModelInterface)a);
        this.footerContainer.add("Center", this.footer);
        bottomPanel.add("Center", this.footerContainer);
        this.footerCombo = new Choice();
        this.footerCombo.initialize();
        this.footerCombo.addItemListener(this);
        try {
            this.footerCollection = (OrderedCollection)this.defaultFooterCollection.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        Enumeration enumer = this.footerCollection.getItems();
        while (enumer.hasMoreElements()) {
            Object o = enumer.nextElement();
            if (o instanceof Annotation) {
                Annotation newAnno = (Annotation)o;
                newAnno.setVerticalJustification(1);
                continue;
            }
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "annotation.error.txt"));
        }
        this.footerCombo.setModelInterface((ModelInterface)this.footerCollection);
        bottomPanel.add("South", this.footerCombo);
        headFootConstraints.weighty = 1.0;
        headFootConstraints.gridheight = 4;
        headFootLayout.setConstraints(bottomPanel, headFootConstraints);
        headerFooterContainer.add(bottomPanel);
        headFootLayout.layoutContainer(headerFooterContainer);
        this.setResizable(false);
        Panel panel1 = new Panel();
        this.add((Component)panel1, "South");
        panel1.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.initialize();
        p.setLayout(new FlowLayout());
        panel1.add("East", p);
        this.buttonOK = new Button(Message.format((String)RB.getStringResource("okButton.txt"), (Object)"       ", (Object)"       "));
        this.buttonOK.initialize();
        this.buttonOK.addActionListener(this);
        p.add(this.buttonOK);
        this.buttonCancel = new Button(Message.format((String)RB.getStringResource("cancelButton.txt"), (Object)"   ", (Object)"   "));
        this.buttonCancel.initialize();
        this.buttonCancel.addActionListener(this);
        p.add(this.buttonCancel);
        this.addWindowListener(this);
        this.setPreferredSize(new Dimension(400, 350));
        this.validate();
        this.pack();
        Util.center(this);
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "selectedButton"}, {"Default value", "0"}, {"Description", RB.getStringResource(RB_KEY, "selectedButton.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "";
        ebi.defaultOutputPropertyName = "selectedButton";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public void setPageFormat(PageFormat pf) {
        if (pf.getOrientation() == 1) {
            this.orientationRB.setSelectedIndex(0);
        } else {
            this.orientationRB.setSelectedIndex(1);
        }
        Paper paper = pf.getPaper();
        double pWidth = paper.getWidth();
        double pHeight = paper.getHeight();
        int paperSize = 0;
        for (int i = 0; i < Paper.sizes.length; ++i) {
            if (Paper.sizes[i][0].getMagnitude((Object)"pt") != pWidth || Paper.sizes[i][1].getMagnitude((Object)"pt") != pHeight) continue;
            paperSize = i;
            break;
        }
        this.paperSizeRB.setSelectedIndex(paperSize);
        this.topSpinBox.setDoubleData(pf.getTopMargin().getMagnitude((Object)RB.getStringResource(RB_KEY, "units.txt")));
        this.bottomSpinBox.setDoubleData(pf.getBottomMargin().getMagnitude((Object)RB.getStringResource(RB_KEY, "units.txt")));
        this.leftSpinBox.setDoubleData(pf.getLeftMargin().getMagnitude((Object)RB.getStringResource(RB_KEY, "units.txt")));
        this.rightSpinBox.setDoubleData(pf.getRightMargin().getMagnitude((Object)RB.getStringResource(RB_KEY, "units.txt")));
        AnnotationView hdr = (AnnotationView)pf.getHeader();
        if (hdr != null) {
            Annotation hModel = (Annotation)hdr.getModelInterface();
            if (hModel != null) {
                Annotation hdrModel = (Annotation)hModel.clone();
                this.headerSpinBox.setDoubleData(hdrModel.getTopMargin().getMagnitude((Object)RB.getStringResource(RB_KEY, "units.txt")));
                this.header.setModelInterface((ModelInterface)hdrModel);
                this.header.repaint();
                boolean foundit = false;
                for (int i = 0; i < this.headerCollection.count(); ++i) {
                    Annotation a = (Annotation)this.headerCollection.get(i);
                    if (!hdrModel.equals(a)) continue;
                    this.headerCollection.set(i, (Object)hdrModel);
                    foundit = true;
                    this.headerCombo.setText(hdrModel.toString());
                    break;
                }
                if (!foundit) {
                    this.headerCollection.add((Object)hdrModel);
                    this.headerCombo.setText(hdrModel.toString());
                    this.customHeaderExists = true;
                }
            } else {
                this.header.setModelInterface((ModelInterface)((Annotation)this.headerCollection.get(0)));
                this.headerCombo.setSelectedIndex(0);
                this.headerSpinBox.setDoubleData(0.0);
            }
        } else {
            this.header.setModelInterface((ModelInterface)((Annotation)this.headerCollection.get(0)));
            this.headerCombo.setSelectedIndex(0);
            this.headerSpinBox.setDoubleData(0.0);
        }
        for (int i = 0; i < this.headerCollection.count(); ++i) {
            Length ln = new Length(this.headerSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt"));
            ((Annotation)this.headerCollection.get(i)).setTopMargin(ln);
        }
        AnnotationView ftr = (AnnotationView)pf.getFooter();
        if (ftr != null) {
            Annotation fModel = (Annotation)ftr.getModelInterface();
            if (fModel != null) {
                Annotation ftrModel = (Annotation)fModel.clone();
                this.footerSpinBox.setDoubleData(ftrModel.getBottomMargin().getMagnitude((Object)RB.getStringResource(RB_KEY, "units.txt")));
                this.footer.setModelInterface((ModelInterface)ftrModel);
                this.footer.repaint();
                boolean foundit = false;
                for (int i = 0; i < this.footerCollection.count(); ++i) {
                    Annotation a = (Annotation)this.footerCollection.get(i);
                    if (!ftrModel.equals(a)) continue;
                    this.footerCollection.set(i, (Object)ftrModel);
                    foundit = true;
                    this.footerCombo.setText(ftrModel.toString());
                    break;
                }
                if (!foundit) {
                    this.footerCollection.add((Object)ftrModel);
                    this.footerCombo.setText(ftrModel.toString());
                    this.customFooterExists = true;
                }
            } else {
                Annotation f = (Annotation)this.footerCollection.get(0);
                f.setVerticalJustification(1);
                this.footer.setModelInterface((ModelInterface)f);
                this.footerCombo.setSelectedIndex(0);
                this.footerSpinBox.setDoubleData(0.0);
            }
        } else {
            Annotation f = (Annotation)this.footerCollection.get(0);
            f.setVerticalJustification(1);
            this.footer.setModelInterface((ModelInterface)f);
            this.footerCombo.setSelectedIndex(0);
            this.footerSpinBox.setDoubleData(0.0);
        }
        for (int i = 0; i < this.footerCollection.count(); ++i) {
            Length ln = new Length(this.footerSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt"));
            ((Annotation)this.footerCollection.get(i)).setBottomMargin(ln);
        }
    }

    public PageFormat getPageFormat() {
        Annotation ftrAnnotation;
        Paper newPaper;
        PageFormat newpf = new PageFormat();
        int selectedOrientation = this.orientationRB.getSelectedIndex();
        if (selectedOrientation == 0) {
            newpf.setOrientation(1);
        } else {
            newpf.setOrientation(0);
        }
        int pSize = this.paperSizeRB.getSelectedIndex();
        switch (pSize) {
            case 0: {
                newPaper = new Paper(0);
                break;
            }
            case 1: {
                newPaper = new Paper(1);
                break;
            }
            case 2: {
                newPaper = new Paper(2);
                break;
            }
            case 3: {
                newPaper = new Paper(3);
                break;
            }
            default: {
                newPaper = new Paper();
            }
        }
        newpf.setPaper(newPaper);
        newpf.setTopMargin(new Length(this.topSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt")));
        newpf.setBottomMargin(new Length(this.bottomSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt")));
        newpf.setLeftMargin(new Length(this.leftSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt")));
        newpf.setRightMargin(new Length(this.rightSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt")));
        Annotation hdrAnnotation = (Annotation)this.header.getModelInterface();
        if (hdrAnnotation != null) {
            hdrAnnotation.setTopMargin(new Length(this.headerSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt")));
        }
        if ((ftrAnnotation = (Annotation)this.footer.getModelInterface()) != null) {
            ftrAnnotation.setBottomMargin(new Length(this.footerSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt")));
        }
        AnnotationView hav = new AnnotationView();
        hav.setModelInterface((ModelInterface)hdrAnnotation);
        newpf.setHeader(hav);
        AnnotationView fav = new AnnotationView();
        fav.setModelInterface((ModelInterface)ftrAnnotation);
        newpf.setFooter(fav);
        return newpf;
    }

    public int getSelectedButton() {
        return this.selectedButton;
    }

    public void addCustomAnnotations(OrderedCollection annotations) {
        String hs = this.headerCombo.getText();
        String fs = this.footerCombo.getText();
        this.customAnnotations = annotations;
        Enumeration enumer = this.customAnnotations.getItems();
        int aCount = this.defaultHeaderCollection.count();
        while (enumer.hasMoreElements()) {
            Object o = enumer.nextElement();
            if (o instanceof Annotation) {
                Annotation newAnno = (Annotation)o;
                this.headerCollection.add((Object)newAnno, aCount);
                Annotation footAnno = (Annotation)newAnno.clone();
                footAnno.setVerticalJustification(1);
                this.footerCollection.add((Object)footAnno, aCount);
                ++aCount;
                continue;
            }
            throw new IllegalArgumentException("The annotations ordered collection must contain only Annotation Objects.");
        }
        this.headerCombo.setText(hs);
        this.footerCombo.setText(fs);
    }

    public void removeCustomAnnotations() {
        if (this.customAnnotations != null) {
            int count = this.customAnnotations.count();
            for (int i = 0; i < count; ++i) {
                this.headerCollection.remove((Object)((Annotation)this.customAnnotations.get(i)));
            }
        }
    }

    public void addCustomToolbarAnnotationElements(OrderedCollection toolbarAnnotations) {
        this.customTools = toolbarAnnotations;
        if (this.customDialog != null) {
            this.customDialog.addCustomToolbarButtons(this.customTools);
        }
    }

    public void removeCustomToolbarAnnotationElements() {
        if (this.customDialog != null) {
            this.customDialog.removeCustomToolbarButtons();
        }
        this.customTools = null;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        block3: {
            Object o;
            block2: {
                o = event.getSource();
                if (o != this.headerSpinBox) break block2;
                for (int i = 0; i < this.headerCollection.count(); ++i) {
                    Length ln = new Length(this.headerSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt"));
                    ((Annotation)this.headerCollection.get(i)).setTopMargin(ln);
                }
                break block3;
            }
            if (o != this.footerSpinBox) break block3;
            for (int i = 0; i < this.footerCollection.count(); ++i) {
                Length ln = new Length(this.footerSpinBox.getNumberValue().doubleValue(), RB.getStringResource(RB_KEY, "units.txt"));
                ((Annotation)this.footerCollection.get(i)).setBottomMargin(ln);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals(RB.getStringResource(RB_KEY, "margins.txt"))) {
            this.marginImage.setSource("res/margin_unselected.gif");
            return;
        }
        Object source = event.getSource();
        if (source == this.customHeader) {
            Annotation ha = (Annotation)this.header.getModelInterface();
            boolean newFlag = false;
            if (ha.toString().equals(RB.getStringResource(RB_KEY, "annotation.none.txt"))) {
                newFlag = true;
            }
            Annotation newHeaderAnnotation = (Annotation)ha.clone();
            if (this.customDialog == null) {
                this.customDialog = new CustomAnnotationDialog(this.parent, (ModelInterface)newHeaderAnnotation);
                this.customDialog.pack();
                if (this.customTools != null) {
                    this.customDialog.addCustomToolbarButtons(this.customTools);
                }
                Util.centerOverWindow(this.customDialog, this);
            } else {
                this.customDialog.setModelInterface(null);
                this.customDialog.setModelInterface((ModelInterface)newHeaderAnnotation);
            }
            this.customDialog.setTitle(RB.getStringResource("CustomAnnotationDialog.", "Title.Header.txt"));
            this.customDialog.setVisible(true);
            int customButton = this.customDialog.getSelectedButton();
            switch (customButton) {
                case 1: {
                    Annotation okAnno = (Annotation)this.customDialog.getAnnotationInterface();
                    this.header.setModelInterface((ModelInterface)okAnno);
                    int position = this.headerCollection.getIndex((Object)ha, 0);
                    if (!newFlag) {
                        this.headerCollection.set(position, (Object)okAnno);
                        this.headerCombo.setSelectedIndex(position);
                        break;
                    }
                    if (this.customHeaderExists) {
                        position = this.headerCollection.count() - 1;
                        ha = (Annotation)this.headerCollection.get(position);
                        this.headerCollection.set(position, (Object)okAnno);
                        this.headerCombo.setSelectedIndex(position);
                        break;
                    }
                    this.headerCollection.add((Object)okAnno);
                    this.headerCombo.setSelectedIndex(this.headerCollection.count() - 1);
                    this.customHeaderExists = true;
                    break;
                }
                case 64: {
                    break;
                }
            }
            this.header.repaint();
            this.customDialog.dispose();
        } else if (source == this.customFooter) {
            Annotation fa = (Annotation)this.footer.getModelInterface();
            boolean newFlag = false;
            if (fa.toString().equals(RB.getStringResource(RB_KEY, "annotation.none.txt"))) {
                newFlag = true;
            }
            Annotation newFooterAnnotation = (Annotation)fa.clone();
            if (this.customDialog == null) {
                this.customDialog = new CustomAnnotationDialog(this.parent, (ModelInterface)newFooterAnnotation);
                this.customDialog.pack();
                if (this.customTools != null) {
                    this.customDialog.addCustomToolbarButtons(this.customTools);
                }
                Util.centerOverWindow(this.customDialog, this);
            } else {
                this.customDialog.setModelInterface((ModelInterface)newFooterAnnotation);
            }
            this.customDialog.setTitle(RB.getStringResource("CustomAnnotationDialog.", "Title.Footer.txt"));
            this.customDialog.setVisible(true);
            int customButton = this.customDialog.getSelectedButton();
            switch (customButton) {
                case 1: {
                    Annotation okAnno = (Annotation)this.customDialog.getAnnotationInterface();
                    this.footer.setModelInterface((ModelInterface)okAnno);
                    int position = this.footerCollection.getIndex((Object)fa, 0);
                    if (!newFlag) {
                        this.footerCollection.set(position, (Object)okAnno);
                        this.footerCombo.setSelectedIndex(position);
                        break;
                    }
                    if (this.customFooterExists) {
                        position = this.footerCollection.count() - 1;
                        this.footerCollection.set(position, (Object)okAnno);
                        this.footerCombo.setSelectedIndex(position);
                        break;
                    }
                    this.footerCollection.add((Object)okAnno);
                    this.footerCombo.setSelectedIndex(this.footerCollection.count() - 1);
                    this.customFooterExists = true;
                    break;
                }
                case 64: {
                    break;
                }
            }
            this.footer.repaint();
            this.customDialog.dispose();
            this.customDialog = null;
        } else if (source == this.buttonOK) {
            this.selectedButton = 1;
        } else if (source == this.buttonCancel) {
            this.selectedButton = 64;
        }
        if (source == this.buttonOK || source == this.buttonCancel) {
            this.dispose();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        Object o = event.getSource();
        if (o == this.topField) {
            this.marginImage.setSource("res/margin_top.gif");
        } else if (o == this.bottomField) {
            this.marginImage.setSource("res/margin_bottom.gif");
        } else if (o == this.leftField) {
            this.marginImage.setSource("res/margin_left.gif");
        } else if (o == this.rightField) {
            this.marginImage.setSource("res/margin_right.gif");
        } else if (o == this.headerField) {
            this.marginImage.setSource("res/margin_head.gif");
        } else if (o == this.footerField) {
            this.marginImage.setSource("res/margin_foot.gif");
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Object o = event.getSource();
        if (o == this.topSpin) {
            this.marginImage.setSource("res/margin_top.gif");
        } else if (o == this.bottomSpin) {
            this.marginImage.setSource("res/margin_bottom.gif");
        } else if (o == this.leftSpin) {
            this.marginImage.setSource("res/margin_left.gif");
        } else if (o == this.rightSpin) {
            this.marginImage.setSource("res/margin_right.gif");
        } else if (o == this.headerSpin) {
            this.marginImage.setSource("res/margin_head.gif");
        } else if (o == this.footerSpin) {
            this.marginImage.setSource("res/margin_foot.gif");
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.selectedButton = 64;
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object o = event.getSource();
        if (o == this.headerCombo) {
            Object item;
            Object[] items = this.headerCombo.getSelectedObjects();
            if (items.length > 0 && (item = items[0]) instanceof Annotation) {
                Annotation a = (Annotation)item;
                this.header.setModelInterface((ModelInterface)a);
                this.header.repaint();
            }
        } else if (o == this.footerCombo) {
            Object item;
            String str = this.footerCombo.getText();
            Object[] items = this.footerCombo.getSelectedObjects();
            if (items.length > 0 && (item = items[0]) instanceof Annotation) {
                Annotation a = (Annotation)item;
                this.footer.setModelInterface((ModelInterface)a);
                this.footer.repaint();
            }
        }
    }

    class DoubleStringValidator
    extends Validator {
        public static final String RB_KEY = "PageSetupDialog.";
        String invalidFormat = "DoubleStringValidator.InvalidFormat";
        String notString = "DoubleStringValidator.NotString";
        String invalidMinimum = "DoubleStringValidator.InvalidMinimum";
        int INVALID_FORMAT = 0;
        int NOT_STRING = 1;
        int INVALID_MINIMUM = 2;

        DoubleStringValidator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean validateValue(Object component, Object value) {
            boolean checkit = false;
            if (value instanceof String) {
                String test = Strings.replace((String)((String)value), (int)0, (int)-1, (String)RB.getStringResource("PageSetupDialog.", "unitsAbbreviation.txt"), (String)"");
                DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
                Double d = new Double("0.0");
                ParsePosition p = new ParsePosition(0);
                try {
                    Number n = df.parse(test, p);
                    if (p.getIndex() != test.length()) {
                        throw new ParseException("ParseException " + test, p.getIndex());
                    }
                    if (n instanceof Long) {
                        d = new Double(((Long)n).toString());
                    } else if (n instanceof Double) {
                        d = (Double)n;
                    }
                    if (checkit || !(d < 0.0)) return true;
                    checkit = true;
                    throw new ParseException("Invalid Minimum", 0);
                }
                catch (ParseException e) {
                    if (!checkit) {
                        this.setValidationMessage((Message)this.messages.get(this.INVALID_FORMAT));
                        this.setValidationMessageCode(this.invalidFormat);
                        return false;
                    }
                    if (!checkit) return false;
                    this.setValidationMessage((Message)this.messages.get(this.INVALID_MINIMUM));
                    this.setValidationMessageCode(this.invalidMinimum);
                    return false;
                }
            } else {
                this.setValidationMessage((Message)this.messages.get(this.NOT_STRING));
                this.setValidationMessageCode(this.notString);
            }
            return false;
        }

        public Object normalizeValue(Object component, Object value) {
            String string = (String)value;
            string.trim();
            return string;
        }

        public void createValidationMessages() {
            super.createValidationMessages();
            this.messages.add(this.newValidationMessage(RB.getStringResource("PageSetupDialog.", "marginValueError.txt")));
            this.messages.add(this.newValidationMessage("DoubleStringValidator can only validate Strings"));
            this.messages.add(this.newValidationMessage(RB.getStringResource("PageSetupDialog.", "minimumValueError.txt")));
        }
    }
}

