/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.PDFGen;
import com.sas.awt.print.PrintGraphics;
import com.sas.collection.OrderedCollectionInterface;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class PDFGraphics
extends PrintGraphics
implements Cloneable {
    Color m_color = Color.black;
    Color m_pageXOR;
    Font m_font = new Font("serif", 0, 12);
    Image m_osImage;
    static Toolkit m_toolkit = Toolkit.getDefaultToolkit();
    boolean m_trace = false;
    boolean m_internal;
    boolean m_original = true;
    boolean m_disposed;
    PDFGen m_gen;
    String m_pdfReaderPath;
    OutputStream m_os;
    AffineTransform m_transform = new AffineTransform();
    Shape usrClip;
    double m_constrainX;
    double m_constrainY;
    static final int NON_RECTILINEAR_TRANSFORM_MASK = 48;
    double[] matrix = new double[6];

    public PDFGraphics() {
    }

    public PDFGraphics(String pdfReaderPath) {
        this.m_pdfReaderPath = pdfReaderPath;
    }

    public PDFGraphics(OutputStream outputStream) {
        this.m_os = outputStream;
    }

    @Override
    public void beginDocument() {
        this.m_gen = new PDFGen(this.m_trace, this.m_os);
        this.m_gen.beginDocument();
    }

    @Override
    public void beginDocument(boolean showOutline) {
        this.m_gen = new PDFGen(this.m_trace, this.m_os);
        this.m_gen.beginDocument(showOutline);
    }

    @Override
    public void endDocument() {
        if (!this.m_disposed) {
            if (this.m_pdfReaderPath != null) {
                this.m_gen.setAcrobatExe(this.m_pdfReaderPath);
            }
            this.m_gen.endDocument();
        }
        this.m_disposed = true;
    }

    @Override
    public void endDocument(OrderedCollectionInterface toc) {
        if (!this.m_disposed) {
            if (this.m_pdfReaderPath != null) {
                this.m_gen.setAcrobatExe(this.m_pdfReaderPath);
            }
            this.m_gen.endDocument(toc);
        }
        this.m_disposed = true;
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("clearRect( " + x + ", " + y + ", " + width + ", " + height + " ) ");
        }
        this.m_gen.drawRect(x, y, width, height, true);
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.clip(new Rectangle(x, y, w, h));
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("copyArea( " + x + ", " + y + ", " + width + ", " + height + ", " + dx + ", " + dy + " ) ");
        }
    }

    @Override
    public Graphics create() {
        if (this.m_trace && !this.m_internal) {
            System.out.println("create()");
        }
        PDFGraphics g = null;
        try {
            g = (PDFGraphics)this.clone();
        }
        catch (CloneNotSupportedException e) {
            Thread.dumpStack();
        }
        this.m_gen.saveState();
        g.m_constrainX = this.m_transform.getTranslateX();
        g.m_constrainY = this.m_transform.getTranslateY();
        return g;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("create( " + x + ", " + y + ", " + width + ", " + height + " ) ");
        }
        this.m_internal = true;
        PDFGraphics g = (PDFGraphics)this.create();
        this.m_internal = false;
        g.m_internal = true;
        g.translate(x, y);
        g.setClip(0, 0, width, height);
        g.m_internal = false;
        return g;
    }

    private Image cropImage(Image img, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        CropImageFilter cropfilter = new CropImageFilter(sx1, sy1, sx2 - sx1, sy2 - sy1);
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), cropfilter);
        Image croppedImg = m_toolkit.createImage(prod);
        return croppedImg;
    }

    @Override
    public void dispose() {
        if (this.m_trace && !this.m_internal) {
            System.out.println("dispose()");
        }
        if (!this.m_original) {
            this.m_gen.restoreState();
        } else if (!this.m_disposed) {
            this.endDocument();
        }
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("draw3DRect( " + x + ", " + y + ", " + width + ", " + height + ", " + raised + " ) ");
        }
        this.m_gen.draw3DRect(x, y, width, height, raised, false);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("drawArc( " + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle);
        }
        this.m_gen.drawArc(x, y, width, height, startAngle, arcAngle, false);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        String str = new String(data, offset, length);
        this.m_gen.drawString(str, x, y);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        String str = new String(data, offset, length);
        this.m_gen.drawString(str, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("drawImage( " + img + ", " + y + ", " + observer + " ) ");
        }
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        return this.m_gen.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgColor, ImageObserver observer) {
        int width = img.getWidth(observer);
        int height = img.getHeight(observer);
        return this.m_gen.drawImage(img, x, y, width, height, bgColor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        Image scaledImage = this.scaleImage(img, width, height, observer);
        if (scaledImage == null) {
            return false;
        }
        return this.m_gen.drawImage(scaledImage, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgColor, ImageObserver observer) {
        Image scaledImage = this.scaleImage(img, width, height, observer);
        if (scaledImage == null) {
            return false;
        }
        return this.m_gen.drawImage(scaledImage, x, y, width, height, bgColor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        Image croppedImage = this.cropImage(img, sx1, sy1, sx2, sy2, observer);
        if (croppedImage == null) {
            return false;
        }
        int width = dx2 - dx1;
        int height = dy2 - dy1;
        Image scaledImage = this.scaleImage(croppedImage, width, height, observer);
        if (scaledImage == null) {
            return false;
        }
        return this.m_gen.drawImage(scaledImage, dx1, dy1, width, height, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgColor, ImageObserver observer) {
        Image croppedImage = this.cropImage(img, sx1, sy1, sx2, sy2, observer);
        if (croppedImage == null) {
            return false;
        }
        int width = dx2 - dx1;
        int height = dy2 - dy1;
        Image scaledImage = this.scaleImage(img, width, height, observer);
        if (scaledImage == null) {
            return false;
        }
        return this.m_gen.drawImage(scaledImage, dx1, dy1, width, height, bgColor, observer);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("drawLine( " + x1 + ", " + y1 + ", " + x2 + ", " + y2 + " ) ");
        }
        this.m_gen.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("drawOval( " + x + ", " + y + ", " + width + ", " + height + " ) ");
        }
        this.m_gen.drawOval(x, y, width, height, false);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_gen.drawPolygon(xPoints, 0, yPoints, 0, nPoints, false);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.m_gen.drawPolygon(p.xpoints, 0, p.ypoints, 0, p.npoints, false);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_gen.drawPolyline(xPoints, 0, yPoints, 0, nPoints);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("drawRect( " + x + ", " + y + ", " + width + ", " + height + " ) ");
        }
        this.m_gen.drawRect(x, y, width, height, false);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.m_gen.drawRoundRect(x, y, width, height, arcWidth, arcHeight, false);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (iterator == null) {
            throw new NullPointerException("AttributedCharacterIterator is null");
        }
        char[] str = new char[iterator.getEndIndex()];
        char c = iterator.first();
        int i = 0;
        while (c != '\uffff') {
            str[i] = c;
            ++i;
            c = iterator.next();
        }
        if (str.length > 0) {
            this.drawString(new String(str), x, y);
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("drawString( " + str + ", " + x + ", " + y + " ) ");
        }
        this.m_gen.drawString(str, x, y);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("fill3DRect( " + x + ", " + y + ", " + width + ", " + height + ", " + raised + " ) ");
        }
        this.m_gen.draw3DRect(x, y, width, height, raised, true);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("fillArc( " + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + " ) ");
        }
        this.m_gen.drawArc(x, y, width, height, startAngle, arcAngle, true);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.m_gen.drawOval(x, y, width, height, true);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.m_gen.drawPolygon(xPoints, 0, yPoints, 0, nPoints, true);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.m_gen.drawPolygon(p.xpoints, 0, p.ypoints, 0, p.npoints, true);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("fillRect( " + x + ", " + y + ", " + width + ", " + height + " ) ");
        }
        this.m_gen.drawRect(x, y, width, height, true);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.m_gen.drawRoundRect(x, y, width, height, arcWidth, arcHeight, true);
    }

    @Override
    public void finalize() {
    }

    @Override
    public Shape getClip() {
        return this.untransformShape(this.usrClip);
    }

    @Override
    public Rectangle getClipBounds() {
        Shape s = this.getClip();
        if (s != null) {
            return s.getBounds();
        }
        return null;
    }

    protected Shape transformShape(Shape s) {
        if (s == null) {
            return null;
        }
        return PDFGraphics.transformShape(this.m_transform, s);
    }

    protected Shape untransformShape(Shape s) {
        if (s == null) {
            return null;
        }
        try {
            return PDFGraphics.transformShape(this.m_transform.createInverse(), s);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    protected static Shape transformShape(AffineTransform tx, Shape clip) {
        if (clip == null) {
            return null;
        }
        if (clip instanceof Rectangle2D && (tx.getType() & 0x30) == 0) {
            double[] matrix;
            Rectangle2D rect = (Rectangle2D)clip;
            matrix = new double[]{rect.getX(), rect.getY(), matrix[0] + rect.getWidth(), matrix[1] + rect.getHeight()};
            tx.transform(matrix, 0, matrix, 0, 2);
            rect = new Rectangle2D.Float();
            rect.setFrameFromDiagonal(matrix[0], matrix[1], matrix[2], matrix[3]);
            return rect.getBounds();
        }
        if (tx.isIdentity()) {
            return PDFGraphics.cloneShape(clip);
        }
        return tx.createTransformedShape(clip);
    }

    protected static Shape cloneShape(Shape s) {
        return new GeneralPath(s);
    }

    @Override
    public Color getColor() {
        Color c = new Color(this.m_color.getRGB());
        return c;
    }

    @Override
    public Font getFont() {
        Font f = new Font(this.m_font.getName(), this.m_font.getStyle(), this.m_font.getSize());
        return f;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return m_toolkit.getFontMetrics(this.m_font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return m_toolkit.getFontMetrics(f);
    }

    private Image scaleImage(Image img, int width, int height, ImageObserver observer) {
        AreaAveragingScaleFilter scalefilter = new AreaAveragingScaleFilter(width, height);
        Image scaleImg = m_toolkit.createImage(new FilteredImageSource(img.getSource(), scalefilter));
        return scaleImg;
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(Shape sh) {
        Rectangle m_clip = sh.getBounds();
        this.m_gen.setClip(m_clip.x, m_clip.y, m_clip.width, m_clip.height);
        this.usrClip = this.transformShape(sh);
    }

    @Override
    public void setColor(Color c) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("setColor( " + c + " ) ");
        }
        if (c != null) {
            this.m_color = c;
            this.m_gen.setColor(c);
        }
    }

    @Override
    public void setFont(Font f) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("setFont( " + f + " ) ");
        }
        if (f == null || f == this.m_font) {
            return;
        }
        this.m_font = new Font(f.getName(), f.getStyle(), f.getSize());
        this.m_gen.setFont(f);
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c) {
    }

    @Override
    public void translate(int x, int y) {
        if (this.m_trace && !this.m_internal) {
            System.out.println("translate( " + x + ", " + y + " ) ");
        }
        this.m_transform.translate(x, y);
        this.m_gen.translate(x, y);
    }

    @Override
    public void draw(Shape s) {
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    @Override
    public void drawString(String s, float x, float y) {
        if (s == null) {
            throw new NullPointerException("string is null");
        }
        this.drawString(s, (int)x, (int)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.drawString(iterator, (int)x, (int)y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    @Override
    public void fill(Shape s) {
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite comp) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setStroke(Stroke s) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void translate(double tx, double ty) {
        this.m_transform.translate(tx, ty);
        this.m_gen.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.m_transform.rotate(theta);
        this.m_gen.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.m_transform.rotate(theta, x, y);
        this.m_gen.translate(x, y);
        this.m_gen.rotate(theta);
        this.m_gen.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.m_transform.scale(sx, sy);
        this.m_gen.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.m_transform.concatenate(Tx);
        this.m_transform.getMatrix(this.matrix);
        this.m_gen.transform(this.matrix);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        try {
            AffineTransform inverse = this.m_transform.createInverse();
            inverse.getMatrix(this.matrix);
            this.m_gen.transform(this.matrix);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        if (this.m_constrainX == 0.0 && this.m_constrainY == 0.0) {
            this.m_transform.setTransform(Tx);
        } else {
            this.m_transform.setToTranslation(this.m_constrainX, this.m_constrainY);
            this.m_transform.concatenate(Tx);
        }
        this.m_transform.getMatrix(this.matrix);
        this.m_gen.transform(this.matrix);
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform xform;
        if (this.m_constrainX == 0.0 && this.m_constrainY == 0.0) {
            xform = new AffineTransform(this.m_transform);
        } else {
            xform = AffineTransform.getTranslateInstance(-this.m_constrainX, -this.m_constrainY);
            xform.concatenate(this.m_transform);
        }
        return xform;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public Color getBackground() {
        return Color.black;
    }

    @Override
    public Stroke getStroke() {
        return null;
    }

    @Override
    public void clip(Shape s) {
        Rectangle m_clip = s.getBounds();
        this.m_gen.clipRect(m_clip.x, m_clip.y, m_clip.width, m_clip.height);
        s = this.transformShape(s);
        if (this.usrClip != null) {
            s = this.intersectShapes(this.usrClip, s);
        }
        this.usrClip = s;
    }

    Shape intersectShapes(Shape s1, Shape s2) {
        if (s1 instanceof Rectangle && s2 instanceof Rectangle) {
            return ((Rectangle)s1).intersection((Rectangle)s2);
        }
        if (s1 instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)s1, s2);
        }
        if (s2 instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)s2, s1);
        }
        return this.intersectByArea(s1, s2);
    }

    Shape intersectRectShape(Rectangle2D r, Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s;
            Rectangle2D.Float outrect = new Rectangle2D.Float();
            double x1 = Math.max(r.getX(), r2.getX());
            double x2 = Math.min(r.getX() + r.getWidth(), r2.getX() + r2.getWidth());
            double y1 = Math.max(r.getY(), r2.getY());
            double y2 = Math.min(r.getY() + r.getHeight(), r2.getY() + r2.getHeight());
            if (x2 - x1 < 0.0 || y2 - y1 < 0.0) {
                outrect.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                outrect.setFrameFromDiagonal(x1, y1, x2, y2);
            }
            return outrect;
        }
        if (r.contains(s.getBounds2D())) {
            return PDFGraphics.cloneShape(s);
        }
        return this.intersectByArea(r, s);
    }

    Shape intersectByArea(Shape s1, Shape s2) {
        Area a1 = new Area(s1);
        Area a2 = s2 instanceof Area ? (Area)s2 : new Area(s2);
        a1.intersect(a2);
        if (a1.isRectangular()) {
            return a1.getBounds();
        }
        return a1;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(null, false, false);
    }

    public void resetPage() {
    }

    protected Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        ((PDFGraphics)obj).m_original = false;
        ((PDFGraphics)obj).m_transform = new AffineTransform(this.m_transform);
        return obj;
    }

    @Override
    public void beginPage(int pageWidth, int pageHeight) {
        this.usrClip = new Rectangle2D.Float(0.0f, 0.0f, pageWidth, pageHeight);
        this.resetPage();
        this.m_gen.beginPage(pageWidth, pageHeight);
    }

    @Override
    public void endPage() {
        this.m_gen.endPage();
    }

    @Override
    public int getPageResolutionHorizontal() {
        return m_toolkit.getScreenResolution();
    }

    @Override
    public int getPageResolutionVertical() {
        return this.getPageResolutionHorizontal();
    }
}

