/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.awt.print.TOCItem;
import com.sas.collection.AssociationList;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.util.ContentServer;
import com.sas.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

class PDFGen {
    static byte[] m_trans = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int BUFFER_INCREMENT = 65536;
    int m_pageKids;
    int m_pageRoot;
    int m_pageCount;
    int m_pageLength;
    int m_pageLengthObj;
    int m_pageResource;
    int m_fontObj;
    int m_fontNumber;
    int m_procSet;
    int m_pageWidth;
    int m_pageHeight;
    int m_byteCount;
    int m_objNum;
    int m_infoObj;
    byte[] m_buf;
    boolean m_trace;
    boolean m_draw;
    boolean m_text;
    boolean m_imageB;
    boolean m_imageC;
    boolean m_imageI;
    Vector m_pdfObjs;
    Vector m_pageObjs;
    Vector m_fontList;
    Vector m_pageFonts;
    PDFFont m_currentFont;
    Color m_currentColor;
    boolean m_previousClip;
    boolean m_deflate = true;
    Rectangle m_clipRectangle;
    String m_acrobatExe = "c:\\acrobat3\\reader\\AcroRd32.exe";
    protected static final String _acrobatArgs = " /n ";
    private double scalexy;
    private int screenres;
    boolean m_useOutline;
    OrderedCollectionInterface m_toc;
    AssociationList m_trailers;
    OutputStream m_os;
    DeflaterOutputStream m_streamos;
    NonDoublingByteArrayOutputStream deflatedOutputStream;
    OutputStream m_userOS;

    public PDFGen(boolean trace) {
        this(trace, null);
    }

    public PDFGen(boolean trace, OutputStream outputStream) {
        this.m_trace = trace;
        this.m_useOutline = false;
        this.m_userOS = outputStream;
        this.m_objNum = 1;
        this.m_byteCount = 0;
        this.m_fontNumber = 1;
        this.m_buf = new byte[258];
        this.m_pdfObjs = new Vector();
        this.m_pageObjs = new Vector();
        this.m_fontList = new Vector();
        this.m_pageFonts = new Vector();
        this.m_trailers = new AssociationList();
        this.m_previousClip = false;
        this.m_currentColor = Color.black;
        this.m_clipRectangle = new Rectangle();
        try {
            this.m_acrobatExe = System.getProperty("AcrobatReader", this.m_acrobatExe);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void beginDocument(boolean showOutline) {
        this.m_useOutline = showOutline;
        this.beginDocument();
    }

    public void beginDocument() {
        try {
            this.m_os = this.m_userOS == null ? new NonDoublingByteArrayOutputStream(65536) : this.m_userOS;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.addText("%PDF-1.2");
        this.m_trailers.set((Object)"/Root", (Object)new Integer(this.m_byteCount));
        this.addObj(this.m_objNum++);
        this.addText("<<");
        this.addText("/Type /Catalog");
        this.addText("/Pages " + ++this.m_objNum + " 0 R");
        this.addText("/Outlines 2 0 R");
        if (this.m_useOutline) {
            this.addText("/PageMode /UseOutlines");
        }
        this.addText(">>");
        this.addText("endobj");
        this.m_pageRoot = this.m_objNum++;
    }

    private void addBytes(byte[] bytes) {
        this.m_draw = true;
        try {
            this.m_os.write(bytes);
            this.m_byteCount += bytes.length;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void addObj(int objNum) {
        if (objNum > this.m_pdfObjs.size()) {
            this.m_pdfObjs.setSize(objNum);
        }
        this.m_pdfObjs.setElementAt(new Integer(this.m_byteCount), objNum - 1);
        this.addText(objNum + " 0 obj");
    }

    private void addText(String str) {
        this.m_draw = true;
        try {
            byte[] output = str.concat("\r\n").getBytes();
            this.m_os.write(output);
            this.m_byteCount += output.length;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Thread.dumpStack();
        }
    }

    private void addTitleText(String str) {
        this.m_draw = true;
        try {
            byte[] output = new byte[256];
            String strTmp = "/Title (";
            output = strTmp.getBytes();
            this.m_os.write(output);
            this.m_byteCount += output.length;
            str = '\ufeff' + str;
            output = str.getBytes("ISO-10646-UCS-2");
            this.m_os.write(output);
            this.m_byteCount += output.length;
            strTmp = ")";
            output = strTmp.concat("\r\n").getBytes();
            this.m_os.write(output);
            this.m_byteCount += output.length;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Thread.dumpStack();
        }
    }

    private void addStreamText(String str) {
        this.m_draw = true;
        if (!this.m_deflate) {
            this.addText(str);
        } else {
            try {
                byte[] output = str.concat("\r\n").getBytes();
                this.m_streamos.write(output);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                Thread.dumpStack();
            }
        }
    }

    private void addText(byte[] pixBuf, int pixCount) {
        this.m_draw = true;
        try {
            int j = 0;
            for (int i = 0; i < pixCount; ++i) {
                this.m_buf[j++] = m_trans[pixBuf[i] >> 4 & 0xF];
                this.m_buf[j++] = m_trans[pixBuf[i] & 0xF];
                if (j < 256) continue;
                this.m_buf[256] = 13;
                this.m_buf[257] = 10;
                this.m_streamos.write(this.m_buf);
                j = 0;
            }
            if (j > 0) {
                this.m_byteCount += j + 2;
                this.m_buf[j++] = 13;
                this.m_buf[j++] = 10;
                this.m_streamos.write(this.m_buf, 0, j);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Thread.dumpStack();
        }
    }

    public void beginPage(int pageWidth, int pageHeight) {
        this.m_pageWidth = pageWidth;
        this.m_pageHeight = pageHeight;
        this.m_draw = false;
        this.m_text = false;
        this.m_imageB = false;
        this.m_imageC = false;
        this.m_imageI = false;
        this.m_pageObjs.addElement(new Integer(this.m_objNum));
        this.addObj(this.m_objNum++);
        this.m_pageResource = this.m_objNum++;
        this.addText("<<");
        this.addText("/Type /Page");
        this.addText("/Parent " + this.m_pageRoot + " 0 R");
        this.addText("/MediaBox [ 0 0 " + this.m_pageWidth + " " + this.m_pageHeight + " ]");
        this.addText("/Resources " + this.m_pageResource + " 0 R");
        this.addText("/Contents " + this.m_objNum + " 0 R");
        this.addText(">>");
        this.addText("endobj");
        this.addObj(this.m_objNum++);
        this.m_pageLengthObj = this.m_objNum++;
        this.addText("<<");
        if (this.m_deflate) {
            this.addText("/Filter /FlateDecode");
        }
        this.addText("/Length " + this.m_pageLengthObj + " 0 R ");
        this.addText(">>");
        this.addText("stream");
        if (this.m_deflate) {
            try {
                this.deflatedOutputStream = new NonDoublingByteArrayOutputStream(65536);
                this.m_streamos = new DeflaterOutputStream(this.deflatedOutputStream);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.m_pageLength = this.m_byteCount;
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.screenres = tk.getScreenResolution();
        this.scalexy = 72.0 / (double)this.screenres;
        this.saveState();
        this.addStreamText(this.scalexy + " 0 0 " + -1.0 * this.scalexy + " 0 " + this.m_pageHeight + " cm");
    }

    public void clearRect(int x, int y, int width, int height) {
        this.addStreamText("q");
        this.addStreamText("1.0 1.0 1.0 rg");
        this.addStreamText("1.0 1.0 1.0 RG");
        this.drawRect(x, y, width, height, true);
        this.addStreamText("S");
        this.addStreamText("Q");
    }

    public void clipRect(int x, int y, int width, int height) {
        Rectangle r = new Rectangle(x, y, width, height);
        if (this.m_clipRectangle.equals(r)) {
            return;
        }
        this.m_clipRectangle = r;
        this.dRect(x, y, width, height);
        this.addStreamText("W");
        this.addStreamText("n");
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised, boolean fill) {
        Color originalColor = this.m_currentColor;
        Color darkerColor = this.m_currentColor.darker();
        if (!raised) {
            this.setColor(darkerColor);
        }
        this.drawRect(x, y, width, height, fill);
        int newx = x + width;
        if (raised) {
            this.setColor(darkerColor);
        } else {
            this.setColor(originalColor);
        }
        int newy = y + height;
        this.drawLine(newx, y, newx, newy);
        this.drawLine(newx, newy, x, newy);
        this.setColor(originalColor);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
        this.addStreamText("n");
        Vector curves = this.arc(x, y, width, height, startAngle, arcAngle);
        this.addStreamText(Math.round((Double)curves.elementAt(0)) + " " + Math.round((Double)curves.elementAt(1)) + " m");
        int i = 0;
        while (i < curves.size()) {
            i += 2;
            this.addStreamText(Math.round((Double)curves.elementAt(i++)) + " " + Math.round((Double)curves.elementAt(i++)) + " " + Math.round((Double)curves.elementAt(i++)) + " " + Math.round((Double)curves.elementAt(i++)) + " " + Math.round((Double)curves.elementAt(i++)) + " " + Math.round((Double)curves.elementAt(i++)) + " c");
        }
        if (fill) {
            int radiusX = width >> 1;
            int radiusY = height >> 1;
            int centerX = x + radiusX;
            int centerY = y + radiusY;
            arcAngle = this.ang360(arcAngle);
            int angleStart = -startAngle;
            double startAngleRadians = (double)angleStart % 360.0 * Math.PI / 180.0;
            double sinStartAngle = Math.sin(startAngleRadians);
            double cosStartAngle = Math.cos(startAngleRadians);
            double startX = (double)centerX + (double)radiusX * cosStartAngle;
            double startY = (double)centerY + (double)radiusY * sinStartAngle;
            this.addStreamText(centerX + " " + centerY + " l");
            this.addStreamText(startX + " " + startY + " l");
        }
        this.addStreamText("h");
        this.addStreamText(fill ? "f" : "S");
    }

    private Vector arc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        Vector curve;
        double y3;
        double x3;
        double angle;
        int angleEnd;
        boolean bool = true;
        Vector curves = new Vector();
        int radiusX = width >> 1;
        int radiusY = height >> 1;
        int centerX = x + radiusX;
        int centerY = y + radiusY;
        arcAngle = this.ang360(arcAngle);
        int angleStart = -startAngle;
        boolean cw = arcAngle < 0;
        double startAngleRadians = (double)angleStart % 360.0 * Math.PI / 180.0;
        double sinStartAngle = Math.sin(startAngleRadians);
        double cosStartAngle = Math.cos(startAngleRadians);
        double startX = (double)centerX + (double)radiusX * cosStartAngle;
        double startY = (double)centerY + (double)radiusY * sinStartAngle;
        double x0 = startX;
        double y0 = startY;
        if (!cw) {
            for (angleEnd = -startAngle - arcAngle; angleStart < angleEnd; angleEnd -= 360) {
            }
            angle = angleEnd - angleStart;
            while (angle < -90.0) {
                double testsin = sinStartAngle;
                sinStartAngle = -cosStartAngle;
                cosStartAngle = testsin;
                x3 = (double)centerX + (double)radiusX * cosStartAngle;
                y3 = (double)centerY + (double)radiusY * sinStartAngle;
                curve = this.addToArc(bool, radiusX, radiusY, x0, y0, x3, y3, x0 + (double)radiusX * cosStartAngle, y0 + (double)radiusY * sinStartAngle);
                for (int i = 0; i < curve.size(); ++i) {
                    curves.addElement(curve.elementAt(i));
                }
                x0 = x3;
                y0 = y3;
                angle = angleEnd - (angleStart -= 90);
                bool = false;
            }
        } else {
            while (angleEnd < angleStart) {
                angleEnd += 360;
            }
            angle = angleEnd - angleStart;
            while (angle > 90.0) {
                sinStartAngle = cosStartAngle;
                cosStartAngle = -sinStartAngle;
                x3 = (double)centerX + (double)radiusX * cosStartAngle;
                y3 = (double)centerY + (double)radiusY * sinStartAngle;
                curve = this.addToArc(bool, radiusX, radiusY, x0, y0, x3, y3, x0 + (double)radiusX * cosStartAngle, y0 + (double)radiusY * sinStartAngle);
                for (int i = 0; i < curve.size(); ++i) {
                    curves.addElement(curve.elementAt(i));
                }
                x0 = x3;
                y0 = y3;
                angle = (angleEnd += 90) - angleStart;
                bool = false;
            }
        }
        double slope = Math.tan(angle * Math.PI / 360.0);
        double radians = (double)angleEnd * Math.PI / 180.0;
        double x1 = x0 - slope * (double)radiusX * sinStartAngle;
        double y1 = y0 + slope * (double)radiusY * cosStartAngle;
        curve = this.addToArc(bool, radiusX, radiusY, x0, y0, (double)centerX + (double)radiusX * Math.cos(radians), (double)centerY + (double)radiusY * Math.sin(radians), x1, y1);
        for (int i = 0; i < curve.size(); ++i) {
            curves.addElement(curve.elementAt(i));
        }
        return curves;
    }

    private Vector addToArc(boolean bool, double radiusX, double radiusY, double x0, double y0, double x3, double y3, double x1, double y1) {
        double xdistance = x1 - x0;
        double ydistance = y1 - y0;
        double x2y2 = xdistance * xdistance + ydistance * ydistance;
        double rx2 = radiusX * radiusX;
        double ry2 = radiusY * radiusY;
        double rx2y2 = rx2 + ry2;
        double xdelta = 0.0;
        double ydelta = 0.0;
        if (!(x2y2 >= rx2y2 * 1.0E8)) {
            xdelta = 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + x2y2 / rx2));
            ydelta = 1.3333333333333333 / (1.0 + Math.sqrt(1.0 + x2y2 / ry2));
        }
        double newx1 = x0 + (x1 - x0) * xdelta;
        double newy1 = y0 + (y1 - y0) * ydelta;
        double newx2 = x3 + (x1 - x3) * xdelta;
        double newy2 = y3 + (y1 - y3) * ydelta;
        Vector<Double> curveto = new Vector<Double>();
        curveto.addElement(new Double(x0));
        curveto.addElement(new Double(y0));
        curveto.addElement(new Double(newx1));
        curveto.addElement(new Double(newy1));
        curveto.addElement(new Double(newx2));
        curveto.addElement(new Double(newy2));
        curveto.addElement(new Double(x3));
        curveto.addElement(new Double(y3));
        return curveto;
    }

    private int ang360(int angle) {
        if (angle > 360) {
            return 360;
        }
        if (angle < -360) {
            return -360;
        }
        return angle;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgColor, ImageObserver observer) {
        int[] pixels = new int[height * width];
        byte[] pixBuf = new byte[770];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            return false;
        }
        this.m_imageC = true;
        int newy = y + height;
        int newheight = -1 * height;
        this.addStreamText("q");
        this.addStreamText(width + " 0 0 " + newheight + " " + x + " " + newy + " cm");
        this.addStreamText("BI");
        this.addStreamText("/W " + width);
        this.addStreamText("/H " + height);
        this.addStreamText("/BPC 8");
        this.addStreamText("/CS /RGB");
        this.addStreamText("/F [/AHx]");
        this.addStreamText("ID");
        int pixCount = 0;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int pixel = pixels[h * width + w];
                pixBuf[pixCount++] = (byte)(pixel >> 16 & 0xFF);
                pixBuf[pixCount++] = (byte)(pixel >> 8 & 0xFF);
                pixBuf[pixCount++] = (byte)(pixel & 0xFF);
                if (pixCount < 768) continue;
                this.addText(pixBuf, pixCount);
                pixCount = 0;
            }
        }
        if (pixCount > 0) {
            this.addText(pixBuf, pixCount);
        }
        this.addStreamText(">");
        this.addStreamText("EI");
        this.addStreamText("Q");
        return true;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.addStreamText(x1 + " " + y1 + " m");
        this.addStreamText(x2 + " " + y2 + " l");
        this.addStreamText("S");
    }

    public void drawOval(int x, int y, int width, int height, boolean fill) {
        this.drawArc(x, y, width, height, 0, 360, fill);
    }

    public void drawPolygon(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints, boolean fill) {
        this.addStreamText("n");
        for (int i = 0; i < nPoints; ++i) {
            int x = xPoints[i] + xOffset;
            int y = yPoints[i] + yOffset;
            this.addStreamText(x + " " + y + (i == 0 ? " m" : " l"));
        }
        this.addStreamText(fill ? "f" : "s");
    }

    public void drawPolyline(int[] xPoints, int xOffset, int[] yPoints, int yOffset, int nPoints) {
        this.addStreamText("n");
        for (int i = 0; i < nPoints; ++i) {
            int x = xPoints[i] + xOffset;
            int y = yPoints[i] + yOffset;
            this.addStreamText(x + " " + y + (i == 0 ? " m" : " l"));
        }
        this.addStreamText("s");
    }

    public void drawRect(int x, int y, int width, int height, boolean fill) {
        this.dRect(x, y, width, height);
        this.addStreamText(fill ? "f" : "S");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
        this.addStreamText("n");
        Vector ula = this.arc(x, y, arcWidth, arcHeight, 90, 90);
        Vector lla = this.arc(x, y + height - arcHeight, arcWidth, arcHeight, 180, 90);
        Vector lra = this.arc(x + width - arcWidth, y + height - arcHeight, arcWidth, arcHeight, 270, 90);
        Vector ura = this.arc(x + width - arcWidth, y, arcWidth, arcHeight, 0, 90);
        this.addStreamText(Math.round((Double)ula.elementAt(0)) + " " + Math.round((Double)ula.elementAt(1)) + " m");
        this.addStreamText(Math.round((Double)ula.elementAt(2)) + " " + Math.round((Double)ula.elementAt(3)) + " " + Math.round((Double)ula.elementAt(4)) + " " + Math.round((Double)ula.elementAt(5)) + " " + Math.round((Double)ula.elementAt(6)) + " " + Math.round((Double)ula.elementAt(7)) + " c");
        this.addStreamText(Math.round((Double)ula.elementAt(6)) + " " + Math.round((Double)ula.elementAt(7)) + " " + Math.round((Double)lla.elementAt(0)) + " " + Math.round((Double)lla.elementAt(1)) + " l");
        this.addStreamText(Math.round((Double)lla.elementAt(2)) + " " + Math.round((Double)lla.elementAt(3)) + " " + Math.round((Double)lla.elementAt(4)) + " " + Math.round((Double)lla.elementAt(5)) + " " + Math.round((Double)lla.elementAt(6)) + " " + Math.round((Double)lla.elementAt(7)) + " c");
        this.addStreamText(Math.round((Double)lla.elementAt(6)) + " " + Math.round((Double)lla.elementAt(7)) + " " + Math.round((Double)lra.elementAt(0)) + " " + Math.round((Double)lra.elementAt(1)) + " l");
        this.addStreamText(Math.round((Double)lra.elementAt(2)) + " " + Math.round((Double)lra.elementAt(3)) + " " + Math.round((Double)lra.elementAt(4)) + " " + Math.round((Double)lra.elementAt(5)) + " " + Math.round((Double)lra.elementAt(6)) + " " + Math.round((Double)lra.elementAt(7)) + " c");
        this.addStreamText(Math.round((Double)lra.elementAt(6)) + " " + Math.round((Double)lra.elementAt(7)) + " " + Math.round((Double)ura.elementAt(0)) + " " + Math.round((Double)ura.elementAt(1)) + " l");
        this.addStreamText(Math.round((Double)ura.elementAt(2)) + " " + Math.round((Double)ura.elementAt(3)) + " " + Math.round((Double)ura.elementAt(4)) + " " + Math.round((Double)ura.elementAt(5)) + " " + Math.round((Double)ura.elementAt(6)) + " " + Math.round((Double)ura.elementAt(7)) + " c");
        this.addStreamText(Math.round((Double)ura.elementAt(6)) + " " + Math.round((Double)ura.elementAt(7)) + " " + Math.round((Double)ula.elementAt(0)) + " " + Math.round((Double)ula.elementAt(1)) + " l");
        this.addStreamText(fill ? "f" : "s");
    }

    public void drawString(String str, int x, int y) {
        if (str.length() == 0) {
            return;
        }
        this.m_text = true;
        this.addStreamText("BT");
        this.addStreamText(this.m_currentFont.getName() + " " + this.m_currentFont.getSize() + " Tf");
        this.addStreamText("1 0 0 -1 " + x + " " + y + " Tm");
        this.addStreamText("(" + this.replaceParens(str) + ") Tj");
        this.addStreamText("ET");
    }

    public void endDocument(OrderedCollectionInterface toc) {
        this.m_toc = toc;
        this.endDocument();
    }

    private String replaceParens(String str) {
        byte[] bytes = str.getBytes();
        byte slash = 92;
        byte lparen = 40;
        byte rparen = 41;
        byte[] newBytes = new byte[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == slash || bytes[i] == lparen || bytes[i] == rparen) {
                newBytes[j] = 92;
                ++j;
            }
            newBytes[j] = bytes[i];
            ++j;
        }
        String newStr = new String(newBytes, 0, j);
        return newStr;
    }

    public void endDocument() {
        String ss;
        String MM;
        String hh;
        String dd;
        int i;
        byte[] xrefEntry = new byte[20];
        this.addObj(2);
        this.addText("<<");
        this.addText("/Type /Outlines");
        int tocCount = 0;
        if (this.m_toc != null && this.m_toc.count() > 0) {
            for (i = tocCount = this.m_toc.count() - 1; i > -1; --i) {
                TOCItem ti = (TOCItem)((Object)this.m_toc.get(i));
                if (ti != null) continue;
                Object object = this.m_toc.removeAt(i);
            }
            tocCount = this.m_toc.count();
        }
        if (this.m_toc == null || tocCount < 1) {
            this.addText("/Count 0");
            this.addText(">>");
            this.addText("endobj");
        } else {
            int first = this.m_objNum;
            int last = first + this.m_toc.count() - 1;
            this.addText("/Count " + this.m_toc.count());
            this.addText("/Type /Outlines");
            this.addText("/First " + first + " 0 R");
            this.addText("/Last " + last + " 0 R");
            this.addText(">>");
            this.addText("endobj");
            TOCItem[] parent = new TOCItem[tocCount];
            int[] PDFOutlineObjNum = new int[tocCount];
            int[] parentObjNum = new int[tocCount];
            for (int b = 0; b < tocCount; ++b) {
                ++this.m_objNum;
            }
            for (int k = 0; k < tocCount; ++k) {
                StaticOrderedCollectionInterface nodes;
                TOCItem tocItem = (TOCItem)((Object)this.m_toc.get(k));
                if (tocItem == null || (nodes = tocItem.getNodeChildren()) == null) continue;
                block3: for (int l = 0; l < nodes.count(); ++l) {
                    TOCItem t = (TOCItem)((Object)nodes.get(l));
                    for (int m = 0; m < tocCount; ++m) {
                        if (t != this.m_toc.get(m)) continue;
                        parent[m] = tocItem;
                        parentObjNum[m] = PDFOutlineObjNum[k];
                        continue block3;
                    }
                }
            }
            TOCItem root = new TOCItem("Book Root Item");
            for (int n = 0; n < tocCount; ++n) {
                if (parent[n] != null) continue;
                root.addNodeChild((SimpleNodeInterface)((TOCItem)((Object)this.m_toc.get(n))));
                parent[n] = root;
                parentObjNum[n] = 2;
            }
            for (int a = 0; a < tocCount; ++a) {
                int cnt;
                TOCItem t = (TOCItem)((Object)this.m_toc.get(a));
                this.addObj(PDFOutlineObjNum[a]);
                this.addText("<<");
                Integer pObj = (Integer)this.m_pageObjs.elementAt(t.getPageNumber() - 1);
                this.addText("/Dest [" + pObj + " 0 R /XYZ 0 " + this.m_pageHeight + " 0]");
                this.addTitleText(t.getNodeText());
                this.addText("/Parent " + parentObjNum[a] + " 0 R");
                StaticOrderedCollectionInterface pkids = parent[a].getNodeChildren();
                if (pkids != null) {
                    for (int c = 0; c < pkids.count(); ++c) {
                        if (t != (TOCItem)((Object)pkids.get(c))) continue;
                        if (c > 0 && pkids.count() > 1) {
                            TOCItem prevObj = (TOCItem)((Object)pkids.get(c - 1));
                            for (int f = 0; f < tocCount; ++f) {
                                if (prevObj != (TOCItem)((Object)this.m_toc.get(f))) continue;
                                this.addText("/Prev " + PDFOutlineObjNum[f] + " 0 R");
                            }
                        }
                        if (c >= pkids.count() - 1) break;
                        TOCItem nextObj = (TOCItem)((Object)pkids.get(c + 1));
                        for (int g = 0; g < tocCount; ++g) {
                            if (nextObj != (TOCItem)((Object)this.m_toc.get(g))) continue;
                            this.addText("/Next " + PDFOutlineObjNum[g] + " 0 R");
                        }
                        break;
                    }
                }
                if ((pkids = t.getNodeChildren()) != null && pkids.count() > 0) {
                    TOCItem frst = (TOCItem)((Object)pkids.get(0));
                    TOCItem lst = (TOCItem)((Object)pkids.get(pkids.count() - 1));
                    for (int d = 0; d < tocCount; ++d) {
                        if (frst == (TOCItem)((Object)this.m_toc.get(d))) {
                            this.addText("/First " + PDFOutlineObjNum[d] + " 0 R");
                        }
                        if (lst != (TOCItem)((Object)this.m_toc.get(d))) continue;
                        this.addText("/Last " + PDFOutlineObjNum[d] + " 0 R");
                    }
                }
                if ((cnt = t.countDescendents()) > 0) {
                    this.addText("/Count " + cnt);
                }
                this.addText(">>");
                this.addText("endobj");
            }
        }
        this.addObj(this.m_pageRoot);
        this.addText("<<");
        this.addText("/Type /Pages");
        String kids = "[ ";
        Enumeration pages = this.m_pageObjs.elements();
        while (pages.hasMoreElements()) {
            Integer objNum = (Integer)pages.nextElement();
            kids = kids.concat(objNum + " 0 R ");
        }
        kids = kids + "]";
        this.addText("/Kids " + kids);
        this.addText("/Count " + this.m_pageObjs.size() + " ");
        this.addText(">>");
        this.addText("endobj");
        this.m_infoObj = this.m_objNum++;
        this.addObj(this.m_infoObj);
        this.addText("<<");
        GregorianCalendar calendar = new GregorianCalendar();
        String year = new Integer(calendar.get(1)).toString();
        String mm = new Integer(calendar.get(2) + 1).toString();
        if (mm.length() < 2) {
            mm = "0" + mm;
        }
        if ((dd = new Integer(calendar.get(5)).toString()).length() < 2) {
            dd = "0" + dd;
        }
        if ((hh = new Integer(calendar.get(11)).toString()).length() < 2) {
            hh = "0" + hh;
        }
        if ((MM = new Integer(calendar.get(12)).toString()).length() < 2) {
            MM = "0" + MM;
        }
        if ((ss = new Integer(calendar.get(13)).toString()).length() < 2) {
            ss = "0" + ss;
        }
        this.addText("/CreationDate (D:" + year + mm + dd + hh + MM + ss + ")");
        this.addText("/Producer (SAS PDFGen Java Class)");
        this.addText(">>");
        this.addText("endobj");
        if (this.m_fontList.size() > 0) {
            Enumeration fonts = this.m_fontList.elements();
            while (fonts.hasMoreElements()) {
                PDFFont font = (PDFFont)fonts.nextElement();
                this.addObj(font.getObjNum());
                this.addText("<<");
                this.addText("/Type /Font");
                String ft = font.getFontType();
                if (ft.equals("TrueType")) {
                    this.addText("/Subtype /TrueType");
                    this.addText("/FirstChar 32");
                    this.addText("/LastChar 255");
                    this.addText("/Name " + font.getName());
                    this.addText("/BaseFont /" + font.getBase());
                    this.addText("/Widths " + font.getWidths());
                    this.addText("/Encoding /" + font.getEncoding());
                    this.addText("/FontDescriptor " + font.getFontDescriptorObjNum() + " 0 R");
                } else if (ft.equals("Type0")) {
                    this.addText("/Subtype /Type0");
                    this.addText("/BaseFont /" + font.getBase());
                    this.addText("/Encoding /" + font.getEncoding());
                    this.addText("/DescendantFonts [" + font.getDescendantFontObjNum() + " 0 R]");
                } else {
                    this.addText("/Subtype /Type1");
                    this.addText("/Name " + font.getName());
                    this.addText("/BaseFont /" + font.getBase());
                    this.addText("/Encoding /" + font.getEncoding());
                }
                this.addText(">>");
                this.addText("endobj");
                if (ft.equals("TrueType")) {
                    this.addObj(font.getFontDescriptorObjNum());
                    this.addText("<<");
                    this.addText("/Type /FontDescriptor");
                    this.addText("/FontName /" + font.getBase());
                    this.addText("/Flags " + font.getFlags());
                    this.addText("/FontBBox " + font.getFontBBox());
                    this.addText("/MissingWidth " + font.getMissingWidth());
                    this.addText("/StemV " + font.getStemV());
                    this.addText("/StemH " + font.getStemH());
                    this.addText("/ItalicAngle " + font.getItalicAngle());
                    this.addText("/CapHeight\t" + font.getCapHeight());
                    this.addText("/XHeight " + font.getXHeight());
                    this.addText("/Ascent " + font.getAscent());
                    this.addText("/Descent " + font.getDescent());
                    this.addText("/Leading " + font.getLeading());
                    this.addText("/MaxWidth " + font.getMaxWidth());
                    this.addText("/AvgWidth " + font.getAvgWidth());
                    this.addText(">>");
                    this.addText("endobj");
                    continue;
                }
                if (!ft.equals("Type0")) continue;
                this.addObj(font.getDescendantFontObjNum());
                this.addText("<<");
                this.addText("/Type /Font");
                this.addText("/BaseFont /" + font.getBase());
                this.addText("/Subtype /CIDFontType2");
                this.addText("/DW 1000");
                this.addText("/CIDSystemInfo " + font.getCIDSystemInfo());
                this.addText("/W " + font.getWidths());
                this.addText("/FontDescriptor " + font.getFontDescriptorObjNum() + " 0 R");
                this.addText(">>");
                this.addText("endobj");
                this.addObj(font.getFontDescriptorObjNum());
                this.addText("<<");
                this.addText("/Type /FontDescriptor");
                this.addText("/FontName /" + font.getBase());
                this.addText("/FontBBox " + font.getFontBBox());
                this.addText("/Flags " + font.getFlags());
                this.addText("/CapHeight\t" + font.getCapHeight());
                this.addText("/Ascent " + font.getAscent());
                this.addText("/Descent " + font.getDescent());
                this.addText("/StemV " + font.getStemV());
                this.addText("/StemH " + font.getStemH());
                this.addText("/ItalicAngle " + font.getItalicAngle());
                this.addText("/XHeight " + font.getXHeight());
                this.addText("/MissingWidth " + font.getMissingWidth());
                this.addText("/Leading " + font.getLeading());
                this.addText("/MaxWidth " + font.getMaxWidth());
                this.addText("/AvgWidth " + font.getAvgWidth());
                this.addText("/Style " + font.getStyle());
                this.addText(">>");
                this.addText("endobj");
            }
            this.m_fontList.removeAllElements();
        }
        int xrefPos = this.m_byteCount;
        this.addText("xref");
        this.addText("0 " + this.m_objNum);
        this.addText("0000000000 65535 f");
        xrefEntry[10] = 32;
        xrefEntry[11] = 48;
        xrefEntry[12] = 48;
        xrefEntry[13] = 48;
        xrefEntry[14] = 48;
        xrefEntry[15] = 48;
        xrefEntry[16] = 32;
        xrefEntry[17] = 110;
        xrefEntry[18] = 13;
        xrefEntry[19] = 10;
        Enumeration objs = this.m_pdfObjs.elements();
        while (objs.hasMoreElements()) {
            Integer objNum = (Integer)objs.nextElement();
            if (objNum == null) continue;
            byte[] num = objNum.toString().getBytes();
            i = 0;
            for (int j = 0; j < 10; ++j) {
                xrefEntry[j] = j < 10 - num.length ? 48 : num[i++];
            }
            this.addBytes(xrefEntry);
        }
        this.addText("trailer");
        this.addText("<<");
        this.addText("/Size " + this.m_objNum);
        this.addText("/Root 1 0 R");
        this.addText("/Info " + this.m_infoObj + " 0 R");
        this.addText(">>");
        this.addText("startxref");
        this.addText(Integer.toString(xrefPos));
        this.addText("%%EOF");
        if (this.m_userOS == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ContentServer.export((byte[])((ByteArrayOutputStream)PDFGen.this.m_os).toByteArray(), (String)"application/pdf", (String)PDFGen.this.getAcrobatExe(), (String)PDFGen._acrobatArgs, (String)".pdf");
                    return null;
                }
            });
        }
    }

    public String getAcrobatExe() {
        return this.m_acrobatExe;
    }

    public void setAcrobatExe(String exe) {
        this.m_acrobatExe = exe;
    }

    public boolean getUseOutline() {
        return this.m_useOutline;
    }

    public void setUseOutline(boolean out) {
        this.m_useOutline = out;
    }

    public void endPage() {
        this.restoreState();
        if (this.m_deflate) {
            try {
                this.m_streamos.finish();
                this.m_streamos.close();
                this.deflatedOutputStream.writeTo(this.m_os);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                Thread.dumpStack();
            }
        }
        if (this.m_deflate) {
            this.m_byteCount = this.m_pageLength + this.deflatedOutputStream.size();
            this.deflatedOutputStream.reset();
        }
        this.addText("");
        this.m_pageLength = this.m_byteCount - this.m_pageLength;
        this.addText("endstream");
        this.addText("endobj");
        this.addObj(this.m_pageLengthObj);
        this.addText(this.m_pageLength + " ");
        this.addText("endobj");
        this.addObj(this.m_pageResource);
        this.addText("<<");
        if (this.m_pageFonts.size() > 0) {
            String fontStr = "/Font <<";
            Enumeration fonts = this.m_pageFonts.elements();
            while (fonts.hasMoreElements()) {
                PDFFont font = (PDFFont)fonts.nextElement();
                fontStr = fontStr.concat(font.getName() + " " + font.getObjNum() + " 0 R ");
            }
            this.addText(fontStr + ">>");
            this.m_pageFonts.removeAllElements();
        }
        String str = "/ProcSet [ ";
        if (this.m_text || this.m_draw || this.m_imageB || this.m_imageC || this.m_imageI) {
            str = str.concat("/PDF ");
        }
        if (this.m_text) {
            str = str.concat("/Text ");
        }
        if (this.m_imageB) {
            str = str.concat("/ImageB ");
        }
        if (this.m_imageC) {
            str = str.concat("/ImageC ");
        }
        if (this.m_imageI) {
            str = str.concat("/ImageI ");
        }
        str = str.concat("]");
        this.addText(str);
        this.addText(">>");
        this.addText("endobj");
    }

    public void finalize() {
    }

    public void restoreState() {
        if (this.m_trace) {
            System.out.println("gen.restoreState()");
        }
        this.addStreamText("Q");
    }

    public void saveState() {
        if (this.m_trace) {
            System.out.println("gen.saveState()");
        }
        this.addStreamText("q");
    }

    public void setClip(int x, int y, int width, int height) {
        Rectangle r;
        if (this.m_trace) {
            System.out.println("gen.setClip( " + x + ", " + y + ", " + width + ", " + height + " ) ");
        }
        if (this.m_clipRectangle.equals(r = new Rectangle(x, y, width, height))) {
            return;
        }
        this.m_clipRectangle = r;
        this.dRect(x, y, width, height);
        this.addStreamText("W");
        this.addStreamText("n");
    }

    private void dRect(int x, int y, int width, int height) {
        this.addStreamText(x + " " + y + " " + width + " " + height + " re");
    }

    public void setColor(Color c) {
        this.m_currentColor = c;
        float r = c.getRed();
        float g = c.getGreen();
        float b = c.getBlue();
        this.addStreamText((r /= 255.0f) + " " + (g /= 255.0f) + " " + (b /= 255.0f) + " rg");
        this.addStreamText(r + " " + g + " " + b + " RG");
    }

    public void setFont(Font f) {
        PDFFont pdfFont = null;
        boolean match = false;
        Enumeration pdfFonts = this.m_fontList.elements();
        while (pdfFonts.hasMoreElements()) {
            pdfFont = (PDFFont)pdfFonts.nextElement();
            if (!pdfFont.equals(f)) continue;
            match = true;
            break;
        }
        if (!match) {
            pdfFont = new PDFFont(f, this.m_objNum++);
        }
        this.m_currentFont = pdfFont;
        if (f.getSize() != pdfFont.getSize()) {
            pdfFont.setSize(f.getSize());
        }
        if (match) {
            match = false;
            pdfFonts = this.m_pageFonts.elements();
            while (pdfFonts.hasMoreElements()) {
                pdfFont = (PDFFont)pdfFonts.nextElement();
                if (!pdfFont.equals(f)) continue;
                match = true;
                break;
            }
        }
        if (!match) {
            this.m_pageFonts.addElement(this.m_currentFont);
        }
    }

    public String toString() {
        return "PDFGen";
    }

    public void translate(double tx, double ty) {
        this.addStreamText("1 0 0 1 " + tx + " " + ty + " cm");
    }

    public void rotate(double theta) {
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        this.addStreamText(cosTheta + " " + sinTheta + " " + -sinTheta + " " + cosTheta + " 0 0 cm");
    }

    public void scale(double sx, double sy) {
        this.addStreamText(sx + " 0 0 " + sy + " 0 0 cm");
    }

    public void transform(double[] matrix) {
        this.addStreamText(matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + "  cm");
    }

    class NonDoublingByteArrayOutputStream
    extends ByteArrayOutputStream {
        int mBufferIncrement;

        public NonDoublingByteArrayOutputStream() {
            this(4096);
        }

        public NonDoublingByteArrayOutputStream(int bufferIncrement) {
            this.mBufferIncrement = bufferIncrement;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            int newcount = this.count + len;
            if (newcount > this.buf.length) {
                byte[] newbuf;
                try {
                    newbuf = new byte[newcount + this.mBufferIncrement];
                }
                catch (OutOfMemoryError e) {
                    System.gc();
                    newbuf = new byte[newcount + this.mBufferIncrement];
                }
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count = newcount;
        }
    }

    public class PDFFont {
        int m_fontObjNum;
        int m_fontDescObjNum;
        Font m_font;
        String m_name;
        String m_baseName;
        String m_widths;
        boolean m_windows;
        String m_fontType;
        int m_flags;
        String m_fontBBox;
        int m_missingWidth;
        int m_stemV;
        int m_stemH;
        int m_italicAngle;
        int m_capHeight;
        int m_xHeight;
        int m_ascent;
        int m_descent;
        int m_leading;
        int m_maxWidth;
        int m_avgWidth;
        Locale m_locale;
        String m_language;
        String m_style;
        String m_encoding;
        int m_descendantFontObjNum;
        String m_CIDSystemInfo;

        public PDFFont(Font f, int objNum) {
            this.m_font = f;
            this.m_fontObjNum = objNum;
            this.m_name = "/F" + PDFGen.this.m_fontNumber++;
            this.m_windows = false;
            this.m_fontType = "Type1";
            this.m_encoding = "MacRomanEncoding";
            this.m_locale = Locale.getDefault();
            this.m_language = this.m_locale.toString();
            if (this.m_language.equalsIgnoreCase("ja_JP") || this.m_language.equalsIgnoreCase("ja")) {
                this.m_fontType = "Type0";
                this.m_fontDescObjNum = PDFGen.this.m_objNum++;
                this.m_encoding = "90msp-RKSJ-H";
                this.m_descendantFontObjNum = PDFGen.this.m_objNum++;
                this.m_CIDSystemInfo = "<< /Registry (Adobe)/Ordering (Japan1)/Supplement 2 >>";
                this.m_baseName = this.getBaseName(this.m_font);
                if (this.m_baseName.indexOf("HeiseiMin-W3") > -1) {
                    this.m_fontBBox = "[ -123 -257 1001 910 ]";
                    this.m_flags = 6;
                    this.m_capHeight = 718;
                    this.m_ascent = 857;
                    this.m_descent = -143;
                    this.m_stemV = 93;
                    this.m_stemH = 31;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 500;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 702;
                    this.m_style = "<< /Panose <010502020400000000000000> >>";
                    this.m_widths = "[ 1 95 500 231 389 500 ]";
                } else if (this.m_baseName.indexOf("HeiseiKakuGo-W5") > -1) {
                    this.m_fontBBox = "[ -92 -250 1010 922 ] ";
                    this.m_flags = 4;
                    this.m_capHeight = 718;
                    this.m_ascent = 875;
                    this.m_descent = -125;
                    this.m_stemV = 93;
                    this.m_stemH = 93;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 500;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 689;
                    this.m_style = "<< /Panose <0801020b0600000000000000> >>";
                    this.m_widths = "[ 1 95 500 231 389 500 ]";
                }
            } else if (this.m_language.equalsIgnoreCase("ko_KR") || this.m_language.equalsIgnoreCase("ko")) {
                this.m_fontType = "Type0";
                this.m_fontDescObjNum = PDFGen.this.m_objNum++;
                this.m_encoding = "KSCms-UHC-H";
                this.m_descendantFontObjNum = PDFGen.this.m_objNum++;
                this.m_CIDSystemInfo = "<< /Registry (Adobe)/Ordering (Korea1)/Supplement 1 >>";
                this.m_baseName = this.getBaseName(this.m_font);
                if (this.m_baseName.indexOf("HYSMyeongJo-Medium") > -1) {
                    this.m_fontBBox = "[ 0 -148 880 1001 ]";
                    this.m_flags = 6;
                    this.m_capHeight = 880;
                    this.m_ascent = 880;
                    this.m_descent = -120;
                    this.m_stemV = 93;
                    this.m_stemH = 31;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 500;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 702;
                    this.m_style = "<< /Panose <010502020400000000000000> >>";
                    this.m_widths = "[ 1 95 500 231 389 500 ]";
                } else if (this.m_baseName.indexOf("HYGoThic-Medium") > -1) {
                    this.m_fontBBox = "[ -92 -250 1010 922 ] ";
                    this.m_flags = 6;
                    this.m_capHeight = 718;
                    this.m_ascent = 875;
                    this.m_descent = -125;
                    this.m_stemV = 93;
                    this.m_stemH = 93;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 500;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 689;
                    this.m_style = "<< /Panose <0801020b0600000000000000> >>";
                    this.m_widths = "[ 1 95 500 231 389 500 ]";
                }
            } else if (this.m_language.equalsIgnoreCase("zh_CN") || this.m_language.equalsIgnoreCase("zh")) {
                this.m_fontType = "Type0";
                this.m_fontDescObjNum = PDFGen.this.m_objNum++;
                this.m_encoding = "GBK-EUC-H";
                this.m_descendantFontObjNum = PDFGen.this.m_objNum++;
                this.m_CIDSystemInfo = "<< /Registry (Adobe)/Ordering (GB1)/Supplement 2 >>";
                this.m_baseName = this.getBaseName(this.m_font);
                if (this.m_baseName.indexOf("STSong-Light") > -1) {
                    this.m_fontBBox = "[ -25 -254 1000 880 ]";
                    this.m_flags = 6;
                    this.m_capHeight = 737;
                    this.m_ascent = 752;
                    this.m_descent = -271;
                    this.m_stemV = 58;
                    this.m_stemH = 58;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 553;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 689;
                    this.m_style = "<< /Panose <0801020b0600000000000000> >>";
                    this.m_widths = "[ 1 [ 207 ] 2 [ 270 ] 3 [ 342 ] 4 [ 467 ] 5 [ 462 ] 6 [ 797 ] 7 [ 710 ]\r\n8 [ 239 ] 9 10 374 11 [ 423 ] 12 [ 605 ] 13 [ 238 ] 14 [ 375 ] 15\r\n[ 238 ] 16 [ 334 ] 17 26 462 27 28 238 29 31 605 32 [ 344 ] 33 [ 748 ]\r\n34 [ 684 ] 35 [ 560 ] 36 [ 695 ] 37 [ 739 ] 38 [ 563 ] 39 [ 511 ]\r\n40 [ 729 ] 41 [ 793 ] 42 [ 318 ] 43 [ 312 ] 44 [ 666 ] 45 [ 526 ]\r\n46 [ 896 ] 47 [ 758 ] 48 [ 772 ] 49 [ 544 ] 50 [ 772 ] 51 [ 628 ]\r\n52 [ 465 ] 53 [ 607 ] 54 [ 753 ] 55 [ 711 ] 56 [ 972 ] 57 [ 647 ]\r\n58 [ 620 ] 59 [ 607 ] 60 [ 374 ] 61 [ 333 ] 62 [ 374 ] 63 [ 606 ]\r\n64 [ 500 ] 65 [ 239 ] 66 [ 417 ] 67 [ 503 ] 68 [ 427 ] 69 [ 529 ]\r\n70 [ 415 ] 71 [ 264 ] 72 [ 444 ] 73 [ 518 ] 74 [ 241 ] 75 [ 230 ]\r\n76 [ 495 ] 77 [ 228 ] 78 [ 793 ] 79 [ 527 ] 80 81 524 82 [ 504]\r\n83 [ 338 ] 84 [ 336 ] 85 [ 277 ] 86 [ 517 ] 87 [ 450 ] 88 [ 652 ]\r\n89 [ 466 ] 90 [ 452 ] 91 [ 407 ] 92 [ 370 ] 93 [ 258 ] 94 [ 370 ]\r\n95 [ 605 ] 814 939 500 7712 [ 517 ] 7713 [ 684 ] 7714 [ 723 ] 7715\r\n[ 1000 ] 7716 [ 500 ] ]";
                }
            } else if (this.m_language.equalsIgnoreCase("zh_TW")) {
                this.m_fontType = "Type0";
                this.m_fontDescObjNum = PDFGen.this.m_objNum++;
                this.m_encoding = "B5pc-H";
                this.m_descendantFontObjNum = PDFGen.this.m_objNum++;
                this.m_CIDSystemInfo = "<< /Registry (Adobe)/Ordering (CNS1)/Supplement 0 >>";
                this.m_baseName = this.getBaseName(this.m_font);
                if (this.m_baseName.indexOf("MSung-Light") > -1) {
                    this.m_fontBBox = "[ -160 -249 1015 888 ]";
                    this.m_flags = 4;
                    this.m_capHeight = 853;
                    this.m_ascent = 880;
                    this.m_descent = -120;
                    this.m_stemV = 93;
                    this.m_stemH = 93;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 500;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 702;
                    this.m_style = "<< /Panose <010502020400000000000000> >>";
                    this.m_widths = "[1 [ 250 250 408 668 490 875 698 250 240 240 417 \r\n667 250 313 250 520 ] 17 26 500 27 [ 250 250 667 \r\n667 667 396 921 677 615 719 760 625 552 771 802 \r\n354 354 781 604 927 750 823 563 823 729 542 698 \r\n771 729 948 771 677 635 344 520 344 469 500 250 \r\n469 521 427 521 438 271 469 531 250 250 458 240 \r\n802 531 500 521 521 365 333 292 521 458 677 479 \r\n458 427 480 496 480 667 ] ]";
                } else if (this.m_baseName.indexOf("MHei-Medium") > -1) {
                    this.m_fontBBox = "[ -45 -250 1015 888 ] ";
                    this.m_flags = 4;
                    this.m_capHeight = 880;
                    this.m_ascent = 880;
                    this.m_descent = -120;
                    this.m_stemV = 93;
                    this.m_stemH = 93;
                    this.m_italicAngle = 0;
                    this.m_xHeight = 616;
                    this.m_missingWidth = 500;
                    this.m_leading = 250;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 689;
                    this.m_style = "<< /Panose <0801020b0600000000000000> >>";
                    this.m_widths = "[ 1 [ 278 278 355 556 556 889 667 222 333 333 389 \r\n584 278 333 278 278 ] 17 26 556 27 [ 278 278 584 584 \r\n584 556 1015 667 667 722 722 667 611 778 722 278 500 \r\n667 556 833 722 778 667 778 722 667 611 722 667 944 667\r\n667 611 278 278 278 469 556 222 556 556 500 556 556 278\r\n556 556 222 222 500 222 833 ] 79 82 556 83 [ 333 500 278 \r\n556 500 722 500 500 500 334 260 334 584 ] ]";
                }
            } else {
                if (Util.osTypeIsWindows()) {
                    this.m_windows = true;
                    this.m_fontType = "TrueType";
                    this.m_encoding = "WinAnsiEncoding";
                    this.m_fontDescObjNum = PDFGen.this.m_objNum++;
                } else if (!Util.osTypeIsWindows() && !Util.osTypeIsSolaris()) {
                    this.m_windows = true;
                    this.m_fontType = "TrueType";
                    this.m_encoding = "WinAnsiEncoding";
                    this.m_fontDescObjNum = PDFGen.this.m_objNum++;
                }
                this.m_baseName = this.getBaseName(this.m_font);
                if (this.m_baseName.equalsIgnoreCase("Arial")) {
                    this.m_widths = "[ 285 333 357 547 547 880 666 190 333 333\r\n  380 595 285 333 285 285 547 547 547 547\r\n\t547 547 547 547 547 547 285 285 595 595\r\n\t595 547 1023 666 666 714 714 666 619 785\r\n\t714 285 500 666 547 833 714 785 666 785\r\n\t714 666 619 714 666 1000 642 666 619 285\r\n\t285 285 452 547 333 547 547 500 547 547\r\n \t309 547 547 238 238 500 238 857 547 547\r\n\t547 547 333 476 285 547 547 690 523 500\r\n\t500 333 261 333 595 761 761 761 595 595\r\n\t595 595 595 595 595 595 595 595 595 761\r\n\t761 761 761 595 595 595 595 595 595 595\r\n\t595 595 595 595 595 761 761 595 285 333\r\n\t547 547 547 547 261 547 333 738 380 547\r\n\t595 333 738 547 404 547 333 333 333 571\r\n\t547 285 333 333 357 547 833 833 833 619\r\n\t666 666 666 666 666 666 1000 714 666 666\r\n\t666 666 285 285 285 285 714 714 785 785\r\n\t785 785 785 595 785 714 714 714 714 666\r\n\t666 619 547 547 547 547 547 547 880 500\r\n\t547 547 547 547 285 285 285 285 547 547\r\n\t547 547 547 547 547 547 619 547 547 547\r\n\t547 500 547 500]";
                    this.m_flags = 32;
                    this.m_fontBBox = "[ -250 -212 1229 1055 ]";
                    this.m_missingWidth = 286;
                    this.m_stemV = 80;
                    this.m_stemH = 80;
                    this.m_italicAngle = 0;
                    this.m_capHeight = 905;
                    this.m_xHeight = 453;
                    this.m_ascent = 905;
                    this.m_descent = -212;
                    this.m_leading = 150;
                    this.m_maxWidth = 1024;
                    this.m_avgWidth = 441;
                } else if (this.m_baseName.equalsIgnoreCase("Arial,Bold")) {
                    this.m_widths = "[ 285 333 476 547 547 833 714 238 333 333\r\n  380 595 285 333 285 285 547 547 547 547\r\n\t547 547 547 547 547 547 333 333 595 595\r\n\t595 619 976 690 714 714 714 666 619 785\r\n  714 285 547 714 619 833 714 785 666 785\r\n  714 666 642 714 666 928 666 666 619 333\r\n  285 333 595 547 333 547 619 547 619 547\r\n  333 619 619 285 285 547 285 880 619 619\r\n  619 619 380 547 333 619 547 785 547 547\r\n  500 380 285 380 595 761 761 761 595 595\r\n  595 595 595 595 595 595 595 595 595 761\r\n  761 761 761 595 595 595 595 595 595 595\r\n  595 595 595 595 595 761 761 595 285 333\r\n  547 547 547 547 285 547 333 738 380 547\r\n  595 333 738 547 404 547 333 333 333 571\r\n  547 285 333 333 357 547 833 833 833 619\r\n  690 690 690 690 690 690 1000 714 666 666\r\n  666 666 285 285 285 285 714 714 785 785\r\n  785 785 785 595 785 714 714 714 714 666\r\n  666 619 547 547 547 547 547 547 880 547\r\n  547 547 547 547 285 285 285 285 619 619\r\n  619 619 619 619 619 547 619 619 619 619\r\n  619 547 619 547 ]";
                    this.m_flags = 16416;
                    this.m_fontBBox = "[ -250 -212 1200 1055 ]";
                    this.m_missingWidth = 333;
                    this.m_stemV = 153;
                    this.m_stemH = 153;
                    this.m_italicAngle = 0;
                    this.m_capHeight = 905;
                    this.m_xHeight = 453;
                    this.m_ascent = 905;
                    this.m_descent = -212;
                    this.m_leading = 150;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 479;
                } else if (this.m_baseName.equalsIgnoreCase("Arial,Italic")) {
                    this.m_widths = "[ 285 285 357 547 547 880 666 190 333 333\r\n\t380 595 285 333 285 285 547 547 547 547\r\n\t547 547 547 547 547 547 285 285 595 595\r\n\t595 547 1000 666 666 714 714 666 619 785\r\n\t714 261 500 666 547 833 714 785 666 785\r\n\t714 666 619 714 666 952 666 666 619 285\r\n\t285 285 476 547 333 547 547 500 547 547\r\n\t285 547 547 214 214 500 214 833 547 547\r\n\t547 547 333 500 285 547 500 738 500 500\r\n\t452 333 261 333 595 761 761 761 595 595\r\n\t595 595 595 595 595 595 595 595 595 761\r\n\t761 761 761 595 595 595 595 595 595 595\r\n\t595 595 595 595 595 761 761 595 285 333\r\n\t547 547 547 547 261 547 333 738 380 547\r\n\t595 333 738 547 404 547 333 333 333 547\r\n\t547 285 333 309 357 547 833 833 833 619\r\n\t666 666 666 666 666 666 1000 714 666 666\r\n\t666 666 261 261 261 261 714 714 785 785\r\n\t785 785 785 595 785 714 714 714 714 666\r\n\t666 619 547 547 547 547 547 547 880 500\r\n\t547 547 547 547 285 285 285 285 547 547\r\n\t547 547 547 547 547 547 619 547 547 547\r\n\t547 500 547 500 ]";
                    this.m_flags = 96;
                    this.m_fontBBox = "[ -250 -212 1200 1055 ]";
                    this.m_missingWidth = 286;
                    this.m_stemV = 80;
                    this.m_stemH = 80;
                    this.m_italicAngle = -11;
                    this.m_capHeight = 905;
                    this.m_xHeight = 453;
                    this.m_ascent = 905;
                    this.m_descent = -212;
                    this.m_leading = 150;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 441;
                } else if (this.m_baseName.equalsIgnoreCase("Arial,BoldItalic")) {
                    this.m_widths = "[ 285 333 476 547 547 857 714 214 333 357\r\n  380 595 285 333 285 285 547 547 547 547\r\n  547 547 547 547 547 547 333 333 595 595\r\n  595 619 1000 714 714 714 714 666 619 785\r\n  714 261 547 714 619 857 714 785 666 785\r\n  714 666 619 714 666 952 666 666 619 333\r\n  285 357 595 547 333 547 619 547 619 547\r\n  333 619 619 285 285 547 285 880 619 619\r\n  619 619 380 523 333 619 547 785 547 547\r\n  500 380 285 380 595 761 761 761 595 595\r\n  595 595 595 595 595 595 595 595 595 761\r\n  761 761 761 595 595 595 595 595 595 595\r\n  595 595 595 595 595 761 761 595 285 333\r\n  571 547 547 547 261 547 333 738 380 547\r\n  595 333 738 547 404 547 333 333 333 571\r\n  547 285 333 333 357 547 833 833 833 619\r\n  714 714 714 714 714 714 1000 714 666 666\r\n  666 666 261 261 261 261 714 714 785 785\r\n  785 785 785 595 785 714 714 714 714 666\r\n  666 619 547 547 547 547 547 547 880 547\r\n  547 547 547 547 285 285 285 285 619 619\r\n  619 619 619 619 619 547 595 619 619 619\r\n  619 547 595 547 ]";
                    this.m_flags = 16480;
                    this.m_fontBBox = "[ -250 -212 1200 1055 ]";
                    this.m_missingWidth = 357;
                    this.m_stemV = 153;
                    this.m_stemH = 153;
                    this.m_italicAngle = -11;
                    this.m_capHeight = 905;
                    this.m_xHeight = 453;
                    this.m_ascent = 905;
                    this.m_descent = -212;
                    this.m_leading = 150;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 479;
                } else if (this.m_baseName.indexOf("CourierNew") > -1) {
                    this.m_widths = "[ 600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 600 600 600 600 600 600\r\n  600 600 600 600 ]";
                    if (this.m_baseName.equalsIgnoreCase("CourierNew")) {
                        this.m_flags = 34;
                        this.m_fontBBox = "[ -250 -300 720 1000 ]";
                        this.m_missingWidth = 600;
                        this.m_stemV = 109;
                        this.m_stemH = 109;
                        this.m_italicAngle = 0;
                        this.m_capHeight = 833;
                        this.m_xHeight = 417;
                        this.m_ascent = 833;
                        this.m_descent = -300;
                        this.m_leading = 133;
                        this.m_maxWidth = 600;
                        this.m_avgWidth = 600;
                    } else if (this.m_baseName.equalsIgnoreCase("CourierNew,Bold")) {
                        this.m_flags = 16418;
                        this.m_fontBBox = "[ -250 -300 720 1000 ]";
                        this.m_missingWidth = 600;
                        this.m_stemV = 191;
                        this.m_stemH = 191;
                        this.m_italicAngle = 0;
                        this.m_capHeight = 833;
                        this.m_xHeight = 417;
                        this.m_ascent = 833;
                        this.m_descent = -300;
                        this.m_leading = 133;
                        this.m_maxWidth = 600;
                        this.m_avgWidth = 600;
                    } else if (this.m_baseName.equalsIgnoreCase("CourierNew,Italic")) {
                        this.m_flags = 98;
                        this.m_fontBBox = "[ -250 -300 720 1000 ]";
                        this.m_missingWidth = 600;
                        this.m_stemV = 109;
                        this.m_stemH = 109;
                        this.m_italicAngle = -11;
                        this.m_capHeight = 833;
                        this.m_xHeight = 417;
                        this.m_ascent = 833;
                        this.m_descent = -300;
                        this.m_leading = 133;
                        this.m_maxWidth = 600;
                        this.m_avgWidth = 600;
                    } else if (this.m_baseName.equalsIgnoreCase("CourierNew,BoldItalic")) {
                        this.m_flags = 16482;
                        this.m_fontBBox = "[ -250 -300 720 1000 ]";
                        this.m_missingWidth = 600;
                        this.m_stemV = 191;
                        this.m_stemH = 191;
                        this.m_italicAngle = -11;
                        this.m_capHeight = 833;
                        this.m_xHeight = 417;
                        this.m_ascent = 833;
                        this.m_descent = -300;
                        this.m_leading = 133;
                        this.m_maxWidth = 600;
                        this.m_avgWidth = 600;
                    }
                } else if (this.m_baseName.equalsIgnoreCase("TimesNewRoman")) {
                    this.m_widths = "[ 258 293 396 500 500 827 775 155 327 327\r\n  465 568 258 327 258 275 500 500 500 500\r\n  500 500 500 500 500 500 258 275 568 568\r\n  568 431 913 706 655 672 724 603 534 724\r\n  706 327 396 706 586 896 724 724 551 724\r\n  672 551 603 724 724 948 724 724 603 327\r\n  258 327 465 500 327 448 500 448 500 448\r\n  310 482 482 258 275 500 258 741 482 500\r\n  500 500 327 396 275 482 482 724 482 482\r\n  448 482 172 482 534 775 775 775 568 568\r\n  568 568 568 568 568 568 568 568 568 775\r\n  775 775 775 568 568 568 568 568 568 568\r\n  568 568 568 568 568 775 775 568 258 293\r\n  500 500 500 500 172 500 310 758 275 482\r\n  568 327 758 500 396 551 293 293 293 568\r\n  448 241 293 293 310 482 741 758 758 431\r\n  706 706 706 706 706 706 879 672 603 603\r\n  603 603 327 327 327 327 724 724 724 724\r\n  724 724 724 568 724 724 724 724 724 724\r\n  568 517 448 448 448 448 448 448 672 448\r\n  448 448 448 448 258 258 258 258 500 482\r\n  500 500 500 500 500 551 500 482 482 482\r\n  482 482 500 482 ]";
                    this.m_flags = 34;
                    this.m_fontBBox = "[ -250 -216 1138 1040 ]";
                    this.m_missingWidth = 328;
                    this.m_stemV = 73;
                    this.m_stemH = 73;
                    this.m_italicAngle = 0;
                    this.m_capHeight = 891;
                    this.m_xHeight = 446;
                    this.m_ascent = 891;
                    this.m_descent = -216;
                    this.m_leading = 149;
                    this.m_maxWidth = 948;
                    this.m_avgWidth = 401;
                } else if (this.m_baseName.equalsIgnoreCase("TimesNewRoman,Bold")) {
                    this.m_widths = "[ 258 327 551 500 500 1000 827 275 327 327\r\n  500 568 258 327 258 275 500 500 500 500\r\n  500 500 500 500 500 500 327 327 568 568\r\n  568 500 931 724 672 724 724 672 620 775\r\n  775 396 500 775 672 965 724 775 620 775\r\n  724 551 672 724 724 1000 724 724 655 327\r\n  275 327 586 500 327 500 551 448 551 448\r\n  344 500 534 275 327 534 275 827 534 482\r\n  551 551 448 396 327 534 500 706 482 500\r\n  413 396 206 396 517 775 775 775 568 568\r\n  568 568 568 568 568 568 568 568 568 775\r\n  775 775 775 568 568 568 568 568 568 568\r\n  568 568 568 568 568 775 775 568 258 327\r\n  500 500 500 500 206 500 362 741 293 500\r\n  568 327 741 500 396 551 293 293 327 568\r\n  534 241 327 293 327 500 758 758 758 500\r\n  724 724 724 724 724 724 1000 724 672 672\r\n  672 672 396 396 396 396 724 724 775 775\r\n  775 775 775 568 775 724 724 724 724 724\r\n  603 551 500 500 500 500 500 500 724 448\r\n\t 448 448 448 448 275 275 275 275 500 534\r\n\t 482 482 482 482 482 551 500 534 534 534\r\n\t 534 500 551 500 ]";
                    this.m_flags = 16418;
                    this.m_fontBBox = "[ -250 -216 1200 1040 ]";
                    this.m_missingWidth = 328;
                    this.m_stemV = 136;
                    this.m_stemH = 136;
                    this.m_italicAngle = 0;
                    this.m_capHeight = 891;
                    this.m_xHeight = 446;
                    this.m_ascent = 891;
                    this.m_descent = -216;
                    this.m_leading = 149;
                    this.m_maxWidth = 1000;
                    this.m_avgWidth = 427;
                } else if (this.m_baseName.equalsIgnoreCase("TimesNewRoman,Italic")) {
                    this.m_widths = "[ 258 293 396 517 500 775 724 224 310 327\r\n  500 672 258 327 258 275 500 500 500 500\r\n  500 500 500 500 500 500 327 327 672 672\r\n  672 500 913 603 603 672 724 603 586 724\r\n  724 327 448 672 551 827 672 724 586 724\r\n  603 500 551 724 586 810 603 534 551 396\r\n  275 396 413 500 344 500 500 448 500 448\r\n  275 500 500 275 275 448 275 724 500 500\r\n  500 500 396 396 275 500 448 637 448 448\r\n  396 396 275 396 534 775 775 775 672 672\r\n  672 672 672 672 672 672 672 672 672 775\r\n  775 775 775 672 672 672 672 672 672 672\r\n  672 672 672 672 672 775 775 672 258 362\r\n  500 500 482 500 275 500 293 724 275 500\r\n  672 327 775 500 396 551 310 293 344 568\r\n  517 258 327 293 310 500 758 758 758 500\r\n  603 603 603 603 603 603 896 672 603 603\r\n  603 603 327 327 327 327 724 672 724 724\r\n  724 724 724 672 724 724 724 724 724 534\r\n  603 500 500 500 500 500 500 500 672 448\r\n  448 448 448 448 275 275 275 275 500 500\r\n  500 500 500 500 500 551 500 500 500 500\r\n  500 448 500 448 ]";
                    this.m_flags = 98;
                    this.m_fontBBox = "[ -250 -216 1097 1040 ]";
                    this.m_missingWidth = 397;
                    this.m_stemV = 73;
                    this.m_stemH = 73;
                    this.m_italicAngle = -11;
                    this.m_capHeight = 891;
                    this.m_xHeight = 446;
                    this.m_ascent = 891;
                    this.m_descent = -216;
                    this.m_leading = 149;
                    this.m_maxWidth = 914;
                    this.m_avgWidth = 402;
                } else if (this.m_baseName.equalsIgnoreCase("TimesNewRoman,BoldItalic")) {
                    this.m_widths = "[ 258 362 551 500 500 844 775 275 327 327\r\n  500 568 258 327 258 275 500 500 500 500\r\n  500 500 500 500 500 500 327 327 568 568\r\n\t 568 500 827 672 672 672 724 672 672 724\r\n\t 775 396 500 672 603 896 724 724 603 724\r\n\t 672 551 603 724 655 896 672 620 603 327\r\n\t 275 327 568 500 327 500 500 448 500 448\r\n\t 327 500 551 275 275 500 275 793 551 500\r\n\t 500 500 396 396 275 551 448 672 500 448\r\n\t 396 344 224 344 568 775 775 775 568 568\r\n\t 568 568 568 568 568 568 568 568 568 775\r\n\t 775 775 775 568 568 568 568 568 568 568\r\n\t 568 568 568 568 568 775 775 568 258 362\r\n\t 500 500 500 500 224 500 327 758 258 500\r\n\t 603 327 741 500 396 551 310 310 327 568\r\n\t 500 258 327 293 293 500 758 758 758 500\r\n\t 672 672 672 672 672 672 948 672 672 672\r\n\t 672 672 396 396 396 396 724 724 724 724\r\n\t 724 724 724 568 724 724 724 724 724 620\r\n\t 603 500 500 500 500 500 500 500 724 448\r\n\t 448 448 448 448 275 275 275 275 500 551\r\n\t 500 500 500 500 500 551 500 551 551 551\r\n\t 551 448 500 448 ]";
                    this.m_flags = 16482;
                    this.m_fontBBox = "[ -250 -216 1138 1040 ]";
                    this.m_missingWidth = 328;
                    this.m_stemV = 131;
                    this.m_stemH = 131;
                    this.m_italicAngle = -11;
                    this.m_capHeight = 891;
                    this.m_xHeight = 446;
                    this.m_ascent = 891;
                    this.m_descent = -216;
                    this.m_leading = 149;
                    this.m_maxWidth = 948;
                    this.m_avgWidth = 412;
                }
            }
            PDFGen.this.m_fontList.addElement(this);
        }

        public String getFontType() {
            return this.m_fontType;
        }

        public String getEncoding() {
            return this.m_encoding;
        }

        public int getDescendantFontObjNum() {
            return this.m_descendantFontObjNum;
        }

        public String getCIDSystemInfo() {
            return this.m_CIDSystemInfo;
        }

        public String getStyle() {
            return this.m_style;
        }

        public boolean equals(Font f) {
            boolean match = false;
            String baseName = this.getBaseName(f);
            if (this.m_baseName.equals(baseName)) {
                match = true;
            }
            return match;
        }

        public String getBase() {
            return this.m_baseName;
        }

        private String getBaseName(Font f) {
            String baseName = "";
            String javaName = f.getName();
            String ft = this.getFontType();
            if (this.m_language.equalsIgnoreCase("ja_JP") || this.m_language.equalsIgnoreCase("ja")) {
                if (javaName.equalsIgnoreCase("SansSerif") || javaName.equalsIgnoreCase("Helvetica") || javaName.equalsIgnoreCase("Dialog") || javaName.equalsIgnoreCase("Monospaced") || javaName.equalsIgnoreCase("Courier") || javaName.equalsIgnoreCase("DialogInput")) {
                    baseName = "HeiseiKakuGo-W5";
                } else if (javaName.equalsIgnoreCase("Serif") || javaName.equalsIgnoreCase("TimesRoman")) {
                    baseName = "HeiseiMin-W3";
                }
                if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(",BoldItalic");
                } else if (f.isBold()) {
                    baseName = baseName.concat(",Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(",Italic");
                }
            } else if (this.m_language.equalsIgnoreCase("ko_KR") || this.m_language.equalsIgnoreCase("ko")) {
                if (javaName.equalsIgnoreCase("SansSerif") || javaName.equalsIgnoreCase("Helvetica") || javaName.equalsIgnoreCase("Dialog") || javaName.equalsIgnoreCase("Monospaced") || javaName.equalsIgnoreCase("Courier") || javaName.equalsIgnoreCase("DialogInput")) {
                    baseName = "HYGoThic-Medium";
                } else if (javaName.equalsIgnoreCase("Serif") || javaName.equalsIgnoreCase("TimesRoman")) {
                    baseName = "HYSMyeongJo-Medium";
                }
                if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(",BoldItalic");
                } else if (f.isBold()) {
                    baseName = baseName.concat(",Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(",Italic");
                }
            } else if (this.m_language.equalsIgnoreCase("zh_CN") || this.m_language.equalsIgnoreCase("zh")) {
                baseName = "STSong-Light";
                if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(",BoldItalic");
                } else if (f.isBold()) {
                    baseName = baseName.concat(",Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(",Italic");
                }
            } else if (this.m_language.equalsIgnoreCase("zh_TW")) {
                if (javaName.equalsIgnoreCase("SansSerif") || javaName.equalsIgnoreCase("Helvetica") || javaName.equalsIgnoreCase("Dialog") || javaName.equalsIgnoreCase("Monospaced") || javaName.equalsIgnoreCase("Courier") || javaName.equalsIgnoreCase("DialogInput")) {
                    baseName = "MHei-Medium";
                } else if (javaName.equalsIgnoreCase("Serif") || javaName.equalsIgnoreCase("TimesRoman")) {
                    baseName = "MSung-Light";
                }
                if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(",BoldItalic");
                } else if (f.isBold()) {
                    baseName = baseName.concat(",Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(",Italic");
                }
            } else if (javaName.equalsIgnoreCase("Serif") || javaName.equalsIgnoreCase("TimesRoman")) {
                baseName = this.m_windows ? "TimesNewRoman" : "Times-";
                if (f.isPlain() && !this.m_windows) {
                    baseName = baseName.concat("Roman");
                } else if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(this.m_windows ? ",BoldItalic" : "BoldOblique");
                } else if (f.isBold()) {
                    baseName = baseName.concat(this.m_windows ? ",Bold" : "Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(this.m_windows ? ",Italic" : "Oblique");
                }
            } else if (javaName.equalsIgnoreCase("SansSerif") || javaName.equalsIgnoreCase("Helvetica") || javaName.equalsIgnoreCase("Dialog")) {
                baseName = this.m_windows ? "Arial" : "Helvetica";
                if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(this.m_windows ? ",BoldItalic" : "-BoldOblique");
                } else if (f.isBold()) {
                    baseName = baseName.concat(this.m_windows ? ",Bold" : "-Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(this.m_windows ? ",Italic" : "-Oblique");
                }
            } else if (javaName.equalsIgnoreCase("Monospaced") || javaName.equalsIgnoreCase("Courier") || javaName.equalsIgnoreCase("DialogInput")) {
                baseName = this.m_windows ? "CourierNew" : "Courier";
                if (f.isBold() && f.isItalic()) {
                    baseName = baseName.concat(this.m_windows ? ",BoldItalic" : "-BoldOblique");
                } else if (f.isBold()) {
                    baseName = baseName.concat(this.m_windows ? ",Bold" : "-Bold");
                } else if (f.isItalic()) {
                    baseName = baseName.concat(this.m_windows ? ",Italic" : "-Oblique");
                }
            } else {
                baseName = this.m_windows ? "CourierNew" : "Courier";
            }
            return baseName;
        }

        public String getName() {
            return this.m_name;
        }

        public int getObjNum() {
            return this.m_fontObjNum;
        }

        public int getFontDescriptorObjNum() {
            return this.m_fontDescObjNum;
        }

        public int getSize() {
            return this.m_font.getSize();
        }

        public void setSize(int size) {
            Font newFont;
            this.m_font = newFont = new Font(this.m_font.getName(), this.m_font.getStyle(), size);
        }

        public String getWidths() {
            return this.m_widths;
        }

        public int getFlags() {
            return this.m_flags;
        }

        public String getFontBBox() {
            return this.m_fontBBox;
        }

        public int getMissingWidth() {
            return this.m_missingWidth;
        }

        public int getStemV() {
            return this.m_stemV;
        }

        public int getStemH() {
            return this.m_stemH;
        }

        public int getItalicAngle() {
            return this.m_italicAngle;
        }

        public int getCapHeight() {
            return this.m_capHeight;
        }

        public int getXHeight() {
            return this.m_xHeight;
        }

        public int getAscent() {
            return this.m_ascent;
        }

        public int getDescent() {
            return this.m_descent;
        }

        public int getLeading() {
            return this.m_leading;
        }

        public int getMaxWidth() {
            return this.m_maxWidth;
        }

        public int getAvgWidth() {
            return this.m_avgWidth;
        }
    }
}

