/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

public class MultiPagePrintLayoutConstraints {
    public static final int SINGLE = 1;
    public static final int STATIC = 2;
    public static final int SCROLL = 4;
    public static final int NO_SCALE = 1;
    public static final int SCALE = 2;
    public static final int SCALE_PRESERVE = 4;
    private int mHowPrinted;
    private int mHowScaled;
    private int[] mExpandDirections;

    public MultiPagePrintLayoutConstraints() {
        this(1, 2);
    }

    public MultiPagePrintLayoutConstraints(int howPrinted) {
        this(howPrinted, 2);
    }

    public MultiPagePrintLayoutConstraints(int howPrinted, int howScaled) {
        this.setHowPrinted(howPrinted);
        this.setHowScaled(howScaled);
        this.setExpandDirections(new int[]{1, 3, 2, 4});
    }

    public int[] getExpandDirections() {
        return this.mExpandDirections;
    }

    public void setExpandDirections(int[] expandDirections) {
        if (expandDirections == null || expandDirections.length > 4) {
            throw new IllegalArgumentException("Expand direction order can include a max of 4 directions.");
        }
        for (int i = 0; i < expandDirections.length; ++i) {
            if (expandDirections[i] == 1 || expandDirections[i] == 3 || expandDirections[i] == 4 || expandDirections[i] == 2) continue;
            throw new IllegalArgumentException("Expand direction order must include SwingUtilities.TOP, BOTTOM, LEFT, or RIGHT values only.");
        }
        this.mExpandDirections = expandDirections;
    }

    protected int getHowPrinted() {
        return this.mHowPrinted;
    }

    protected void setHowPrinted(int howPrinted) {
        this.mHowPrinted = howPrinted;
    }

    protected int getHowScaled() {
        return this.mHowScaled;
    }

    protected void setHowScaled(int howScaled) {
        this.mHowScaled = howScaled;
    }
}

