/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.ModelInterface;
import com.sas.awt.Dialog;
import com.sas.awt.print.Annotation;
import com.sas.awt.print.AnnotationInterface;
import com.sas.awt.print.AnnotationToolbarElement;
import com.sas.awt.print.RB;
import com.sas.awt.util.Util;
import com.sas.collection.OrderedCollection;
import com.sas.collection.Pair;
import com.sas.collection.PropertyBagInterface;
import com.sas.collection.StaticPropertyBagInterface;
import com.sas.measures.Length;
import com.sas.table.CellStyle;
import com.sas.table.ColumnStyle;
import com.sas.table.DataCell;
import com.sas.table.FontStyle;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.TableException;
import com.sas.table.TableInterface;
import com.sas.table.TableView;
import com.sas.table.TextCell;
import com.sas.text.Message;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.ColorDialog;
import com.sas.visuals.FontDialog;
import com.sas.visuals.ImageView;
import com.sas.visuals.LabelView;
import com.sas.visuals.Resources;
import com.sas.visuals.Toolbar;
import com.sas.visuals.ToolbarButton;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;

class CustomAnnotationDialog
extends Dialog
implements TableInterface,
StaticColumnLabelInterface,
ActionListener {
    public static final String RB_KEY = "CustomAnnotationDialog.";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 64;
    protected static final int NUM_ROWS = 4;
    protected static final int NUM_COLUMNS = 3;
    protected TableView mTableView;
    protected Toolbar mToolbar;
    protected int mSelectedButton;
    protected OrderedCollection mCustomButtons;
    protected TransformInterface mCurrentTransform;
    protected AnnotationInterface mAnnotation;

    public CustomAnnotationDialog(Frame parent) {
        this(parent, (ModelInterface)null);
    }

    public CustomAnnotationDialog(Frame parent, ModelInterface model) {
        super(parent, "", true);
        this.setLayout(new BorderLayout(0, 10));
        Panel panel = new Panel(new BorderLayout(0, 6));
        LabelView label = new LabelView(RB.getStringResource(RB_KEY, "Instructions.txt"));
        label.initialize();
        label.setSize(new Dimension(500, 150));
        label.setFont(new Font("Dialog", 0, 12));
        label.setWordWrap(true);
        label.setResizeToFit(true);
        panel.add("North", label);
        this.mToolbar = new Toolbar(1);
        Image btnImg = Resources.getImage(CustomAnnotationDialog.class, (String)"res/Color.gif");
        ToolbarButton btn = new ToolbarButton(new ImageView(btnImg));
        this.mToolbar.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomAnnotationDialog.this.mTableView.commitModifiedCells();
                Frame parentFrame = Util.getParentFrame(CustomAnnotationDialog.this);
                ColorDialog d = new ColorDialog(parentFrame, true, false);
                d.pack();
                try {
                    Util.centerOver(d, parentFrame);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                d.setSelectedColor((Color)CustomAnnotationDialog.this.mTableView.getCurrentElement().getEffectiveStylePropertyValue("foregroundColor", null));
                d.setVisible(true);
                d.dispose();
                switch (d.getSelectedButton()) {
                    case 1: {
                        Color color = d.getSelectedColor();
                        Enumeration enumer = CustomAnnotationDialog.this.mTableView.getSelectedCells();
                        while (enumer.hasMoreElements()) {
                            DataCell cell = (DataCell)enumer.nextElement();
                            CustomAnnotationDialog.this.setCellColor(cell, color);
                            CustomAnnotationDialog.this.mAnnotation.setForeground(color, cell.getRow().getIndex(), CustomAnnotationDialog.this.getAlignment(cell.getColumn().getIndex()));
                        }
                        break;
                    }
                }
            }
        });
        btnImg = Resources.getImage(CustomAnnotationDialog.class, (String)"res/Font.gif");
        btn = new ToolbarButton(new ImageView(btnImg));
        this.mToolbar.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomAnnotationDialog.this.mTableView.commitModifiedCells();
                Frame parentFrame = Util.getParentFrame(CustomAnnotationDialog.this);
                FontDialog d = new FontDialog(parentFrame, true);
                d.pack();
                try {
                    Util.centerOver(d, parentFrame);
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
                FontStyle bag = new FontStyle();
                CustomAnnotationDialog.this.mTableView.getCurrentElement().getEffectiveStylePropertyBag("fontStyle", (PropertyBagInterface)bag, false);
                d.setSelectedFont(bag.getFont());
                d.setVisible(true);
                d.dispose();
                switch (d.getSelectedButton()) {
                    case 1: {
                        FontStyle fontStyle = new FontStyle();
                        Font font = d.getSelectedFont();
                        fontStyle.setFont(font);
                        Enumeration enumer = CustomAnnotationDialog.this.mTableView.getSelectedCells();
                        while (enumer.hasMoreElements()) {
                            DataCell cell = (DataCell)enumer.nextElement();
                            CustomAnnotationDialog.this.setCellFont(cell, fontStyle);
                            CustomAnnotationDialog.this.mAnnotation.setFont(font, cell.getRow().getIndex(), CustomAnnotationDialog.this.getAlignment(cell.getColumn().getIndex()));
                        }
                        break;
                    }
                }
            }
        });
        this.mToolbar.add(4);
        this.addToolbarButton("res/Date.gif", "{date}");
        this.addToolbarButton("res/Time.gif", "{time}");
        this.addToolbarButton("res/PageNumbers.gif", "{page}");
        this.mToolbar.add(4);
        panel.add("Center", this.mToolbar);
        this.mTableView = new TableView();
        this.mTableView.initialize();
        this.mTableView.setColumnsConformed(true);
        this.mTableView.getDefaultColumnStyle().setSize(new Length("1 px"));
        this.mTableView.getDefaultCellStyle().setActivationLevel(3);
        panel.add("South", this.mTableView);
        this.add("Center", panel);
        panel = new Panel(new BorderLayout());
        Panel buttonPanel = new Panel(new GridLayout(1, 2, 6, 0));
        Button button = new Button(Message.format((String)RB.getStringResource("okButton.txt"), (Object)"  ", (Object)"  "));
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomAnnotationDialog.this.getAnnotationInterface();
                CustomAnnotationDialog.this.setVisible(false);
                CustomAnnotationDialog.this.mSelectedButton = 1;
                CustomAnnotationDialog.this.mTableView.commitModifiedCells();
            }
        });
        button = new Button(Message.format((String)RB.getStringResource("cancelButton.txt"), (Object)"  ", (Object)"  "));
        buttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomAnnotationDialog.this.setVisible(false);
                CustomAnnotationDialog.this.mSelectedButton = 64;
            }
        });
        panel.add("East", buttonPanel);
        this.add("South", panel);
        this.setModelInterface(model);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CustomAnnotationDialog.this.mSelectedButton = 64;
                CustomAnnotationDialog.this.dispose();
            }
        });
    }

    @Override
    public synchronized void attachModel(ModelInterface model) {
        super.attachModel(model);
        if (model != null) {
            this.mAnnotation = (AnnotationInterface)((AnnotationInterface)model).clone();
            this.mTableView.setModelInterface((ModelInterface)this);
            this.mTableView.getDefaultCellStyle().set("activatedOnCurrent", Boolean.TRUE);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setHorizontalJustification(256);
            ColumnStyle columnStyle = new ColumnStyle();
            columnStyle.setDefaultCellStyle(cellStyle);
            this.mTableView.getColumn(2).setStyle((StaticPropertyBagInterface)columnStyle);
            cellStyle = new CellStyle();
            cellStyle.setHorizontalJustification(2);
            columnStyle = new ColumnStyle();
            columnStyle.setDefaultCellStyle(cellStyle);
            this.mTableView.getColumn(3).setStyle((StaticPropertyBagInterface)columnStyle);
            FontStyle fontStyle = new FontStyle();
            for (int i = 1; i <= this.mAnnotation.getLineCount(); ++i) {
                for (int j = 1; j <= 3; ++j) {
                    Color c;
                    Font f = this.mAnnotation.getFont(i, this.getAlignment(j));
                    if (f != null) {
                        fontStyle.setFont(f);
                        this.setCellFont(this.mTableView.getRow(i).getCell(j), fontStyle);
                    }
                    if ((c = this.mAnnotation.getForeground(i, this.getAlignment(j))) == null) continue;
                    this.setCellColor(this.mTableView.getRow(i).getCell(j), c);
                }
            }
            DataCell cell = this.mTableView.getRow(1).getCell(1);
            try {
                this.mTableView.setCurrentElement(cell);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.mTableView.select(cell, cell, false);
        }
    }

    @Override
    public synchronized void detachModel(ModelInterface model) {
        super.detachModel(model);
        this.mAnnotation = null;
        this.mTableView.setModelInterface(null);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.top += 8;
        insets.bottom += 8;
        insets.left += 8;
        insets.right += 8;
        return insets;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.mSelectedButton = 1;
            this.mTableView.requestFocus();
            try {
                TextCell cell = (TextCell)((DataCell)this.mTableView.getCurrentElement()).getView();
                cell.processFocusEvent(new FocusEvent(this.mTableView, 1005));
            }
            catch (TableException tableException) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    protected void addCustomToolbarButtons(OrderedCollection elements) {
        int count = elements.count();
        for (int i = 0; i < count; ++i) {
            ToolbarButton btn = new ToolbarButton();
            AnnotationToolbarElement elem = (AnnotationToolbarElement)elements.get(i);
            this.mToolbar.add(btn);
            btn.setName(elem.mText);
            btn.setDefaultIcon(elem.mIcon);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cnt = CustomAnnotationDialog.this.mCustomButtons.count();
                    for (int j = 0; j < cnt; ++j) {
                        Pair pair = (Pair)CustomAnnotationDialog.this.mCustomButtons.get(j);
                        if (pair.getFirst() != (ToolbarButton)e.getSource()) continue;
                        CustomAnnotationDialog.this.mCurrentTransform = (TransformInterface)pair.getSecond();
                        break;
                    }
                    CustomAnnotationDialog.this.insertText(((ToolbarButton)e.getSource()).getName());
                    if (CustomAnnotationDialog.this.mAnnotation != null && CustomAnnotationDialog.this.mCurrentTransform != null) {
                        CustomAnnotationDialog.this.mAnnotation.addTransformInterface(((ToolbarButton)e.getSource()).getName(), CustomAnnotationDialog.this.mCurrentTransform);
                    }
                }
            });
            if (this.mCustomButtons == null) {
                this.mCustomButtons = new OrderedCollection();
            }
            this.mCustomButtons.add((Object)new Pair((Object)btn, (Object)elem.mFormatter));
        }
        this.mToolbar.validate();
    }

    protected void removeCustomToolbarButtons() {
        if (this.mCustomButtons != null) {
            int count = this.mCustomButtons.count();
            for (int i = 0; i < count; ++i) {
                this.mToolbar.remove((ToolbarButton)((Pair)this.mCustomButtons.get(i)).getFirst());
            }
            this.mToolbar.validate();
        }
    }

    protected int getAlignment(int columnIndex) {
        return columnIndex == 1 ? 1 : (columnIndex == 2 ? 256 : 2);
    }

    protected void addToolbarButton(String imageName, String text) {
        Image btnImg = Resources.getImage(CustomAnnotationDialog.class, (String)imageName);
        ToolbarButton btn = new ToolbarButton(new ImageView(btnImg));
        this.mToolbar.add(btn);
        btn.setName(text);
        btn.addActionListener(this);
    }

    protected void setCellColor(DataCell cell, Color color) {
        CellStyle style = (CellStyle)cell.getStyle();
        if (style == null) {
            style = new CellStyle();
        }
        style.setForegroundColor(color);
        cell.setStyle((StaticPropertyBagInterface)style);
        cell.refresh(1);
    }

    protected void setCellFont(DataCell cell, FontStyle fontStyle) {
        CellStyle style = (CellStyle)cell.getStyle();
        if (style == null) {
            style = new CellStyle();
        }
        style.setFontStyle(fontStyle);
        cell.setStyle((StaticPropertyBagInterface)style);
        cell.refresh(1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.mCurrentTransform = null;
        this.insertText(((ToolbarButton)e.getSource()).getName());
        this.mTableView.requestFocus();
    }

    protected void insertText(String text) {
        try {
            TextCell cell = (TextCell)((DataCell)this.mTableView.getCurrentElement()).getView();
            StringBuffer buf = new StringBuffer(cell.getText());
            int caretPosition = cell.getCaretPosition();
            if (caretPosition == -1) {
                buf.append(text);
            } else {
                buf.insert(caretPosition, text);
            }
            cell.setText(buf.toString());
            cell.getCell().repaint();
            this.mTableView.commitModifiedCells();
        }
        catch (TableException tableException) {
            // empty catch block
        }
    }

    public int countColumns(int maxCount) throws TableException {
        return this.getColumnCount();
    }

    public int countRows(int maxCount) throws TableException {
        return this.getRowCount();
    }

    public Object getCell(int rowIndex, int columnIndex) throws TableException {
        int align = columnIndex == 1 ? 1 : (columnIndex == 2 ? 256 : 2);
        String s = this.mAnnotation.getMessage(rowIndex, align);
        return s == null ? "" : s;
    }

    public Object[][] getCells(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        throw new TableException("method getCells() not supported");
    }

    public Class getCellClass(int rowIndex, int columnIndex) throws TableException {
        try {
            return Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException e) {
            throw new TableException(e.getMessage());
        }
    }

    public Class[][] getCellClasses(int startRowIndex, int startColumnIndex, int rowCount, int columnCount) throws TableException {
        throw new TableException("method getCellClasses() not supported");
    }

    public Object[] getColumn(int index) throws TableException {
        throw new TableException("method getColumn() not supported");
    }

    public int getColumnCount() throws TableException {
        return 3;
    }

    public Object[] getRow(int index) throws TableException {
        throw new TableException("method getRow() not supported");
    }

    public int getRowCount() throws TableException {
        return 4;
    }

    public boolean isCellsModifiable() {
        return true;
    }

    public boolean isMultipleRowUpdateSupported() {
        return false;
    }

    public boolean isMultipleColumnUpdateSupported() {
        return false;
    }

    public void setCell(int rowIndex, int columnIndex, Object value) {
        this.mAnnotation.setMessage((String)value, rowIndex, this.getAlignment(columnIndex));
    }

    public void setCells(int startRowIndex, int startColumnIndex, int rowCount, int colCount, Object[][] values) throws TableException {
        throw new TableException("method setCells() not supported");
    }

    public void setColumn(int index, Object[] values) throws TableException {
        throw new TableException("method setColumn() not supported");
    }

    public void setRow(int index, Object[] values) throws TableException {
        throw new TableException("method setRow() not supported");
    }

    public Object getColumnLabel(int index) {
        String label;
        switch (index) {
            case 1: {
                label = RB.getStringResource(RB_KEY, "ColumnLabel.Left.txt");
                break;
            }
            case 2: {
                label = RB.getStringResource(RB_KEY, "ColumnLabel.Center.txt");
                break;
            }
            default: {
                label = RB.getStringResource(RB_KEY, "ColumnLabel.Right.txt");
            }
        }
        return label;
    }

    public Object[] getColumnLabels(int startIndex, int count) throws TableException {
        throw new TableException("method getColumnLabels() not supported");
    }

    public boolean isColumnsLabelSupported() {
        return false;
    }

    public boolean isColumnLabelsSupported() {
        return true;
    }

    public AnnotationInterface getAnnotationInterface() {
        return this.mAnnotation;
    }

    public int getSelectedButton() {
        return this.mSelectedButton;
    }

    public static void main(String[] argv) {
        Annotation annotation = new Annotation();
        annotation.setMessage("SAS Institute Inc.", 1, 1);
        annotation.setMessage("{date}", 1, 2);
        annotation.setMessage("My Document Title", 2, 256);
        CustomAnnotationDialog d = new CustomAnnotationDialog(new Frame(), (ModelInterface)annotation);
        d.pack();
        ((java.awt.Dialog)d).setTitle(RB.getStringResource(RB_KEY, "Title.Header.txt"));
        ((java.awt.Dialog)d).setVisible(true);
        System.exit(0);
    }
}

