/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt.print;

import com.sas.Component;
import com.sas.awt.print.AnnotationInterface;
import com.sas.awt.print.RB;
import com.sas.collection.OrderedCollection;
import com.sas.measures.Length;
import com.sas.util.Strings;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.Alignment;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Annotation
extends Component
implements Cloneable,
Serializable,
AnnotationInterface,
Alignment {
    static final long serialVersionUID = 2340978842470030599L;
    public static final String RB_KEY = "Annotation.";
    public static final String PAGE_VARIABLE = RB.getStringResource("Annotation.", "Page.txt");
    public static final String DATE_VARIABLE = RB.getStringResource("Annotation.", "Date.txt");
    public static final String TIME_VARIABLE = RB.getStringResource("Annotation.", "Time.txt");
    protected OrderedCollection mLeftMessages = new OrderedCollection();
    protected OrderedCollection mRightMessages = new OrderedCollection();
    protected OrderedCollection mCenterMessages = new OrderedCollection();
    protected OrderedCollection mLineAttributes = new OrderedCollection();
    protected static final Font defaultFont = new Font("serif", 0, 14);
    protected int mStartPageNumber = 1;
    private int mPageNumber = 1;
    protected int mVertJust;
    protected Color mColor;
    protected Font mFont;
    protected Length mTopMargin;
    protected Length mBottomMargin;
    protected Length mLeftMargin;
    protected Length mRightMargin;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    protected static DateFormat dateFormat = DateFormat.getDateInstance(1);
    protected static DateFormat timeFormat = DateFormat.getTimeInstance();
    protected Hashtable mFormatters;

    public Annotation() {
        this(null, null, null);
    }

    public Annotation(String leftMessage, String centerMessage, String rightMessage) {
        this(leftMessage, centerMessage, rightMessage, 0);
    }

    public Annotation(String leftMessage, String centerMessage, String rightMessage, int verticalJustification) {
        this.setTopMargin(new Length(0.0, "in"));
        this.setBottomMargin(new Length(0.0, "in"));
        this.setLeftMargin(new Length(0.0, "in"));
        this.setRightMargin(new Length(0.0, "in"));
        this.setMessage(leftMessage, 1, 1);
        this.setMessage(centerMessage, 1, 256);
        this.setMessage(rightMessage, 1, 2);
        this.setVerticalJustification(verticalJustification);
        this.mFormatters = new Hashtable();
    }

    @Override
    public void setMessage(String message, int lineNumber, int align) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("Invalid line number " + lineNumber + " provided to setMessage().");
        }
        new Element(message, --lineNumber, align).add();
    }

    @Override
    public void addTransformInterface(String text, TransformInterface formatter) {
        this.mFormatters.put(text, formatter);
    }

    public TransformInterface getTransformInterface(String text) {
        return (TransformInterface)this.mFormatters.get(text);
    }

    public Enumeration getTransformInterfaceKeys() {
        return this.mFormatters.keys();
    }

    public void removeTransformInterface(String text) {
        this.mFormatters.remove(text);
    }

    public void removeAllTransformInterfaces() {
        this.mFormatters.clear();
    }

    @Override
    public String getMessage(int lineNumber, int align) {
        String s = null;
        try {
            s = this.getElement(--lineNumber, align).getMessage();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return s;
    }

    @Override
    public void setForeground(Color color) {
        this.mColor = color;
    }

    @Override
    public void setForeground(Color color, int lineNumber) {
        ((Attributes)this.mLineAttributes.get((int)(--lineNumber))).mColor = color;
    }

    @Override
    public void setForeground(Color color, int lineNumber, int align) {
        try {
            this.getElement(--lineNumber, align).setColor(color);
        }
        catch (NullPointerException e) {
            new Element("", lineNumber, align).add();
            this.setForeground(color, lineNumber, align);
        }
    }

    @Override
    public Color getForeground(int lineNumber, int align) {
        Color c;
        block2: {
            c = null;
            try {
                c = this.getElement(--lineNumber, align).getColor();
            }
            catch (NullPointerException e) {
                c = ((Attributes)this.mLineAttributes.get((int)lineNumber)).mColor;
                if (c != null) break block2;
                c = this.mColor;
            }
        }
        return c;
    }

    @Override
    public void setFont(Font font) {
        this.mFont = font;
    }

    @Override
    public void setFont(Font font, int lineNumber) {
        ((Attributes)this.mLineAttributes.get((int)(--lineNumber))).mFont = font;
    }

    @Override
    public void setFont(Font font, int lineNumber, int align) {
        try {
            this.getElement(--lineNumber, align).setFont(font);
        }
        catch (NullPointerException e) {
            new Element("", lineNumber, align).add();
            this.setFont(font, lineNumber, align);
        }
    }

    @Override
    public Font getFont(int lineNumber, int align) {
        Font f;
        block2: {
            f = null;
            try {
                f = this.getElement(--lineNumber, align).getFont();
            }
            catch (NullPointerException e) {
                f = ((Attributes)this.mLineAttributes.get((int)lineNumber)).mFont;
                if (f != null) break block2;
                f = this.mFont;
            }
        }
        return f;
    }

    @Override
    public void setTopMargin(Length margin) {
        this.mTopMargin = margin;
    }

    @Override
    public Length getTopMargin() {
        return this.mTopMargin;
    }

    @Override
    public void setBottomMargin(Length margin) {
        this.mBottomMargin = margin;
    }

    @Override
    public Length getBottomMargin() {
        return this.mBottomMargin;
    }

    @Override
    public void setLeftMargin(Length margin) {
        this.mLeftMargin = margin;
    }

    @Override
    public Length getLeftMargin() {
        return this.mLeftMargin;
    }

    @Override
    public void setRightMargin(Length margin) {
        this.mRightMargin = margin;
    }

    @Override
    public Length getRightMargin() {
        return this.mRightMargin;
    }

    public int getStartPageNumber() {
        return this.mStartPageNumber;
    }

    @Override
    public String getText(int lineNumber, int align) {
        String s = null;
        try {
            s = this.getElement(--lineNumber, align).getText();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return s;
    }

    @Override
    public int getVerticalJustification() {
        return this.mVertJust;
    }

    @Override
    public void setVerticalJustification(int justification) {
        if (!(justification == 0 | justification == 1)) {
            throw new IllegalArgumentException("Invalid value specified in setVerticalJustification().");
        }
        this.mVertJust = justification;
    }

    @Override
    public int getLineCount() {
        return this.mLineAttributes.count();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("");
        boolean needComma = false;
        String s = this.getLine(1);
        if (!s.equals("")) {
            needComma = true;
            buf.append(s);
        }
        if (!(s = this.getLine(256)).equals("")) {
            if (needComma) {
                buf.append(", ");
            }
            needComma = true;
            buf.append(s);
        }
        if (!(s = this.getLine(2)).equals("")) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(s);
        }
        if (buf.toString().equals("")) {
            return RB.getStringResource("PageSetupDialog.", "annotation.none.txt");
        }
        return buf.toString();
    }

    protected String getLine(int align) {
        StringBuffer buf = new StringBuffer("");
        String lineSep = System.getProperty("line.separator");
        boolean needLineFeed = false;
        int count = this.getLineCount();
        for (int i = 1; i <= count; ++i) {
            String s = this.getText(i, align);
            if (s != null && !s.equals("")) {
                if (needLineFeed) {
                    buf.append(lineSep);
                }
                buf.append(s);
            }
            needLineFeed = true;
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        Annotation annotation = (Annotation)o;
        boolean rc = false;
        if (annotation != null) {
            if (annotation != this) {
                if (this.getTopMargin().getMagnitude((Object)"in") != annotation.getTopMargin().getMagnitude((Object)"in") || this.getBottomMargin().getMagnitude((Object)"in") != annotation.getBottomMargin().getMagnitude((Object)"in") || this.getLeftMargin().getMagnitude((Object)"in") != annotation.getLeftMargin().getMagnitude((Object)"in") || this.getRightMargin().getMagnitude((Object)"in") != annotation.getRightMargin().getMagnitude((Object)"in")) {
                    return false;
                }
                if (this.toString().equals(annotation.toString())) {
                    rc = true;
                } else if (this.mLeftMessages.count() == annotation.mLeftMessages.count() && this.mCenterMessages.count() == annotation.mCenterMessages.count() && this.mRightMessages.count() == annotation.mRightMessages.count()) {
                    Element e2;
                    Element e1;
                    int i;
                    int count = this.mLeftMessages.count();
                    for (i = 0; i < count && ((e1 = (Element)this.mLeftMessages.get(i)) == (e2 = (Element)annotation.mLeftMessages.get(i)) || e1 != null && e1.equals(e2)); ++i) {
                    }
                    if (i == count) {
                        count = this.mCenterMessages.count();
                        for (i = 0; i < count && ((e1 = (Element)this.mCenterMessages.get(i)) == (e2 = (Element)annotation.mCenterMessages.get(i)) || e1 != null && e1.equals(e2)); ++i) {
                        }
                        if (i == count) {
                            count = this.mRightMessages.count();
                            for (i = 0; i < count && ((e1 = (Element)this.mRightMessages.get(i)) == (e2 = (Element)annotation.mRightMessages.get(i)) || e1 != null && e1.equals(e2)); ++i) {
                            }
                            if (i == count && annotation.mFormatters.size() == this.mFormatters.size()) {
                                rc = true;
                                Enumeration enumer = this.mFormatters.keys();
                                while (enumer.hasMoreElements()) {
                                    String key = (String)enumer.nextElement();
                                    if (annotation.mFormatters.containsKey(key)) {
                                        if (this.mFormatters.get(key) == annotation.mFormatters.get(key)) continue;
                                        rc = false;
                                    } else {
                                        rc = false;
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
            } else {
                rc = true;
            }
        }
        return rc;
    }

    protected final OrderedCollection getCollection(int align) {
        return align == 1 ? this.mLeftMessages : (align == 256 ? this.mCenterMessages : (align == 2 ? this.mRightMessages : null));
    }

    @Override
    public Object clone() {
        try {
            Annotation annotation = (Annotation)super.clone();
            annotation.mLeftMessages = this.copyElements(this.mLeftMessages);
            annotation.mCenterMessages = this.copyElements(this.mCenterMessages);
            annotation.mRightMessages = this.copyElements(this.mRightMessages);
            int count = this.mLineAttributes.count();
            for (int i = 0; i < count; ++i) {
                annotation.mLineAttributes.set(i, ((Attributes)this.mLineAttributes.get(i)).clone());
            }
            annotation.mTopMargin = (Length)this.mTopMargin.clone();
            annotation.mBottomMargin = (Length)this.mBottomMargin.clone();
            annotation.mLeftMargin = (Length)this.mLeftMargin.clone();
            annotation.mRightMargin = (Length)this.mRightMargin.clone();
            return annotation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected final Element getElement(int line, int align) {
        Element e = null;
        try {
            e = (Element)this.getCollection(align).get(line);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return e;
    }

    protected OrderedCollection copyElements(OrderedCollection inCollection) {
        OrderedCollection out = new OrderedCollection();
        int count = inCollection.count();
        for (int i = 0; i < count; ++i) {
            try {
                out.add(((Element)inCollection.get(i)).clone());
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return out;
    }

    class Element
    implements Cloneable,
    Serializable {
        private int mLineNumber;
        private int mAlignment;
        private String mMessage;
        private Attributes mAttributes;

        public Element(String message, int lineNumber, int align) {
            this.mAttributes = new Attributes();
            this.setMessage(message);
            this.mLineNumber = lineNumber;
            this.mAlignment = align;
        }

        public void add() {
            OrderedCollection coll;
            int count = Annotation.this.mLineAttributes.count();
            if (this.mLineNumber + 1 > count) {
                Annotation.this.mLineAttributes.setSize(this.mLineNumber + 1);
                for (int i = count; i <= this.mLineNumber; ++i) {
                    Annotation.this.mLineAttributes.set(i, (Object)new Attributes());
                }
            }
            if (this.mLineNumber + 1 > (coll = Annotation.this.getCollection(this.mAlignment)).count()) {
                coll.setSize(this.mLineNumber + 1);
            }
            coll.set(this.mLineNumber, (Object)this);
        }

        public void setMessage(String message) {
            this.mMessage = message;
        }

        public String getMessage() {
            return this.mMessage;
        }

        public void setColor(Color color) {
            this.mAttributes.mColor = color;
        }

        public Color getColor() {
            Color color = this.mAttributes.mColor;
            if (color == null && (color = ((Attributes)Annotation.this.mLineAttributes.get((int)this.mLineNumber)).mColor) == null) {
                color = Annotation.this.mColor;
            }
            return color;
        }

        public void setFont(Font font) {
            this.mAttributes.mFont = font;
        }

        public Font getFont() {
            Font font = this.mAttributes.mFont;
            if (font == null && (font = ((Attributes)Annotation.this.mLineAttributes.get((int)this.mLineNumber)).mFont) == null) {
                font = Annotation.this.mFont;
            }
            return font;
        }

        public String getText() {
            String message = this.mMessage;
            Enumeration keys = Annotation.this.mFormatters.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                TransformInterface t = (TransformInterface)Annotation.this.mFormatters.get(key);
                try {
                    String s = (String)t.transform((Object)key);
                    message = Strings.replace((String)message, (int)0, (int)-1, (String)key, (String)s);
                }
                catch (TransformException transformException) {}
            }
            message = Strings.replace((String)message, (int)0, (int)-1, (String)PAGE_VARIABLE, (String)Integer.toString(Annotation.this.mPageNumber));
            Date now = new Date();
            message = Strings.replace((String)message, (int)0, (int)-1, (String)DATE_VARIABLE, (String)dateFormat.format(now));
            message = Strings.replace((String)message, (int)0, (int)-1, (String)TIME_VARIABLE, (String)timeFormat.format(now));
            return message;
        }

        public Object clone() {
            try {
                Element elem = (Element)super.clone();
                elem.mAttributes = (Attributes)this.mAttributes.clone();
                return elem;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean equals(Element element) {
            boolean rc = false;
            if (element != null) {
                rc = element == this ? true : this.mLineNumber == element.mLineNumber && this.mAlignment == element.mLineNumber && this.mMessage.equals(element.mMessage) && this.mAttributes.equals(element.mAttributes);
            }
            return rc;
        }
    }

    class Attributes
    implements Cloneable,
    Serializable {
        public Color mColor;
        public Font mFont;

        Attributes() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean equals(Attributes attributes) {
            boolean rc = false;
            if (attributes != null) {
                rc = attributes == this ? true : attributes.mColor.equals(this.mColor) && attributes.mFont.equals(this.mFont);
            }
            return rc;
        }
    }
}

