/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.TextAreaVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.util.Strings;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.util.validators.ValidatorInterface;
import java.awt.Container;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextArea
extends TextAreaVisualComponent
implements ContentsChangedListener,
PublicClonable,
ValidatorInterface,
ViewDefaultModelInterface,
StringDataInterface {
    private boolean keystrokeUpdate;
    private boolean doSuper;
    private boolean columnFlag;
    private boolean autoHighlight;
    private transient boolean setStartLocation;
    private transient boolean mouseDragged;
    private transient int startLocation = 0;
    private int oldSelStart = 0;
    private int oldSelEnd = 0;
    private int oldCaret;
    private String oldSText;
    private String previousText;
    private int versionNumber = 1;
    private boolean selectRowText;
    private ValidationInterface validator;
    private ErrorHandlerInterface errorHandler;
    private boolean isValid;
    private transient Object setTextOnModelLock;
    private transient boolean inSetTextOnModel;
    protected TransformInterface displayTransform;
    protected TransformInterface inputTransform;
    protected TransformInterface outputTransform;
    protected transient int currentCaretRow = 0;
    protected transient String currentCaretRowText = null;
    protected transient int currentRowCount = 0;
    protected transient int caretRowBeforeDoubleClick = 0;
    protected StringData defaultModel = null;
    static final long serialVersionUID = 4657196121305472477L;
    public static final String RB_KEY = "TextArea.";
    private static String[] requiredInterfacesString1 = new String[]{"com.sas.lang.StringDataInterface"};
    private static String[] requiredInterfacesString2 = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    private static boolean sizeSetFromConstructor;
    private static int constructorColumns;
    private static int constructorRows;
    static int defaultWidth;
    static int defaultHeight;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "displayTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "inputTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "outputTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "autoHighlight"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.autoHighlight.pd.txt")}}, {{"Name", "caretPosition"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.caretPosition.pd.txt")}}, {{"Name", "columns"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.columns.pd.txt")}}, {{"Name", "editable"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.editable.pd.txt")}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "keystrokeUpdate"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.keystrokeUpdate.pd.txt")}}, {{"Name", "rows"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"rows.pd.txt")}}, {{"Name", "scrollbarVisibility"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"scrollbarVisibility.pd.txt")}}, {{"Name", "selectedText"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.selectedText.pd.txt")}}, {{"Name", "selectionEnd"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.selectionEnd.pd.txt")}}, {{"Name", "selectionStart"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.selectionStart.pd.txt")}}, {{"Name", "selectRowText"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"selectRowText.pd.txt")}}, {{"Name", "text"}, {"Description", com.sas.awt.RB.getStringResource((String)"TextComponent.text.pd.txt")}, {"Property editor class", "com.sas.beans.editors._TextEditor"}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public TextArea() {
        this.initializeComponent();
        this.enableEvents(60L);
    }

    public TextArea(String text) {
        this();
        this.setText(text);
    }

    public TextArea(int rows, int columns) {
        super(rows, columns);
        this.initializeComponent();
        this.enableEvents(60L);
    }

    public TextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.initializeComponent();
        this.enableEvents(60L);
    }

    public TextArea(String text, int rows, int columns, int scrollbars) {
        super(text, rows, columns, scrollbars);
        this.initializeComponent();
        this.enableEvents(60L);
    }

    @Override
    public void append(String str) {
        if (str != null && this.getModelInterface() != null) {
            String text = super.getText() + str;
            super.append(str);
            this.doSuper = false;
            this.setTextOnModel(text);
            if (com.sas.util.Util.unequal((Object)this.previousText, (Object)text)) {
                this.firePropertyChange("text", this.previousText, text);
            }
            this.previousText = text;
            this.doSuper = true;
            if (this.getSelectedText() != null && this.getSelectedText().length() > 0) {
                this.select(0, 0);
                this.sendTextEvents();
            }
        }
    }

    @Override
    public void attachModel(ModelInterface model) {
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
        }
        if (!(model instanceof StringDataInterface) && !(model instanceof OrderedCollectionInterface)) {
            this.setEditable(false);
        }
        super.attachModel(model);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            TextArea clone = (TextArea)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setText(this.getText());
            clone.setEditable(this.isEditable());
            clone.setSelectionStart(this.getSelectionStart());
            clone.setSelectionEnd(this.getSelectionEnd());
            clone.setCaretPosition(this.getCaretPosition());
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                StringData clonedModel = (StringData)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    public void contentsChanged(ContentsChangedEvent evt) {
        this.refresh();
    }

    protected int countRows() {
        String text = this.getText();
        int rows = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++rows;
        }
        return rows;
    }

    public void delete(int start, int end) {
        this.replaceRange("", start, end);
    }

    public void deselectAll() {
        if (this.getSelectedText() != null && com.sas.util.Util.unequal((Object)this.getSelectedText(), (Object)"")) {
            this.select(0, 0);
            this.sendTextEvents();
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.defaultModel.setText(null);
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    public int getCaretRow() {
        String testText = this.getText();
        if ((testText = testText.substring(0, this.getCaretPosition())).length() > 0) {
            int[] pos = Strings.positions((String)testText, (int)0, (int)-1, (String)"\n", (boolean)false);
            return pos.length;
        }
        return 0;
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public ErrorHandlerInterface getErrorHandler() {
        return this.errorHandler;
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(2);
        requiredInterfaces.addElement(requiredInterfacesString1);
        requiredInterfaces.addElement(requiredInterfacesString2);
        return requiredInterfaces;
    }

    public String getRowText(int row) {
        String text = this.getText();
        if (text != null && text.length() > 0) {
            int[] pos = Strings.positions((String)text, (int)0, (int)-1, (String)"\n", (boolean)false);
            if (pos.length > 0) {
                int maxPosition = pos.length - 1;
                if (row == 0) {
                    return text.substring(0, pos[0]);
                }
                if (row >= pos.length) {
                    if (text.length() - 1 > pos[maxPosition]) {
                        return text.substring(pos[maxPosition] + 1);
                    }
                    return "";
                }
                return text.substring(pos[row - 1] + 1, pos[row]);
            }
            return text;
        }
        return "";
    }

    public ValidationInterface getValidator() {
        return this.validator;
    }

    protected void handleError() {
        ErrorHandlerInterface handler = this.getErrorHandler();
        for (Container parent = this.getParent(); handler == null && parent != null && parent instanceof ValidatorInterface; parent = parent.getParent()) {
            handler = ((ValidatorInterface)parent).getErrorHandler();
        }
        if (handler != null) {
            handler.handleError((ComponentInterface)this, this.validator.getValidationMessage(), this.validator.getValidationMessageCode());
        }
    }

    public boolean isSelectRowText() {
        return this.selectRowText;
    }

    @Override
    public boolean isValid() {
        if (this.validator != null) {
            return this.validator.validateValue((Object)this, (Object)this.getText());
        }
        return true;
    }

    private void highlightRowText() {
        if (this.isSelectRowText()) {
            String text = this.getText();
            int currentCaretPos = this.getCaretPosition();
            if (text != null && text.length() > 0 && this.getCaretRow() <= this.countRows() - 1) {
                String subtext = this.getRowText(this.getCaretRow());
                if (subtext != null && subtext.length() > 0) {
                    int[] pos = Strings.positions((String)text, (int)0, (int)-1, (String)"\n", (boolean)false);
                    if (pos.length > 0) {
                        if (this.getCaretRow() == 0) {
                            this.select(0, pos[0]);
                        } else {
                            this.select(pos[this.getCaretRow() - 1] + 1, pos[this.getCaretRow()]);
                        }
                    } else {
                        this.selectAll();
                    }
                } else {
                    this.select(currentCaretPos, currentCaretPos);
                }
            } else {
                this.select(currentCaretPos, currentCaretPos);
            }
        }
    }

    @Override
    public void insert(String str, int pos) {
        if (str != null && this.getModelInterface() != null) {
            String text = "";
            text = pos > this.getText().length() ? this.getText() + str : (pos < 0 ? str + this.getText() : this.getText().substring(0, pos) + str + this.getText().substring(pos));
            this.setTextOnModel(text);
            if (this.getSelectedText() != null && this.getSelectedText().length() > 0) {
                this.select(0, 0);
                this.sendTextEvents();
            }
        }
    }

    public boolean isAutoHighlight() {
        return this.autoHighlight;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isKeystrokeUpdate() {
        return this.keystrokeUpdate;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            if (e.getID() == 1005) {
                if (model instanceof StringDataInterface) {
                    if (this.getText() != null && this.getText().length() > 0 && com.sas.util.Util.unequal((Object)this.previousText, (Object)this.getText())) {
                        this.setTextOnModel(this.getText());
                    }
                    if (this.autoHighlight) {
                        this.deselectAll();
                    }
                } else if (model instanceof OrderedCollectionInterface) {
                    this.updateOrderedCollectionModel(this.getText());
                }
            } else if (e.getID() == 1004 && this.autoHighlight) {
                this.selectAll();
            }
        }
        super.processFocusEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 402) {
            ModelInterface model = this.getModelInterface();
            if (com.sas.util.Util.unequal((Object)this.oldSText, (Object)"")) {
                this.sendTextEvents();
            }
            if (this.oldCaret != this.getCaretPosition()) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("caretPosition", new Integer(this.oldCaret), new Integer(this.getCaretPosition()));
                }
                this.oldCaret = this.getCaretPosition();
            }
            String newText = this.getText();
            if (e.getKeyCode() == 10) {
                super.processKeyEvent(e);
                if (model != null) {
                    this.doSuper = false;
                    if (model instanceof StringDataInterface) {
                        if (com.sas.util.Util.unequal((Object)this.previousText, (Object)newText)) {
                            this.setTextOnModel(newText);
                            String text = null;
                            if (model instanceof StringDataInterface) {
                                text = ((StringDataInterface)model).getText();
                            }
                            if (com.sas.util.Util.unequal((Object)text, (Object)this.getText())) {
                                newText = text;
                                super.setText(null);
                                super.append(text);
                            }
                            this.firePropertyChange("text", this.previousText, newText);
                            this.previousText = newText;
                        }
                    } else if (model instanceof OrderedCollectionInterface) {
                        this.updateCaretPosition();
                        this.firePropertyChange("text", this.previousText, newText);
                        this.previousText = newText;
                    }
                    this.doSuper = true;
                } else {
                    this.firePropertyChange("text", null, newText);
                }
            } else {
                this.doSuper = false;
                char checkKey = e.getKeyChar();
                super.processKeyEvent(e);
                if (this.isKeystrokeUpdate() && checkKey != '\uffff') {
                    if (model instanceof StringDataInterface) {
                        if (com.sas.util.Util.unequal((Object)this.previousText, (Object)newText)) {
                            this.setTextOnModel(newText);
                            String text = ((StringDataInterface)model).getText();
                            if (com.sas.util.Util.unequal((Object)text, (Object)this.getText())) {
                                newText = text;
                                super.setText(null);
                                super.append(text);
                            }
                            this.firePropertyChange("text", this.previousText, newText);
                            this.previousText = newText;
                        }
                    } else if (model instanceof OrderedCollectionInterface) {
                        this.setTextOnModel(newText);
                        this.firePropertyChange("text", this.previousText, newText);
                        this.previousText = newText;
                    }
                } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    this.updateCaretPosition();
                }
                this.doSuper = true;
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        ModelInterface model = this.getModelInterface();
        if (e.getID() == 502 && this.mouseDragged) {
            String text = this.getText();
            if (text != null) {
                boolean oneRowOnly = true;
                int i = 0;
                for (i = 0; i < text.length(); ++i) {
                    if (text.charAt(i) != '\n') continue;
                    oneRowOnly = false;
                    break;
                }
                if (oneRowOnly) {
                    int newSelStart = this.startLocation;
                    if (this.getCaretPosition() >= this.startLocation) {
                        super.setSelectionStart(this.startLocation);
                    } else {
                        super.setSelectionStart(this.getCaretPosition());
                        super.setSelectionEnd(newSelStart);
                    }
                    super.select(this.getSelectionStart(), this.getSelectionEnd());
                    this.sendTextEvents();
                    this.setStartLocation = true;
                    this.mouseDragged = false;
                } else {
                    this.sendTextEvents();
                    this.setStartLocation = true;
                    this.mouseDragged = false;
                }
            } else {
                this.sendTextEvents();
                this.setStartLocation = true;
                this.mouseDragged = false;
            }
        } else if (e.getID() == 500) {
            if (model instanceof StringDataInterface) {
                if (this.isSelectRowText() && this.currentCaretRow != this.getCaretRow()) {
                    this.highlightRowText();
                    this.updateCaretPosition();
                } else if (this.oldSText.length() > 0) {
                    this.sendTextEvents();
                }
            } else if (model instanceof OrderedCollectionInterface) {
                this.updateCaretPosition();
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506) {
            String text = this.getText();
            boolean oneRowOnly = true;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\n') continue;
                oneRowOnly = false;
                break;
            }
            if (this.setStartLocation) {
                this.mouseDragged = true;
                this.startLocation = this.getCaretPosition();
                this.setStartLocation = false;
            }
        }
        super.processMouseMotionEvent(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"text") || com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"items")) {
            this.refresh();
        }
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            StaticOrderedCollectionInterface collection;
            String text = "";
            if (model instanceof StringDataInterface) {
                text = ((StringDataInterface)model).getText();
            } else if (model instanceof StaticOrderedCollectionInterface && (collection = (StaticOrderedCollectionInterface)model).count() > 0) {
                Enumeration e = collection.getItems();
                while (e.hasMoreElements()) {
                    Object item = e.nextElement();
                    TransformInterface transform = this.getDisplayTransform();
                    if (transform != null) {
                        try {
                            item = transform.transform(item);
                        }
                        catch (TransformException transformException) {
                            // empty catch block
                        }
                    }
                    text = text + item.toString() + "\n";
                }
            }
            if (text == null) {
                text = "";
            }
            if (com.sas.util.Util.unequal((Object)text, (Object)this.previousText) && this.doSuper) {
                super.setText(text);
                this.firePropertyChange("text", this.previousText, text);
                this.previousText = text;
            }
            if (com.sas.util.Util.unequal((Object)this.oldSText, (Object)"") && com.sas.util.Util.unequal((Object)text, (Object)"")) {
                int startpos = text.indexOf(this.oldSText);
                super.select(startpos, startpos + this.oldSText.length());
            }
        }
    }

    @Override
    public void refresh(ModelInterface Model) {
        if (Model == null) {
            this.setText(null);
        } else {
            this.refresh();
        }
    }

    @Override
    public void replaceRange(String str, int start, int end) {
        if (str != null && this.getModelInterface() != null) {
            if (com.sas.util.Util.equal((Object)str, (Object)"") && start < 0) {
                return;
            }
            String text = null;
            text = start < 0 && com.sas.util.Util.unequal((Object)str, (Object)"") ? str + this.getText() : (end > this.getText().length() || end < 0 ? this.getText().substring(0, start) + str : (end < start ? this.getText().substring(0, end) + str + this.getText().substring(start) : this.getText().substring(0, start) + str + this.getText().substring(end)));
            this.setTextOnModel(text);
            if (this.getSelectedText() != null && this.getSelectedText().length() > 0) {
                this.select(0, 0);
                this.sendTextEvents();
            }
        }
    }

    @Override
    public void select(int selectionStart, int selectionEnd) {
        if (this.getText() != null && this.getText().length() > 0) {
            super.select(selectionStart, selectionEnd);
        }
    }

    @Override
    public void selectAll() {
        super.selectAll();
        this.sendTextEvents();
    }

    private void sendTextEvents() {
        String test = this.getSelectedText();
        if (test == null) {
            test = "";
        }
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int caret = this.getCaretPosition();
        String text = this.getText();
        int textLength = text.length();
        int[] pos = Strings.positions((String)text, (int)0, (int)-1, (String)"\n", (boolean)false);
        if (pos.length > 0 && start < textLength) {
            int i;
            int endcount = 0;
            int count = 0;
            for (i = 0; i < pos.length && start > pos[i]; ++i) {
                ++count;
            }
            for (i = 0; i < pos.length && end > pos[i]; ++i) {
                ++endcount;
            }
            for (i = 0; i < pos.length; ++i) {
                if (end - pos[i] != 1) continue;
                endcount = 1;
                break;
            }
            start -= count;
            caret -= count;
            end -= endcount;
        }
        if (end > textLength) {
            end = textLength;
        }
        if (start > textLength) {
            start = textLength;
        }
        if (com.sas.util.Util.unequal((Object)this.oldSText, (Object)test)) {
            this.firePropertyChange("selectedText", this.oldSText, test);
            this.oldSText = test;
            if (this.oldSelStart != start) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("selectionStart", new Integer(this.oldSelStart), new Integer(this.getSelectionStart()));
                }
                this.oldSelStart = start;
            }
            if (this.oldSelEnd != end) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("selectionEnd", new Integer(this.oldSelEnd), new Integer(this.getSelectionEnd()));
                }
                this.oldSelEnd = end;
            }
            if (this.oldCaret != caret) {
                if (this.anyPropertyChangeListeners()) {
                    this.firePropertyChange("caretPosition", new Integer(this.oldCaret), new Integer(this.getCaretPosition()));
                }
                this.oldCaret = caret;
            }
        }
    }

    public void setAutoHighlight(boolean value) {
        if (value != this.autoHighlight) {
            this.autoHighlight = value;
            this.firePropertyChange("autoHighlight", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setCaretPosition(int position) {
        if (this.getCaretPosition() != position) {
            int oldCaret = this.getCaretPosition();
            if (this.getPeer() != null) {
                super.setCaretPosition(position);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("caretPosition", new Integer(oldCaret), new Integer(position));
        }
    }

    @Override
    public void setColumns(int columns) {
        if (this.getColumns() != columns) {
            int oldCols = this.getColumns();
            super.setColumns(columns);
            if (columns != 0 && this.getRows() != 0) {
                this.setSize(this.getPreferredSize(this.getRows(), columns));
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("columns", new Integer(oldCols), new Integer(columns));
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString1);
        requiredInterfaces.addElement(requiredInterfacesString2);
        this.setRequiredInterfaces(requiredInterfaces);
        this.displayTransform = null;
        this.inputTransform = null;
        this.outputTransform = null;
        this.validator = null;
        this.setTextOnModelLock = new Object();
        this.defaultModel = new StringData();
        String model_text = "";
        this.defaultModel.initialize();
        if (super.getText() != null) {
            model_text = super.getText();
        }
        this.defaultModel.setText(model_text);
        this.attachModel((ModelInterface)this.defaultModel);
        this.setBackgroundColor(SystemColor.window);
        this.oldCaret = -1;
        this.oldSText = "";
        this.previousText = "";
        this.setStartLocation = true;
        this.doSuper = true;
    }

    public void setDisplayTransform(TransformInterface displayTransform) {
        if (this.displayTransform != displayTransform) {
            this.displayTransform = displayTransform;
            this.firePropertyChange("displayTransform", this.displayTransform, displayTransform);
        }
    }

    @Override
    public void setEditable(boolean t) {
        if (this.isEditable() != t) {
            super.setEditable(t);
            this.firePropertyChange("editable", t ? Boolean.FALSE : Boolean.TRUE, t ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setErrorHandler(ErrorHandlerInterface errorHandler) {
        this.errorHandler = errorHandler;
        this.firePropertyChange("errorHandler", null, errorHandler);
    }

    public void setKeystrokeUpdate(boolean value) {
        if (this.isKeystrokeUpdate() != value) {
            this.keystrokeUpdate = value;
            this.firePropertyChange("keystrokeUpdate", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setInputTransform(TransformInterface inputTransform) {
        if (this.inputTransform != inputTransform) {
            this.inputTransform = inputTransform;
            this.firePropertyChange("inputTransform", this.inputTransform, inputTransform);
        }
    }

    public void setOutputTransform(TransformInterface outputTransform) {
        if (this.outputTransform != outputTransform) {
            this.outputTransform = outputTransform;
            this.firePropertyChange("outputTransform", this.outputTransform, outputTransform);
        }
    }

    @Override
    public void setRows(int rows) {
        if (this.getRows() != rows) {
            int oldRows = this.getRows();
            super.setRows(rows);
            if (rows != 0 && this.getColumns() != 0) {
                this.setSize(this.getPreferredSize(rows, this.getColumns()));
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("rows", new Integer(oldRows), new Integer(rows));
        }
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        if (this.getSelectionEnd() != selectionEnd) {
            super.setSelectionEnd(selectionEnd);
            this.sendTextEvents();
        }
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        if (this.getSelectionStart() != selectionStart) {
            super.setSelectionStart(selectionStart);
            this.sendTextEvents();
        }
    }

    public void setSelectRowText(boolean value) {
        if (value != this.isSelectRowText()) {
            this.selectRowText = value;
            this.firePropertyChange("selectRowText", value ? Boolean.FALSE : Boolean.TRUE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setText(String text) {
        ModelInterface model;
        if (text == null) {
            text = "";
        }
        if ((this.getText() == null || com.sas.util.Util.unequal((Object)this.getText(), (Object)text)) && (model = this.getModelInterface()) != null) {
            boolean goodText = this.setTextOnModel(text);
            if (model instanceof StringDataInterface) {
                String modelText = ((StringDataInterface)this.getModelInterface()).getText();
                if (goodText && com.sas.util.Util.unequal((Object)this.getText(), (Object)text)) {
                    super.setText(text);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setTextOnModel(String text) {
        Object object = this.setTextOnModelLock;
        synchronized (object) {
            if (this.inSetTextOnModel) {
                return true;
            }
            this.inSetTextOnModel = true;
        }
        ModelInterface model = this.getModelInterface();
        if (this.validator == null) {
            if (model instanceof StringDataInterface) {
                this.isValid = true;
                this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
                ((StringDataInterface)model).setText(text);
                this.inSetTextOnModel = false;
                return true;
            }
            if (model instanceof OrderedCollectionInterface) {
                this.isValid = true;
                this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
                this.updateOrderedCollectionModel(text);
                this.inSetTextOnModel = false;
                return true;
            }
        } else {
            if (this.validator.validateValue((Object)this, (Object)text)) {
                text = (String)this.validator.normalizeValue((Object)this, (Object)text);
                if (model instanceof StringDataInterface) {
                    this.isValid = true;
                    this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
                    ((StringDataInterface)model).setText(text);
                    this.inSetTextOnModel = false;
                    return true;
                }
                if (model instanceof OrderedCollectionInterface) {
                    this.isValid = true;
                    this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
                    this.updateOrderedCollectionModel(text);
                    this.inSetTextOnModel = false;
                    return true;
                }
            }
            this.isValid = false;
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
            this.handleError();
        }
        this.previousText = "";
        this.inSetTextOnModel = false;
        return false;
    }

    public void setValidator(ValidationInterface validator) {
        this.validator = validator;
        this.firePropertyChange("validator", null, validator);
    }

    protected OrderedCollection transformStrings(String text) {
        OrderedCollection outputCollection = new OrderedCollection();
        outputCollection.initialize();
        StringTokenizer strToken = new StringTokenizer(text, "\n");
        while (strToken.hasMoreElements()) {
            Object element = strToken.nextElement();
            if (this.outputTransform != null) {
                try {
                    element = this.outputTransform.transform(element);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            outputCollection.add(element);
        }
        return outputCollection;
    }

    public void updateCaretPosition() {
        int newCaretRow;
        boolean updateNeeded = false;
        int rows = this.countRows();
        if (this.currentRowCount != rows) {
            this.currentRowCount = rows;
            updateNeeded = true;
        }
        if ((newCaretRow = this.getCaretRow()) != this.currentCaretRow) {
            String oldCaretRowText;
            if (this.anyPropertyChangeListeners()) {
                this.firePropertyChange("caretRow", new Integer(this.currentCaretRow), new Integer(newCaretRow));
            }
            if (com.sas.util.Util.unequal((Object)(oldCaretRowText = this.getRowText(this.currentCaretRow)), (Object)this.currentCaretRowText)) {
                updateNeeded = true;
            }
            this.currentCaretRow = newCaretRow;
            this.currentCaretRowText = this.getRowText(newCaretRow);
        }
        if (updateNeeded && this.isEditable()) {
            this.setTextOnModel(this.getText());
        } else if (this.isSelectRowText()) {
            this.highlightRowText();
        }
    }

    protected synchronized void updateOrderedCollectionModel(String text) {
        int caretPos = this.getCaretPosition();
        OrderedCollectionInterface collection = (OrderedCollectionInterface)this.getModelInterface();
        OrderedCollection transformedTextCollection = this.transformStrings(text);
        TransformInterface displayTransform = this.getDisplayTransform();
        if (com.sas.util.Util.unequal((Object)collection, (Object)transformedTextCollection)) {
            collection.removeAll();
            Enumeration localEnum = transformedTextCollection.getItems();
            while (localEnum.hasMoreElements()) {
                Object localObject = localEnum.nextElement();
                if (displayTransform != null) {
                    try {
                        localObject = displayTransform.transform(localObject);
                    }
                    catch (TransformException transformException) {
                        // empty catch block
                    }
                }
                if (displayTransform != null) {
                    try {
                        localObject = displayTransform.transform(localObject);
                    }
                    catch (TransformException transformException) {
                        // empty catch block
                    }
                }
                collection.add(localObject);
            }
        }
        this.setCaretPosition(caretPos);
        if (this.isSelectRowText()) {
            this.highlightRowText();
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        if (this.versionNumber == 0) {
            this.oldSText = "";
            this.oldCaret = -1;
            this.autoHighlight = false;
            this.versionNumber = 1;
        }
        this.setTextOnModelLock = new Object();
        this.setStartLocation = true;
        if (this.getRows() == 12 && TextArea.getDefaultHeight() == 124) {
            this.setRows(0);
        }
        if (this.getColumns() == 12 && TextArea.getDefaultWidth() == 124) {
            this.setColumns(0);
        }
    }

    static {
        defaultWidth = 124;
        defaultHeight = 124;
    }
}

