/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Vector;

public class ModalDispatchThread
extends Thread {
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static String name = "AWT-EventQueue-SASModal-";
    private static int count = 0;
    private Container container;
    private Vector childWindows = new Vector(10, 10);
    private Vector oldChildWindows = new Vector(10, 10);
    private static Class activeEventClass;
    private static Method dispatchMethod;

    public ModalDispatchThread(Container container) {
        super(name + count++);
        this.theQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        this.container = container;
    }

    public void stopDispatching() {
        this.doDispatch = false;
    }

    public void addChildWindow(Window w) {
        this.childWindows.addElement(w);
    }

    @Override
    public void run() {
        boolean srcIsAComponent = false;
        boolean isAChild = false;
        boolean isStrictAncestor = false;
        Component last = null;
        while (this.doDispatch) {
            try {
                AWTEvent event = this.theQueue.getNextEvent();
                Object src = event.getSource();
                srcIsAComponent = src instanceof Component;
                isAChild = false;
                isStrictAncestor = false;
                if (!srcIsAComponent && event instanceof InputEvent) continue;
                if (this.container != null && srcIsAComponent && !(isStrictAncestor = this.container.isAncestorOf((Component)src)) && this.container != src) {
                    if (!this.childWindows.isEmpty()) {
                        int length;
                        int i = length = this.childWindows.size();
                        while (i-- > 0) {
                            Window childWin = (Window)this.childWindows.elementAt(i);
                            if (childWin != src && !childWin.isAncestorOf((Component)src)) continue;
                            isAChild = true;
                            break;
                        }
                        i = length = this.oldChildWindows.size();
                        while (i-- > 0) {
                            Window oldChildWin = (Window)this.oldChildWindows.elementAt(i);
                            if (oldChildWin != src && !oldChildWin.isAncestorOf((Component)src)) continue;
                            isAChild = true;
                            break;
                        }
                        if (!isAChild && (event instanceof InputEvent || event.getID() == 201 || event.getID() == 202)) {
                            continue;
                        }
                    } else if (event instanceof InputEvent) continue;
                }
                if (srcIsAComponent) {
                    if (event.getID() == 200 && this.container != src) {
                        if (!this.childWindows.contains(src)) {
                            this.childWindows.addElement(src);
                        }
                        if (this.oldChildWindows.contains(src)) {
                            this.oldChildWindows.removeElement(src);
                        }
                        isAChild = true;
                    } else if (isAChild && (event.getID() == 201 || event.getID() == 202)) {
                        if (this.childWindows.contains(src)) {
                            this.childWindows.removeElement(src);
                        }
                        if (!this.oldChildWindows.contains(src)) {
                            this.oldChildWindows.addElement(src);
                        }
                    }
                    if (event.getID() == 1005 && isStrictAncestor) {
                        last = (Component)src;
                    } else {
                        if (event.getID() == 1004 && !isAChild && !isStrictAncestor) {
                            if (!this.container.isVisible() || last == null) continue;
                            last.requestFocus();
                            last = null;
                            continue;
                        }
                        if (event instanceof WindowEvent && !isAChild && !isStrictAncestor && src != this.container && !this.oldChildWindows.contains(src)) continue;
                    }
                    ((Component)src).dispatchEvent(event);
                    continue;
                }
                if (src instanceof MenuComponent) {
                    ((MenuComponent)src).dispatchEvent(event);
                    continue;
                }
                if (activeEventClass == null || !activeEventClass.isInstance(event)) continue;
                dispatchMethod.invoke((Object)event, null);
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable e) {
                System.err.println("Exception occurred during event dispatching:");
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            if (System.getProperty("java.version").startsWith("1.1")) {
                activeEventClass = Class.forName("java.awt.peer.ActiveEvent");
                dispatchMethod = activeEventClass.getDeclaredMethod("dispatch", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            activeEventClass = null;
            dispatchMethod = null;
        }
    }
}

