/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.ListBoxVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.OrderedListCollection;
import com.sas.collection.PredicateEnumeration;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticStringListInterface;
import com.sas.collection.StringCollection;
import com.sas.lang.StringDataInterface;
import com.sas.text.Message;
import com.sas.util.PredicateInterface;
import com.sas.util.PrefixPredicate;
import com.sas.util.Util;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.StringArrayToVectorTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.transforms.VectorToStringArrayTransform;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ListBox
extends ListBoxVisualComponent
implements ContentsChangedListener,
StringDataInterface,
PublicClonable,
ViewDefaultModelInterface {
    private static final String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    private int multipleSelectionStyle = 0;
    private transient boolean shiftPressed;
    private transient boolean ctrlPressed;
    private transient int lastIndexClicked = -1;
    private String selectionPrefix = "";
    private String fprefix = "";
    private boolean keyboardSelectable;
    private TransformInterface outputTransform;
    private TransformInterface inputTransform;
    private TransformInterface displayTransform;
    private int visRows;
    private boolean requestToResize;
    private int tempVisRows;
    private StringCollection initItems;
    private OrderedCollection defaultModel;
    private boolean suppressPaint;
    private transient boolean newModel;
    private transient boolean executingReadObject;
    private transient boolean deselectIndexes;
    private boolean maintainOrderedSelections;
    private OrderedListCollection orderedItems;
    private OrderedListCollection orderedIndexes;
    private transient OrderedListCollection excludedKeys;
    private transient boolean changeSelectionPrefix;
    private transient int smm = 0;
    static final long serialVersionUID = -2184429646671555404L;
    public static final String RB_KEY = "ListBox.";
    public static final int STANDARD_AWT = 0;
    public static final int EXTENDED_SELECT = 1;
    static int defaultWidth = 124;
    static int defaultHeight = 124;

    private synchronized boolean notInContentsChanged() {
        return this.smm <= 0;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "displayTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "inputTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "initialItems"}, {"Description", com.sas.awt.RB.getStringResource((String)"initialItems.pd.txt")}}, {{"Name", "items"}, {"Hidden", "true"}}, {{"Name", "keyboardSelectable"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"keyboardSelectable.pd.txt")}}, {{"Name", "multipleMode"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"multipleMode.pd.txt")}}, {{"Name", "multipleSelections"}, {"Hidden", "true"}}, {{"Name", "multipleSelectionStyle"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"multipleSelectionStyle.pd.txt")}, {"Property editor class", "com.sas.beans.editors.MultipleSelectionStyleEditor"}}, {{"Name", "outputTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "rows"}, {"Hidden", "true"}}, {{"Name", "selectedIndex"}, {"Description", com.sas.awt.RB.getStringResource((String)"selectedIndex.pd.txt")}}, {{"Name", "selectedIndexes"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"selectedIndexes.pd.txt")}}, {{"Name", "selectedItem"}, {"Description", com.sas.awt.RB.getStringResource((String)"selectedItem.pd.txt")}, {"Read method", "getSelectedItem"}, {"Property editor class", "com.sas.beans.editors._SelectedItemEditor"}}, {{"Name", "selectedItems"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"selectedItems.pd.txt")}, {"Read method", "getSelectedItems"}}, {{"Name", "selectedObjects"}, {"Expert", "true"}}, {{"Name", "selectionPrefix"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"selectionPrefix.pd.txt")}, {"Expert", "true"}}, {{"Name", "selectionsOrdered"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"selectionsOrdered.pd.txt")}, {"Expert", "true"}}, {{"Name", "text"}, {"Hidden", "true"}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "visibleRows"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"visibleRows.pd.txt")}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ListBox() {
        this.initializeComponent();
    }

    public ListBox(int rows) {
        super(rows);
        this.initializeComponent();
    }

    public ListBox(int rows, boolean multipleMode) {
        super(rows, multipleMode);
        this.initializeComponent();
    }

    public synchronized void addItems(Enumeration items) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            if (this.inputTransform != null) {
                EnumerationTransform enumer = new EnumerationTransform(items, this.inputTransform);
                ((OrderedCollectionInterface)model).addItems((Enumeration)enumer);
            } else {
                ((OrderedCollectionInterface)model).addItems(items);
            }
        }
    }

    public synchronized void add(Object item) {
        this.add(item, -1);
    }

    public synchronized void add(Object item, int index) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            Object inputItem = item;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(item);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"ListBox"));
                }
            }
            if (index == -1) {
                ((OrderedCollectionInterface)model).add(inputItem);
            } else {
                ((OrderedCollectionInterface)model).add(inputItem, index);
            }
        }
    }

    public synchronized void add(Object[] items) {
        OrderedCollection temp = new OrderedCollection(items);
        Enumeration etemp = temp.getItems();
        this.addItems(etemp);
    }

    @Override
    public void add(String item) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).add((Object)item);
        }
    }

    @Override
    public synchronized void add(String item, int index) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            if (this.notInContentsChanged()) {
                if (index == -1) {
                    ((OrderedCollectionInterface)model).add((Object)item);
                } else {
                    ((OrderedCollectionInterface)model).add((Object)item, index);
                }
            } else {
                super.add(item, index);
            }
        }
    }

    @Override
    public void addItem(String item) {
        super.addItem(item);
    }

    @Override
    public synchronized void addItem(String item, int index) {
        super.addItem(item, index);
    }

    @Override
    public synchronized void attachModel(ModelInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
        }
        int oldSelected = this.getSelectedIndex();
        String oldSelItem = this.getSelectedItem();
        String[] oldSelItems = this.getSelectedItems();
        int[] oldSelIndexes = this.getSelectedIndexes();
        Object[] oldSelObjects = this.getSelectedObjects();
        if (!this.executingReadObject && Util.unequal((Object)this.getModelInterface(), (Object)model)) {
            this.newModel = true;
        }
        this.executingReadObject = false;
        super.attachModel(model);
        this.newModel = false;
        int[] newSelIndexes = this.getSelectedIndexes();
        if (newSelIndexes.length != oldSelIndexes.length) {
            this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
            this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
            this.firePropertyChange("selectedIndexes", oldSelIndexes, newSelIndexes);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
        }
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        try {
            ListBox clone = (ListBox)this.getClass().newInstance();
            clone.orderedItems = (OrderedListCollection)this.orderedItems.clone();
            clone.orderedIndexes = (OrderedListCollection)this.orderedIndexes.clone();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                OrderedCollection clonedModel = (OrderedCollection)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            clone.setDisplayTransform(this.getDisplayTransform());
            clone.setInputTransform(this.getInputTransform());
            clone.setOutputTransform(this.getOutputTransform());
            clone.setKeyboardSelectable(this.isKeyboardSelectable());
            clone.setMultipleMode(this.isMultipleMode());
            clone.setSelectedIndexes(this.getSelectedIndexes());
            clone.setMultipleSelectionStyle(this.getMultipleSelectionStyle());
            clone.setSelectionsOrdered(this.isSelectionsOrdered());
            clone.setSelectionPrefix(this.getSelectionPrefix());
            clone.setVisibleRows(this.getVisibleRows());
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void contentsChanged(ContentsChangedEvent evt) {
        boolean handled = false;
        try {
            int[] oldSelIndexes;
            if (this.smm < 0) {
                this.smm = 0;
            }
            ++this.smm;
            if (evt instanceof CollectionChangedInfo) {
                CollectionChangedInfo nevt = (CollectionChangedInfo)evt;
                String[] oldItems = this.getItems();
                if (nevt.howChanged == HowChanged.ADDED) {
                    int oldSelected = -1;
                    oldSelIndexes = new int[]{};
                    if (this.anyPropertyChangeListeners()) {
                        oldSelIndexes = this.getOrderedIndexes();
                        if (!this.isMultipleMode() && this.orderedIndexes.count() > 0) {
                            oldSelected = oldSelIndexes[0];
                        }
                    }
                    handled = true;
                    if (nevt.whatChanged != null) {
                        if (this.displayTransform != null) {
                            Object displayItem = this.displayTransform.transform(nevt.whatChanged);
                            super.add(displayItem.toString(), nevt.start);
                        } else {
                            super.add(nevt.whatChanged.toString(), nevt.start);
                        }
                    } else {
                        Enumeration enc = ((OrderedCollectionInterface)this.getModelInterface()).getItems(nevt.start, nevt.end);
                        if (enc != null) {
                            int position = nevt.start;
                            while (enc.hasMoreElements()) {
                                Object dItem = enc.nextElement();
                                if (this.displayTransform != null) {
                                    Object displayItem = this.displayTransform.transform(dItem);
                                    if (displayItem == null) throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                                    super.add(displayItem.toString(), position++);
                                    continue;
                                }
                                if (dItem != null) {
                                    super.add(dItem.toString(), position++);
                                    continue;
                                }
                                if (dItem != null) continue;
                                throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                            }
                        }
                    }
                    boolean hasChanged = false;
                    int itemCount = this.orderedIndexes.count();
                    if (itemCount > 0) {
                        for (int i = 0; i < itemCount; ++i) {
                            int cindex = (Integer)this.orderedIndexes.get(i);
                            if (cindex < nevt.start) continue;
                            Integer temp = new Integer(cindex + 1);
                            this.orderedIndexes.set(i, (Object)temp);
                            hasChanged = true;
                        }
                    }
                    if (hasChanged && this.anyPropertyChangeListeners()) {
                        this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
                        this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
                    }
                    String[] newItems = this.getItems();
                    this.firePropertyChange("items", oldItems, newItems);
                } else if (nevt.howChanged == HowChanged.REMOVED) {
                    handled = true;
                    int oldSelected = -1;
                    int[] oldSelIndexes2 = this.getOrderedIndexes();
                    String oldSelItem = null;
                    String[] oldSelItems = this.getOrderedItems();
                    if (this.anyPropertyChangeListeners() && !this.isMultipleMode()) {
                        oldSelItem = this.getSelectedItem();
                        oldSelected = this.getSelectedIndex();
                    }
                    boolean selectStatus = false;
                    if (nevt.whatChanged != null) {
                        super.remove(nevt.start);
                        int itemCount = this.orderedIndexes.count();
                        if (itemCount > 0) {
                            for (int i = itemCount - 1; i >= 0; --i) {
                                int location;
                                Integer temp;
                                int cindex = (Integer)this.orderedIndexes.get(i);
                                if (cindex > nevt.start) {
                                    temp = new Integer(cindex - 1);
                                    this.orderedIndexes.set(i, (Object)temp);
                                    selectStatus = true;
                                    continue;
                                }
                                if (cindex != nevt.start || (location = this.orderedIndexes.getIndex((Object)(temp = new Integer(cindex)), 0)) == -1) continue;
                                this.orderedIndexes.removeAt(location);
                                this.orderedItems.removeAt(location);
                                selectStatus = true;
                            }
                        }
                    } else {
                        if (nevt.start == 0) {
                            super.removeAll();
                        } else {
                            for (int i = nevt.end - 1; i > nevt.start - 1; --i) {
                                super.remove(i);
                            }
                        }
                        int[] newSelIndexes = this.getSelectedIndexes();
                        if (newSelIndexes.length != oldSelIndexes2.length) {
                            selectStatus = true;
                        }
                        int itemCount = this.getItemCount();
                        if (this.orderedIndexes.count() > 0 && selectStatus) {
                            for (int i = 0; i < oldSelIndexes2.length; ++i) {
                                Integer temp;
                                int location;
                                if (oldSelIndexes2[i] < itemCount || (location = this.orderedIndexes.getIndex((Object)(temp = new Integer(oldSelIndexes2[i])), 0)) == -1) continue;
                                this.orderedIndexes.removeAt(location);
                                this.orderedItems.removeAt(location);
                            }
                        }
                    }
                    if (!this.anyPropertyChangeListeners() || !selectStatus) {
                        return;
                    }
                    this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
                    this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
                    this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
                    this.firePropertyChange("selectedIndexes", oldSelIndexes2, this.getSelectedIndexes());
                    this.firePropertyChange("selectedObjects", new Object[0], this.getSelectedObjects());
                    this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
                    String[] newItems = this.getItems();
                    this.firePropertyChange("items", oldItems, newItems);
                } else if (nevt.howChanged == HowChanged.REPLACED) {
                    handled = true;
                    boolean selectStatus = this.isIndexSelected(nevt.start);
                    int oldSelected = this.getSelectedIndex();
                    String oldSelItem = this.getSelectedItem();
                    String[] oldSelItems = this.getSelectedItems();
                    int[] oldSelIndexes3 = this.getSelectedIndexes();
                    Object[] oldSelObjects = this.getSelectedObjects();
                    if (nevt.start != -1) {
                        Integer temp;
                        int location;
                        Object obj = ((StaticOrderedCollectionInterface)this.getModelInterface()).get(nevt.start);
                        if (this.displayTransform != null) {
                            Object displayItem = this.displayTransform.transform(obj);
                            if (displayItem == null) throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                            super.replaceItem(displayItem.toString(), nevt.start);
                        } else if (obj != null) {
                            super.replaceItem(obj.toString(), nevt.start);
                        } else if (obj == null) {
                            throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                        }
                        if (this.orderedIndexes.count() > 0 && selectStatus && (location = this.orderedIndexes.getIndex((Object)(temp = new Integer(nevt.start)), 0)) != -1) {
                            this.orderedIndexes.removeAt(location);
                            this.orderedItems.removeAt(location);
                        }
                    } else {
                        this.refresh(this.getModelInterface());
                        this.deselectAllItems();
                    }
                    if (!this.anyPropertyChangeListeners() || !selectStatus) {
                        return;
                    }
                    this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
                    this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
                    this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
                    this.firePropertyChange("selectedIndexes", oldSelIndexes3, this.getSelectedIndexes());
                    this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                    this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
                    String[] newItems = this.getItems();
                    this.firePropertyChange("items", oldItems, newItems);
                } else if (nevt.howChanged == HowChanged.REORDERED) {
                    ModelInterface model = this.getModelInterface();
                    this.refresh(model);
                }
            }
            if (handled) return;
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            this.refresh(this.getModelInterface());
            this.deselectAllItems();
            if (!this.anyPropertyChangeListeners() || oldSelIndexes.length == 0) {
                return;
            }
            this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
            this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
            this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
            return;
        }
        catch (TransformException transformException) {
            return;
        }
        finally {
            --this.smm;
        }
    }

    @Override
    public synchronized void deselect(int index) {
        boolean selectStatus = this.isIndexSelected(index);
        if (selectStatus) {
            Integer temp;
            int location;
            int oldSelected = index;
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            super.deselect(index);
            if (this.orderedIndexes.count() > 0 && (location = this.orderedIndexes.getIndex((Object)(temp = new Integer(index)), 0)) != -1) {
                this.orderedIndexes.removeAt(location);
                this.orderedItems.removeAt(location);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
            this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(index));
            this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
        }
    }

    public synchronized void deselectAll() {
        int oldSelected = this.getSelectedIndex();
        String oldSelItem = this.getSelectedItem();
        String[] oldSelItems = this.getSelectedItems();
        int[] oldSelIndexes = this.getSelectedIndexes();
        Object[] oldSelObjects = this.getSelectedObjects();
        this.deselectAllItems();
        if (!this.anyPropertyChangeListeners() || oldSelIndexes.length == 0) {
            return;
        }
        this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
        this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
        this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
        this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
        this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
        this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
    }

    private synchronized void deselectAllItems() {
        int[] selIndexes = this.getSelectedIndexes();
        if (selIndexes != null) {
            int cnt = selIndexes.length;
            for (int i = 0; i < cnt; ++i) {
                super.deselect(selIndexes[i]);
            }
        }
        this.orderedIndexes.removeAll();
        this.orderedItems.removeAll();
    }

    @Override
    public synchronized void detachModel(ModelInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
        if (this.defaultModel != null && this.defaultModel.count() > 0) {
            this.defaultModel.removeAll();
        }
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    public synchronized int findItemByPrefix(String prefix, int index) {
        ModelInterface model;
        int findex = -1;
        if (prefix != null && index >= 0 && (model = this.getModelInterface()) != null) {
            String[] listItems = this.getItems();
            StringArrayToVectorTransform arrayTransform = new StringArrayToVectorTransform();
            Vector transformedValue = (Vector)arrayTransform.transform((Object)listItems);
            Enumeration items = transformedValue.elements();
            EnumerationTransform lowercaseItems = new EnumerationTransform(items, new TransformInterface(){

                public Object transform(Object obj) {
                    return obj.toString().toLowerCase();
                }
            });
            Vector<Object> temp = new Vector<Object>();
            while (lowercaseItems.hasMoreElements()) {
                temp.addElement(lowercaseItems.nextElement());
            }
            PredicateEnumeration en = new PredicateEnumeration(temp.elements(), (PredicateInterface)new PrefixPredicate(prefix.trim().toLowerCase()));
            VectorToStringArrayTransform sarrayTransform = new VectorToStringArrayTransform();
            String[] transformedArray = (String[])sarrayTransform.transform(temp);
            StringCollection curItems = new StringCollection(transformedArray);
            boolean enumerationEmpty = true;
            while (en.hasMoreElements()) {
                Object ox = en.nextElement();
                findex = curItems.getIndex(ox, index);
                if (findex >= index) {
                    enumerationEmpty = false;
                    break;
                }
                findex = -1;
            }
            if (enumerationEmpty) {
                findex = -1;
            }
        }
        return findex;
    }

    private void fireSelectionPropertyChange(String oldSelItem, String[] oldSelItems, int oldSelected, int[] oldSelIndexes, Object[] oldSelObjects) {
        this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
        this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
        this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
        this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
        this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
        this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public synchronized String[] getInitialItems() {
        if (this.defaultModel != null && this.defaultModel.count() > 0) {
            int i = 0;
            int modelCount = this.defaultModel.count();
            String[] items = new String[modelCount];
            Enumeration modelE = this.defaultModel.getItems();
            EnumerationTransform initialItemsE = new EnumerationTransform(modelE, this.outputTransform);
            while (initialItemsE.hasMoreElements()) {
                items[i++] = initialItemsE.nextElement().toString();
            }
            return items;
        }
        return new String[0];
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    public int getMultipleSelectionStyle() {
        return this.multipleSelectionStyle;
    }

    private int[] getOrderedIndexes() {
        int itemCount = this.orderedIndexes.count();
        int[] indexArray = new int[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            indexArray[i] = (Integer)this.orderedIndexes.get(i);
        }
        return indexArray;
    }

    private String[] getOrderedItems() {
        int itemCount = this.orderedItems.count();
        String[] stringArray = new String[this.orderedItems.count()];
        for (int i = 0; i < itemCount; ++i) {
            Object temp = this.orderedItems.get(i);
            if (this.outputTransform != null) {
                try {
                    temp = this.outputTransform.transform(temp);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            stringArray[i] = temp != null ? temp.toString() : null;
        }
        return stringArray;
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public int[] getSelectedIndexes() {
        if (!this.isSelectionsOrdered()) {
            return super.getSelectedIndexes();
        }
        return this.getOrderedIndexes();
    }

    @Override
    public String[] getSelectedItems() {
        if (!this.isSelectionsOrdered()) {
            return super.getSelectedItems();
        }
        return this.getOrderedItems();
    }

    @Override
    public Object[] getSelectedObjects() {
        int[] selIndexes = this.getSelectedIndexes();
        ModelInterface model = this.getModelInterface();
        if (model != null && ((StaticOrderedCollectionInterface)model).count() > 0 && selIndexes.length > 0) {
            Object[] items = new Object[selIndexes.length];
            int count = ((StaticOrderedCollectionInterface)model).count();
            for (int i = 0; i < selIndexes.length; ++i) {
                if (selIndexes[i] >= count) continue;
                Object temp = ((StaticOrderedCollectionInterface)model).get(selIndexes[i]);
                if (this.outputTransform == null) {
                    items[i] = temp;
                    continue;
                }
                try {
                    items[i] = this.outputTransform.transform(temp);
                    continue;
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            return items;
        }
        Object[] noitems = new Object[]{};
        return noitems;
    }

    public String getSelectionPrefix() {
        return this.selectionPrefix;
    }

    public String getText() {
        return this.getSelectedItem();
    }

    public int getVisibleRows() {
        return this.visRows;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isKeyboardSelectable() {
        return this.keyboardSelectable;
    }

    @Override
    public synchronized void initialize() {
        int[] selIndexes = this.getSelectedIndexes();
        this.requestToResize = false;
        if (selIndexes.length > 0) {
            for (int i = 0; i < selIndexes.length; ++i) {
                super.select(selIndexes[i]);
            }
        }
    }

    @Override
    public void initializeComponent() {
        super.initializeComponent();
        if (this.isDesignTime()) {
            this.defaultModel.add((Object)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"defaultModel.Item1.txt"));
            this.defaultModel.add((Object)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"defaultModel.Item2.txt"));
        }
    }

    private void initializeExcludedKeys() {
        this.excludedKeys.add((Object)new Integer(8));
        this.excludedKeys.add((Object)new Integer(10));
        this.excludedKeys.add((Object)new Integer(27));
        this.excludedKeys.add((Object)new Integer(9));
        this.excludedKeys.add((Object)new Integer(18));
        this.excludedKeys.add((Object)new Integer(20));
        this.excludedKeys.add((Object)new Integer(17));
        this.excludedKeys.add((Object)new Integer(157));
        this.excludedKeys.add((Object)new Integer(16));
    }

    public boolean isSelectionsOrdered() {
        return this.maintainOrderedSelections;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.suppressPaint) {
            super.paint(g);
        }
    }

    @Override
    protected synchronized void processItemEvent(ItemEvent e) {
        try {
            Integer temp;
            int location;
            Object item;
            int oldSelected = -1;
            int[] oldSelIndexes = new int[]{};
            String oldSelItem = null;
            String[] oldSelItems = new String[]{};
            Object[] oldSelObjects = this.getSelectedObjects();
            if (this.anyPropertyChangeListeners()) {
                oldSelIndexes = this.getOrderedIndexes();
                oldSelItems = this.getOrderedItems();
                if (!this.isMultipleMode() && this.orderedIndexes.count() > 0) {
                    oldSelected = (Integer)this.orderedIndexes.get(0);
                    Object temp2 = this.orderedItems.get(0);
                    if (this.outputTransform != null) {
                        try {
                            temp2 = this.outputTransform.transform(temp2);
                        }
                        catch (TransformException transformException) {
                            // empty catch block
                        }
                    }
                    oldSelItem = temp2.toString();
                }
            }
            Object outputItem = e.getItem();
            if (this.outputTransform != null) {
                outputItem = this.outputTransform.transform(e.getItem());
            }
            ItemEvent newItemEvent = new ItemEvent(e.getItemSelectable(), e.getID(), outputItem, e.getStateChange());
            int newIndex = (Integer)e.getItem();
            ModelInterface model = this.getModelInterface();
            int selectionState = e.getStateChange();
            if (e.getStateChange() == 1) {
                if (this.getMultipleSelectionStyle() == 0 || this.getMultipleSelectionStyle() == 1 && !this.isMultipleMode()) {
                    if (!this.isMultipleMode()) {
                        this.orderedIndexes.removeAll();
                        this.orderedItems.removeAll();
                    }
                    if (((StaticOrderedCollectionInterface)model).count() > 0) {
                        this.orderedIndexes.add((Object)new Integer(newIndex));
                        item = ((StaticOrderedCollectionInterface)model).get(newIndex);
                        this.orderedItems.add(item);
                    }
                }
            } else if (e.getStateChange() == 2 && !Util.JVMVendorIsMicrosoft() && this.orderedIndexes.count() > 0 && (location = this.orderedIndexes.getIndex((Object)(temp = new Integer(newIndex)), 0)) != -1) {
                this.orderedIndexes.removeAt(location);
                this.orderedItems.removeAt(location);
            }
            if (this.isMultipleMode() && this.getMultipleSelectionStyle() == 1) {
                if (this.ctrlPressed) {
                    if (this.shiftPressed) {
                        this.processShiftSelection(newIndex);
                    } else {
                        if (selectionState == 1) {
                            super.select(newIndex);
                            if (((StaticOrderedCollectionInterface)model).count() > 0) {
                                this.orderedIndexes.add((Object)new Integer(newIndex));
                                item = ((StaticOrderedCollectionInterface)model).get(newIndex);
                                this.orderedItems.add(item);
                            }
                        } else {
                            super.deselect(newIndex);
                        }
                        this.lastIndexClicked = newIndex;
                    }
                } else if (this.shiftPressed && this.lastIndexClicked != -1) {
                    this.deselectIndexes = true;
                    this.processShiftSelection(newIndex);
                } else {
                    this.deselectAllItems();
                    this.orderedIndexes.removeAll();
                    this.orderedItems.removeAll();
                    super.select(newIndex);
                    if (((StaticOrderedCollectionInterface)model).count() > 0) {
                        this.orderedIndexes.add((Object)new Integer(newIndex));
                        item = ((StaticOrderedCollectionInterface)model).get(newIndex);
                        this.orderedItems.add(item);
                        this.lastIndexClicked = newIndex;
                    }
                }
            }
            if (selectionState == 1) {
                super.processItemEvent(newItemEvent);
            } else if (!Util.JVMVendorIsMicrosoft()) {
                super.processItemEvent(newItemEvent);
            }
            if (this.anyPropertyChangeListeners()) {
                this.fireSelectionPropertyChange(oldSelItem, oldSelItems, oldSelected, oldSelIndexes, oldSelObjects);
            }
        }
        catch (TransformException transformException) {
            // empty catch block
        }
    }

    @Override
    protected synchronized void processKeyEvent(KeyEvent e) {
        if (this.isMultipleMode()) {
            if (e.getID() == 401 && e.getKeyCode() == 16) {
                this.shiftPressed = true;
            } else if (e.getID() == 402 && e.getKeyCode() == 16) {
                this.shiftPressed = false;
            }
            if (e.getID() == 401 && e.getKeyCode() == 17) {
                this.ctrlPressed = true;
            } else if (e.getID() == 402 && e.getKeyCode() == 17) {
                this.ctrlPressed = false;
            }
        }
        if (this.isKeyboardSelectable()) {
            if (e.getID() == 401) {
                this.changeSelectionPrefix = !e.isActionKey() && !this.excludedKeys.contains((Object)new Integer(e.getKeyCode()));
            } else if (e.getID() == 400) {
                char checkKey = e.getKeyChar();
                if (checkKey != '\uffff') {
                    Character keyTyped = new Character(checkKey);
                    if (this.changeSelectionPrefix) {
                        this.setSelectionPrefix(keyTyped.toString());
                    } else {
                        this.changeSelectionPrefix = true;
                    }
                }
            } else if (e.getID() == 402) {
                this.changeSelectionPrefix = !e.isActionKey() && !this.excludedKeys.contains((Object)new Integer(e.getKeyCode()));
            }
        }
        super.processKeyEvent(e);
    }

    private void processShiftSelection(int newIndex) {
        ModelInterface model = this.getModelInterface();
        if (this.lastIndexClicked < newIndex) {
            int location;
            Integer temp;
            for (int i = this.lastIndexClicked; i <= newIndex; ++i) {
                int location2;
                Integer temp2 = new Integer(i);
                if (this.orderedIndexes.count() > 0 && (location2 = this.orderedIndexes.getIndex((Object)temp2, 0)) != -1) {
                    this.orderedIndexes.removeAt(location2);
                    this.orderedItems.removeAt(location2);
                }
                if (((StaticOrderedCollectionInterface)model).count() > 0) {
                    this.orderedIndexes.add((Object)temp2);
                    Object item = ((StaticOrderedCollectionInterface)model).get(i);
                    this.orderedItems.add(item);
                }
                super.select(i);
            }
            if (!this.deselectIndexes) {
                return;
            }
            int firstPos = newIndex + 1;
            int lastIndex = this.getItemCount() - 1;
            if (firstPos <= lastIndex) {
                for (int j = firstPos; j <= lastIndex; ++j) {
                    if (!this.isIndexSelected(j)) continue;
                    super.deselect(j);
                    temp = new Integer(j);
                    if (this.orderedIndexes.count() <= 0 || (location = this.orderedIndexes.getIndex((Object)temp, 0)) == -1) continue;
                    this.orderedIndexes.removeAt(location);
                    this.orderedItems.removeAt(location);
                }
            }
            if (this.lastIndexClicked > 0) {
                for (int k = 0; k < this.lastIndexClicked; ++k) {
                    if (!this.isIndexSelected(k)) continue;
                    super.deselect(k);
                    temp = new Integer(k);
                    if (this.orderedIndexes.count() <= 0 || (location = this.orderedIndexes.getIndex((Object)temp, 0)) == -1) continue;
                    this.orderedIndexes.removeAt(location);
                    this.orderedItems.removeAt(location);
                }
            }
            this.deselectIndexes = false;
        } else if (this.lastIndexClicked > newIndex) {
            int location;
            Integer temp;
            for (int i = this.lastIndexClicked; i >= newIndex; --i) {
                int location3;
                Integer temp3 = new Integer(i);
                if (this.orderedIndexes.count() > 0 && (location3 = this.orderedIndexes.getIndex((Object)temp3, 0)) != -1) {
                    this.orderedIndexes.removeAt(location3);
                    this.orderedItems.removeAt(location3);
                }
                if (((StaticOrderedCollectionInterface)model).count() > 0) {
                    this.orderedIndexes.add((Object)temp3);
                    Object item = ((StaticOrderedCollectionInterface)model).get(i);
                    this.orderedItems.add(item);
                }
                super.select(i);
            }
            if (!this.deselectIndexes) {
                return;
            }
            int firstPos = this.lastIndexClicked + 1;
            int lastIndex = this.getItemCount() - 1;
            if (firstPos <= lastIndex) {
                for (int j = firstPos; j <= lastIndex; ++j) {
                    if (!this.isIndexSelected(j)) continue;
                    super.deselect(j);
                    temp = new Integer(j);
                    if (this.orderedIndexes.count() <= 0 || (location = this.orderedIndexes.getIndex((Object)temp, 0)) == -1) continue;
                    this.orderedIndexes.removeAt(location);
                    this.orderedItems.removeAt(location);
                }
            }
            if (newIndex > 0) {
                for (int k = 0; k < newIndex; ++k) {
                    if (!this.isIndexSelected(k)) continue;
                    super.deselect(k);
                    temp = new Integer(k);
                    if (this.orderedIndexes.count() <= 0 || (location = this.orderedIndexes.getIndex((Object)temp, 0)) == -1) continue;
                    this.orderedIndexes.removeAt(location);
                    this.orderedItems.removeAt(location);
                }
            }
            this.deselectIndexes = false;
        } else {
            int count = this.getItemCount();
            for (int i = 0; i < count; ++i) {
                if (!this.isIndexSelected(i)) continue;
                super.deselect(i);
            }
            this.orderedIndexes.removeAll();
            this.orderedItems.removeAll();
            super.select(newIndex);
            if (((StaticOrderedCollectionInterface)model).count() > 0) {
                this.orderedIndexes.add((Object)new Integer(newIndex));
                Object item = ((StaticOrderedCollectionInterface)model).get(newIndex);
                this.orderedItems.add(item);
            }
        }
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            this.refresh(model);
        } else {
            super.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refresh(ModelInterface model) {
        try {
            ++this.smm;
            if (model != null) {
                int[] selIndexes = this.getSelectedIndexes();
                super.removeAll();
                Enumeration elements = ((StaticOrderedCollectionInterface)model).getItems();
                int index = 0;
                if (elements != null) {
                    while (elements.hasMoreElements()) {
                        Object dItem = elements.nextElement();
                        if (this.displayTransform != null) {
                            Object displayItem = this.displayTransform.transform(dItem);
                            if (displayItem != null) {
                                super.add(displayItem.toString(), index++);
                                continue;
                            }
                            throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                        }
                        if (dItem != null) {
                            super.add(dItem.toString(), index++);
                            continue;
                        }
                        if (dItem != null) continue;
                        throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                    }
                }
                int itemCount = this.getItemCount();
                if (this.getItemCount() > 0) {
                    String[] newItems = this.getItems();
                    if (!this.newModel && selIndexes.length > 0) {
                        for (int i = 0; i < selIndexes.length; ++i) {
                            if (selIndexes[i] >= itemCount) continue;
                            super.select(selIndexes[i]);
                        }
                    }
                    if (!this.anyPropertyChangeListeners()) {
                        return;
                    }
                    this.firePropertyChange("items", null, newItems);
                }
            }
        }
        catch (TransformException transformException) {
        }
        finally {
            --this.smm;
        }
    }

    @Override
    public synchronized void remove(int position) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            if (this.notInContentsChanged()) {
                ((OrderedCollectionInterface)model).removeAt(position);
            } else {
                super.remove(position);
            }
        }
    }

    public synchronized void remove(Object item) {
        Object inputItem = item;
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            int i;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(item);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"ListBox"));
                }
            }
            boolean found_item = false;
            int itemCount = ((StaticOrderedCollectionInterface)model).count();
            for (i = 0; i < itemCount; ++i) {
                if (!Util.equal((Object)inputItem, (Object)((StaticOrderedCollectionInterface)model).get(i))) continue;
                found_item = true;
                break;
            }
            if (found_item) {
                this.remove(i);
            } else {
                throw new IllegalArgumentException(Message.format((String)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"IllegalArgumentException.ex.txt"), (Object)item));
            }
        }
    }

    @Override
    public void remove(String item) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            int i;
            boolean found_item = false;
            int itemCount = this.getItemCount();
            for (i = 0; i < itemCount; ++i) {
                if (!Util.equal((Object)item, (Object)this.getItem(i))) continue;
                found_item = true;
                break;
            }
            if (found_item) {
                this.remove(i);
            } else {
                throw new IllegalArgumentException(Message.format((String)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"IllegalArgumentException.ex.txt"), (Object)item));
            }
        }
    }

    @Override
    public synchronized void removeAll() {
        try {
            this.suppressPaint = true;
            ModelInterface model = this.getModelInterface();
            if (this.notInContentsChanged()) {
                ((OrderedCollectionInterface)model).removeAll();
            }
        }
        finally {
            this.suppressPaint = false;
        }
    }

    public synchronized void replaceItem(Object newvalue, int index) {
        ModelInterface model;
        Object inputItem = newvalue;
        if (this.inputTransform != null) {
            try {
                inputItem = this.inputTransform.transform(newvalue);
            }
            catch (TransformException e) {
                System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"ListBox"));
            }
        }
        if ((model = this.getModelInterface()) != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).set(index, inputItem);
        }
    }

    @Override
    public synchronized void replaceItem(String newvalue, int index) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).set(index, (Object)newvalue);
        }
    }

    @Override
    public void select(int index) {
        if (index >= this.getItemCount() || index < -1 || this.isIndexSelected(index)) {
            return;
        }
        int oldSelected = -1;
        int[] oldSelIndexes = new int[]{};
        String oldSelItem = null;
        String[] oldSelItems = new String[]{};
        Object[] oldSelObjects = this.getSelectedObjects();
        if (this.anyPropertyChangeListeners()) {
            oldSelIndexes = this.getOrderedIndexes();
            oldSelItems = this.getOrderedItems();
            if (!this.isMultipleMode() && this.orderedIndexes.count() > 0) {
                oldSelected = (Integer)this.orderedIndexes.get(0);
                Object temp = this.orderedItems.get(0);
                if (this.outputTransform != null) {
                    try {
                        temp = this.outputTransform.transform(temp);
                    }
                    catch (TransformException transformException) {
                        // empty catch block
                    }
                }
                oldSelItem = temp.toString();
            }
        }
        if (index == -1) {
            if (!this.isMultipleMode()) {
                this.deselectAll();
                return;
            }
            this.selectAll();
            return;
        }
        super.select(index);
        if (!this.isMultipleMode()) {
            this.orderedIndexes.removeAll();
            this.orderedItems.removeAll();
        }
        if (index != -1) {
            this.orderedIndexes.add((Object)new Integer(index));
            ModelInterface model = this.getModelInterface();
            Object item = ((StaticOrderedCollectionInterface)model).get(index);
            this.orderedItems.add(item);
        }
        if (!this.anyPropertyChangeListeners()) {
            return;
        }
        this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
        this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
        if (index != -1) {
            this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
        } else {
            this.firePropertyChange("selectedItems", oldSelItems, new String[0]);
            this.firePropertyChange("selectedObjects", oldSelObjects, new Object[0]);
        }
        this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(index));
        this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
    }

    public synchronized void selectAll() {
        if (this.isMultipleMode()) {
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                ModelInterface model = this.getModelInterface();
                if (this.isIndexSelected(i)) continue;
                super.select(i);
                this.orderedIndexes.add((Object)new Integer(i));
                Object item = ((StaticOrderedCollectionInterface)model).get(i);
                this.orderedItems.add(item);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            int[] newSelIndexes = this.getSelectedIndexes();
            if (oldSelIndexes.length != newSelIndexes.length) {
                this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
                this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
                this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
                this.firePropertyChange("selectedIndexes", oldSelIndexes, newSelIndexes);
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
            }
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.defaultModel = new OrderedCollection();
        this.defaultModel.initialize();
        this.setModelInterface((ModelInterface)this.defaultModel);
        this.enableEvents(520L);
        this.orderedItems = new OrderedListCollection();
        this.orderedIndexes = new OrderedListCollection();
        this.excludedKeys = new OrderedListCollection();
        this.initializeExcludedKeys();
        this.visRows = 8;
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (transform != this.displayTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            ModelInterface model = this.getModelInterface();
            if (model != null) {
                this.refresh(model);
            }
            this.firePropertyChange("displayTransform", oldTransform, transform);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getPeer() != null) {
            this.addNotify();
        }
    }

    public void setInputTransform(TransformInterface transform) {
        if (transform != this.inputTransform) {
            TransformInterface oldTransform = this.inputTransform;
            this.inputTransform = transform;
            this.firePropertyChange("inputTransform", oldTransform, transform);
        }
    }

    public void setInitialItems(String[] items) {
        StringCollection newItems;
        StringCollection curItems;
        boolean i = false;
        String[] oldItems = this.getInitialItems();
        if (items == null) {
            items = new String[]{};
        }
        if (Util.equal((Object)(curItems = new StringCollection(oldItems)), (Object)(newItems = new StringCollection(items)))) {
            return;
        }
        this.defaultModel.removeAll();
        Enumeration eitems = newItems.getItems();
        if (this.defaultModel instanceof ContentsChangedSource) {
            this.defaultModel.removeContentsChangedListener((ContentsChangedListener)this);
        }
        this.addItems(eitems);
        this.refresh();
        if (this.defaultModel instanceof ContentsChangedSource) {
            this.defaultModel.addContentsChangedListener((ContentsChangedListener)this);
        }
        int oldSelected = this.getSelectedIndex();
        String oldSelItem = this.getSelectedItem();
        String[] oldSelItems = this.getSelectedItems();
        int[] oldSelIndexes = this.getSelectedIndexes();
        Object[] oldSelObjects = this.getSelectedObjects();
        ModelInterface model = this.getModelInterface();
        if (model == null || model != this.defaultModel) {
            this.detachModel(model);
        }
        this.firePropertyChange("initialItems", oldItems, items);
        int newSelected = this.getSelectedIndex();
        String newSelItem = this.getSelectedItem();
        if (newSelected != oldSelected) {
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(newSelected));
            this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
        }
        if (newSelItem != oldSelItem) {
            this.firePropertyChange("selectedItem", oldSelItem, newSelItem);
            this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
        }
    }

    public synchronized void setItems(Object[] items) {
        if (items != null && items.length > 0) {
            ModelInterface si = this.getModelInterface();
            if (si != null && si instanceof OrderedCollectionInterface) {
                Vector curItems = new Vector();
                Enumeration ecr = ((StaticOrderedCollectionInterface)si).getItems();
                while (ecr.hasMoreElements()) {
                    curItems.addElement(ecr.nextElement());
                }
                Vector<Object> newItems = new Vector<Object>();
                for (int i = 0; i < items.length; ++i) {
                    newItems.addElement(items[i]);
                }
                if (newItems.equals(curItems)) {
                    return;
                }
                this.removeAll();
                Enumeration sl = newItems.elements();
                ((OrderedCollectionInterface)si).addItems(sl);
            }
        } else {
            this.removeAll();
        }
    }

    public synchronized void setItems(String[] items) {
        if (items != null && items.length > 0) {
            ModelInterface si = this.getModelInterface();
            if (si != null && si instanceof OrderedCollectionInterface) {
                StringCollection newItems = new StringCollection(items);
                StringCollection curItems = new StringCollection(this.getItems());
                if (newItems.equals((StaticStringListInterface)curItems)) {
                    return;
                }
                this.removeAll();
                if (this.notInContentsChanged()) {
                    Vector<String> vi = new Vector<String>(items.length);
                    for (int i = 0; i < items.length; ++i) {
                        vi.addElement(items[i]);
                    }
                    Enumeration sl = vi.elements();
                    ((OrderedCollectionInterface)si).addItems(sl);
                }
            }
        } else {
            this.removeAll();
        }
    }

    public synchronized void setKeyboardSelectable(boolean state) {
        if (this.isKeyboardSelectable() != state) {
            this.keyboardSelectable = state;
            this.firePropertyChange("keyboardSelectable", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public synchronized void setMultipleMode(boolean state) {
        if (this.isMultipleMode() != state) {
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            super.setMultipleMode(state);
            int[] newIndex = super.getSelectedIndexes();
            if (this.orderedIndexes.count() > 0) {
                this.orderedIndexes.removeAll();
                this.orderedItems.removeAll();
                if (!state && newIndex[0] != -1) {
                    this.orderedIndexes.add((Object)new Integer(newIndex[0]));
                    ModelInterface model = this.getModelInterface();
                    Object item = ((StaticOrderedCollectionInterface)model).get(newIndex[0]);
                    this.orderedItems.add(item);
                }
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            if (newIndex.length > 0 && newIndex[0] != oldSelected || newIndex.length == 0 && oldSelected != -1) {
                this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
                this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                if (newIndex.length > 0) {
                    this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(newIndex[0]));
                } else {
                    this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(-1));
                }
                this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
                this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
            }
            this.firePropertyChange("multipleMode", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setMultipleSelectionStyle(int style) {
        int oldStyle = this.multipleSelectionStyle;
        if (this.multipleSelectionStyle != style) {
            if (style == 0) {
                this.multipleSelectionStyle = 0;
            } else if (style == 1) {
                this.multipleSelectionStyle = 1;
            } else {
                throw new IllegalArgumentException("Illegal Argument " + style);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("multipleSelectionStyle", new Integer(oldStyle), new Integer(style));
        }
    }

    public void setOutputTransform(TransformInterface transform) {
        if (transform != this.outputTransform) {
            TransformInterface oldTransform = this.outputTransform;
            this.outputTransform = transform;
            this.firePropertyChange("outputTransform", oldTransform, transform);
        }
    }

    public synchronized void setSelectedIndex(int index) {
        this.select(index);
    }

    public synchronized void setSelectedIndexes(int[] indexes) {
        if (indexes.length > 0) {
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            Object[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            try {
                int i;
                OrderedListCollection tempIndexes = (OrderedListCollection)this.orderedIndexes.clone();
                OrderedListCollection tempItems = (OrderedListCollection)this.orderedItems.clone();
                this.deselectAllItems();
                ModelInterface model = this.getModelInterface();
                boolean foundValidIndex = false;
                for (i = 0; i < indexes.length; ++i) {
                    super.select(indexes[i]);
                    if (indexes[i] >= this.getItemCount() || indexes[i] <= -1) continue;
                    Integer temp = new Integer(indexes[i]);
                    this.orderedIndexes.add((Object)temp);
                    Object item = ((StaticOrderedCollectionInterface)model).get(indexes[i]);
                    this.orderedItems.add(item);
                    foundValidIndex = true;
                }
                if (!foundValidIndex) {
                    for (i = 0; i < oldSelIndexes.length; ++i) {
                        super.select(oldSelIndexes[i]);
                    }
                    int indexCount = tempIndexes.count();
                    for (int j = 0; j < indexCount; ++j) {
                        this.orderedIndexes.add(tempIndexes.get(j));
                        this.orderedItems.add(tempItems.get(j));
                    }
                    return;
                }
                OrderedCollection curItems = new OrderedCollection(oldSelItems);
                OrderedCollection newItems = new OrderedCollection((Object[])this.getSelectedItems());
                if (newItems.equals((StaticOrderedCollectionInterface)curItems)) {
                    return;
                }
                if (!this.anyPropertyChangeListeners()) {
                    return;
                }
                this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
                this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
                this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
                this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            this.deselectAll();
        }
    }

    public synchronized void setSelectedItem(Object text) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof StaticOrderedCollectionInterface) {
            Object inputItem = text;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(text);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"ListBox"));
                }
            }
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            boolean found_item = false;
            if (inputItem == null && oldSelIndexes.length > 0) {
                this.deselectAllItems();
                this.orderedIndexes.removeAll();
                this.orderedItems.removeAll();
            } else {
                if (Util.equal((Object)oldSelItem, (Object)inputItem)) {
                    return;
                }
                int itemCount = ((StaticOrderedCollectionInterface)model).count();
                for (int i = 0; i < itemCount; ++i) {
                    if (!Util.equal((Object)inputItem, (Object)((StaticOrderedCollectionInterface)model).get(i))) continue;
                    super.select(i);
                    Integer temp = new Integer(i);
                    this.orderedIndexes.add((Object)temp);
                    this.orderedItems.add(inputItem);
                    found_item = true;
                    break;
                }
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            if (found_item || inputItem == null && oldSelItem != null) {
                this.firePropertyChange("selectedItem", oldSelItem, inputItem);
                this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldSelItem, inputItem);
                int newSelected = this.getSelectedIndex();
                if (oldSelected != newSelected) {
                    this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(newSelected));
                }
            }
        }
    }

    public synchronized void setSelectedItem(String text) {
        if (this.inputTransform != null) {
            String temp = text;
            this.setSelectedItem((Object)temp);
            return;
        }
        Integer oldSelected = new Integer(this.getSelectedIndex());
        String oldSelItem = this.getSelectedItem();
        String[] oldSelItems = this.getSelectedItems();
        int[] oldSelIndexes = this.getSelectedIndexes();
        Object[] oldSelObjects = this.getSelectedObjects();
        boolean found_item = false;
        if (text == null && oldSelIndexes.length > 0) {
            this.deselectAllItems();
            this.orderedIndexes.removeAll();
            this.orderedItems.removeAll();
        } else {
            if (Util.equal((Object)oldSelItem, (Object)text)) {
                return;
            }
            if (!this.isMultipleMode()) {
                this.orderedIndexes.removeAll();
                this.orderedItems.removeAll();
            }
            int itemCount = this.getItemCount();
            for (int i = 0; i < itemCount; ++i) {
                if (!Util.equal((Object)this.getItem(i), (Object)text)) continue;
                super.select(i);
                Integer temp = new Integer(i);
                this.orderedIndexes.add((Object)temp);
                this.orderedItems.add((Object)this.getItem(i));
                found_item = true;
                break;
            }
        }
        if (!found_item) {
            this.deselectAllItems();
            this.orderedIndexes.removeAll();
            this.orderedItems.removeAll();
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("selectedItems", oldSelItems, new String[0]);
            this.firePropertyChange("selectedItem", oldSelItem, null);
            this.firePropertyChange("selectedIndex", oldSelected, new Integer(-1));
            this.firePropertyChange("selectedIndexes", oldSelIndexes, new int[0]);
            this.firePropertyChange("selectedObjects", oldSelObjects, new Object[0]);
            this.firePropertyChange("text", oldSelItem, null);
            return;
        }
        if (!this.anyPropertyChangeListeners()) {
            return;
        }
        if (found_item || text == null && oldSelItem != null) {
            this.firePropertyChange("selectedItem", oldSelItem, text);
            this.firePropertyChange("selectedItems", oldSelItems, new String[0]);
            this.firePropertyChange("selectedObjects", oldSelObjects, new Object[0]);
            this.firePropertyChange("text", oldSelItem, text);
            Integer newSelected = new Integer(this.getSelectedIndex());
            if (Util.unequal((Object)oldSelected, (Object)newSelected)) {
                this.firePropertyChange("selectedIndex", oldSelected, newSelected);
            }
        }
    }

    public synchronized void setSelectedItems(Object[] items) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof StaticOrderedCollectionInterface) {
            OrderedCollection curItems;
            OrderedCollection newItems;
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            if (items.length == 0 && oldSelItems.length == 0) {
                return;
            }
            if (items.length > 0 && oldSelItems.length > 0 && (newItems = new OrderedCollection(items)).equals((StaticOrderedCollectionInterface)(curItems = new OrderedCollection(oldSelObjects)))) {
                return;
            }
            this.deselectAllItems();
            this.orderedIndexes.removeAll();
            this.orderedItems.removeAll();
            if (items.length > 0) {
                for (int i = 0; i < items.length; ++i) {
                    Object inputItem = items[i];
                    if (this.inputTransform != null) {
                        try {
                            inputItem = this.inputTransform.transform(items[i]);
                        }
                        catch (TransformException e) {
                            System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"ListBox"));
                        }
                    }
                    if (inputItem != null) {
                        int selIndex = ((StaticOrderedCollectionInterface)model).getIndex(inputItem, 0);
                        if (selIndex == -1) continue;
                        super.select(selIndex);
                        this.orderedIndexes.add((Object)new Integer(selIndex));
                        this.orderedItems.add((Object)this.getItem(selIndex));
                        continue;
                    }
                    this.deselectAllItems();
                    this.orderedIndexes.removeAll();
                    this.orderedItems.removeAll();
                }
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
            this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
            this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
        }
    }

    public synchronized void setSelectedItems(String[] items) {
        OrderedCollection curItems;
        OrderedCollection newItems;
        if (this.inputTransform != null && items.length > 0) {
            Object[] newItems2 = new Object[items.length];
            for (int i = 0; i < items.length; ++i) {
                newItems2[i] = items[i];
            }
            this.setSelectedItems(newItems2);
            return;
        }
        int oldSelected = this.getSelectedIndex();
        String oldSelItem = this.getSelectedItem();
        Object[] oldSelItems = this.getSelectedItems();
        int[] oldSelIndexes = this.getSelectedIndexes();
        Object[] oldSelObjects = this.getSelectedObjects();
        if (items.length == 0 && oldSelItems.length == 0) {
            return;
        }
        if (items.length > 0 && oldSelItems.length > 0 && (newItems = new OrderedCollection((Object[])items)).equals((StaticOrderedCollectionInterface)(curItems = new OrderedCollection(oldSelItems)))) {
            return;
        }
        this.deselectAllItems();
        this.orderedIndexes.removeAll();
        this.orderedItems.removeAll();
        if (items.length > 0) {
            StringCollection t_items = new StringCollection(this.getItems());
            for (int i = 0; i < items.length; ++i) {
                int selIndex = t_items.getIndex(items[i], 0);
                if (items[i] == null) {
                    this.deselectAllItems();
                    this.orderedIndexes.removeAll();
                    this.orderedItems.removeAll();
                    continue;
                }
                if (selIndex == -1) continue;
                super.select(selIndex);
                this.orderedIndexes.add((Object)new Integer(selIndex));
                this.orderedItems.add((Object)this.getItem(selIndex));
            }
        }
        if (!this.anyPropertyChangeListeners()) {
            return;
        }
        this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
        this.firePropertyChange("selectedItems", oldSelItems, this.getSelectedItems());
        this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(this.getSelectedIndex()));
        this.firePropertyChange("selectedIndexes", oldSelIndexes, this.getSelectedIndexes());
        this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
        this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
    }

    public synchronized void setSelectionPrefix(String prefix) {
        String oldPrefix = this.getSelectionPrefix();
        if (prefix != null && prefix.length() > 0 && this.isKeyboardSelectable()) {
            this.selectionPrefix = prefix;
            int pos = -1;
            int itemCount = this.getItemCount();
            if (itemCount > 0) {
                int[] selIndexes = this.getOrderedIndexes();
                int indLength = selIndexes.length;
                pos = indLength > 0 && selIndexes[indLength - 1] + 1 < itemCount ? this.findItemByPrefix(this.selectionPrefix, selIndexes[indLength - 1] + 1) : this.findItemByPrefix(this.selectionPrefix, 0);
            }
            int oldSelected = this.getSelectedIndex();
            String oldSelItem = this.getSelectedItem();
            String[] oldSelItems = this.getSelectedItems();
            int[] oldSelIndexes = this.getSelectedIndexes();
            Object[] oldSelObjects = this.getSelectedObjects();
            if (pos >= 0) {
                if (this.shiftPressed) {
                    if (this.lastIndexClicked != -1) {
                        this.deselectIndexes = true;
                    }
                    this.processShiftSelection(pos);
                    if (this.anyPropertyChangeListeners()) {
                        this.fireSelectionPropertyChange(oldSelItem, oldSelItems, oldSelected, oldSelIndexes, oldSelObjects);
                    }
                } else {
                    this.deselectAll();
                    this.select(pos);
                }
                this.firePropertyChange("selectionPrefix", oldPrefix, prefix);
            } else {
                pos = this.findItemByPrefix(this.selectionPrefix, 0);
                if (pos >= 0) {
                    if (this.shiftPressed) {
                        if (this.lastIndexClicked != -1) {
                            this.deselectIndexes = true;
                        }
                        this.processShiftSelection(pos);
                        if (this.anyPropertyChangeListeners()) {
                            this.fireSelectionPropertyChange(oldSelItem, oldSelItems, oldSelected, oldSelIndexes, oldSelObjects);
                        }
                    } else {
                        this.deselectAll();
                        this.select(pos);
                    }
                    this.firePropertyChange("selectionPrefix", oldPrefix, prefix);
                } else {
                    this.deselectAll();
                }
            }
        } else if (prefix == null || prefix == "") {
            this.deselectAll();
        } else if (prefix != null && Util.unequal((Object)oldPrefix, (Object)prefix)) {
            this.selectionPrefix = prefix;
            this.deselectAll();
        }
    }

    public void setSelectionsOrdered(boolean value) {
        this.maintainOrderedSelections = value;
    }

    public synchronized void setText(String text) {
        this.setSelectedItem(text);
    }

    public synchronized void setVisibleRows(int rows) {
        int oldr = this.getRows();
        if (oldr != rows && rows > 0) {
            this.visRows = rows;
            Dimension dp = this.getSize();
            if (this.getPeer() != null) {
                Dimension d = this.getPreferredSize(rows);
                super.setSize(dp.width, d.height);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("visibleRows", new Integer(oldr), new Integer(rows));
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        if (this.orderedItems == null) {
            this.orderedItems = new OrderedListCollection();
        }
        if (this.orderedIndexes == null) {
            this.orderedIndexes = new OrderedListCollection();
        }
        this.executingReadObject = true;
        this.changeSelectionPrefix = true;
        if (this.excludedKeys == null) {
            this.excludedKeys = new OrderedListCollection();
            this.initializeExcludedKeys();
        }
    }
}

