/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.LabelVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.lang.StringData;
import com.sas.lang.StringDataInterface;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;

public class Label
extends LabelVisualComponent
implements PublicClonable,
StringDataInterface,
ResizeToFitInterface,
ViewDefaultModelInterface {
    private boolean resizeToFit;
    private StringData defaultModel;
    static final long serialVersionUID = 1769629011464838289L;
    public static final String RB_KEY = "Label.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.lang.StringDataInterface"};
    static int defaultWidth = 124;
    static int defaultHeight = 23;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "alignment"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"alignment.pd.txt")}, {"Property editor class", "com.sas.beans.editors.LabelAlignmentEditor"}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "resizeToFit"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"resizeToFit.pd.txt")}}, {{"Name", "text"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "23"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Label() {
        this.initializeComponent();
        if (this.isDesignTime()) {
            this.setText(com.sas.awt.RB.getStringResource((String)"Label.txt"));
        }
    }

    public Label(String text) {
        super(text);
        this.initializeComponent();
    }

    public Label(String text, int alignment) {
        super(text, alignment);
        this.initializeComponent();
    }

    public Label(ResourceBundle bundle, String textID) {
        this(bundle.getString(textID));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkForResizing();
        this.setEnabled(!this.isEnabled());
        this.setEnabled(!this.isEnabled());
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
    }

    private void checkForResizing() {
        if (this.isResizeToFit()) {
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Label clone = (Label)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setAlignment(this.getAlignment());
            clone.setResizeToFit(this.isResizeToFit());
            clone.setText(this.getText());
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                StringData clonedModel = (StringData)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.defaultModel.setText(null);
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"text")) {
            this.refresh();
        }
    }

    public void refresh() {
        String oldText;
        String text;
        ModelInterface model = this.getModelInterface();
        if (model != null && com.sas.util.Util.unequal((Object)(text = ((StringDataInterface)model).getText()), (Object)(oldText = this.getText()))) {
            super.setText(text);
            this.checkForResizing();
            this.firePropertyChange("text", oldText, text);
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model == null) {
            this.setText(null);
        } else {
            this.refresh();
        }
    }

    @Override
    public void setAlignment(int alignment) {
        int oldAlign = this.getAlignment();
        if (oldAlign != alignment) {
            super.setAlignment(alignment);
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("alignment", new Integer(oldAlign), new Integer(alignment));
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        this.setRequiredInterfaces(requiredInterfaces);
        this.defaultModel = new StringData();
        this.defaultModel.initialize();
        if (super.getText() != null) {
            this.defaultModel.setText(super.getText());
        }
        this.attachModel((ModelInterface)this.defaultModel);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.checkForResizing();
    }

    public void setResizeToFit(boolean resizeToFit) {
        if (this.resizeToFit != resizeToFit) {
            this.resizeToFit = resizeToFit;
            this.checkForResizing();
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("resizeToFit", resizeToFit ? Boolean.FALSE : Boolean.TRUE, resizeToFit ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setText(String text) {
        ModelInterface model = this.getModelInterface();
        if (com.sas.util.Util.unequal((Object)this.getText(), (Object)text) && model != null) {
            ((StringDataInterface)model).setText(text);
        }
    }
}

