/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.RB;
import com.sas.awt.DialogContainerComponent;
import com.sas.awt.ModalDispatchThread;
import com.sas.awt.util.Util;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.IDEDnDManager;
import com.sas.lang.StringDataInterface;
import com.sas.security.SecuritySupport;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.security.PrivilegedAction;

public class Dialog
extends DialogContainerComponent
implements WindowListener,
StringDataInterface {
    protected boolean autoDispose = true;
    protected boolean _modal;
    protected static boolean _inApplet;
    protected static boolean _cantUseSASModal;
    protected transient int setVisibleCalled;
    protected transient ModalDispatchThread t;
    protected final Object READY = new Serializable(){};
    static final long serialVersionUID = -706008273117437473L;
    public static final String RB_KEY = "Dialog.";
    static int defaultWidth;
    static int defaultHeight;

    public static boolean isSASModalEnabled() {
        return !_inApplet && !_cantUseSASModal;
    }

    public static void setSASModalEnabled(boolean nonAWTModal) {
        _inApplet = !nonAWTModal;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "name"}, {"Description", com.sas.awt.RB.getStringResource((String)"name.pd.txt")}, {"Expert", "true"}}, {{"Name", "modal"}, {"Short description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"modal.spd.txt")}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"modal.pd.txt")}}, {{"Name", "resizable"}, {"Short description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"resizable.spd.txt")}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"resizable.pd.txt")}}, {{"Name", "text"}, {"Hidden", "true"}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "title"}, {"Short description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"title.spd.txt")}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"title.pd.txt")}}, {{"Name", "defaultWidth"}, {"Default value", "100"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "30"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public Dialog(Frame parent) {
        super(parent);
        this.initializeComponent();
        this.enableEvents(64L);
    }

    public Dialog(Frame parent, String title, boolean modal) {
        super(parent, title, _inApplet || _cantUseSASModal ? modal : false);
        this._modal = modal;
        this.initializeComponent();
        this.enableEvents(64L);
    }

    public Dialog(Frame parent, String title) {
        super(parent, title);
        this.initializeComponent();
        this.enableEvents(64L);
    }

    @Override
    public void dispose() {
        if (_inApplet || _cantUseSASModal) {
            super.dispose();
        } else {
            this.fireReadySignal();
            super.dispose();
            this.stopDispatchThread();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(boolean visible, boolean doBlock) {
        ++this.setVisibleCalled;
        if (!this._modal || _inApplet || _cantUseSASModal) {
            boolean modalDialog = this.isModal();
            Container parent = this.getParent();
            boolean suspend = false;
            if (visible && modalDialog && parent instanceof Frame) {
                suspend = true;
                IDEDnDManager.suspend((Frame)parent);
            }
            super.setVisible(visible);
            if (suspend) {
                IDEDnDManager.resume((Frame)parent);
            }
            return;
        }
        if (visible && this._modal) {
            boolean inDispatchThread;
            Thread currentThread = Thread.currentThread();
            boolean bl = inDispatchThread = currentThread.getName().indexOf("AWT-EventQueue") >= 0;
            if (!inDispatchThread) {
                class EventDispatchThreadBlocker
                extends Button {
                    Object waiter = new Object();
                    boolean done;

                    public EventDispatchThreadBlocker() {
                        this.enableEvents(-1L);
                    }

                    @Override
                    protected void processEvent(AWTEvent e) {
                        this.done = true;
                        Dialog.this.waitForReadySignal();
                    }
                }
                EventDispatchThreadBlocker edtb = new EventDispatchThreadBlocker();
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ActionEvent(edtb, 1001, "abc"));
                while (!edtb.done) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (currentThread instanceof ModalDispatchThread) {
                ((ModalDispatchThread)currentThread).addChildWindow(this);
            }
            this.newDispatchThread();
            boolean modalDialog = this.isModal();
            Container parent = this.getParent();
            boolean suspend = false;
            if (modalDialog && parent instanceof Frame) {
                suspend = true;
                IDEDnDManager.suspend((Frame)parent);
            }
            super.setVisible(true);
            if (suspend) {
                IDEDnDManager.resume((Frame)parent);
            }
            this.waitTilReady(doBlock);
        }
        if (this.isVisible() && !visible && this._modal) {
            this.fireReadySignal();
            super.setVisible(false);
            this.stopDispatchThread();
        }
    }

    @Override
    public void show() {
        if (this.setVisibleCalled == 0) {
            this.setVisible(true);
        } else {
            super.show();
        }
    }

    @Override
    public void hide() {
        if (this.setVisibleCalled == 1) {
            this.setVisible(false);
        } else {
            super.hide();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201 || e.getID() == 202) {
            this.setVisibleCalled = 0;
        }
        if (e.getID() == 201 && this.autoDispose) {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReadySignal() {
        Object object = this.READY;
        synchronized (object) {
            try {
                this.READY.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireReadySignal() {
        Object object = this.READY;
        synchronized (object) {
            this.READY.notifyAll();
        }
    }

    protected void stopDispatchThread() {
        if (this.t != null) {
            this.t.stopDispatching();
            this.t = null;
        }
    }

    protected void newDispatchThread() {
        this.t = (ModalDispatchThread)SecuritySupport.securitySupport.doThreadPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ModalDispatchThread(Dialog.this);
            }
        });
        this.t.start();
    }

    protected void waitTilReady(boolean doBlock) {
        if (doBlock) {
            this.waitForReadySignal();
        }
    }

    public String getText() {
        return this.getTitle();
    }

    @Override
    public void setModal(boolean b) {
        if (this.isModal() != b) {
            if (_inApplet || _cantUseSASModal) {
                super.setModal(b);
            }
            this._modal = b;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"modal", (boolean)b);
        }
    }

    @Override
    public void setResizable(boolean resizable) {
        if (super.isResizable() != resizable) {
            super.setResizable(resizable);
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"resizable", (boolean)resizable);
        }
    }

    public void setText(String text) {
        this.setTitle(text);
    }

    @Override
    public void setTitle(String text) {
        String oldTitle;
        if (text == null) {
            text = "";
        }
        if ((oldTitle = this.getTitle()) == null || !oldTitle.equals(text)) {
            super.setTitle(text);
            this.firePropertyChange("title", oldTitle, text);
            this.firePropertyChange("text", oldTitle, text);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void center() {
        Util.center(this);
    }

    public void centerOver(Component component) {
        Util.centerOver(this, component);
    }

    public void centerOverWindow(Component component) {
        Util.centerOverWindow(this, component);
    }

    public boolean getAutoDispose() {
        return this.autoDispose;
    }

    public void setAutoDispose(boolean autoDispose) {
        if (this.autoDispose != autoDispose) {
            this.autoDispose = autoDispose;
            ComponentInterfaceSupport.firePropertyChange((ComponentInterface)this, (String)"autoDispose", (boolean)autoDispose);
        }
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        try {
            if (sm != null) {
                sm.checkAwtEventQueueAccess();
            }
        }
        finally {
            _inApplet = true;
        }
        {
        }
    }
}

