/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.DesignTimeDropResult;
import com.sas.awt.ContainerInterface;
import com.sas.awt.ContainerInterfaceSupportInfo;
import com.sas.awt.RB;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.graphics.IDEDnDManager;
import com.sas.util.errorhandlers.ErrorHandlerInterface;
import com.sas.util.validators.ValidationInterface;
import com.sas.util.validators.ValidatorInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;

public class ContainerInterfaceSupport
implements Serializable {
    static final long serialVersionUID = 1126060189173501123L;
    public static final String RB_KEY = "ContainerInterfaceSupport.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "IDEDnDDropTarget"}, {"Expert", "true"}}, {{"Name", "IDEDnDDropBarrier"}, {"Expert", "true"}}, {{"Name", "components"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"components.pd.txt")}, {"Expert", "true"}}, {{"Name", "componentCount"}, {"Description", RB.getStringResource((String)RB_KEY, (String)"componentCount.pd.txt")}, {"Expert", "true"}}, {{"Name", "containerInterfaceSupportInfo"}, {"Hidden", "true"}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public static void setDefaultValues(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        containerInstance.superSetDefaultValues();
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        info.isIDEDnDDropTarget = true;
        info.isIDEDnDDropBarrier = false;
        info.insets = new Insets(0, 0, 0, 0);
    }

    public static Insets getInsets(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        Insets infoInsets = info.insets;
        Insets superInsets = (Insets)containerInstance.superGetInsets().clone();
        Insets borderInsets = containerInstance.getBorder().getInsets((Component)awtContainerInstance);
        if (borderInsets == null) {
            borderInsets = new Insets(0, 0, 0, 0);
        }
        if (superInsets == null) {
            superInsets = new Insets(0, 0, 0, 0);
        }
        if (infoInsets == null) {
            infoInsets = new Insets(0, 0, 0, 0);
        }
        superInsets.top += infoInsets.top + borderInsets.top;
        superInsets.bottom += infoInsets.bottom + borderInsets.bottom;
        superInsets.right += infoInsets.right + borderInsets.right;
        superInsets.left += infoInsets.left + borderInsets.left;
        return superInsets;
    }

    public static void addNotify(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        containerInstance.superAddNotify();
        if (componentInstance.isDesignTime()) {
            if (containerInstance.isIDEDnDDropTarget()) {
                IDEDnDManager.registerTarget(awtContainerInstance);
            }
            if (containerInstance.isIDEDnDDropBarrier()) {
                IDEDnDManager.registerDnDBarrier(awtContainerInstance);
            }
        }
    }

    public static void removeNotify(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        containerInstance.superRemoveNotify();
        if (componentInstance.isDesignTime()) {
            if (containerInstance.isIDEDnDDropTarget()) {
                IDEDnDManager.unRegisterTarget(awtContainerInstance);
            }
            if (containerInstance.isIDEDnDDropBarrier()) {
                IDEDnDManager.unRegisterBarrier(awtContainerInstance);
            }
        }
    }

    public static void setInsets(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, Insets newInsets) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        if (newInsets == null) {
            info.insets = new Insets(0, 0, 0, 0);
        } else {
            Insets borderInsets = containerInstance.getBorder().getInsets((Component)awtContainerInstance);
            info.insets.top = newInsets.top >= borderInsets.top ? newInsets.top - borderInsets.top : 0;
            info.insets.bottom = newInsets.bottom >= borderInsets.bottom ? newInsets.bottom - borderInsets.bottom : 0;
            info.insets.right = newInsets.right >= borderInsets.right ? newInsets.right - borderInsets.right : 0;
            info.insets.left = newInsets.left >= borderInsets.left ? newInsets.left - borderInsets.left : 0;
        }
        awtContainerInstance.invalidate();
        awtContainerInstance.validate();
        componentInstance.firePropertyChange("insets", null, (Object)info.insets);
    }

    public static void setInsets(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, int top, int left, int bottom, int right) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        Insets borderInsets = containerInstance.getBorder().getInsets((Component)awtContainerInstance);
        info.insets.top = top >= borderInsets.top ? top - borderInsets.top : 0;
        info.insets.bottom = bottom >= borderInsets.bottom ? bottom - borderInsets.bottom : 0;
        info.insets.right = right >= borderInsets.right ? right - borderInsets.right : 0;
        info.insets.left = left >= borderInsets.left ? left - borderInsets.left : 0;
        awtContainerInstance.invalidate();
        awtContainerInstance.validate();
        componentInstance.firePropertyChange("insets", null, (Object)info.insets);
    }

    public static int dragOver(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, Point point, int representation, int keyState, Vector data) {
        return 2;
    }

    public static int dragEnter(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtComponawtContainerInstanceentInstance, Point point, int representation, int keyState, Vector data) {
        return -1;
    }

    public static void dragLeave(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
    }

    public static DesignTimeDropResult drop(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, Point point, int representation, int keyState, Vector data) {
        Insets inset = awtContainerInstance.getInsets();
        point.translate(inset.left, inset.top);
        Component comp = awtContainerInstance.getComponentAt(point.x, point.y);
        if (comp != null) {
            comp = ContainerInterfaceSupport.findDropComponent(comp);
        }
        DesignTimeDropResult retcode = null;
        switch (representation) {
            case 4: {
                retcode = new DesignTimeDropResult();
                retcode.container = awtContainerInstance;
                retcode.location = new Rectangle(point);
            }
        }
        return retcode;
    }

    public static boolean isIDEDnDDropTarget(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        return info.isIDEDnDDropTarget;
    }

    public static void setIDEDnDDropTarget(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, boolean isDropTarget) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        info.isIDEDnDDropTarget = isDropTarget;
        if (componentInstance.isDesignTime()) {
            if (isDropTarget) {
                IDEDnDManager.registerTarget(awtContainerInstance);
            } else {
                IDEDnDManager.unRegisterTarget(awtContainerInstance);
            }
        }
    }

    public static Component findDropComponent(Component component) {
        Component lastBarrier = component;
        Container ancestor = component.getParent();
        if (ancestor == null) {
            return component;
        }
        while (ancestor != null) {
            if (ancestor instanceof ContainerInterface && ((ContainerInterface)((Object)ancestor)).isIDEDnDDropBarrier()) {
                lastBarrier = ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return lastBarrier;
    }

    public static boolean isIDEDnDDropBarrier(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        return info.isIDEDnDDropBarrier;
    }

    public static void setIDEDnDDropBarrier(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, boolean isDropBarrier) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        info.isIDEDnDDropBarrier = isDropBarrier;
        if (componentInstance.isDesignTime()) {
            if (isDropBarrier) {
                IDEDnDManager.registerDnDBarrier(awtContainerInstance);
            } else {
                IDEDnDManager.unRegisterBarrier(awtContainerInstance);
            }
        }
    }

    public static ErrorHandlerInterface getErrorHandler(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        return info.errorHandler;
    }

    public static void setErrorHandler(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, ErrorHandlerInterface errorHandler) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        info.errorHandler = errorHandler;
        componentInstance.firePropertyChange("errorHandler", null, (Object)errorHandler);
    }

    public static boolean isValid(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        Component[] children = awtContainerInstance.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof ValidatorInterface) || ((ValidatorInterface)children[i]).isValid()) continue;
            return false;
        }
        return true;
    }

    public static ValidationInterface getValidator(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        return info.validator;
    }

    public static void setValidator(ComponentInterface componentInstance, ContainerInterface containerInstance, Container awtContainerInstance, ValidationInterface validator) {
        ContainerInterfaceSupportInfo info = containerInstance.getContainerInterfaceSupportInfo();
        info.validator = validator;
        componentInstance.firePropertyChange("validator", null, (Object)validator);
    }

    public static void clone(ContainerInterface sourceObject, ContainerInterface destObject) throws CloneNotSupportedException {
        if (sourceObject.getContainerInterfaceSupportInfo() != null) {
            destObject.setContainerInterfaceSupportInfo((ContainerInterfaceSupportInfo)sourceObject.getContainerInterfaceSupportInfo().clone());
        }
    }
}

