/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.ChoiceVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.collection.CollectionChangedInfo;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.collection.HowChanged;
import com.sas.collection.OrderedCollection;
import com.sas.collection.OrderedCollectionInterface;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.collection.StaticStringListInterface;
import com.sas.collection.StringCollection;
import com.sas.lang.StringDataInterface;
import com.sas.text.Message;
import com.sas.util.Util;
import com.sas.util.transforms.EnumerationTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Choice
extends ChoiceVisualComponent
implements ContentsChangedListener,
StringDataInterface,
PublicClonable,
ResizeToFitInterface,
ViewDefaultModelInterface {
    private boolean doAdd = true;
    private TransformInterface outputTransform;
    private TransformInterface inputTransform;
    private TransformInterface displayTransform;
    private StringCollection initItems;
    private OrderedCollection defaultModel;
    private boolean resizeToFit;
    private transient boolean doNotSelect;
    private transient boolean executingReadObject;
    private transient int smm = 0;
    static final long serialVersionUID = 7709097641697053726L;
    public static final String RB_KEY = "Choice.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.collection.StaticOrderedCollectionInterface"};
    static int defaultWidth = 124;
    static int defaultHeight = 25;

    private boolean notInContentsChanged() {
        return this.smm <= 0;
    }

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "displayTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"displayTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "inputTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"inputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "initialItems"}, {"Description", com.sas.awt.RB.getStringResource((String)"initialItems.pd.txt")}}, {{"Name", "items"}, {"Hidden", "true"}}, {{"Name", "outputTransform"}, {"Description", com.sas.awt.RB.getStringResource((String)"outputTransform.pd.txt")}, {"Expert", "true"}}, {{"Name", "resizeToFit"}, {"Description", Util.getCommonStringResource((String)"resizeToFit.pd.txt")}}, {{"Name", "selectedIndex"}, {"Description", com.sas.awt.RB.getStringResource((String)"selectedIndex.pd.txt")}}, {{"Name", "selectedItem"}, {"Description", com.sas.awt.RB.getStringResource((String)"selectedItem.pd.txt")}, {"Read method", "getSelectedItem"}, {"Property editor class", "com.sas.beans.editors._SelectedItemEditor"}}, {{"Name", "selectedObjects"}, {"Expert", "true"}}, {{"Name", "text"}, {"Hidden", "true"}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "25"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selectedItem";
        ebi.defaultOutputPropertyName = "selectedItem";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public Choice() {
        this.initializeComponent();
    }

    @Override
    public void add(String item) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            if (this.notInContentsChanged()) {
                ((OrderedCollectionInterface)model).add((Object)item);
            } else {
                super.add(item);
            }
        }
    }

    public void add(Object[] items) {
        OrderedCollection temp = new OrderedCollection(items);
        Enumeration etemp = temp.getItems();
        this.addItems(etemp);
    }

    public void addItems(Enumeration items) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            if (this.inputTransform != null) {
                EnumerationTransform enumer = new EnumerationTransform(items, this.inputTransform);
                ((OrderedCollectionInterface)model).addItems((Enumeration)enumer);
            } else {
                ((OrderedCollectionInterface)model).addItems(items);
            }
        }
    }

    public void add(Object item) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            Object inputItem = item;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(item);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"Choice"));
                }
            }
            ((OrderedCollectionInterface)model).add(inputItem);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isResizeToFit()) {
            this.setSize(this.computePreferredSize());
        }
    }

    @Override
    public void attachModel(ModelInterface model) {
        int newIndex;
        String newSelectedItem;
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).addContentsChangedListener((ContentsChangedListener)this);
        }
        String oldSelectedItem = this.getSelectedItem();
        int oldIndex = this.getSelectedIndex();
        Object[] oldSelObjects = this.getSelectedObjects();
        if (!this.executingReadObject && Util.unequal((Object)this.getModelInterface(), (Object)model)) {
            this.doNotSelect = true;
        }
        this.executingReadObject = false;
        super.attachModel(model);
        this.doNotSelect = false;
        if (this.isResizeToFit()) {
            this.setSize(this.getPreferredSize());
        }
        if (Util.unequal((Object)oldSelectedItem, (Object)(newSelectedItem = this.getSelectedItem()))) {
            this.firePropertyChange("selectedItem", oldSelectedItem, newSelectedItem);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelectedItem, newSelectedItem);
        }
        if (oldIndex != (newIndex = this.getSelectedIndex())) {
            this.firePropertyChange("selectedIndex", new Integer(oldIndex), new Integer(newIndex));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Choice clone = (Choice)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setDisplayTransform(this.getDisplayTransform());
            clone.setInputTransform(this.getInputTransform());
            clone.setOutputTransform(this.getOutputTransform());
            int selIndex = this.getSelectedIndex();
            if (selIndex >= 0) {
                clone.setSelectedIndex(this.getSelectedIndex());
            }
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                OrderedCollection clonedModel = (OrderedCollection)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public Dimension computePreferredSize() {
        Enumeration elements = null;
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            int itemCount = ((StaticOrderedCollectionInterface)model).count();
            if (itemCount > 0 && this.getFont() != null) {
                elements = ((StaticOrderedCollectionInterface)model).getItems();
                int textwidth = 0;
                try {
                    Object largestElement = elements.nextElement();
                    if (this.displayTransform != null) {
                        largestElement = this.displayTransform.transform(largestElement);
                    }
                    String sLargestElement = largestElement.toString();
                    while (elements.hasMoreElements()) {
                        String temp;
                        Object oTemp = elements.nextElement();
                        if (this.getDisplayTransform() != null) {
                            oTemp = this.displayTransform.transform(oTemp);
                        }
                        if ((temp = oTemp.toString()).length() <= sLargestElement.length()) continue;
                        sLargestElement = temp;
                    }
                    FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
                    textwidth = fontmetrics.stringWidth(sLargestElement) + 30;
                }
                catch (Exception e) {
                    return new Dimension(super.computePreferredSize());
                }
                return new Dimension(textwidth, super.computePreferredSize().height);
            }
            return new Dimension(super.computePreferredSize());
        }
        return new Dimension(super.computePreferredSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void contentsChanged(ContentsChangedEvent evt) {
        boolean handled = false;
        try {
            int newIndex;
            if (this.smm < 0) {
                this.smm = 0;
            }
            ++this.smm;
            if (evt instanceof CollectionChangedInfo) {
                CollectionChangedInfo nevt = (CollectionChangedInfo)evt;
                String[] oldItems = this.getItems();
                int selIndex = this.getSelectedIndex();
                String oldSelItem = this.getSelectedItem();
                Object[] oldSelObjects = this.getSelectedObjects();
                if (nevt.howChanged == HowChanged.ADDED) {
                    handled = true;
                    if (nevt.whatChanged != null) {
                        Object dItem = nevt.whatChanged;
                        if (this.displayTransform != null) {
                            Object displayItem = this.displayTransform.transform(dItem);
                            super.insert(displayItem.toString(), nevt.start);
                        } else {
                            super.insert(dItem.toString(), nevt.start);
                        }
                        if (selIndex != -1) {
                            if (selIndex < nevt.start) {
                                super.select(selIndex);
                            } else if (selIndex + 1 <= this.getItemCount()) {
                                super.select(selIndex + 1);
                            }
                        }
                    } else {
                        ModelInterface model = this.getModelInterface();
                        Enumeration enc = ((StaticOrderedCollectionInterface)model).getItems(nevt.start, nevt.end);
                        int position = nevt.start;
                        int i = 0;
                        while (enc.hasMoreElements()) {
                            Object dItem = enc.nextElement();
                            if (this.displayTransform != null) {
                                Object displayItem = this.displayTransform.transform(dItem);
                                if (displayItem == null) throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                                super.insert(displayItem.toString(), position++);
                                ++i;
                                continue;
                            }
                            if (dItem != null) {
                                super.insert(dItem.toString(), position++);
                                ++i;
                                continue;
                            }
                            if (dItem != null) continue;
                            throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                        }
                        if (selIndex != -1) {
                            if (selIndex < nevt.start) {
                                super.select(selIndex);
                            } else if (selIndex + i <= this.getItemCount()) {
                                super.select(selIndex + i);
                            }
                        }
                    }
                    if (!this.anyPropertyChangeListeners()) {
                        return;
                    }
                    int newSelectedIndex = this.getSelectedIndex();
                    if (newSelectedIndex != selIndex) {
                        this.firePropertyChange("selectedIndex", new Integer(selIndex), new Integer(newSelectedIndex));
                        String newSelItem = this.getSelectedItem();
                        if (Util.unequal((Object)newSelItem, (Object)oldSelItem)) {
                            this.firePropertyChange("selectedItem", oldSelItem, newSelItem);
                            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                            this.firePropertyChange("text", oldSelItem, newSelItem);
                        }
                    }
                    String[] newItems = this.getItems();
                    this.firePropertyChange("items", oldItems, newItems);
                } else if (nevt.howChanged == HowChanged.REMOVED) {
                    handled = true;
                    oldSelItem = this.getSelectedItem();
                    if (nevt.whatChanged != null) {
                        super.remove(nevt.start);
                        int currentSelected = this.getSelectedIndex();
                        if (currentSelected == 0 && this.getItemCount() > 0) {
                            super.select(0);
                        }
                        if (this.anyPropertyChangeListeners() && currentSelected != selIndex) {
                            this.firePropertyChange("selectedIndex", new Integer(selIndex), new Integer(currentSelected));
                            this.firePropertyChange("selectedItem", oldSelItem, this.getSelectedItem());
                            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                            this.firePropertyChange("text", oldSelItem, this.getSelectedItem());
                        }
                    } else {
                        String selItem = this.getSelectedItem();
                        if (nevt.start == 0) {
                            super.removeAll();
                        } else {
                            for (int i = nevt.end - 1; i > nevt.start - 1; --i) {
                                super.remove(i);
                            }
                        }
                        if (this.anyPropertyChangeListeners() && selIndex != -1) {
                            this.firePropertyChange("selectedIndex", new Integer(selIndex), new Integer(-1));
                            this.firePropertyChange("selectedItem", selItem, null);
                            this.firePropertyChange("selectedObjects", oldSelObjects, new Object[0]);
                            this.firePropertyChange("text", selItem, null);
                        }
                    }
                    String[] newItems = this.getItems();
                    this.firePropertyChange("items", oldItems, newItems);
                } else if (nevt.howChanged == HowChanged.REPLACED) {
                    int newSelectedIndex;
                    handled = true;
                    ModelInterface model = this.getModelInterface();
                    Object obj = ((StaticOrderedCollectionInterface)model).get(nevt.start);
                    if (this.displayTransform != null) {
                        Object displayItem = this.displayTransform.transform(obj);
                        if (displayItem == null) throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                        super.insert(displayItem.toString(), nevt.start);
                        super.remove(nevt.start + 1);
                    } else if (obj != null) {
                        super.insert(obj.toString(), nevt.start);
                        super.remove(nevt.start + 1);
                    } else if (obj == null) {
                        throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                    }
                    if (selIndex > nevt.start) {
                        super.select(selIndex);
                    }
                    if ((newSelectedIndex = this.getSelectedIndex()) != selIndex) {
                        this.firePropertyChange("selectedIndex", new Integer(selIndex), new Integer(newSelectedIndex));
                        String newSelItem = this.getSelectedItem();
                        if (Util.unequal((Object)newSelItem, (Object)oldSelItem)) {
                            this.firePropertyChange("selectedItem", oldSelItem, newSelItem);
                            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                            this.firePropertyChange("text", oldSelItem, newSelItem);
                        }
                    }
                    String[] newItems = this.getItems();
                    this.firePropertyChange("items", oldItems, newItems);
                } else if (nevt.howChanged == HowChanged.REORDERED) {
                    ModelInterface model = this.getModelInterface();
                    this.refresh(model);
                }
                if (this.isResizeToFit()) {
                    this.setSize(this.getPreferredSize());
                }
            }
            if (handled) return;
            String oldSelectedItem = this.getSelectedItem();
            int oldIndex = this.getSelectedIndex();
            Object[] oldSelObjects = this.getSelectedObjects();
            this.doNotSelect = true;
            this.refresh(this.getModelInterface());
            this.doNotSelect = false;
            String newSelectedItem = this.getSelectedItem();
            if (Util.unequal((Object)oldSelectedItem, (Object)newSelectedItem)) {
                this.firePropertyChange("selectedItem", oldSelectedItem, newSelectedItem);
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldSelectedItem, newSelectedItem);
            }
            if (oldIndex == (newIndex = this.getSelectedIndex())) return;
            this.firePropertyChange("selectedIndex", new Integer(oldIndex), new Integer(newIndex));
            return;
        }
        catch (TransformException transformException) {
            return;
        }
        finally {
            --this.smm;
        }
    }

    @Override
    public void detachModel(ModelInterface model) {
        if (model instanceof ContentsChangedSource) {
            ((ContentsChangedSource)model).removeContentsChangedListener((ContentsChangedListener)this);
        }
        if (this.defaultModel != null && this.defaultModel.count() > 0) {
            this.defaultModel.removeAll();
        }
        super.detachModel(model);
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    public TransformInterface getDisplayTransform() {
        return this.displayTransform;
    }

    public synchronized String[] getInitialItems() {
        if (this.defaultModel != null && this.defaultModel.count() > 0) {
            int i = 0;
            int modelCount = this.defaultModel.count();
            String[] items = new String[modelCount];
            Enumeration modelE = this.defaultModel.getItems();
            EnumerationTransform initialItemsE = new EnumerationTransform(modelE, this.outputTransform);
            while (initialItemsE.hasMoreElements()) {
                items[i++] = initialItemsE.nextElement().toString();
            }
            return items;
        }
        return new String[0];
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }

    public String[] getItems() {
        String[] none = new String[]{};
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            int itemCount = ((StaticOrderedCollectionInterface)model).count();
            String[] items = new String[itemCount];
            if (this.outputTransform != null) {
                try {
                    for (int i = 0; i < itemCount; ++i) {
                        Object temp = ((StaticOrderedCollectionInterface)model).get(i);
                        items[i] = this.outputTransform.transform(temp).toString();
                    }
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"outputTransform.ex.txt"), (Object)"Choice"));
                }
            } else {
                for (int i = 0; i < itemCount; ++i) {
                    Object temp = ((StaticOrderedCollectionInterface)model).get(i);
                    items[i] = temp != null ? temp.toString() : "";
                }
            }
            return items;
        }
        return none;
    }

    public TransformInterface getOutputTransform() {
        return this.outputTransform;
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    @Override
    public Object[] getSelectedObjects() {
        int selIndex = this.getSelectedIndex();
        ModelInterface model = this.getModelInterface();
        if (model != null && ((StaticOrderedCollectionInterface)model).count() > 0 && selIndex >= 0) {
            int count = ((StaticOrderedCollectionInterface)model).count();
            if (selIndex >= count) {
                return new Object[0];
            }
            Object[] items = new Object[1];
            if (this.outputTransform != null) {
                try {
                    Object temp = ((StaticOrderedCollectionInterface)model).get(selIndex);
                    items[0] = this.outputTransform.transform(temp);
                }
                catch (TransformException transformException) {}
            } else {
                items[0] = ((StaticOrderedCollectionInterface)model).get(selIndex);
            }
            return items;
        }
        return new Object[0];
    }

    public String getText() {
        return this.getSelectedItem();
    }

    public void insert(Object item, int index) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            Object inputItem = item;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(item);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"Choice"));
                }
            }
            ((OrderedCollectionInterface)model).add(inputItem, index);
        }
    }

    @Override
    public void insert(String item, int index) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).add((Object)item, index);
        }
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    @Override
    protected void processItemEvent(ItemEvent e) {
        try {
            Object outputItem = e.getItem();
            if (this.outputTransform != null) {
                outputItem = this.outputTransform.transform(e.getItem());
            }
            ItemEvent newItemEvent = new ItemEvent(e.getItemSelectable(), e.getID(), outputItem, e.getStateChange());
            super.processItemEvent(newItemEvent);
        }
        catch (TransformException exc) {
            System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"processItemEvent.ex.txt"), (Object)((Object)exc)));
        }
    }

    public void refresh() {
        ModelInterface model = this.getModelInterface();
        if (model != null) {
            this.refresh(model);
        } else {
            super.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(ModelInterface model) {
        try {
            ++this.smm;
            if (model != null) {
                int selIndex = this.getSelectedIndex();
                super.removeAll();
                int itemCount = super.getItemCount();
                for (int i = itemCount - 1; i >= 0; --i) {
                    super.remove(i);
                }
                Enumeration elements = ((StaticOrderedCollectionInterface)model).getItems();
                if (elements != null) {
                    while (elements.hasMoreElements()) {
                        Object dItem = elements.nextElement();
                        if (this.displayTransform != null) {
                            Object displayItem = this.displayTransform.transform(dItem);
                            if (displayItem != null) {
                                super.add(displayItem.toString());
                                continue;
                            }
                            throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                        }
                        if (dItem != null) {
                            super.add(dItem.toString());
                            continue;
                        }
                        if (dItem != null) continue;
                        throw new NullPointerException(com.sas.awt.RB.getStringResource((String)"NullPointerException.ex.txt"));
                    }
                }
            }
        }
        catch (TransformException transformException) {
        }
        finally {
            --this.smm;
        }
    }

    @Override
    public void remove(int position) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            if (this.notInContentsChanged()) {
                ((OrderedCollectionInterface)model).removeAt(position);
            } else {
                super.remove(position);
            }
        }
    }

    public void remove(Object item) {
        Object inputItem = item;
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            int i;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(item);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"Choice"));
                }
            }
            boolean found_item = false;
            int itemCount = ((OrderedCollectionInterface)model).count();
            for (i = 0; i < itemCount; ++i) {
                if (!Util.equal((Object)inputItem, (Object)((OrderedCollectionInterface)model).get(i))) continue;
                found_item = true;
                break;
            }
            if (found_item) {
                this.remove(i);
            } else {
                throw new IllegalArgumentException(Message.format((String)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"IllegalArgumentException.ex.txt"), (Object)item));
            }
        }
    }

    @Override
    public void remove(String item) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            int i;
            boolean found_item = false;
            int itemCount = this.getItemCount();
            for (i = 0; i < itemCount; ++i) {
                if (!Util.equal((Object)item, (Object)this.getItem(i))) continue;
                found_item = true;
                break;
            }
            if (found_item) {
                this.remove(i);
            } else {
                throw new IllegalArgumentException(Message.format((String)com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"IllegalArgumentException.ex.txt"), (Object)item));
            }
        }
    }

    @Override
    public void removeAll() {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof OrderedCollectionInterface) {
            ((OrderedCollectionInterface)model).removeAll();
        }
    }

    @Override
    public void select(int index) {
        if (this.notInContentsChanged()) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex != index) {
                Integer oldSelected = new Integer(selectedIndex);
                String oldSelItem = null;
                Object[] oldSelObjects = this.getSelectedObjects();
                if (selectedIndex < this.getItemCount()) {
                    oldSelItem = this.getSelectedItem();
                }
                super.select(index);
                if (!this.anyPropertyChangeListeners()) {
                    return;
                }
                String newSelItem = this.getSelectedItem();
                if (Util.unequal((Object)newSelItem, (Object)oldSelItem)) {
                    this.firePropertyChange("selectedItem", oldSelItem, newSelItem);
                    this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                    this.firePropertyChange("text", oldSelItem, newSelItem);
                }
                this.firePropertyChange("selectedIndex", oldSelected, new Integer(this.getSelectedIndex()));
            }
        } else {
            super.select(index);
        }
    }

    @Override
    public void select(String str) {
        this.setSelectedItem(str);
    }

    @Override
    public void setDefaultValues() {
        this.defaultModel = new OrderedCollection();
        this.defaultModel.initialize();
        this.setModelInterface((ModelInterface)this.defaultModel);
    }

    public void setDisplayTransform(TransformInterface transform) {
        if (transform != this.displayTransform) {
            TransformInterface oldTransform = this.displayTransform;
            this.displayTransform = transform;
            ModelInterface model = this.getModelInterface();
            if (this.getModelInterface() != null) {
                this.refresh(model);
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("displayTransform", oldTransform, transform);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getPeer() != null) {
            this.addNotify();
        }
    }

    public void setInitialItems(String[] items) {
        StringCollection newItems;
        StringCollection curItems;
        boolean i = false;
        String[] oldItems = this.getInitialItems();
        if (items == null) {
            items = new String[]{};
        }
        if (Util.equal((Object)(curItems = new StringCollection(oldItems)), (Object)(newItems = new StringCollection(items)))) {
            return;
        }
        this.defaultModel.removeAll();
        Enumeration eitems = newItems.getItems();
        if (this.defaultModel instanceof ContentsChangedSource) {
            this.defaultModel.removeContentsChangedListener((ContentsChangedListener)this);
        }
        this.addItems(eitems);
        this.refresh();
        this.defaultModel.addContentsChangedListener((ContentsChangedListener)this);
        int oldSelected = this.getSelectedIndex();
        String oldSelItem = this.getSelectedItem();
        Object[] oldSelObjects = this.getSelectedObjects();
        ModelInterface model = this.getModelInterface();
        if (model == null || model != this.defaultModel) {
            this.detachModel(model);
        }
        this.firePropertyChange("initialItems", oldItems, items);
        int newSelected = this.getSelectedIndex();
        String newSelItem = this.getSelectedItem();
        if (newSelected != oldSelected) {
            this.firePropertyChange("selectedIndex", new Integer(oldSelected), new Integer(newSelected));
        }
        if (newSelItem != oldSelItem) {
            this.firePropertyChange("selectedItem", oldSelItem, newSelItem);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
        }
        if (this.isResizeToFit()) {
            this.setSize(this.getPreferredSize());
        }
    }

    public void setInputTransform(TransformInterface transform) {
        if (transform != this.inputTransform) {
            TransformInterface oldTransform = this.inputTransform;
            this.inputTransform = transform;
            this.firePropertyChange("inputTransform", oldTransform, transform);
        }
    }

    public void setItems(Object[] items) {
        if (items != null && items.length > 0) {
            ModelInterface si = this.getModelInterface();
            if (si != null && si instanceof OrderedCollectionInterface) {
                Vector curItems = new Vector();
                Enumeration ecr = ((OrderedCollectionInterface)si).getItems();
                while (ecr.hasMoreElements()) {
                    curItems.addElement(ecr.nextElement());
                }
                Vector<Object> newItems = new Vector<Object>();
                for (int i = 0; i < items.length; ++i) {
                    newItems.addElement(items[i]);
                }
                if (newItems.equals(curItems)) {
                    return;
                }
                super.removeAll();
                Enumeration sl = newItems.elements();
                ((OrderedCollectionInterface)si).addItems(sl);
            }
        } else {
            super.removeAll();
        }
    }

    public void setItems(String[] items) {
        if (items != null && items.length > 0) {
            ModelInterface si = this.getModelInterface();
            if (si != null && si instanceof OrderedCollectionInterface) {
                StringCollection newItems = new StringCollection(items);
                StringCollection curItems = new StringCollection(this.getItems());
                if (newItems.equals((StaticStringListInterface)curItems)) {
                    return;
                }
                super.removeAll();
                Vector<String> vi = new Vector<String>(items.length);
                for (int i = 0; i < items.length; ++i) {
                    vi.addElement(items[i]);
                }
                Enumeration sl = vi.elements();
                ((OrderedCollectionInterface)si).addItems(sl);
            }
        } else {
            super.removeAll();
        }
    }

    public void setOutputTransform(TransformInterface transform) {
        if (transform != this.outputTransform) {
            TransformInterface oldTransform = this.outputTransform;
            this.outputTransform = transform;
            this.firePropertyChange("outputTransform", oldTransform, transform);
        }
    }

    public void setResizeToFit(boolean resizeToFit) {
        if (this.resizeToFit != resizeToFit) {
            this.resizeToFit = resizeToFit;
            ModelInterface model = this.getModelInterface();
            if (model != null && resizeToFit && ((StaticOrderedCollectionInterface)model).count() > 0) {
                this.setSize(this.getPreferredSize());
            }
            this.firePropertyChange("resizeToFit", resizeToFit ? Boolean.FALSE : Boolean.TRUE, resizeToFit ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setSelectedIndex(int index) {
        this.select(index);
    }

    public void setSelectedItem(Object text) {
        ModelInterface model = this.getModelInterface();
        if (model != null && model instanceof StaticOrderedCollectionInterface) {
            Object inputItem = text;
            if (this.inputTransform != null) {
                try {
                    inputItem = this.inputTransform.transform(text);
                }
                catch (TransformException e) {
                    System.out.println(Message.format((String)com.sas.awt.RB.getStringResource((String)"inputTransform.ex.txt"), (Object)"Choice"));
                }
            }
            Integer oldSelected = new Integer(this.getSelectedIndex());
            String oldSelItem = this.getSelectedItem();
            Object[] oldSelObjects = this.getSelectedObjects();
            boolean found_item = false;
            if (Util.equal((Object)oldSelItem, (Object)inputItem)) {
                return;
            }
            int itemCount = ((StaticOrderedCollectionInterface)model).count();
            for (int i = 0; i < itemCount; ++i) {
                if (!Util.equal((Object)inputItem, (Object)((StaticOrderedCollectionInterface)model).get(i))) continue;
                super.select(i);
                found_item = true;
                break;
            }
            if (!found_item) {
                throw new IllegalArgumentException("item " + text + " not found in choice");
            }
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            if (found_item) {
                this.firePropertyChange("selectedItem", oldSelItem, inputItem);
                this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
                this.firePropertyChange("text", oldSelItem, inputItem);
                Integer newSelected = new Integer(this.getSelectedIndex());
                if (Util.unequal((Object)oldSelected, (Object)newSelected)) {
                    this.firePropertyChange("selectedIndex", oldSelected, newSelected);
                }
            }
        }
    }

    public void setSelectedItem(String text) {
        if (this.inputTransform != null) {
            String temp = text;
            this.setSelectedItem((Object)temp);
            return;
        }
        Integer oldSelected = new Integer(this.getSelectedIndex());
        String oldSelItem = this.getSelectedItem();
        Object[] oldSelObjects = this.getSelectedObjects();
        boolean found_item = false;
        if (Util.equal((Object)oldSelItem, (Object)text)) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!Util.equal((Object)this.getItem(i), (Object)text)) continue;
            super.select(i);
            found_item = true;
            break;
        }
        if (!found_item) {
            throw new IllegalArgumentException("item " + text + " not found in choice");
        }
        if (!this.anyPropertyChangeListeners()) {
            return;
        }
        if (found_item || text == null && oldSelItem != null) {
            this.firePropertyChange("selectedItem", oldSelItem, text);
            this.firePropertyChange("selectedObjects", oldSelObjects, this.getSelectedObjects());
            this.firePropertyChange("text", oldSelItem, text);
            Integer newSelected = new Integer(this.getSelectedIndex());
            if (Util.unequal((Object)oldSelected, (Object)newSelected)) {
                this.firePropertyChange("selectedIndex", oldSelected, newSelected);
            }
        }
    }

    public void setText(String text) {
        this.setSelectedItem(text);
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        this.executingReadObject = true;
        if (this.getSelectedIndex() == -1 && this.countItems() != 0) {
            this.setSelectedIndex(0);
        }
    }
}

