/*
 * Decompiled with CFR 0.152.
 */
package com.sas.awt;

import com.sas.ComponentInterface;
import com.sas.ComponentInterfaceSupport;
import com.sas.ModelInterface;
import com.sas.PublicClonable;
import com.sas.RB;
import com.sas.ViewDefaultModelInterface;
import com.sas.awt.CheckBoxVisualComponent;
import com.sas.awt.VisualInterfaceSupport;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.beans.Util;
import com.sas.lang.BooleanData;
import com.sas.lang.BooleanDataInterface;
import com.sas.lang.StringDataInterface;
import com.sas.visuals.ResizeToFitInterface;
import java.awt.CheckboxGroup;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;

public class CheckBox
extends CheckBoxVisualComponent
implements StringDataInterface,
PublicClonable,
ResizeToFitInterface,
ViewDefaultModelInterface {
    private boolean superSetState;
    private boolean resizeToFit;
    private BooleanData defaultModel;
    static final long serialVersionUID = -6359374720823241553L;
    public static final String RB_KEY = "CheckBox.";
    private static String[] requiredInterfacesString = new String[]{"com.sas.lang.BooleanDataInterface"};
    static int defaultWidth = 124;
    static int defaultHeight = 23;

    public static int getDefaultWidth() {
        return defaultWidth;
    }

    public static synchronized void setDefaultWidth(int newDefaultWidth) {
        defaultWidth = newDefaultWidth;
    }

    public static int getDefaultHeight() {
        return defaultHeight;
    }

    public static synchronized void setDefaultHeight(int newDefaultHeight) {
        defaultHeight = newDefaultHeight;
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{{{"Name", "border"}, {"Hidden", "true"}}, {{"Name", "checkboxGroup"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"checkboxGroup.pd.txt")}, {"Expert", "true"}}, {{"Name", "defaultModelAttached"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"defaultModelAttached.pd.txt")}, {"Expert", "true"}}, {{"Name", "label"}, {"Hidden", "true"}}, {{"Name", "resizeToFit"}, {"Description", com.sas.util.Util.getCommonStringResource((String)"resizeToFit.pd.txt")}}, {{"Name", "selected"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"selected.pd.txt")}}, {{"Name", "selectedObjects"}, {"Expert", "true"}}, {{"Name", "state"}, {"Hidden", "true"}}, {{"Name", "text"}, {"Description", com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"text.pd.txt")}}, {{"Name", "transparent"}, {"Hidden", "true"}}, {{"Name", "defaultWidth"}, {"Default value", "124"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultWidth.pd.txt")}}, {{"Name", "defaultHeight"}, {"Default value", "23"}, {"Description", RB.getStringResource((String)"VisualInterface.defaultHeight.pd.txt")}}};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "selected";
        ebi.defaultOutputPropertyName = "selected";
        ebi.propertyMetadata = propertyMetadata;
        ebi.shortDescription = com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"description.txt");
        return ebi;
    }

    public CheckBox() {
        this.initializeComponent();
        if (this.isDesignTime()) {
            this.setText(com.sas.awt.RB.getStringResource((String)RB_KEY, (String)"constructor.txt"));
        }
    }

    public CheckBox(String text) {
        super(text);
        this.initializeComponent();
    }

    public CheckBox(ResourceBundle bundle, String textID) {
        super(bundle.getString(textID));
        this.initializeComponent();
    }

    public CheckBox(String text, boolean state) {
        super(text, state);
        this.initializeComponent();
        this.setState(true);
    }

    public CheckBox(String text, boolean state, CheckboxGroup group) {
        super(text, state, group);
        this.initializeComponent();
        this.setState(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkForResizing();
    }

    @Override
    public void attachModel(ModelInterface model) {
        super.attachModel(model);
        Util.addPropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
    }

    private void checkForResizing() {
        if (this.isResizeToFit()) {
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            CheckBox clone = (CheckBox)this.getClass().newInstance();
            ComponentInterfaceSupport.clone((ComponentInterface)this, (ComponentInterface)clone);
            VisualInterfaceSupport.clone(this, clone);
            clone.setCheckboxGroup(this.getCheckboxGroup());
            clone.setText(this.getLabel());
            clone.setResizeToFit(this.isResizeToFit());
            clone.setSelected(this.getState());
            if (this.defaultModel != null && this.getModelInterface() == this.defaultModel) {
                BooleanData clonedModel = (BooleanData)this.defaultModel.clone();
                clone.setModelInterface((ModelInterface)clonedModel);
                clone.defaultModel = clonedModel;
            }
            clone.initialize();
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    @Override
    public Dimension computePreferredSize() {
        if (this.getFont() != null && this.getText().length() > 0) {
            FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
            int textwidth = fontmetrics.stringWidth(this.getLabel()) + 30;
            int textheight = fontmetrics.getAscent() + fontmetrics.getDescent() + 10;
            return new Dimension(textwidth, textheight);
        }
        return super.computePreferredSize();
    }

    @Override
    public void detachModel(ModelInterface model) {
        super.detachModel(model);
        Util.removePropertyChangeListener((Object)model, (PropertyChangeListener)((Object)this));
        ModelInterface modelInterface = this.getModelInterface();
        if (modelInterface == null) {
            this.defaultModel.setBooleanData(false);
            this.setModelInterface((ModelInterface)this.defaultModel);
        }
    }

    @Override
    public Vector getRequiredInterfaces() {
        Vector<String[]> requiredInterfaces = new Vector<String[]>(1);
        requiredInterfaces.addElement(requiredInterfacesString);
        return requiredInterfaces;
    }

    public String getText() {
        return this.getLabel();
    }

    public boolean isDefaultModelAttached() {
        return this.defaultModel == this.getModelInterface();
    }

    public boolean isResizeToFit() {
        return this.resizeToFit;
    }

    public boolean isSelected() {
        return this.getState();
    }

    @Override
    protected void processItemEvent(ItemEvent e) {
        super.processItemEvent(e);
        boolean state = this.getState();
        this.firePropertyChange("selected", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("state", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.getModelInterface() && com.sas.util.Util.equal((Object)event.getPropertyName(), (Object)"booleanData")) {
            this.refresh();
        }
    }

    public void refresh() {
        boolean state;
        boolean oldState;
        ModelInterface model = this.getModelInterface();
        if (model != null && (oldState = this.getState()) != (state = ((BooleanDataInterface)model).getBooleanData())) {
            super.setState(state);
            this.firePropertyChange("selected", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange("state", state ? Boolean.FALSE : Boolean.TRUE, state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void refresh(ModelInterface model) {
        if (model == null) {
            this.setSelected(false);
        } else {
            this.refresh();
        }
    }

    @Override
    public void setCheckboxGroup(CheckboxGroup g) {
        CheckboxGroup oldGroup = this.getCheckboxGroup();
        if (com.sas.util.Util.unequal((Object)oldGroup, (Object)g)) {
            super.setCheckboxGroup(g);
            this.firePropertyChange("checkboxGroup", oldGroup, g);
        }
    }

    @Override
    public void setDefaultValues() {
        super.setDefaultValues();
        this.defaultModel = new BooleanData();
        this.defaultModel.initialize();
        this.attachModel((ModelInterface)this.defaultModel);
        this.defaultModel.setBooleanData(this.getState());
        this.enableEvents(512L);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.checkForResizing();
    }

    @Override
    public void setLabel(String text) {
        if (com.sas.util.Util.unequal((Object)this.getLabel(), (Object)text)) {
            String oldLabel = this.getLabel();
            super.setLabel(text);
            this.checkForResizing();
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("text", oldLabel, text);
            this.firePropertyChange("label", oldLabel, text);
        }
    }

    public void setResizeToFit(boolean resizeToFit) {
        if (this.resizeToFit != resizeToFit) {
            this.resizeToFit = resizeToFit;
            this.checkForResizing();
            if (!this.anyPropertyChangeListeners()) {
                return;
            }
            this.firePropertyChange("resizeToFit", resizeToFit ? Boolean.FALSE : Boolean.TRUE, resizeToFit ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void setSelected(boolean state) {
        this.setState(state);
    }

    @Override
    public void setState(boolean state) {
        ModelInterface model = this.getModelInterface();
        if (this.getState() != state && model != null) {
            ((BooleanDataInterface)model).setBooleanData(state);
        }
    }

    public void setText(String text) {
        this.setLabel(text);
    }
}

