/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.GetSystemPropertyAction;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.PluginsDirRepository;
import com.sas.app.RepositoryException;
import com.sas.app.RepositoryOptions;
import com.sas.app.SDSImageServerCacheRepository;
import com.sas.app.SDSLookThrough;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public abstract class Repository {
    public static final String PROP_REPOSITORY_PATH = "sas.app.repository.path";
    private static final String TAG_FILE_NAME = "sas.vjr.def.txt";
    private static final int PROCESS_RECURSIVE = 0;
    private static final int PROCESS_NON_RECURSIVE = 1;
    private static final int ADD_TO_OUTPUT = 2;
    private static final int POP_EXCLUDE_NAMES = 3;
    private static final Integer I_PROCESS_RECURSIVE = new Integer(0);
    private static final Integer I_PROCESS_NON_RECURSIVE = new Integer(1);
    private static final Integer I_ADD_TO_OUTPUT = new Integer(2);
    private static final Integer I_POP_EXCLUDE_NAMES = new Integer(3);
    private final Repository m_parent;
    private final RepositoryOptions m_options;
    private final boolean m_behaviorDevLookThrough;

    public static Repository getDefaultRepository() throws RepositoryException {
        StringTokenizer tok;
        int n;
        File[] eclipseDirs;
        File tagFile;
        String path;
        block32: {
            File classLoc;
            block33: {
                try {
                    path = (String)AccessController.doPrivileged(new GetSystemPropertyAction(PROP_REPOSITORY_PATH));
                }
                catch (SecurityException e) {
                    path = null;
                }
                if (path == null) {
                    try {
                        path = (String)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return System.getenv(Repository.PROP_REPOSITORY_PATH);
                                }
                                catch (Error e) {
                                    return null;
                                }
                            }
                        });
                    }
                    catch (SecurityException e) {
                        path = null;
                    }
                }
                tagFile = null;
                eclipseDirs = null;
                if (path != null) break block32;
                classLoc = Repository.inferRepositoryClassCodebase();
                if (classLoc == null) {
                    throw new RepositoryException(Util.format("Repository.location.ex.txt"));
                }
                tagFile = Repository.locateTagFileFor(classLoc);
                if (tagFile == null) break block33;
                Properties props = new Properties();
                FileInputStream s = null;
                try {
                    s = new FileInputStream(tagFile);
                    props.load(s);
                }
                catch (IOException e) {
                    try {
                        throw new RepositoryException(Util.format("Repository.location.tagFile.load.ex.fmt.txt", tagFile), e);
                    }
                    catch (Throwable throwable) {
                        Util.close(s);
                        throw throwable;
                    }
                }
                Util.close(s);
                path = props.getProperty(PROP_REPOSITORY_PATH);
                break block32;
            }
            File eclipse = Repository.locatePluginsAncestor(classLoc);
            if (eclipse == null) {
                throw new RepositoryException(Util.format("Repository.location.ex.txt"));
            }
            eclipseDirs = new File[]{eclipse};
        }
        if (eclipseDirs == null && path != null && (n = (tok = new StringTokenizer(path.trim(), File.pathSeparator)).countTokens()) > 0) {
            eclipseDirs = new File[n];
            File base = tagFile != null ? tagFile.getParentFile() : null;
            for (int i = 0; i < n; ++i) {
                String loc = tok.nextToken().trim();
                if (loc.length() <= 0) {
                    eclipseDirs = null;
                    break;
                }
                File f = new File(loc);
                if (base != null && !f.isAbsolute()) {
                    f = new File(base, loc);
                }
                eclipseDirs[i] = f;
            }
        }
        RepositoryException cause = null;
        if (eclipseDirs != null) {
            try {
                String[] lookThroughs;
                boolean devLookThrough = false;
                RepositoryOptions options = new RepositoryOptions();
                Repository rc = PluginsDirRepository.newChain(eclipseDirs, false, options);
                boolean debug = options.m_debug;
                if (debug) {
                    System.out.println("sas.launcher SDS Mode env " + options.m_sdsEnv);
                    System.out.flush();
                }
                if (options.m_sdsEnv == null) {
                    return rc;
                }
                try {
                    lookThroughs = SDSLookThrough.getSingleUseLookthrough(options.m_sdsEnv);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to retrieve look-through info for sds env \"" + options.m_sdsEnv + '\"', e);
                }
                if (lookThroughs == null) {
                    throw new RepositoryException("Unable to retrieve look-through info for sds env \"" + options.m_sdsEnv + '\"');
                }
                File userHome = null;
                try {
                    String temp = (String)AccessController.doPrivileged(new GetSystemPropertyAction("user.home"));
                    if (temp != null && temp.trim().length() > 0) {
                        userHome = Util.canonical(new File(temp));
                    }
                }
                catch (SecurityException e) {
                    throw new RepositoryException("Unable to determine user home", e);
                }
                if (userHome == null) {
                    throw new RepositoryException("Unable to determine user home");
                }
                File cacheBase = new File(userHome, ".sasLauncherSDSModeCache");
                for (int i = lookThroughs.length - 1; i >= 0; --i) {
                    String track = lookThroughs[i];
                    if (track.startsWith("/")) {
                        track = track.substring(1);
                    }
                    if (track.endsWith("/")) {
                        track = track.substring(0, track.length() - 1);
                    }
                    if (track.length() <= 0) {
                        throw new RepositoryException("Bad sdsenv option value specified: \"" + options.m_sdsEnv + '\"');
                    }
                    File localCacheLoc = new File(cacheBase, track);
                    String imageServerPath = "/sasgen/" + track + "/gvjr/DEVD/default/gen/eclipse";
                    rc = new SDSImageServerCacheRepository(rc, false, options, imageServerPath, localCacheLoc);
                }
                return rc;
            }
            catch (RepositoryException e) {
                cause = e;
            }
        }
        String msg = tagFile != null ? Util.format("Repository.location.tagFile.pathProp.fmt.txt", tagFile, path) : (path != null ? Util.format("Repository.location.propPath.ex.fmt.txt", path) : Util.format("Repository.location.ex.txt"));
        RepositoryException ex = new RepositoryException(msg);
        if (cause != null) {
            ex.initCause(cause);
        }
        throw ex;
    }

    public static Repository newChain(File[] eclipseDirs) throws IllegalArgumentException, RepositoryException {
        return PluginsDirRepository.newChain(eclipseDirs, false);
    }

    public static URL[] getClasspath(Plugin[] plugins) throws IllegalArgumentException {
        int n;
        if (plugins == null) {
            throw Util.illegalNull("plugins");
        }
        LinkedHashSet<URL> rc = null;
        for (int i = 0; i < plugins.length; ++i) {
            URL[] cp;
            Plugin p = plugins[i];
            if (p == null || (cp = p.getBundleClasspath()) == null || cp.length <= 0) continue;
            for (int j = 0; j < cp.length; ++j) {
                URL u = cp[j];
                if (u == null) continue;
                if (rc == null) {
                    rc = new LinkedHashSet<URL>();
                }
                rc.add(u);
            }
        }
        return rc != null && (n = rc.size()) > 0 ? rc.toArray(new URL[n]) : Util.ZERO_URLS;
    }

    private static File inferRepositoryClassCodebase() {
        File rc;
        File rc2;
        Class<Repository> c = Repository.class;
        URL base1 = Repository.baseLocationFromResource(c);
        if (base1 != null && (rc2 = Util.toFile(base1)) != null) {
            return rc2;
        }
        URL base2 = Repository.baseLocationFromCodeSourceLocation(c);
        if (base2 != null && (rc = Util.toFile(base2)) != null) {
            return rc;
        }
        if (base1 != null) {
            try {
                URL base3 = Repository.resolveEclipseURL(base1, c.getClassLoader());
                File rc3 = Util.toFile(base3);
                if (rc3 != null) {
                    return rc3;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL baseLocationFromResource(Class c) {
        String res = "/" + c.getName().replace('.', '/') + ".class";
        URL base = c.getResource(res);
        if (base == null) {
            return null;
        }
        String temp = base.toString();
        if (!temp.endsWith(res)) {
            return null;
        }
        temp = temp.substring(0, temp.length() - res.length() + 1);
        if ("jar".equals(base.getProtocol())) {
            if (!temp.startsWith("jar:") || !temp.endsWith("!/")) {
                return null;
            }
            temp = temp.substring(4, temp.length() - 2);
        }
        try {
            return new URL(temp);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static URL baseLocationFromCodeSourceLocation(Class c) {
        try {
            CodeSource cs;
            ProtectionDomain pd = c.getProtectionDomain();
            if (pd != null && (cs = pd.getCodeSource()) != null) {
                return cs.getLocation();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static File locateTagFileFor(File p) {
        if (p == null) {
            return null;
        }
        String path = p.getAbsolutePath().replace(File.separatorChar, '/').replace('\\', '/');
        boolean unc = path.startsWith("//");
        while (p != null) {
            File rc;
            if (unc) {
                path = p.getAbsolutePath().replace(File.separatorChar, '/').replace('\\', '/');
                if (path.startsWith("//")) {
                    path = path.substring(2);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.indexOf(47) < 0) {
                    return null;
                }
            }
            if ((rc = new File(p, TAG_FILE_NAME)).exists()) {
                return rc;
            }
            p = p.getParentFile();
        }
        return null;
    }

    private static File locatePluginsAncestor(File p) {
        while (p != null) {
            String name = p.getName();
            p = p.getParentFile();
            if (!"plugins".equals(name)) continue;
            return p;
        }
        return null;
    }

    private static URL resolveEclipseURL(URL u, ClassLoader cl2) {
        boolean triedNull;
        if (u == null) {
            return null;
        }
        URL rc = Repository.invokeEclipseResolve("org.eclipse.core.runtime.FileLocator", "resolve", u, cl2);
        if (rc != null) {
            return rc;
        }
        rc = Repository.invokeEclipseResolve("org.eclipse.core.runtime.Platform", "resolve", u, cl2);
        if (rc != null) {
            return rc;
        }
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        IdentityHashMap<ClassLoader, ClassLoader> seenCL = new IdentityHashMap<ClassLoader, ClassLoader>();
        if (cl2 != null) {
            seenCL.put(cl2, cl2);
            triedNull = false;
            classLoaders.add(null);
        } else {
            triedNull = true;
        }
        try {
            ClassLoader ourCL = Repository.class.getClassLoader();
            if (ourCL != null) {
                classLoaders.add(ourCL);
            }
        }
        catch (SecurityException ourCL) {
            // empty catch block
        }
        try {
            classLoaders.add(ClassLoader.getSystemClassLoader());
        }
        catch (SecurityException ourCL) {
            // empty catch block
        }
        try {
            classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        catch (SecurityException ourCL) {
            // empty catch block
        }
        for (ClassLoader cl2 : classLoaders) {
            if (cl2 == null) {
                if (triedNull) continue;
                triedNull = true;
            }
            if (seenCL.containsKey(cl2)) continue;
            seenCL.put(cl2, cl2);
            rc = Repository.invokeEclipseResolve("org.eclipse.core.runtime.FileLocator", "resolve", u, cl2);
            if (rc != null) {
                return rc;
            }
            rc = Repository.invokeEclipseResolve("org.eclipse.core.runtime.Platform", "resolve", u, cl2);
            if (rc == null) continue;
            return rc;
        }
        return null;
    }

    private static URL invokeEclipseResolve(String className, String methodName, URL u, ClassLoader cl) {
        try {
            Object rc;
            Class<?> c = cl == null ? Class.forName(className) : Class.forName(className, true, cl);
            Method m = c.getMethod(methodName, URL.class);
            if (Modifier.isStatic(m.getModifiers()) && (rc = m.invoke(null, u)) instanceof URL) {
                return (URL)rc;
            }
        }
        catch (LinkageError linkageError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    protected static Plugin[] runtimeNoTaint(Plugin[] plugins) {
        if (plugins == null || plugins.length <= 0) {
            return plugins;
        }
        try {
            return Repository.noTaint(plugins);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static Plugin[] noTaint(Plugin[] plugins) throws RepositoryException {
        if (plugins == null || plugins.length <= 0) {
            return plugins;
        }
        ArrayList<Plugin> tainted = null;
        for (int i = 0; i < plugins.length; ++i) {
            Plugin p = plugins[i];
            if (!p.isTainted()) continue;
            if (tainted == null) {
                tainted = new ArrayList<Plugin>();
            }
            tainted.add(p);
        }
        if (tainted == null) {
            return plugins;
        }
        throw new RepositoryException(Util.format("Repository.taint.ex.fmt.txt", Repository.formatPluginList(tainted)));
    }

    private static String formatPluginList(Collection plugins) throws IllegalArgumentException {
        if (plugins == null) {
            throw Util.illegalNull("plugins");
        }
        boolean first = true;
        StringBuffer b = new StringBuffer();
        for (Plugin p : plugins) {
            if (p == null) continue;
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(p.getName()).append(' ').append(p.getVersion().toVersionString());
        }
        if (first) {
            throw Util.illegalArgument("plugins.isEmpty()", Boolean.TRUE);
        }
        return b.toString();
    }

    protected static Plugin runtimeNoTaint(Plugin p) {
        if (p == null || !p.isTainted()) {
            return p;
        }
        ArrayList<Plugin> tainted = new ArrayList<Plugin>();
        tainted.add(p);
        throw new RuntimeException(new RepositoryException(Util.format("Repository.taint.ex.fmt.txt", Repository.formatPluginList(tainted))));
    }

    private static PluginRequest[] push(List stack, Set excludes, PickList pickList, PluginRequest[] tempRequests, Set tempSet) throws IllegalArgumentException {
        if (stack == null) {
            throw Util.illegalNull("stack");
        }
        if (excludes == null) {
            throw Util.illegalNull("excludes");
        }
        if (pickList == null) {
            throw Util.illegalNull("pickList");
        }
        if (pickList.isEmpty()) {
            return tempRequests;
        }
        if (tempSet == null) {
            tempSet = new HashSet();
        }
        tempRequests = pickList.getRequestsAndExcludes(tempRequests, tempSet);
        boolean recursive = pickList.isRecursive();
        if (recursive && !tempSet.isEmpty()) {
            int nNewExcludes = 0;
            for (String name : tempSet) {
                if (!excludes.add(name)) continue;
                ++nNewExcludes;
                stack.add(name);
            }
            if (nNewExcludes > 0) {
                stack.add(new Integer(nNewExcludes));
                stack.add(I_POP_EXCLUDE_NAMES);
            }
        }
        Integer command = recursive ? I_PROCESS_RECURSIVE : I_PROCESS_NON_RECURSIVE;
        for (int i = tempRequests.length - 1; i >= 0; --i) {
            String name;
            PluginRequest r = tempRequests[i];
            if (r == null || excludes.contains(name = r.getName())) continue;
            stack.add(r);
            stack.add(command);
        }
        return tempRequests;
    }

    protected Repository(Repository parent, boolean behaviorDevLookThrough, RepositoryOptions repositoryOptions) {
        this.m_parent = parent;
        this.m_options = repositoryOptions == null ? new RepositoryOptions() : repositoryOptions;
        this.m_behaviorDevLookThrough = behaviorDevLookThrough;
    }

    protected Repository getParent() {
        return this.m_parent;
    }

    protected RepositoryOptions getOptions() {
        return this.m_options;
    }

    protected boolean isDevLookThrough() {
        return this.m_behaviorDevLookThrough;
    }

    protected abstract File getLocation();

    public Plugin find(PluginRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw Util.illegalNull("request");
        }
        return this.find(request, this.getOptions().m_useTainted);
    }

    protected Plugin find(PluginRequest request, boolean useTainted) throws IllegalArgumentException {
        Plugin q;
        if (request == null) {
            throw Util.illegalNull("request");
        }
        Plugin rc = this.localFind(request);
        Repository parent = this.getParent();
        if (parent == null) {
            return useTainted ? rc : Repository.runtimeNoTaint(rc);
        }
        if (rc == null) {
            return parent.find(request, useTainted);
        }
        VersionSpec range = request.getRange();
        if (this.m_behaviorDevLookThrough || !range.isRange()) {
            return useTainted ? rc : Repository.runtimeNoTaint(rc);
        }
        if (!range.isOpenEnded() && range.isIncludeEnd()) {
            VersionSpec v = rc.getVersion();
            if (range.getEndMajor() == v.getMajor() && range.getEndMinor() == v.getMinor() && range.getEndMicro() == v.getMicro() && range.getEndQualifier().equals(v.getQualifier())) {
                return useTainted ? rc : Repository.runtimeNoTaint(rc);
            }
        }
        if ((q = parent.find(request, true)) != null && q.getVersion().compareTo(rc.getVersion()) > 0) {
            rc = q;
        }
        return useTainted ? rc : Repository.runtimeNoTaint(rc);
    }

    protected abstract Plugin localFind(PluginRequest var1) throws IllegalArgumentException;

    public Plugin[] findAll(PluginRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw Util.illegalNull("request");
        }
        return this.findAll(request, this.m_options.m_useTainted);
    }

    protected Plugin[] findAll(PluginRequest request, boolean useTainted) {
        Plugin[] a = this.localFindAll(request);
        Repository parent = this.getParent();
        if (parent == null) {
            return useTainted ? a : Repository.runtimeNoTaint(a);
        }
        if (a.length <= 0) {
            return parent.findAll(request, useTainted);
        }
        Plugin[] b = parent.findAll(request, true);
        if (b.length <= 0) {
            return useTainted ? a : Repository.runtimeNoTaint(a);
        }
        ArrayList<Plugin> chosen = new ArrayList<Plugin>();
        int ia = 0;
        int ib = 0;
        Plugin pa = a[ia++];
        VersionSpec va = pa.getVersion();
        Plugin pb = b[ib++];
        VersionSpec vb = pb.getVersion();
        while (pa != null || pb != null) {
            boolean incBoth;
            boolean chooseB;
            if (pa == null) {
                chooseB = true;
                incBoth = false;
            } else if (pb == null) {
                chooseB = false;
                incBoth = false;
            } else {
                assert (va != null);
                int c = va.compareTo(vb);
                chooseB = c < 0;
                incBoth = c == 0;
            }
            chosen.add(chooseB ? pb : pa);
            if (!chooseB || incBoth) {
                if (ia >= a.length) {
                    pa = null;
                    va = null;
                } else {
                    pa = a[ia++];
                    va = pa.getVersion();
                }
            }
            if (!chooseB && !incBoth) continue;
            if (ib >= b.length) {
                pb = null;
                vb = null;
                continue;
            }
            pb = b[ib++];
            vb = pb.getVersion();
        }
        Plugin[] rc = chosen.toArray(new Plugin[chosen.size()]);
        return useTainted ? rc : Repository.runtimeNoTaint(rc);
    }

    protected abstract Plugin[] localFindAll(PluginRequest var1) throws IllegalArgumentException;

    public Plugin[] find(PickList pickList) throws IllegalArgumentException, RepositoryException {
        int n;
        if (pickList == null) {
            throw Util.illegalNull("pickList");
        }
        if (pickList.isEmpty()) {
            return Plugin.ZERO_PLUGINS;
        }
        HashSet excludes = new HashSet();
        PluginRequest[] requests = pickList.getRequestsAndExcludes(null, excludes);
        assert (requests.length > 0 && requests[requests.length - 1] != null);
        ArrayList<PluginRequest> unsatisfied = null;
        Plugin[] plugins = new Plugin[requests.length];
        int n2 = 0;
        for (int i = 0; i < requests.length; ++i) {
            Plugin p = this.find(requests[i], true);
            if (p != null) {
                plugins[n2++] = p;
                continue;
            }
            if (requests[i].isOptional()) continue;
            if (unsatisfied == null) {
                unsatisfied = new ArrayList<PluginRequest>();
            }
            unsatisfied.add(requests[i]);
        }
        if (unsatisfied != null) {
            throw new RepositoryException(Util.format("Repository.lookup.ex.txt"), unsatisfied);
        }
        if (!pickList.isRecursive()) {
            if (n2 == plugins.length) {
                return this.m_options.m_useTainted ? plugins : Repository.noTaint(plugins);
            }
            if (n2 <= 0) {
                return Plugin.ZERO_PLUGINS;
            }
            Plugin[] rc = new Plugin[n2];
            System.arraycopy(plugins, 0, rc, 0, n2);
            return this.m_options.m_useTainted ? rc : Repository.noTaint(rc);
        }
        HashSet tempSet = new HashSet();
        excludes.clear();
        ArrayList classpathOrderNames = new ArrayList();
        HashMap<String, Plugin> chosenPlugins = new HashMap<String, Plugin>();
        HashMap<String, PluginRequest> causitiveRequest = new HashMap<String, PluginRequest>();
        ArrayList<Object> stack = new ArrayList<Object>();
        requests = Repository.push(stack, excludes, pickList, requests, tempSet);
        block6: while ((n = stack.size()) > 0) {
            int command = (Integer)stack.remove(--n);
            switch (command) {
                case 0: 
                case 1: {
                    PluginRequest r = (PluginRequest)stack.remove(--n);
                    String name = r.getName();
                    Plugin p = (Plugin)chosenPlugins.get(name);
                    if (p != null) {
                        if (r.getRange().includes(p.getVersion()) || r.isOptional() && this.find(r, true) == null) continue block6;
                        PluginRequest cr = (PluginRequest)causitiveRequest.get(name);
                        assert (cr != null);
                        ArrayList<PluginRequest> list = new ArrayList<PluginRequest>();
                        list.add(cr);
                        list.add(r);
                        throw new RepositoryException(Util.format("Repository.lookup.collision.ex.txt"), list);
                    }
                    p = this.find(r, true);
                    if (p == null) {
                        if (r.isOptional()) continue block6;
                        ArrayList<PluginRequest> unsatisfied2 = new ArrayList<PluginRequest>();
                        unsatisfied2.add(r);
                        throw new RepositoryException(Util.format("Repository.lookup.ex.txt"), unsatisfied2);
                    }
                    assert (!causitiveRequest.containsKey(name));
                    chosenPlugins.put(name, p);
                    causitiveRequest.put(name, r);
                    stack.add(name);
                    stack.add(I_ADD_TO_OUTPUT);
                    if (command != 0) continue block6;
                    requests = Repository.push(stack, excludes, p.getRequiredBundles(), requests, tempSet);
                    continue block6;
                }
                case 2: {
                    classpathOrderNames.add(stack.remove(--n));
                    continue block6;
                }
                case 3: {
                    int i = (Integer)stack.remove(--n);
                    assert (i > 0);
                    if (i <= 0) {
                        throw new IllegalStateException();
                    }
                    while (i-- > 0) {
                        excludes.remove(stack.remove(--n));
                    }
                    continue block6;
                }
            }
            throw new IllegalStateException(Integer.toString(command));
        }
        n = classpathOrderNames.size();
        if (n <= 0) {
            return Plugin.ZERO_PLUGINS;
        }
        Plugin[] rc = new Plugin[n];
        Iterator it = classpathOrderNames.iterator();
        for (int i = 0; i < n; ++i) {
            rc[i] = (Plugin)chosenPlugins.get(it.next());
            assert (rc[i] != null);
        }
        assert (!it.hasNext());
        return this.m_options.m_useTainted ? rc : Repository.noTaint(rc);
    }

    public Plugin[] getPlugins() {
        HashMap map = new HashMap();
        this.putAllPlugins(map);
        int n = map.size();
        if (n <= 0) {
            return Plugin.ZERO_PLUGINS;
        }
        Plugin[] rc = new TreeMap(map).values().toArray(new Plugin[n]);
        return this.m_options.m_useTainted ? rc : Repository.runtimeNoTaint(rc);
    }

    protected void putAllPlugins(Map map) throws IllegalArgumentException {
        if (map == null) {
            throw Util.illegalNull("map");
        }
        Repository parent = this.getParent();
        if (parent != null) {
            parent.putAllPlugins(map);
        }
        this.localPutAllPlugins(map);
    }

    protected abstract void localPutAllPlugins(Map var1) throws IllegalArgumentException;

    public long getTimestamp() {
        long lts = this.localGetTimestamp();
        Repository parent = this.getParent();
        return parent == null ? lts : Math.max(lts, parent.getTimestamp());
    }

    protected abstract long localGetTimestamp();

    public abstract Repository reindex(long var1);
}

