/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSF.security.EauthCredentials;
import com.platform.LSF.security.LSFUser;
import com.platform.LSFJobFlow.api.CommBrokerINF;
import com.platform.LSFJobFlow.api.ConnectionFactory;
import com.platform.LSFJobFlow.api.JFCharReader;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFSAXParser;
import com.platform.LSFJobFlow.api.JFVersion;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;

class JFServiceProxy {
    private String srvSecondaryPort = null;
    private String srvSecondary = null;
    private String srvName = null;
    private int srvTimeout = 0;
    private boolean srvEncrypt = false;
    private ConnectionFactory connFactory = null;
    private static final int JS_CONN_TIMEOUT = 1024;
    static boolean m_serverOn = true;

    private void envInitialize() throws JFException {
        String string;
        String string2;
        int n;
        String string3 = JFConfigManager.getConfig("JS_CONN_TIMEOUT", Integer.toString(1024));
        try {
            n = Integer.parseInt(string3);
        }
        catch (RuntimeException runtimeException) {
            n = 1024;
        }
        this.srvTimeout = n *= 1000;
        String string4 = JFConfigManager.getConfig("JS_ENCRYPTION", "false");
        if (string4.trim().equalsIgnoreCase("true")) {
            this.srvEncrypt = true;
        }
        this.srvSecondary = string2 = JFConfigManager.getConfig("JS_FAILOVER_HOST");
        this.srvSecondaryPort = string = JFConfigManager.getConfig("JS_PORT");
    }

    public JFServiceProxy(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("INTERNAL_ERROR") + ": " + JFResource.getString("SVC_INVK_SVC_NULL"));
        }
        this.srvName = string;
        this.envInitialize();
        this.connFactory = ConnectionFactory.getInstance();
    }

    public Document invoke(Document document) throws SAXException, IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Object object;
        String string;
        Object object2;
        JFCharReader jFCharReader = (JFCharReader)this._invoke(document, false);
        if (jFCharReader == null) {
            throw new IOException(JFResource.getString("SVC_ERR") + ": " + JFResource.getString("SVC_INVK_NO_RESP"));
        }
        try {
            object2 = JFConfigManager.getServerVersion(false);
            if (object2 != null && ((JFVersion)object2).compareTo("6.0") < 0) {
                string = "</JF_GetHistoryResponse>";
                object = "<JF_GetHistoryResponse/>";
                String string2 = jFCharReader.toString();
                int n = string2.indexOf(string + "\n" + (String)object);
                if (n > 0) {
                    string2 = string2.substring(0, n + string.length());
                    jFCharReader = new JFCharReader(string2.toCharArray());
                }
            }
        }
        catch (JFException jFException) {
            // empty catch block
        }
        object2 = new InputSource(jFCharReader);
        string = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return ((DocumentBuilder)object).parse((InputSource)object2);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return string;
    }

    public JFSAXParser invokeBySAX(Document document) throws TransformerConfigurationException, SAXException, IOException, ParserConfigurationException, TransformerException {
        JFSAXParser jFSAXParser = null;
        try {
            Object object;
            boolean bl = JFConfigManager.getConfig("JS_LARGE_FLOW_SAVE", "false").equalsIgnoreCase("true");
            jFSAXParser = bl ? ((object = this._invoke(document, true)) != null ? new JFSAXParser((File)object) : new JFSAXParser((JFCharReader)this._invoke(document, false))) : new JFSAXParser((JFCharReader)this._invoke(document, false));
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        return jFSAXParser;
    }

    private Properties getRequest(Document document) throws SAXException, IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        if (!m_serverOn && "Yes".equals(JFConfigManager.getConfig("JS_CONNECT_ONCE", "No"))) {
            throw new IOException(JFResource.getString("COMM_ERR"));
        }
        if (document == null) {
            throw new NullPointerException(JFResource.getString("SVC_ERR") + ": " + JFResource.getString("SVC_INVK_REQ_NULL"));
        }
        Subject subject = JFLoginManager.getSubject();
        if (subject == null) {
            throw new NullPointerException(JFResource.getString("SVC_INVK_SUBJECT_NULL"));
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource dOMSource = new DOMSource(document);
        transformer.transform(dOMSource, streamResult);
        Properties properties = new Properties();
        properties.setProperty("method", "POST");
        properties.setProperty("uri", this.srvName);
        String string = JFLoginManager.getUserName();
        if (string != null) {
            properties.setProperty("content-owner", string);
        }
        properties.setProperty("JS-ClientIntVersion", JFConfigManager.getEffectiveClientVersion().getVersion());
        Set<Principal> set = subject.getPrincipals();
        Set<Object> set2 = subject.getPublicCredentials();
        Iterator<Object> iterator = set.iterator();
        LSFUser lSFUser = (LSFUser)iterator.next();
        iterator = set2.iterator();
        EauthCredentials eauthCredentials = (EauthCredentials)iterator.next();
        properties.setProperty("JS-User", lSFUser.getUserName());
        properties.setProperty("JS-UID", Integer.toString(lSFUser.getUID()));
        properties.setProperty("JS-GID", Integer.toString(lSFUser.getGID()));
        properties.setProperty("JS-Credentials", eauthCredentials.getEncoded());
        if (lSFUser.getDomain() != null) {
            properties.setProperty("JS-Domain", lSFUser.getDomain());
        }
        properties.setProperty("content", streamResult.getWriter().toString());
        return properties;
    }

    private Object _invoke(Document document, boolean bl) throws TransformerConfigurationException, SAXException, IOException, ParserConfigurationException, TransformerException {
        JFCharReader jFCharReader = null;
        File file = null;
        Properties properties = this.getRequest(document);
        String string = JFConfigManager.getConfig("JS_HOST");
        String string2 = JFConfigManager.getConfig("JS_PORT");
        if (string == null || string.length() < 1) {
            throw new IOException(JFResource.getString("SVC_INVK_HOST_NULL"));
        }
        if (string2 == null || string2.length() < 1) {
            throw new IOException(JFResource.getString("SVC_INVK_PORT_NULL"));
        }
        String string3 = "http://" + string + ":" + string2;
        CommBrokerINF commBrokerINF = this.connFactory.getCommBroker(1, string3, this.srvTimeout, this.srvEncrypt);
        if (commBrokerINF == null) {
            throw new IOException(JFResource.getString("SVC_ERR") + ": " + JFResource.getString("SVC_INVK_COMM_NULL"));
        }
        try {
            if (bl) {
                file = commBrokerINF.sendRecvByFile(properties);
            } else {
                jFCharReader = commBrokerINF.sendRecv(properties);
            }
            m_serverOn = true;
        }
        catch (IOException iOException) {
            if ((iOException instanceof UnknownHostException || iOException instanceof SocketException) && this.srvSecondary != null) {
                string3 = "http://" + this.srvSecondary + ":" + this.srvSecondaryPort;
                commBrokerINF = this.connFactory.getCommBroker(1, string3, this.srvTimeout, this.srvEncrypt);
                try {
                    if (bl) {
                        file = commBrokerINF.sendRecvByFile(properties);
                    } else {
                        jFCharReader = commBrokerINF.sendRecv(properties);
                    }
                    m_serverOn = true;
                    if (JFConfigManager.isExternalLogin()) {
                        this.exchangeServerHost();
                    }
                }
                catch (IOException iOException2) {
                    m_serverOn = false;
                    commBrokerINF.releaseConnection();
                    throw iOException2;
                }
            }
            m_serverOn = false;
            commBrokerINF.releaseConnection();
            throw iOException;
        }
        this.connFactory.releaseCommBroker(commBrokerINF);
        if (bl) {
            return file;
        }
        return jFCharReader;
    }

    private void exchangeServerHost() {
        String string = JFConfigManager.getConfig("JS_HOST");
        JFConfigManager.addConfig("JS_HOST", this.srvSecondary);
        this.srvSecondary = string;
        JFConfigManager.addConfig("JS_FAILOVER_HOST", string);
    }
}

