/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCharReader;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventFactory;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArray;
import com.platform.LSFJobFlow.api.JFFlowArrayElementInfo;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayInstance;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobArrayInstance;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobInstance;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLinkEventInstance;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTemplateData;
import com.platform.LSFJobFlow.api.JFTemplateJob;
import com.platform.LSFJobFlow.api.JFTemplateParameter;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVariableEvent;
import com.platform.LSFJobFlow.api.JFVersion;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class JFSAXParser {
    private static String PROXY_EVENT_PREFIX = "_proxy_";
    private XmlPullParser xpp = null;
    private File tmpFile = null;
    private Reader reader = null;
    private JFFlowInstance jfFlowInstance = null;
    private JFFlow mainFlow = null;
    private Map<String, JFFlow> subFlows = new HashMap<String, JFFlow>();
    private Map<String, JFFlowArray> flowArrays = new HashMap<String, JFFlowArray>();
    private Map<String, JFJob> jobs = new HashMap<String, JFJob>();
    private Map<String, JFJobArray> jobArrays = new HashMap<String, JFJobArray>();
    private Map<String, JFEvent> events = new HashMap<String, JFEvent>();
    private Map<String, Integer> eventCombinations = new HashMap<String, Integer>();
    private boolean oldServer = false;

    JFSAXParser(File file) throws XmlPullParserException, FileNotFoundException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        this.xpp = xmlPullParserFactory.newPullParser();
        this.tmpFile = file;
        this.reader = new FileReader(this.tmpFile);
        this.xpp.setInput(this.reader);
        this.setupEnv();
    }

    JFSAXParser(JFCharReader jFCharReader) throws XmlPullParserException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        this.xpp = xmlPullParserFactory.newPullParser();
        this.reader = jFCharReader;
        this.xpp.setInput(this.reader);
        this.setupEnv();
    }

    private void setupEnv() {
        JFVersion jFVersion = JFConfigManager.getServerVersion();
        if (jFVersion != null && jFVersion.compareTo("5.5") < 0) {
            this.oldServer = true;
        }
    }

    JFFlowInstance getFlowInstance() throws JFException {
        this.jfFlowInstance = new JFFlowInstance();
        try {
            this.parse(this.xpp);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new JFException("parse xml failed::" + xmlPullParserException.getMessage());
        }
        catch (IOException iOException) {
            throw new JFException("parse xml failed::" + iOException.getMessage());
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
        }
        return this.jfFlowInstance;
    }

    private void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException, JFException {
        int n = -1;
        int n2 = xmlPullParser.getEventType();
        while (n2 != 1) {
            Object object;
            if (n2 == 2) {
                if (xmlPullParser.getDepth() == 4 && xmlPullParser.getName().equals("JobFlowReq")) {
                    object = xmlPullParser.getAttributeValue(null, "DTDVersion");
                    if (object == null || ((String)object).equals("") || !"3.0".equals(object)) {
                        throw new JFException(JFResource.getString("DEFN_VERSION_UNSUPPORTED"));
                    }
                    String string = xmlPullParser.getAttributeValue(null, "MainEntry");
                    if (string == null || string.equals("")) {
                        throw new JFException(JFResource.getString("DEFN_MAIN_UNSPECIFIED"));
                    }
                    this.mainFlow = new JFFlow(string);
                    this.setMainFlowAttributes(xmlPullParser, this.mainFlow);
                } else if (xmlPullParser.getDepth() == 5 && xmlPullParser.getName().equals("JobFlowDef")) {
                    this.parseJFFlowDef(xmlPullParser, xmlPullParser.getAttributeValue(null, "Name"));
                } else if (xmlPullParser.getDepth() == 5 && xmlPullParser.getName().equals("JobDef")) {
                    this.parseJFJobDef(xmlPullParser);
                } else if (xmlPullParser.getDepth() == 2 && xmlPullParser.getName().equals("return") && 0 != (n = Integer.parseInt(xmlPullParser.nextText()))) {
                    throw new JFException(JFFlowManager.iMgrErrorToString(n));
                }
            } else if (n2 == 3 && xmlPullParser.getName().equals("flowDefinition") && xmlPullParser.getDepth() == 3) {
                this.jfFlowInstance.setFlowDefintion(this.mainFlow);
                this.parseJFFlowInstance(xmlPullParser, this.jfFlowInstance);
                object = this.getParentFlow(this.jfFlowInstance.getName());
                this.setupJFFlowInstance((JFFlow)object, this.jfFlowInstance);
                if (this.jfFlowInstance.getOwner() == null) {
                    this.jfFlowInstance.setOwner(JFFlowInstance.getUserByFlowName(this.jfFlowInstance.getFlowDefinition().getName()));
                }
            }
            if (xmlPullParser.getEventType() == 1) break;
            n2 = xmlPullParser.next();
        }
    }

    private void parseJFFlowDef(XmlPullParser xmlPullParser, String string) throws XmlPullParserException, IOException, JFException {
        JFFlow jFFlow = null;
        if (string.equals(this.mainFlow.getName())) {
            this.setFlowAttributesFromXML(xmlPullParser, this.mainFlow);
            jFFlow = this.mainFlow;
        } else {
            jFFlow = this.subFlows.get(string);
        }
        int n = xmlPullParser.nextTag();
        while (n != 3 || !"JobFlowDef".equals(xmlPullParser.getName()) && n != 1) {
            if (n == 2) {
                if ("ActivityDef".equals(xmlPullParser.getName())) {
                    this.parseActivityDef(xmlPullParser, jFFlow);
                } else if ("flowVersion".equals(xmlPullParser.getName()) && !xmlPullParser.isEmptyElementTag()) {
                    jFFlow.setFlowVersion(this.getJFFlowVersion(xmlPullParser));
                } else if ("Events".equals(xmlPullParser.getName()) && !xmlPullParser.isEmptyElementTag()) {
                    int n2 = this.getEventCombination(xmlPullParser);
                    JFEvent[] jFEventArray = this.getEvents(xmlPullParser);
                    jFFlow.setTriggerEvents(jFEventArray, n2);
                } else if ("Exceptions".equals(xmlPullParser.getName()) && !xmlPullParser.isEmptyElementTag()) {
                    jFFlow.m_handlerList = this.getHandlers(xmlPullParser);
                } else if ((!"TriggeredEvents".equals(xmlPullParser.getName()) || xmlPullParser.isEmptyElementTag()) && "BasedTemplateName".equals(xmlPullParser.getName())) {
                    jFFlow.setAttribute("BasedTemplateName", xmlPullParser.getAttributeValue(null, "Value"));
                }
            }
            n = xmlPullParser.next();
        }
    }

    private void parseActivityDef(XmlPullParser xmlPullParser, JFFlow jFFlow) throws XmlPullParserException, IOException, JFException {
        JFEvent[] jFEventArray = null;
        List<JFHandler> list = Collections.EMPTY_LIST;
        JFJob jFJob = null;
        JFFlow jFFlow2 = null;
        int n = 0;
        String string = xmlPullParser.getAttributeValue(null, "ImplementType");
        String string2 = xmlPullParser.getAttributeValue(null, "ImplementRefer");
        String string3 = xmlPullParser.getAttributeValue(null, "IndexList");
        String string4 = xmlPullParser.getAttributeValue(null, "Name");
        String string5 = xmlPullParser.getAttributeValue(null, "FirstElement");
        String string6 = xmlPullParser.getAttributeValue(null, "LastElement");
        if (string.equals("Job")) {
            jFJob = this.jobs.get(string2);
            if (jFJob == null) {
                jFJob = new JFJob(JFXMLSource.getName(string2));
                this.jobs.put(string2, jFJob);
                this.setJobAttributesFromXML(xmlPullParser, jFJob);
            }
        } else if (string.equals("SubFlow")) {
            jFFlow2 = this.subFlows.get(string2);
            if (jFFlow2 == null) {
                jFFlow2 = new JFFlow(JFXMLSource.getName(string4));
                this.setFlowAttributesFromXML(xmlPullParser, jFFlow2);
                this.subFlows.put(string2, jFFlow2);
            }
            this.setFlowAttributesFromXML(xmlPullParser, jFFlow2);
        } else if (string.equals("DynamicSubFlow")) {
            // empty if block
        }
        while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("ActivityDef")) {
            if (xmlPullParser.getEventType() == 2) {
                if (!xmlPullParser.isEmptyElementTag() && xmlPullParser.getName().equals("Events")) {
                    n = this.getEventCombination(xmlPullParser);
                    jFEventArray = this.getEvents(xmlPullParser);
                } else if (!xmlPullParser.isEmptyElementTag() && xmlPullParser.getName().equals("Exceptions")) {
                    list = this.getHandlers(xmlPullParser);
                }
            }
            xmlPullParser.next();
        }
        if (string.equals("Job")) {
            jFJob.m_handlerList = list;
            this.eventCombinations.put(string2, n);
            if (string3 != null) {
                JFJobArray jFJobArray = this.jobArrays.get(string2);
                if (jFJobArray == null) {
                    jFJobArray = new JFJobArray(jFJob.getName(), jFJob, string3);
                    this.jobArrays.put(string2, jFJobArray);
                }
                if (jFJobArray.getArrayIndex().equals("")) {
                    jFJobArray.setArrayIndex(string3);
                }
                List list2 = jFFlow.m_activities;
                JFFlow jFFlow3 = jFFlow;
                jFFlow3.getClass();
                list2.add(jFFlow3.new JFFlow.Activity(jFJob.getName(), jFJobArray, jFEventArray, n));
            } else {
                List list3 = jFFlow.m_activities;
                JFFlow jFFlow4 = jFFlow;
                jFFlow4.getClass();
                list3.add(jFFlow4.new JFFlow.Activity(jFJob.getName(), jFJob, jFEventArray, n));
            }
        } else if (string.equals("SubFlow")) {
            jFFlow2.m_handlerList = list;
            if (string5 != null) {
                JFFlowArray jFFlowArray = this.flowArrays.get(string2);
                if (jFFlowArray == null) {
                    jFFlowArray = new JFFlowArray(jFFlow2.getName(), jFFlow2, string5, string6);
                    this.flowArrays.put(string2, jFFlowArray);
                }
                jFFlowArray.setFirstElement(string5);
                jFFlowArray.setLastElement(string6);
                List list4 = jFFlow.m_activities;
                JFFlow jFFlow5 = jFFlow;
                jFFlow5.getClass();
                list4.add(jFFlow5.new JFFlow.Activity(jFFlow2.getName(), jFFlowArray, jFEventArray, n));
            } else {
                List list5 = jFFlow.m_activities;
                JFFlow jFFlow6 = jFFlow;
                jFFlow6.getClass();
                list5.add(jFFlow6.new JFFlow.Activity(jFFlow2.getName(), jFFlow2, jFEventArray, n));
            }
        } else if (string.equals("DynamicSubFlow")) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    private JFJob parseJFJobDef(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException, JFException {
        Object object;
        block19: {
            Object object2;
            Object object3;
            Object object4;
            Object object7;
            String string = xmlPullParser.getAttributeValue(null, "Name");
            String string2 = xmlPullParser.getAttributeValue(null, "ExecutionType");
            object = this.jobs.get(string);
            if (object == null) {
                object = new JFJob(JFXMLSource.getName(string));
                this.jobs.put(string, (JFJob)object);
            }
            if (string2 != null) {
                ((JFJob)object).setExecutionType(string2);
            }
            int n = xmlPullParser.nextTag();
            while (n != 3 || !xmlPullParser.getName().equals("JobDef")) {
                if (n == 2) {
                    object7 = xmlPullParser.getName();
                    String object62 = xmlPullParser.getAttributeValue(null, "Value");
                    if (!((String)object7).equals("TemplateData")) {
                        if (((String)object7).equals("Exceptions")) {
                            object4 = this.getHandlers(xmlPullParser);
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                JFHandler jFHandler = (JFHandler)object3.next();
                                ((JFJob)object).addHandler(jFHandler);
                            }
                        } else {
                            ((JFJob)object).setAttribute((String)object7, object62);
                        }
                    } else {
                        void var10_22;
                        object4 = new JFTemplateJob((JFJob)object);
                        ((JFTemplateJob)object4).setTemplateData(this.getJFTemplateJobFromXML(xmlPullParser));
                        for (Map.Entry entry : ((JFJob)object).getAttributes().entrySet()) {
                            ((JFJob)object4).setAttribute((String)entry.getKey(), (String)entry.getValue());
                        }
                        object3 = this.getJFFlowNameFromJFJobName(string);
                        JFFlow jFFlow = this.subFlows.get(object3);
                        if (jFFlow == null && this.mainFlow.getName().equals(object3)) {
                            JFFlow jFFlow2 = this.mainFlow;
                        }
                        if (var10_22 != null && var10_22.m_activities.remove(object2 = var10_22.getActivityByJobName(string))) {
                            List list = var10_22.m_activities;
                            void v1 = var10_22;
                            v1.getClass();
                            list.add((JFFlow)v1.new JFFlow.Activity(((JFJob)object4).getName(), (JFJob)object4, ((JFFlow.Activity)object2).getEventArray(), ((JFFlow.Activity)object2).getCombinationOp()));
                            object = object4;
                        }
                    }
                }
                n = xmlPullParser.next();
            }
            if (!((JFJob)object).getExecutionType().equals("link")) break block19;
            if (((JFJob)object).getAttribute("ExitCodeValue") != null) {
                object7 = this.getJFFlowNameFromJFJobName(string);
                Object var7_8 = null;
                if (((String)object7).equals(this.mainFlow.getName())) {
                    JFFlow jFFlow = this.mainFlow;
                } else {
                    JFFlow jFFlow = this.subFlows.get(object7);
                }
                var7_11.m_termJob = object;
                object4 = new StringTokenizer(((JFJob)object).getAttribute("ExitCodeValue"), ",");
                var7_11.m_termActivities = new LinkedList();
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    void var7_11;
                    var7_11.m_termActivities.add(JFXMLSource.getName(((StringTokenizer)object4).nextToken()));
                }
            } else {
                for (Map.Entry entry : this.events.entrySet()) {
                    object4 = (JFEvent)entry.getValue();
                    if (!(object4 instanceof JFLinkEvent)) continue;
                    object3 = (JFLinkEvent)object4;
                    String string3 = ((JFLinkEvent)object3).m_linkJobName;
                    if (!string.equals(string3)) continue;
                    ((JFLinkEvent)object3).m_combinationOp = this.eventCombinations.get(string);
                    if (((JFLinkEvent)object3).m_events != null) continue;
                    object2 = this.getJFFlowNameFromJFJobName(((JFLinkEvent)object3).m_linkJobName);
                    JFFlow jFFlow = this.subFlows.get(object2);
                    if (jFFlow == null && this.mainFlow.getName().equals(object2)) {
                        jFFlow = this.mainFlow;
                    }
                    if (jFFlow == null) continue;
                    ((JFLinkEvent)object3).m_events = jFFlow.getActivityByJobName(((JFLinkEvent)object3).m_linkJobName).getEventList();
                }
            }
        }
        return object;
    }

    private void parseJFFlowInstance(XmlPullParser xmlPullParser, JFFlowInstance jFFlowInstance) throws XmlPullParserException, IOException, JFException {
        while (true) {
            if (xmlPullParser.getEventType() == 2) {
                if (xmlPullParser.getName().equals("id")) {
                    jFFlowInstance.setInstanceId(Long.parseLong(xmlPullParser.nextText()));
                } else if (xmlPullParser.getName().equals("name")) {
                    jFFlowInstance.setName(xmlPullParser.nextText());
                } else if (xmlPullParser.getName().equals("owner")) {
                    jFFlowInstance.setOwner(xmlPullParser.nextText());
                } else if (xmlPullParser.getName().equals("triggerUser")) {
                    jFFlowInstance.setTriggerUser(new JFUser(xmlPullParser.nextText()));
                } else if (xmlPullParser.getName().equals("state")) {
                    jFFlowInstance.setState(Integer.parseInt(xmlPullParser.nextText()));
                } else if (xmlPullParser.getName().equals("statusCode")) {
                    jFFlowInstance.setStatus(Integer.parseInt(xmlPullParser.nextText()));
                } else if (xmlPullParser.getName().equals("startTime")) {
                    if (!this.oldServer) {
                        xmlPullParser.nextTag();
                        jFFlowInstance.setStartTime(new JFTime(xmlPullParser.nextText()));
                    } else {
                        try {
                            jFFlowInstance.setStartTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText())));
                        }
                        catch (ParseException parseException) {
                            JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                        }
                    }
                } else if (xmlPullParser.getName().equals("finishTime")) {
                    if (!this.oldServer) {
                        xmlPullParser.nextTag();
                        jFFlowInstance.setFinishTime(new JFTime(xmlPullParser.nextText()));
                    } else {
                        try {
                            jFFlowInstance.setFinishTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText())));
                        }
                        catch (ParseException parseException) {
                            JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                        }
                    }
                } else if (xmlPullParser.getName().equals("isFromOwnFlowDefinition")) {
                    jFFlowInstance.setFromOwnFlowDefinition("true".equalsIgnoreCase(xmlPullParser.nextText()));
                } else if (xmlPullParser.getName().equals("isDraft")) {
                    jFFlowInstance.setDraft("true".equalsIgnoreCase(xmlPullParser.nextText()));
                } else if (xmlPullParser.getName().equals("jobArrayInstances") && !xmlPullParser.isEmptyElementTag()) {
                    this.addJFJobArrayInstances(xmlPullParser, jFFlowInstance);
                } else if (xmlPullParser.getName().equals("jobInstances") && !xmlPullParser.isEmptyElementTag()) {
                    this.addJFJobInstances(xmlPullParser, jFFlowInstance);
                } else if (xmlPullParser.getName().equals("subFlowInstances") && !xmlPullParser.isEmptyElementTag()) {
                    this.addJFSubFlowInstances(xmlPullParser, xmlPullParser.getDepth(), jFFlowInstance);
                } else if (xmlPullParser.getName().equals("flowArrayInstances") && !xmlPullParser.isEmptyElementTag()) {
                    this.addJFFlowArrayInstances(xmlPullParser, jFFlowInstance);
                } else if (xmlPullParser.getName().equals("inputData")) {
                    jFFlowInstance.setInputData(xmlPullParser.nextText());
                } else if (xmlPullParser.getName().equals("outputData")) {
                    jFFlowInstance.setOutputData(xmlPullParser.nextText());
                } else if (xmlPullParser.getName().equals("variables")) {
                    if (!xmlPullParser.isEmptyElementTag()) {
                        jFFlowInstance.setLocalVariables(this.parseVariables(xmlPullParser, "variables"));
                        xmlPullParser.next();
                    } else {
                        xmlPullParser.next();
                        xmlPullParser.next();
                    }
                    if (xmlPullParser.getName().equals("localVars")) {
                        if (!xmlPullParser.isEmptyElementTag()) {
                            jFFlowInstance.setLocalVariables(this.parseVariables(xmlPullParser, "variables"));
                            xmlPullParser.next();
                        } else {
                            xmlPullParser.next();
                            xmlPullParser.next();
                        }
                    }
                    if (xmlPullParser.getName().equals("inputVars")) {
                        if (!xmlPullParser.isEmptyElementTag()) {
                            jFFlowInstance.setInputVariables(this.parseVariables(xmlPullParser, "inputVars"));
                            xmlPullParser.next();
                        } else {
                            xmlPullParser.next();
                            xmlPullParser.next();
                        }
                    }
                    if (!xmlPullParser.getName().equals("events") || xmlPullParser.isEmptyElementTag()) break;
                    this.setJFEventInstancesFromXML(xmlPullParser, jFFlowInstance);
                    break;
                }
            }
            if (xmlPullParser.getEventType() == 1) break;
            xmlPullParser.next();
        }
    }

    private Properties parseVariables(XmlPullParser xmlPullParser, String string) throws XmlPullParserException, IOException {
        Properties properties = new Properties();
        while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals(string)) {
            if (xmlPullParser.getEventType() == 2 && xmlPullParser.isEmptyElementTag()) {
                String string2 = JFXMLSource.decodeXML(xmlPullParser.getAttributeValue(null, "varName"));
                String string3 = JFXMLSource.decodeXML(xmlPullParser.getAttributeValue(null, "varValue"));
                properties.put(string2, string3);
            }
            xmlPullParser.next();
        }
        return properties;
    }

    private void addJFJobInstances(XmlPullParser xmlPullParser, JFFlowInstance jFFlowInstance) throws XmlPullParserException, IOException, JFException {
        xmlPullParser.nextTag();
        int n = xmlPullParser.getDepth();
        JFJobInstance jFJobInstance = null;
        String string = null;
        JFFlow jFFlow = null;
        boolean bl = true;
        while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("jobInstances")) {
            Object object;
            if (xmlPullParser.getEventType() == 3) {
                if (xmlPullParser.getDepth() == n && xmlPullParser.getName().equals("item")) {
                    jFJobInstance.setJobDefintion(string, jFFlow, false, bl);
                    jFJobInstance.initializeEventInstances(jFFlow);
                    object = jFJobInstance.getJobDefinition();
                    if (object != null && !((JFJob)object).getExecutionType().equals("link")) {
                        jFFlowInstance.addJFJobInstance(jFJobInstance);
                    } else {
                        jFFlowInstance.putLinkJob(((JFJob)object).getName(), jFJobInstance);
                    }
                    JFEventInstance[] jFEventInstanceArray = jFJobInstance.getEventInstances();
                    for (int i = 0; jFEventInstanceArray != null && i < jFEventInstanceArray.length; ++i) {
                        JFEventInstance jFEventInstance = jFEventInstanceArray[i];
                        if (!(jFEventInstance instanceof JFLinkEventInstance)) continue;
                        jFFlowInstance.addJFLinkEventInstance((JFLinkEventInstance)jFEventInstance);
                    }
                }
            } else if (xmlPullParser.getEventType() == 2) {
                if (xmlPullParser.getDepth() == n && xmlPullParser.getName().equals("item")) {
                    jFJobInstance = new JFJobInstance();
                } else if (xmlPullParser.getName().equals("jobDefinitionName")) {
                    string = xmlPullParser.nextText();
                    object = this.getJFFlowNameFromJFJobName(string);
                    jFFlow = ((String)object).equals(this.mainFlow.getName()) ? this.mainFlow : this.subFlows.get(object);
                } else if (xmlPullParser.getName().equals("events")) {
                    this.setJFEventInstancesFromXML(xmlPullParser, jFJobInstance);
                } else if (xmlPullParser.getName().equals("startTime")) {
                    if (!this.oldServer) {
                        xmlPullParser.nextTag();
                        jFJobInstance.setStartTime(new JFTime(xmlPullParser.nextText()));
                    } else {
                        try {
                            jFFlowInstance.setStartTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText())));
                        }
                        catch (ParseException parseException) {
                            JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                        }
                    }
                } else if (xmlPullParser.getName().equals("finishTime")) {
                    if (!this.oldServer) {
                        xmlPullParser.nextTag();
                        jFJobInstance.setFinishTime(new JFTime(xmlPullParser.nextText()));
                    } else {
                        try {
                            jFFlowInstance.setFinishTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText())));
                        }
                        catch (ParseException parseException) {
                            JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                        }
                    }
                } else if (xmlPullParser.getName().equals("isOnHold")) {
                    jFJobInstance.setOnHold(Boolean.parseBoolean(xmlPullParser.nextText()));
                    bl = false;
                } else {
                    jFJobInstance.setJFJobInstanceAttributes(xmlPullParser.getName(), xmlPullParser.nextText());
                }
            }
            xmlPullParser.next();
        }
    }

    private void addJFJobArrayInstances(XmlPullParser xmlPullParser, JFFlowInstance jFFlowInstance) throws XmlPullParserException, IOException, JFException {
        xmlPullParser.nextTag();
        int n = xmlPullParser.getDepth();
        int n2 = -1;
        JFJobArrayInstance jFJobArrayInstance = null;
        JFJobInstance jFJobInstance = null;
        String string = null;
        JFFlow jFFlow = null;
        String string2 = null;
        boolean bl = true;
        while (!(xmlPullParser.getEventType() == 3 && xmlPullParser.getName().equals("jobArrayInstances") || xmlPullParser.getEventType() == 1)) {
            Object object;
            Object object2;
            if (xmlPullParser.getEventType() == 3) {
                if (xmlPullParser.getName().equals("jobInstance") && xmlPullParser.getDepth() == n2) {
                    jFJobInstance.setJobDefintion(string, jFFlow, true, bl);
                    jFJobInstance.initializeEventInstances(jFFlow);
                    jFJobArrayInstance.setJobInstance(jFJobInstance);
                } else if (xmlPullParser.getName().equals("item") && xmlPullParser.getDepth() == n) {
                    object2 = new JFJobArray(jFJobInstance.getJobDefinition().getName(), jFJobInstance.getJobDefinition(), string2);
                    jFJobArrayInstance.setJobArrayDefinition((JFJobArray)object2);
                    object = jFJobArrayInstance.getJobInstance().getEventInstances();
                    for (int i = 0; object != null && i < ((JFEventInstance[])object).length; ++i) {
                        Object object3 = object[i];
                        if (!(object3 instanceof JFLinkEventInstance)) continue;
                        jFFlowInstance.addJFLinkEventInstance((JFLinkEventInstance)object3);
                    }
                    jFFlowInstance.addJFJobArrayInstance(jFJobArrayInstance);
                }
            } else if (xmlPullParser.getEventType() == 2) {
                object2 = xmlPullParser.getName();
                if (xmlPullParser.getDepth() == n && ((String)object2).equals("item")) {
                    jFJobArrayInstance = new JFJobArrayInstance();
                } else if (((String)object2).equals("jobInstance")) {
                    jFJobInstance = new JFJobInstance();
                    n2 = xmlPullParser.getDepth();
                } else if (((String)object2).equals("jobDefinitionName") && xmlPullParser.getDepth() == n2 + 1) {
                    xmlPullParser.next();
                    string = xmlPullParser.getText();
                    object = this.getJFFlowNameFromJFJobName(string);
                    jFFlow = ((String)object).equals(this.mainFlow.getName()) ? this.mainFlow : this.subFlows.get(object);
                } else if (((String)object2).equals("events") && xmlPullParser.getDepth() == n2 + 1) {
                    this.setJFEventInstancesFromXML(xmlPullParser, jFJobInstance);
                } else if (((String)object2).equals("startTime")) {
                    xmlPullParser.nextTag();
                    if (!this.oldServer) {
                        xmlPullParser.next();
                        jFJobInstance.setStartTime(new JFTime(xmlPullParser.getText()));
                    } else {
                        try {
                            jFFlowInstance.setStartTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.getText())));
                        }
                        catch (ParseException parseException) {
                            JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                        }
                    }
                } else if (((String)object2).equals("finishTime") && xmlPullParser.getDepth() == n2 + 1) {
                    xmlPullParser.nextTag();
                    if (!this.oldServer) {
                        xmlPullParser.next();
                        jFJobInstance.setFinishTime(new JFTime(xmlPullParser.getText()));
                    } else {
                        try {
                            jFFlowInstance.setFinishTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.getText())));
                        }
                        catch (ParseException parseException) {
                            JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                        }
                    }
                } else if (((String)object2).equals("isOnHold") && xmlPullParser.getDepth() == n2 + 1) {
                    xmlPullParser.next();
                    jFJobInstance.setOnHold(Boolean.parseBoolean(xmlPullParser.getText()));
                    bl = false;
                } else if (xmlPullParser.getDepth() == n2 + 1) {
                    xmlPullParser.next();
                    object = xmlPullParser.getText();
                    jFJobInstance.setJFJobInstanceAttributes((String)object2, (String)object);
                } else if (((String)object2).equals("states") && xmlPullParser.getDepth() == n2 && !xmlPullParser.isEmptyElementTag()) {
                    object = 0;
                    Integer n3 = 0;
                    while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("states")) {
                        if (xmlPullParser.getEventType() == 2) {
                            if (xmlPullParser.getName().equals("id")) {
                                object = Integer.parseInt(xmlPullParser.nextText());
                            } else if (xmlPullParser.getName().equals("state")) {
                                n3 = Integer.parseInt(xmlPullParser.nextText());
                            }
                        } else if (xmlPullParser.getEventType() == 3 && xmlPullParser.getName().equals("item")) {
                            jFJobArrayInstance.putState((Integer)object, n3);
                        }
                        xmlPullParser.next();
                    }
                } else if (((String)object2).equals("jobIds") && xmlPullParser.getDepth() == n2 && !xmlPullParser.isEmptyElementTag()) {
                    object = new ArrayList();
                    while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("jobIds")) {
                        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("item")) {
                            object.add(Long.parseLong(xmlPullParser.nextText()));
                        }
                        xmlPullParser.next();
                    }
                    jFJobArrayInstance.setJobIds((List<Long>)object);
                } else if (((String)object2).equals("indexList") && xmlPullParser.getDepth() == n2 && !xmlPullParser.isEmptyElementTag()) {
                    string2 = xmlPullParser.nextText();
                    jFJobArrayInstance.setIndexList(string2);
                }
            }
            if (xmlPullParser.getEventType() == 1) break;
            xmlPullParser.next();
        }
    }

    private void addJFSubFlowInstances(XmlPullParser xmlPullParser, int n, JFFlowInstance jFFlowInstance) throws XmlPullParserException, IOException, JFException {
        xmlPullParser.nextTag();
        JFFlowInstance jFFlowInstance2 = null;
        int n2 = xmlPullParser.getDepth();
        while (!(xmlPullParser.getEventType() == 3 && xmlPullParser.getDepth() == n && xmlPullParser.getName().equals("subFlowInstances") || xmlPullParser.getEventType() == 1)) {
            if (xmlPullParser.getEventType() == 2 && xmlPullParser.getDepth() == n2 && xmlPullParser.getName().equals("item")) {
                xmlPullParser.next();
                if (xmlPullParser.getName().equals("flowDefinition")) {
                    while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("flowDefinition")) {
                        xmlPullParser.next();
                    }
                }
                jFFlowInstance2 = new JFFlowInstance();
                this.parseJFFlowInstance(xmlPullParser, jFFlowInstance2);
                JFFlow jFFlow = this.getParentFlow(jFFlowInstance2.getName());
                this.setupJFFlowInstance(jFFlow, jFFlowInstance2);
                if (jFFlowInstance.getOwner() == null && jFFlowInstance.getFlowDefinition() != null) {
                    jFFlowInstance.setOwner(JFFlowInstance.getUserByFlowName(jFFlowInstance.getFlowDefinition().getName()));
                }
                jFFlowInstance.addSubFlowInstance(jFFlowInstance2);
                JFEventInstance[] jFEventInstanceArray = jFFlowInstance2.getEventInstances();
                for (int i = 0; jFEventInstanceArray != null && i < jFEventInstanceArray.length; ++i) {
                    JFEventInstance jFEventInstance = jFEventInstanceArray[i];
                    if (!(jFEventInstance instanceof JFLinkEventInstance)) continue;
                    jFFlowInstance.addJFLinkEventInstance((JFLinkEventInstance)jFEventInstance);
                }
            }
            if (xmlPullParser.getEventType() == 1) break;
            xmlPullParser.next();
        }
    }

    private void addJFFlowArrayInstances(XmlPullParser xmlPullParser, JFFlowInstance jFFlowInstance) throws XmlPullParserException, IOException, JFException {
        int n = xmlPullParser.getDepth();
        int n2 = xmlPullParser.getDepth();
        JFFlowArrayInstance jFFlowArrayInstance = null;
        JFFlow jFFlow = this.getJFFlow(jFFlowInstance.getName());
        while (!(xmlPullParser.getEventType() == 3 && xmlPullParser.getName().equals("flowArrayInstances") && n == xmlPullParser.getDepth() || xmlPullParser.getEventType() == 1)) {
            JFEventInstance[] jFEventInstanceArray;
            if (xmlPullParser.getEventType() == 2) {
                if (xmlPullParser.getDepth() == n + 1 && xmlPullParser.getName().equals("item")) {
                    jFFlowArrayInstance = new JFFlowArrayInstance();
                    n2 = xmlPullParser.getDepth();
                } else if (xmlPullParser.getDepth() == n2 + 1) {
                    if (xmlPullParser.getName().equals("name") && !xmlPullParser.isEmptyElementTag()) {
                        jFEventInstanceArray = xmlPullParser.nextText();
                        jFFlowArrayInstance.setName((String)jFEventInstanceArray);
                        jFFlowArrayInstance.setFlowDefinition(this.getJFFlow((String)jFEventInstanceArray));
                    } else if (xmlPullParser.getName().equals("owner") && !xmlPullParser.isEmptyElementTag()) {
                        jFFlowArrayInstance.setOwner(xmlPullParser.nextText());
                    } else if (xmlPullParser.getName().equals("state") && !xmlPullParser.isEmptyElementTag()) {
                        jFFlowArrayInstance.setState(Integer.parseInt(xmlPullParser.nextText()));
                    } else if (xmlPullParser.getName().equals("statusCode") && !xmlPullParser.isEmptyElementTag()) {
                        jFFlowArrayInstance.setExitCode(Integer.parseInt(xmlPullParser.nextText()));
                    } else if (xmlPullParser.getName().equals("startTime") && !xmlPullParser.isEmptyElementTag()) {
                        if (!this.oldServer) {
                            xmlPullParser.nextTag();
                            jFFlowArrayInstance.setStartTime(new JFTime(xmlPullParser.nextText()));
                        } else {
                            try {
                                jFFlowArrayInstance.setStartTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText())));
                            }
                            catch (ParseException parseException) {
                                JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                            }
                        }
                    } else if (xmlPullParser.getName().equals("finishTime") && !xmlPullParser.isEmptyElementTag()) {
                        if (!this.oldServer) {
                            xmlPullParser.nextTag();
                            jFFlowArrayInstance.setStartTime(new JFTime(xmlPullParser.nextText()));
                        } else {
                            try {
                                jFFlowArrayInstance.setStartTime(new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText())));
                            }
                            catch (ParseException parseException) {
                                JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                            }
                        }
                    } else if (xmlPullParser.getName().equals("ItemlocalVars") && !xmlPullParser.isEmptyElementTag()) {
                        jFFlowArrayInstance.setItemLocalVariables(this.parseVariables(xmlPullParser, "ItemlocalVars"));
                    } else if (xmlPullParser.getName().equals("firstElement") && !xmlPullParser.isEmptyElementTag()) {
                        jFFlowArrayInstance.setFirstElement(xmlPullParser.nextText());
                    } else if (xmlPullParser.getName().equals("lastElement") && !xmlPullParser.isEmptyElementTag()) {
                        jFFlowArrayInstance.setLastElement(xmlPullParser.nextText());
                    } else if (xmlPullParser.getName().equals("elements") && !xmlPullParser.isEmptyElementTag()) {
                        this.setJFFlowArrayElementInfosFromXML(xmlPullParser, jFFlowArrayInstance);
                    } else if (xmlPullParser.getName().equals("events") && !xmlPullParser.isEmptyElementTag()) {
                        this.setJFEventInstancesFromXML(xmlPullParser, jFFlowArrayInstance);
                    }
                }
            } else if (xmlPullParser.getEventType() == 3 && xmlPullParser.getName().equals("item") && xmlPullParser.getDepth() == n + 1) {
                if (jFFlowArrayInstance.getOwner() == null) {
                    jFFlowArrayInstance.setOwner(jFFlowArrayInstance.getUserByFlowArrayName(jFFlowArrayInstance.getFlowDefinition().getName()));
                }
                jFFlowArrayInstance.setJFFlowArray(new JFFlowArray(jFFlowArrayInstance.getName(), jFFlowArrayInstance.getFlowDefinition(), jFFlowArrayInstance.getFirstElement(), jFFlowArrayInstance.getLastElement()));
                jFFlowArrayInstance.initializeEventInstances(jFFlow);
                jFFlowArrayInstance.m_flowDefinition.setAttributes(jFFlow.getFlowArray(jFFlowArrayInstance.m_flowDefinition.getName()).getFlowDefinition().getAttributes());
                jFFlowArrayInstance.m_flowDefinition.m_handlerList = jFFlow.getFlowArray((String)jFFlowArrayInstance.m_flowDefinition.getName()).getFlowDefinition().m_handlerList;
                jFEventInstanceArray = jFFlowArrayInstance.getEventInstances();
                for (int i = 0; jFEventInstanceArray != null && i < jFEventInstanceArray.length; ++i) {
                    JFEventInstance jFEventInstance = jFEventInstanceArray[i];
                    if (!(jFEventInstance instanceof JFLinkEventInstance)) continue;
                    jFFlowInstance.addJFLinkEventInstance((JFLinkEventInstance)jFEventInstance);
                }
                jFFlowInstance.addJFFlowArrayInstance(jFFlowArrayInstance);
            }
            if (xmlPullParser.getEventType() == 1) break;
            xmlPullParser.next();
        }
    }

    private JFFlow getParentFlow(String string) {
        JFFlow jFFlow = null;
        String string2 = this.getParentDefinitionName(this.getDefinitionNameFromInstanceName(string));
        jFFlow = string2.equals(this.mainFlow.getName()) ? this.mainFlow : this.subFlows.get(string2);
        return jFFlow;
    }

    private JFFlow getJFFlow(String string) {
        JFFlow jFFlow = null;
        String string2 = this.getDefinitionNameFromInstanceName(string);
        jFFlow = string2.equals(this.mainFlow.getName()) ? this.mainFlow : this.subFlows.get(string2);
        return jFFlow;
    }

    private int getEventCombination(XmlPullParser xmlPullParser) {
        int n = 0;
        String string = xmlPullParser.getAttributeValue(null, "CombinationType");
        if (string != null && string.equals("Or")) {
            n = 1;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public List<JFHandler> getHandlers(XmlPullParser var1_1) throws XmlPullParserException, IOException, JFException {
        var2_2 = new LinkedList<JFHandler>();
        var3_3 = null;
        var4_4 = 30;
        var5_5 = 1;
        var6_6 = null;
        var7_7 = null;
        while (var1_1.getEventType() != 3 || !var1_1.getName().equals("Exceptions")) {
            if (var1_1.getEventType() == 2) {
                if ("Exception".equals(var1_1.getName())) {
                    var3_3 = var1_1.getAttributeValue(null, "Type");
                    if (var3_3 == null || var3_3.equals("")) {
                        throw new JFException(JFResource.getString("DEFN_HANDLER_NOACTION"));
                    }
                    var8_8 = var1_1.getAttributeValue(null, "Delay");
                    if (var8_8 != null && !var8_8.equals("")) {
                        try {
                            var5_5 = Integer.valueOf((String)var8_8);
                            var5_5 = var5_5 < 1 ? 1 : var5_5;
                        }
                        catch (Exception var9_10) {
                            throw new JFException(JFResource.getString("DEFN_HANDLER_INV_DELAY"));
                        }
                    }
                    if ((var9_9 = var1_1.getAttributeValue(null, "NumberRerun")) != null && !var9_9.equals("")) {
                        try {
                            var4_4 = Integer.valueOf(var9_9);
                            if (var4_4 >= 1 && var4_4 <= 50) ** GOTO lbl60
                            var4_4 = 30;
                        }
                        catch (Exception var10_12) {
                            throw new JFException(JFResource.getString("DEFN_HANDLER_INV_NUMBER_RERUN"));
                        }
                    }
                } else if ("Event".equals(var1_1.getName())) {
                    var8_8 = this.getJFEventAttributes(var1_1);
                    var9_9 = var1_1.getAttributeValue(null, "GeneratorType");
                    var10_11 = var1_1.nextToken();
                    if (var10_11 == 5 || var10_11 == 4) {
                        var11_13 = var1_1.getText();
                        if (var9_9.equals("lsf") && !var11_13.endsWith(")") && ((var12_14 = var1_1.next()) == 5 || var12_14 == 4)) {
                            var11_13 = var11_13 + var1_1.getText();
                        }
                        if ((var6_6 = this.events.get(var11_13)) == null) {
                            var12_15 = JFEventFactory.getEventFactory();
                            var6_6 = var12_15.createEvent(var9_9, var11_13);
                            for (Map.Entry<K, V> var14_17 : var8_8.entrySet()) {
                                var6_6.setAttribute((String)var14_17.getKey(), (String)var14_17.getValue());
                            }
                        }
                        this._setupJFEvent(var6_6);
                    }
                } else if ("JobDef".equals(var1_1.getName())) {
                    var7_7 = this.parseJFJobDef(var1_1);
                }
            } else if (var1_1.getEventType() == 3 && "Exception".equals(var1_1.getName())) {
                if (var3_3.equals("alarm")) {
                    if (var7_7 == null) {
                        throw new JFException(JFResource.getString("HANDLER_ALARM_NULL"));
                    }
                    var8_8 = new JFHandler(var6_6, 2, var5_5, var4_4);
                    var8_8.setAlarmJob(var7_7);
                    var2_2.add((JFHandler)var8_8);
                } else {
                    var2_2.add(new JFHandler(var6_6, var3_3.trim().equalsIgnoreCase("Kill") != false ? 0 : 1, var5_5, var4_4));
                }
            }
lbl60:
            // 9 sources

            var1_1.next();
        }
        return var2_2;
    }

    private JFEvent[] getEvents(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException, JFException {
        JFEvent[] jFEventArray = null;
        HashMap<String, JFEvent> hashMap = new HashMap<String, JFEvent>();
        int n = xmlPullParser.next();
        long l = System.nanoTime() / 1000L % 1000000L;
        while (n != 3 || !xmlPullParser.getName().equals("Events")) {
            if (n == 2 && "Event".equals(xmlPullParser.getName())) {
                String string = xmlPullParser.getAttributeValue(null, "GeneratorType");
                Map<String, String> map = this.getJFEventAttributes(xmlPullParser);
                if (xmlPullParser.nextToken() == 5) {
                    String object = xmlPullParser.getText();
                    String string2 = "" + l++;
                    while (this.events.containsKey(string2) || hashMap.containsKey(string2)) {
                        string2 = "" + l++;
                    }
                    JFEventFactory jFEventFactory = JFEventFactory.getEventFactory();
                    JFEvent jFEvent = jFEventFactory.createEvent(string, object);
                    for (Map.Entry entry : map.entrySet()) {
                        jFEvent.setAttribute((String)entry.getKey(), (String)entry.getValue());
                    }
                    hashMap.put(string2, jFEvent);
                }
            }
            n = xmlPullParser.next();
        }
        if (!hashMap.isEmpty()) {
            jFEventArray = new JFEvent[hashMap.size()];
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                jFEventArray[n2] = (JFEvent)entry.getValue();
                this._setupJFEvent(jFEventArray[n2]);
                this.events.put((String)entry.getKey(), jFEventArray[n2]);
                ++n2;
            }
        }
        return jFEventArray;
    }

    private Map<String, String> getJFEventAttributes(XmlPullParser xmlPullParser) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < xmlPullParser.getAttributeCount(); ++i) {
            String string = xmlPullParser.getAttributeName(i);
            String string2 = xmlPullParser.getAttributeValue(i);
            if (string2.equals("") || string2.equals("null")) continue;
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private JFFlowVersion getJFFlowVersion(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        JFFlowVersion jFFlowVersion = new JFFlowVersion();
        while (xmlPullParser.getEventType() != 3 || !"flowVersion".equals(xmlPullParser.getName())) {
            if (xmlPullParser.getEventType() == 2) {
                if ("version".equals(xmlPullParser.getName())) {
                    jFFlowVersion.setVersion(xmlPullParser.nextText());
                } else if ("submissionTime".equals(xmlPullParser.getName())) {
                    xmlPullParser.next();
                    jFFlowVersion.setSubmissionTime(new JFTime(xmlPullParser.nextText()));
                } else if ("comments".equals(xmlPullParser.getName())) {
                    jFFlowVersion.setComments(xmlPullParser.nextText());
                }
            }
            xmlPullParser.next();
        }
        return jFFlowVersion;
    }

    private void setupJFFlowInstance(JFFlow jFFlow, JFFlowInstance jFFlowInstance) {
        if (jFFlow != null) {
            jFFlowInstance.initializeEventInstances(jFFlow);
        }
        if (jFFlowInstance.getFlowDefinition() == null) {
            JFFlow jFFlow2 = this.subFlows.get(this.getDefinitionNameFromInstanceName(jFFlowInstance.getName()));
            jFFlowInstance.setFlowDefintion(jFFlow2);
        }
        jFFlowInstance.setupLinks(jFFlowInstance.getJFLinkEventInstances(), jFFlowInstance.getLinkJobs());
    }

    private void setMainFlowAttributes(XmlPullParser xmlPullParser, JFFlow jFFlow) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        String string14;
        String string15;
        String string16;
        String string17;
        String string18 = JFConfigManager.getClientVersion().getVersion();
        if (string18 != null) {
            jFFlow.setAttribute("ClientVersion", string18);
        }
        String string19 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "Description"));
        jFFlow.setAttribute("Description", string19);
        String string20 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "ExitConditionIgnoreWaitingActivities"));
        if (string20 != null) {
            jFFlow.setAttribute("ExitConditionIgnoreWaitingActivities", string20);
        }
        if ((string17 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "EndBehaviour"))) != null) {
            jFFlow.setAttribute("EndBehaviour", string17);
        }
        if ((string16 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStateMailWhen"))) != null) {
            jFFlow.setAttribute("FlowStateMailWhen", string16);
        }
        if ((string15 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "MailDestination"))) != null) {
            jFFlow.setAttribute("MailDestination", string15);
        }
        if ((string14 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "Exclusive"))) != null) {
            jFFlow.setAttribute("Exclusive", string14);
        }
        if ((string13 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "UpdateType"))) != null) {
            jFFlow.setAttribute("UpdateType", string13);
        }
        if ((string12 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowWorkingDir"))) != null) {
            jFFlow.setAttribute("FlowWorkingDir", JFXMLSource.decodeXML(string12));
        }
        if ((string11 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "ExitCodeRule"))) != null) {
            jFFlow.setAttribute("ExitCodeRule", JFXMLSource.decodeXML(string11));
        }
        if ((string10 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowEnvVars"))) != null) {
            jFFlow.setAttribute("FlowEnvVars", JFXMLSource.decodeXML(string10));
        }
        if ((string9 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "Owner"))) != null) {
            jFFlow.setAttribute("Owner", string9);
        }
        if ((string8 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowCreateStdout"))) != null) {
            jFFlow.setAttribute("FlowCreateStdout", string8);
        }
        if ((string7 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStdout"))) != null) {
            jFFlow.setAttribute("FlowStdout", string7);
        }
        if ((string6 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStdoutDir"))) != null) {
            jFFlow.setAttribute("FlowStdoutDir", string6);
        }
        if ((string5 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStdoutAutoIndex"))) != null) {
            jFFlow.setAttribute("FlowStdoutAutoIndex", string5);
        }
        if ((string4 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowCreateStderr"))) != null) {
            jFFlow.setAttribute("FlowCreateStderr", string4);
        }
        if ((string3 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStderr"))) != null) {
            jFFlow.setAttribute("FlowStderr", string3);
        }
        if ((string2 = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStderrDir"))) != null) {
            jFFlow.setAttribute("FlowStderrDir", string2);
        }
        if ((string = JFXMLSource.convertToXMLAttrString(xmlPullParser.getAttributeValue(null, "FlowStderrAutoIndex"))) != null) {
            jFFlow.setAttribute("FlowStderrAutoIndex", string);
        }
    }

    private void setFlowAttributesFromXML(XmlPullParser xmlPullParser, JFFlow jFFlow) {
        int n = xmlPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            jFFlow.setAttribute(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
        }
    }

    private void setJobAttributesFromXML(XmlPullParser xmlPullParser, JFJob jFJob) {
        int n = xmlPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            jFJob.setAttribute(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
        }
    }

    private void _setupJFEvent(JFEvent jFEvent) {
        String string = jFEvent.getEventGeneratorType();
        if (string.equals("flow")) {
            JFFlowEvent jFFlowEvent = (JFFlowEvent)jFEvent;
            String string2 = jFFlowEvent.m_flowName;
            if (string2.equals(this.mainFlow.getName())) {
                jFFlowEvent.m_flowRef = this.mainFlow;
            } else {
                JFFlow jFFlow = this.subFlows.get(string2);
                if (jFFlow == null && !jFFlowEvent.isProxy()) {
                    jFFlow = new JFFlow(JFXMLSource.getName(string2));
                    this.subFlows.put(string2, jFFlow);
                }
                jFFlowEvent.m_flowRef = jFFlow;
            }
        } else if (string.equals("flow_except")) {
            JFFlowExceptionEvent jFFlowExceptionEvent = (JFFlowExceptionEvent)jFEvent;
            String string3 = jFFlowExceptionEvent.m_flowName;
            if (string3.equals(this.mainFlow.getName())) {
                jFFlowExceptionEvent.m_flowRef = this.mainFlow;
            } else {
                JFFlow jFFlow = this.subFlows.get(string3);
                if (jFFlow == null) {
                    jFFlow = new JFFlow(JFXMLSource.getName(string3));
                    this.subFlows.put(string3, jFFlow);
                }
                jFFlowExceptionEvent.m_flowRef = jFFlow;
            }
        } else if (string.equals("lsf") || string.equals("manual") || string.equals("otherbatch") || string.equals("local")) {
            JFJobEvent jFJobEvent = (JFJobEvent)jFEvent;
            String string4 = jFJobEvent.m_jobName;
            JFJob jFJob = this.jobs.get(string4);
            if (jFJob == null && !jFJobEvent.isProxy()) {
                jFJob = new JFJob(JFXMLSource.getName(string4));
                this.jobs.put(string4, jFJob);
            }
            jFJobEvent.m_jobRef = jFJob;
        } else if (string.equals("job_except")) {
            JFJobExceptionEvent jFJobExceptionEvent = (JFJobExceptionEvent)jFEvent;
            String string5 = jFJobExceptionEvent.m_jobName;
            JFJob jFJob = this.jobs.get(jFJobExceptionEvent.m_jobName);
            if (jFJob == null) {
                jFJob = new JFJob(JFXMLSource.getName(string5));
                this.jobs.put(string5, jFJob);
            }
            jFJobExceptionEvent.m_jobRef = jFJob;
        } else if (string.equals("variable")) {
            JFVariableEvent jFVariableEvent = (JFVariableEvent)jFEvent;
            String string6 = jFVariableEvent.m_jobName;
            JFJob jFJob = this.jobs.get(string6);
            if (jFJob == null && !jFVariableEvent.isProxy()) {
                jFJob = new JFJob(JFXMLSource.getName(string6));
                this.jobs.put(string6, jFJob);
            }
            jFVariableEvent.m_jobRef = jFJob;
        } else if (string.equals("jobarray")) {
            JFJobArray jFJobArray;
            JFJobArrayEvent jFJobArrayEvent = (JFJobArrayEvent)jFEvent;
            String string7 = jFJobArrayEvent.m_jobArrName;
            JFJob jFJob = this.jobs.get(string7);
            if (jFJob == null) {
                jFJob = new JFJob(JFXMLSource.getName(string7));
                this.jobs.put(string7, jFJob);
            }
            if ((jFJobArray = this.jobArrays.get(string7)) == null && !jFJobArrayEvent.isProxy()) {
                jFJobArray = new JFJobArray(JFXMLSource.getName(string7), jFJob, "");
                this.jobArrays.put(string7, jFJobArray);
            }
            jFJobArrayEvent.m_jobArrRef = jFJobArray;
        } else if (string.equals("jobarray_except")) {
            JFJobArray jFJobArray;
            JFJobArrayExceptionEvent jFJobArrayExceptionEvent = (JFJobArrayExceptionEvent)jFEvent;
            String string8 = jFJobArrayExceptionEvent.m_jobArrName;
            JFJob jFJob = this.jobs.get(string8);
            if (jFJob == null) {
                jFJob = new JFJob(JFXMLSource.getName(string8));
                this.jobs.put(string8, jFJob);
            }
            if ((jFJobArray = this.jobArrays.get(string8)) == null) {
                jFJobArray = new JFJobArray(JFXMLSource.getName(string8), jFJob, "");
                this.jobArrays.put(string8, jFJobArray);
            }
            jFJobArrayExceptionEvent.m_jobArrRef = jFJobArray;
        } else if (string.equals("flowarray")) {
            JFFlowArrayEvent jFFlowArrayEvent = (JFFlowArrayEvent)jFEvent;
            String string9 = jFFlowArrayEvent.m_flowArrName;
            JFFlow jFFlow = this.subFlows.get(string9);
            if (jFFlow == null) {
                jFFlow = new JFFlow(JFXMLSource.getName(string9));
                this.subFlows.put(string9, jFFlow);
            }
            JFFlowArray jFFlowArray = new JFFlowArray(JFXMLSource.getName(string9), jFFlow, null, null);
            this.flowArrays.put(string9, jFFlowArray);
            jFFlowArrayEvent.m_flowArrRef = jFFlowArray;
        } else if (string.equals("flowarray_except")) {
            JFFlowArrayExceptionEvent jFFlowArrayExceptionEvent = (JFFlowArrayExceptionEvent)jFEvent;
            String string10 = jFFlowArrayExceptionEvent.m_flowArrName;
            JFFlow jFFlow = this.subFlows.get(string10);
            if (jFFlow == null) {
                jFFlow = new JFFlow(JFXMLSource.getName(string10));
                this.subFlows.put(string10, jFFlow);
            }
            JFFlowArray jFFlowArray = new JFFlowArray(JFXMLSource.getName(string10), jFFlow, null, null);
            this.flowArrays.put(string10, jFFlowArray);
            jFFlowArrayExceptionEvent.m_flowArrRef = jFFlowArray;
        } else if (!(string.equals("dynamicflow") || string.equals("dynamicflow_except") || string.equals("dynamicflowarray") || string.equals("dynamicflowarray_except") || !string.equals("link"))) {
            JFLinkEvent jFLinkEvent = (JFLinkEvent)jFEvent;
            String string11 = jFLinkEvent.m_linkJobName;
            JFJob jFJob = this.jobs.get(string11);
            if (jFJob == null) {
                jFJob = new JFJob(JFXMLSource.getName(string11));
                this.jobs.put(string11, jFJob);
            }
            jFLinkEvent.m_linkJobRef = jFJob;
        }
    }

    private void setJFFlowArrayElementInfosFromXML(XmlPullParser xmlPullParser, JFFlowArrayInstance jFFlowArrayInstance) throws XmlPullParserException, IOException {
        JFFlowArrayElementInfo jFFlowArrayElementInfo = null;
        while (!(xmlPullParser.getEventType() == 3 && xmlPullParser.getName().equals("elements") || xmlPullParser.getEventType() == 1)) {
            if (xmlPullParser.getEventType() == 2) {
                String string;
                if (xmlPullParser.getName().equals("element")) {
                    jFFlowArrayElementInfo = new JFFlowArrayElementInfo();
                    jFFlowArrayElementInfo.m_name = jFFlowArrayInstance.m_name;
                } else if (xmlPullParser.getName().equals("index") && !xmlPullParser.isEmptyElementTag()) {
                    jFFlowArrayElementInfo.m_index = Integer.parseInt(xmlPullParser.nextText());
                    int n = jFFlowArrayInstance.getFirstIndex();
                    int n2 = jFFlowArrayInstance.getLastIndex();
                    if (n == 0 || n > jFFlowArrayElementInfo.m_index) {
                        jFFlowArrayInstance.setFirstIndex(jFFlowArrayElementInfo.m_index);
                    }
                    if (n2 == 0 || n2 < jFFlowArrayElementInfo.m_index) {
                        jFFlowArrayInstance.setLastIndex(jFFlowArrayElementInfo.m_index);
                    }
                } else if (xmlPullParser.getName().equals("state") && !xmlPullParser.isEmptyElementTag()) {
                    jFFlowArrayElementInfo.m_state = Integer.parseInt(xmlPullParser.nextText());
                } else if (xmlPullParser.getName().equals("statusCode") && !xmlPullParser.isEmptyElementTag()) {
                    jFFlowArrayElementInfo.m_exitCode = Integer.parseInt(xmlPullParser.nextText());
                } else if (xmlPullParser.getName().equals("startTime") && !xmlPullParser.isEmptyElementTag()) {
                    xmlPullParser.nextTag();
                    jFFlowArrayElementInfo.m_startTime = new JFTime(xmlPullParser.nextText()).getTime();
                } else if (xmlPullParser.getName().equals("finishTime") && !xmlPullParser.isEmptyElementTag()) {
                    xmlPullParser.nextTag();
                    jFFlowArrayElementInfo.m_finishTime = new JFTime(xmlPullParser.nextText()).getTime();
                } else if (xmlPullParser.getName().equals("localVars") && !xmlPullParser.isEmptyElementTag()) {
                    Properties properties = new Properties();
                    while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("localVars")) {
                        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("item") && xmlPullParser.isEmptyElementTag()) {
                            String string2 = xmlPullParser.getAttributeValue(null, "varName");
                            string = xmlPullParser.getAttributeValue(null, "varValue");
                            properties.put(string2, string);
                        }
                        xmlPullParser.next();
                    }
                    jFFlowArrayInstance.putLocalVars(Long.valueOf(jFFlowArrayElementInfo.m_index), properties);
                } else if (xmlPullParser.getName().equals("inputVars") && !xmlPullParser.isEmptyElementTag()) {
                    Properties properties = new Properties();
                    while (!(xmlPullParser.getEventType() == 3 && xmlPullParser.getName().equals("inputVars") || xmlPullParser.getEventType() == 1)) {
                        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("item") && xmlPullParser.isEmptyElementTag()) {
                            String string3 = xmlPullParser.getAttributeValue(null, "varName");
                            string = xmlPullParser.getAttributeValue(null, "varValue");
                            properties.put(string3, string);
                        }
                        xmlPullParser.next();
                    }
                    jFFlowArrayInstance.putInputVars(Long.valueOf(jFFlowArrayElementInfo.m_index), properties);
                }
                if (xmlPullParser.getEventType() == 3) {
                    jFFlowArrayInstance.putJFFlowArrayElementInfo(jFFlowArrayElementInfo);
                }
            }
            if (xmlPullParser.getEventType() == 1) break;
            xmlPullParser.next();
        }
    }

    private void setJFEventInstancesFromXML(XmlPullParser xmlPullParser, Object object) throws XmlPullParserException, IOException, JFException {
        block37: {
            JFEventInstance jFEventInstance = null;
            JFEvent jFEvent = null;
            JFTime jFTime = null;
            String string = null;
            String string2 = null;
            boolean bl = false;
            int n = xmlPullParser.getEventType();
            long l = System.nanoTime() / 1000L % 1000000L;
            if (!xmlPullParser.isEmptyElementTag()) {
                n = xmlPullParser.nextTag();
                while (true) {
                    if (n == 2) {
                        if ("item".equals(xmlPullParser.getName())) {
                            jFEventInstance = new JFEventInstance();
                        } else if (xmlPullParser.getName().equalsIgnoreCase("Event")) {
                            Map<String, String> map = this.getJFEventAttributes(xmlPullParser);
                            if (xmlPullParser.nextToken() == 5) {
                                String string3 = xmlPullParser.getText();
                                String string4 = "" + l++;
                                while (this.events.containsKey(string4)) {
                                    string4 = "" + l++;
                                }
                                String string5 = map.get("GeneratorType");
                                jFEvent = JFEventFactory.getEventFactory().createEvent(string5, string3);
                                this.events.put(string4, jFEvent);
                                for (Map.Entry<String, String> entry : map.entrySet()) {
                                    jFEvent.setAttribute(entry.getKey(), entry.getValue());
                                }
                            }
                        } else if (xmlPullParser.getName().equalsIgnoreCase("time")) {
                            if (!this.oldServer) {
                                n = xmlPullParser.nextTag();
                                jFTime = new JFTime(xmlPullParser.nextText());
                            } else {
                                try {
                                    jFTime = new JFTime(JFDateTimeParser.oldParse(xmlPullParser.nextText()));
                                }
                                catch (ParseException parseException) {
                                    JFDebug.println("JFFlowInstance::fromXML: wrong format of startTime " + parseException.getMessage());
                                }
                            }
                        } else if (xmlPullParser.getName().equalsIgnoreCase("RuntimeInfo")) {
                            string = xmlPullParser.nextText();
                        } else if (xmlPullParser.getName().equalsIgnoreCase("TriggerFile")) {
                            string2 = xmlPullParser.nextText();
                        } else if (xmlPullParser.getName().equalsIgnoreCase("CompletedManually") && "Yes".equals(xmlPullParser.nextText())) {
                            bl = true;
                        }
                    } else if (n == 3) {
                        if (xmlPullParser.getName().equals("events")) break block37;
                        if (xmlPullParser.getName().equals("item")) {
                            this.setupJFEvent(jFEvent);
                            jFEventInstance.setJFEventDefinition(jFEvent);
                            jFEventInstance.setRuntimeInfo(string);
                            jFEventInstance.setTime(jFTime);
                            jFEventInstance.setTriggerFile(string2);
                            jFEventInstance.setCompletedManually(bl);
                            if (jFEvent.getEventGeneratorType().equals("link")) {
                                if (object instanceof JFFlowInstance) {
                                    ((JFFlowInstance)object).addJFEventInstance(new JFLinkEventInstance(jFEventInstance));
                                } else if (object instanceof JFJobInstance) {
                                    ((JFJobInstance)object).addJFEventInstance(new JFLinkEventInstance(jFEventInstance));
                                } else if (object instanceof JFFlowArrayInstance) {
                                    ((JFFlowArrayInstance)object).addJFEventInstance(new JFLinkEventInstance(jFEventInstance));
                                }
                            } else if (object instanceof JFFlowInstance) {
                                ((JFFlowInstance)object).addJFEventInstance(jFEventInstance);
                            } else if (object instanceof JFJobInstance) {
                                ((JFJobInstance)object).addJFEventInstance(jFEventInstance);
                            } else if (object instanceof JFFlowArrayInstance) {
                                ((JFFlowArrayInstance)object).addJFEventInstance(jFEventInstance);
                            }
                        }
                    }
                    n = xmlPullParser.next();
                }
            }
            n = xmlPullParser.nextTag();
        }
    }

    private JFTemplateData getJFTemplateJobFromXML(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException, JFException {
        String string = xmlPullParser.getAttributeValue(null, "TemplateName");
        String string2 = xmlPullParser.getAttributeValue(null, "Version");
        JFTemplateData jFTemplateData = new JFTemplateData();
        jFTemplateData.setTemplateName(string);
        jFTemplateData.setVersion(string2);
        while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("TemplateData")) {
            if (xmlPullParser.getEventType() == 2) {
                if (xmlPullParser.getName().equals("Execution")) {
                    String string3 = xmlPullParser.getAttributeValue(null, "Type");
                    String string4 = xmlPullParser.getAttributeValue(null, "Action");
                    int n = -1;
                    if (string3 == null || string3.length() <= 0) {
                        throw new JFException(JFResource.getString("TEMPLATE_DATA_INVALID") + ": " + JFResource.getString("TEMPLAET_TYPE_NOT_DEFINED"));
                    }
                    n = string3.equals("lsf") ? 0 : (string3.equals("script") ? 3 : (string3.equals("oracle") ? 1 : (string3.equals("zos") ? 2 : 4)));
                    jFTemplateData.setExecutionTypeString(string3);
                    jFTemplateData.setExecutionType(n);
                    jFTemplateData.setExecutionAction(string4);
                    jFTemplateData.setExecutionParameters(this.getJFTemplateParameterListFromXML(xmlPullParser, xmlPullParser.getName()));
                } else if (xmlPullParser.getName().equals("Submission")) {
                    jFTemplateData.setSubmissionParameters(this.getJFTemplateParameterListFromXML(xmlPullParser, xmlPullParser.getName()));
                }
            }
            xmlPullParser.next();
        }
        return jFTemplateData;
    }

    private JFTemplateParameterList getJFTemplateParameterListFromXML(XmlPullParser xmlPullParser, String string) throws XmlPullParserException, IOException, JFException {
        JFTemplateParameterList jFTemplateParameterList = new JFTemplateParameterList();
        while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals(string)) {
            if (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("Param")) {
                Object object;
                JFTemplateParameter jFTemplateParameter = new JFTemplateParameter();
                String string2 = xmlPullParser.getAttributeValue(null, "Name");
                if (string2 == null) {
                    throw new JFException(JFResource.getString("TEMPLATE_INVALID_CONTENT") + ":" + JFResource.getString("TEMPLATE_PARAM_NAME_NULL"));
                }
                jFTemplateParameter.setName(string2);
                String string3 = xmlPullParser.getAttributeValue(null, "Caption");
                if (string3 != null && string3.trim().length() > 0) {
                    jFTemplateParameter.setCaption(string3);
                }
                String[] stringArray = null;
                if (xmlPullParser.isEmptyElementTag()) {
                    object = xmlPullParser.getAttributeValue(null, "Input");
                    if (object == null) {
                        throw new JFException(JFResource.getString("TEMPLATE_INVALID_CONTENT") + ":" + JFResource.getString("TEMPLATE_PARAM_NAME_NULL"));
                    }
                    stringArray = new String[]{object};
                } else {
                    object = new ArrayList();
                    while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("Param")) {
                        if (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("Repeat")) {
                            String string4 = xmlPullParser.getAttributeValue(null, "Input");
                            if (string4 == null) {
                                throw new JFException(JFResource.getString("TEMPLATE_INVALID_CONTENT") + ":" + JFResource.getString("TEMPLATE_PARAM_NAME_NULL"));
                            }
                            object.add(string4);
                        }
                        xmlPullParser.next();
                    }
                    stringArray = new String[object.size()];
                    object.toArray(stringArray);
                }
                jFTemplateParameter.setUserInput(stringArray);
                jFTemplateParameterList.addParameter(jFTemplateParameter);
            }
            xmlPullParser.next();
        }
        return jFTemplateParameterList;
    }

    private JFJob getJobDefByName(String string) {
        JFJob jFJob = this.jobs.get(string);
        if (jFJob == null) {
            jFJob = this.jobs.get(this.getDefinitionNameFromInstanceName(string));
        }
        return jFJob;
    }

    private JFFlow getFlowDefByName(String string) {
        if (string.equals(this.mainFlow.getName()) || this.getDefinitionNameFromInstanceName(string).equals(this.mainFlow.getName())) {
            return this.mainFlow;
        }
        JFFlow jFFlow = this.subFlows.get(string);
        if (jFFlow == null) {
            jFFlow = this.subFlows.get(this.getDefinitionNameFromInstanceName(string));
        }
        return jFFlow;
    }

    private JFJobArray getJobArrayDefByName(String string) {
        JFJobArray jFJobArray = this.jobArrays.get(string);
        if (jFJobArray == null) {
            jFJobArray = this.jobArrays.get(this.getDefinitionNameFromInstanceName(string));
        }
        return jFJobArray;
    }

    private JFFlowArray getFlowArrayDefByName(String string) {
        JFFlowArray jFFlowArray = this.flowArrays.get(string);
        if (jFFlowArray == null) {
            jFFlowArray = this.flowArrays.get(this.getDefinitionNameFromInstanceName(string));
        }
        return jFFlowArray;
    }

    private void setupJFEvent(JFEvent jFEvent) {
        String string = jFEvent.getEventGeneratorType();
        if (string.equals("lsf") || string.equals("manual") || string.equals("otherbatch") || string.equals("local")) {
            JFJobEvent jFJobEvent = (JFJobEvent)jFEvent;
            jFJobEvent.m_jobRef = this.getJobDefByName(jFJobEvent.m_jobName);
        } else if (string.equals("variable")) {
            JFVariableEvent jFVariableEvent = (JFVariableEvent)jFEvent;
            jFVariableEvent.m_jobRef = this.getJobDefByName(jFVariableEvent.m_jobName);
        } else if (string.equals("link")) {
            JFLinkEvent jFLinkEvent = (JFLinkEvent)jFEvent;
            jFLinkEvent.m_linkJobRef = this.getJobDefByName(jFLinkEvent.m_linkJobName);
        } else if (string.equals("flow")) {
            JFFlowEvent jFFlowEvent = (JFFlowEvent)jFEvent;
            jFFlowEvent.m_flowRef = this.getFlowDefByName(jFFlowEvent.m_flowName);
        } else if (string.equals("jobarray")) {
            JFJobArrayEvent jFJobArrayEvent = (JFJobArrayEvent)jFEvent;
            jFJobArrayEvent.m_jobArrRef = this.getJobArrayDefByName(jFJobArrayEvent.m_jobArrName);
        } else if (string.equals("job_except")) {
            JFJobExceptionEvent jFJobExceptionEvent = (JFJobExceptionEvent)jFEvent;
            jFJobExceptionEvent.m_jobRef = this.getJobDefByName(jFJobExceptionEvent.m_jobName);
        } else if (string.equals("jobarray_except")) {
            JFJobArrayExceptionEvent jFJobArrayExceptionEvent = (JFJobArrayExceptionEvent)jFEvent;
            jFJobArrayExceptionEvent.m_jobArrRef = this.getJobArrayDefByName(jFJobArrayExceptionEvent.m_jobArrName);
        } else if (string.equals("flow_except")) {
            JFFlowExceptionEvent jFFlowExceptionEvent = (JFFlowExceptionEvent)jFEvent;
            jFFlowExceptionEvent.m_flowRef = this.getFlowDefByName(jFFlowExceptionEvent.m_flowName);
        } else if (string.equals("flowarray")) {
            JFFlowArrayEvent jFFlowArrayEvent = (JFFlowArrayEvent)jFEvent;
            jFFlowArrayEvent.m_flowArrRef = this.getFlowArrayDefByName(jFFlowArrayEvent.m_flowArrName);
        } else if (string.equals("flowarray_except")) {
            JFFlowArrayExceptionEvent jFFlowArrayExceptionEvent = (JFFlowArrayExceptionEvent)jFEvent;
            jFFlowArrayExceptionEvent.m_flowArrRef = this.getFlowArrayDefByName(jFFlowArrayExceptionEvent.m_flowArrName);
        } else if (string.equals("FileAgent_v1.0")) {
            // empty if block
        }
    }

    private String getJFFlowNameFromJFJobName(String string) {
        return string.substring(0, string.lastIndexOf(":"));
    }

    private String getDefinitionNameFromInstanceName(String string) {
        return string.substring(string.indexOf(":") + 1);
    }

    private String getParentDefinitionName(String string) {
        return string.substring(0, string.lastIndexOf(":"));
    }

    private String getJFEventNameFromCDSECT(String string) {
        String string2 = null;
        try {
            String string3 = string.substring(string.indexOf("(") + 1, string.length());
            string2 = string.substring(0, string.indexOf("(") + 1) + string3.substring(string3.indexOf(":") + 1);
            Integer.parseInt(string3.substring(0, string3.indexOf(":")));
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

