/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFResource;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class JFLocalHistoryRecord {
    public static final int DAEMON = 0;
    public static final int CALENDAR = 1;
    public static final int FLOWDEF = 2;
    public static final int FLOW = 3;
    public static final int JOB = 4;
    public static final int ALARM = 5;
    static Map m_categoryMap = null;
    private int m_category;
    private Date m_timeStamp;
    private String m_userName;
    private String m_flowName;
    private String m_objectName;
    private String m_action;
    private String m_actionData;
    private Properties m_actionProperties = new Properties();

    JFLocalHistoryRecord(String string) throws JFException {
        int n;
        long l;
        if (string != null) {
            int n2;
            int n3 = 0;
            while ((n2 = string.indexOf(92, n3)) >= 0) {
                string = string.substring(0, n2) + "\\\\" + string.substring(n2 + 1);
                n3 = n2 + 2;
            }
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.quoteChar(34);
        String string2 = this.getNextToken(streamTokenizer);
        Object v = m_categoryMap.get(string2);
        if (v == null) {
            throw new JFException(JFResource.getString("Ill_formed_history_record_category"));
        }
        this.m_category = (Integer)v;
        this.m_userName = this.getNextToken(streamTokenizer);
        try {
            l = Long.parseLong(this.getNextToken(streamTokenizer));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("Ill_formed_history_record_timestamp"));
        }
        this.m_timeStamp = new Date(l * 1000L);
        this.m_objectName = this.getNextToken(streamTokenizer);
        if (this.m_category == 4 && (n = this.m_objectName.indexOf("%")) > 0) {
            this.m_objectName = this.m_objectName.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_objectName, ":");
        if (this.m_category == 2) {
            if (stringTokenizer.countTokens() != 2) {
                throw new JFException(JFResource.getString("Ill_formed_history_record_flowdef"));
            }
            String string3 = stringTokenizer.nextToken();
            this.m_flowName = stringTokenizer.nextToken();
        } else if (this.m_category == 3) {
            if (stringTokenizer.countTokens() != 3) {
                throw new JFException(JFResource.getString("Unparsed_history_record_flow"));
            }
            String string4 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
            this.m_flowName = stringTokenizer.nextToken();
        } else if (this.m_category == 4) {
            if (stringTokenizer.countTokens() < 4) {
                throw new JFException(JFResource.getString("Ill_formed_history_record_job"));
            }
            String string5 = stringTokenizer.nextToken();
            this.m_userName = stringTokenizer.nextToken();
            this.m_flowName = stringTokenizer.nextToken();
        } else if (this.m_category == 5) {
            if (stringTokenizer.countTokens() < 4) {
                throw new JFException(JFResource.getString("Ill_formed_history_record_alarm"));
            }
            String string6 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
            this.m_flowName = stringTokenizer.nextToken();
        }
        this.m_action = this.getNextToken(streamTokenizer);
        try {
            if (streamTokenizer.nextToken() == -1) {
                return;
            }
        }
        catch (IOException iOException) {
            return;
        }
        this.parseActionInfo(streamTokenizer.sval);
    }

    private String getNextToken(StreamTokenizer streamTokenizer) throws JFException {
        try {
            if (streamTokenizer.nextToken() == -1) {
                throw new JFException(JFResource.getString("Ill_formed_history_record_field_missing"));
            }
        }
        catch (IOException iOException) {
            throw new JFException(JFResource.getString("Ill_formed_history_record_field_missing"));
        }
        return streamTokenizer.sval;
    }

    private void parseActionInfo(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        string.replaceAll("quotequote", "\"");
        this.m_actionData = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n >= 0) {
                this.m_actionProperties.setProperty(string2.substring(0, n), string2.substring(n + 1));
                continue;
            }
            if (!this.m_actionData.equals("")) {
                this.m_actionData = this.m_actionData + "\n";
            }
            this.m_actionData = this.m_actionData + string2;
        }
    }

    public int getCategory() {
        return this.m_category;
    }

    public Date getTimeStamp() {
        return this.m_timeStamp;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getFlowName() {
        return this.m_flowName;
    }

    public String getObjectName() {
        return this.m_objectName;
    }

    public String getAction() {
        return this.m_action;
    }

    public String getActionData() {
        return this.m_actionData;
    }

    public Properties getActionProperties() {
        return this.m_actionProperties;
    }

    static {
        m_categoryMap = new Hashtable(6);
        m_categoryMap.put("DAEMON", new Integer(0));
        m_categoryMap.put("CALENDAR", new Integer(1));
        m_categoryMap.put("FLOWDEF", new Integer(2));
        m_categoryMap.put("FLOW", new Integer(3));
        m_categoryMap.put("JOB", new Integer(4));
        m_categoryMap.put("ALARM", new Integer(5));
    }
}

