/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDynamicFlow;
import com.platform.LSFJobFlow.api.JFDynamicFlowArray;
import com.platform.LSFJobFlow.api.JFDynamicFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFDynamicFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFDynamicFlowEvent;
import com.platform.LSFJobFlow.api.JFDynamicFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventFactory;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFileEvent;
import com.platform.LSFJobFlow.api.JFFlowArray;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTimeEvent;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import com.platform.LSFJobFlow.api.JFVariableEvent;
import com.platform.LSFJobFlow.api.JFXMLFileSource;
import com.platform.LSFJobFlow.api.JFXMLSource;
import com.platform.LSFJobFlow.api.JFXMLStringSource;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class JFFlow
implements Cloneable {
    private String m_flowDefName = null;
    private Properties m_defProps = null;
    List m_activities = null;
    JFJob m_termJob = null;
    List m_termActivities = null;
    private List m_triggerEvents = null;
    private int m_triggerCombinationOp = 0;
    private JFEventInstance[] m_triggeredEventInstances;
    private JFFlowVersion m_flowVersion = new JFFlowVersion();
    private int m_linkInstanceCnt = 0;
    List m_handlerList = new LinkedList();
    private Vector m_eventActivities = new Vector();
    private Map m_proxyLocations = new Hashtable();
    static final String DTD_VERSION = "3.0";
    public static final int COMB_AND = 0;
    public static final int COMB_OR = 1;
    public static final String EXIT_CONDITION_IGNORE_WAITING_ACTIVITIES = "ExitConditionIgnoreWaitingActivities";
    public static final String END_BEHAVIOUR_FLOW_STOP = "FlowStop";
    public static final String END_BEHAVIOUR_FLOW_STOP_KILL = "FlowStopKill";
    public static final String END_BEHAVIOUR_FLOW_CONTINUE = "FlowContinue";
    public static final String END_BEHAVIOUR_FLOW_CONTINUE_DELAY = "FlowContinueDelay";
    public static final String FLOW_ENV_VARS = "FlowEnvVars";
    public static final String FLOW_WORKING_DIR = "FlowWorkingDir";
    public static final String UPDATE_TYPE = "UpdateType";
    public static final String AUTOMATIC = "Automatic";
    public static final String MANUAL = "Manual";
    public static final String EXIT_CODE_RULE = "ExitCodeRule";
    public static final String FROM_LAST_ITEM = "FromLastItem";
    public static final String FROM_SUM_OF_ITEMS = "FromSumOfItems";
    public static final String MAIN_FLOW_OWNER = "Owner";
    public static final String CLIENT_VERSION = "ClientVersion";
    public static final String STD_OUT_CREATE = "FlowCreateStdout";
    public static final String STD_OUT_OVERRIDE = "FlowOverrideStdout";
    public static final String STD_OUT_DIR = "FlowStdoutDir";
    public static final String STD_OUT = "FlowStdout";
    public static final String STD_OUT_AUTO_JOB_ARRAY_INDEX = "FlowStdoutAutoIndex";
    public static final String STD_ERR_CREATE = "FlowCreateStderr";
    public static final String STD_ERR_OVERRIDE = "FlowOverrideStderr";
    public static final String STD_ERR_DIR = "FlowStderrDir";
    public static final String STD_ERR = "FlowStderr";
    public static final String STD_ERR_AUTO_JOB_ARRAY_INDEX = "FlowStderrAutoIndex";
    public static final String INPUT_FILES = "InputFiles";
    public static final String OUTPUT_FILES = "OutputFiles";
    private static final int MAX_JOB_NAME_LENGTH = 510;
    private static final int MAX_JOB_INSTANCE_ID_LENGTH = 20;
    public static final String PRE_SUMIT_USER_ERROR = "pre_submit_user_error";
    public static final String PRE_SUMIT_DEPENDENT_ERROR = "pre_submit_dependent_error";

    public JFFlow(String string) {
        if (null == string) {
            throw new NullPointerException(JFResource.getString("FLOWNAME_NULL"));
        }
        if (string.equals("")) {
            throw new IllegalArgumentException(JFResource.getString("INVALID_NAME"));
        }
        this.m_flowDefName = string;
        this.clear();
    }

    public void addJob(JFJob jFJob) {
        this.addJob(jFJob, null);
    }

    public void addJob(JFJob jFJob, JFEvent jFEvent) {
        if (jFJob == null) {
            throw new NullPointerException(JFResource.getString("JOB_NULL"));
        }
        if (jFEvent != null && jFEvent.getEventGeneratorType().equals("link")) {
            this.addLinkEvent((JFLinkEvent)jFEvent);
        }
        JFEvent[] jFEventArray = new JFEvent[]{jFEvent};
        this.m_activities.add(new Activity(jFJob.getName(), jFJob, jFEventArray, 0));
    }

    public void addJobArray(JFJobArray jFJobArray) {
        this.addJobArray(jFJobArray, null);
    }

    public void addJobArray(JFJobArray jFJobArray, JFEvent jFEvent) {
        if (jFJobArray == null) {
            throw new NullPointerException(JFResource.getString("JOB_NULL"));
        }
        if (jFEvent != null && jFEvent.getEventGeneratorType().equals("link")) {
            this.addLinkEvent((JFLinkEvent)jFEvent);
        }
        JFEvent[] jFEventArray = new JFEvent[]{jFEvent};
        this.m_activities.add(new Activity(jFJobArray.getName(), jFJobArray, jFEventArray, 0));
    }

    public void addFlow(JFFlow jFFlow) {
        this.addFlow(jFFlow, null);
    }

    public void addFlow(JFFlow jFFlow, JFEvent jFEvent) {
        if (jFFlow == null) {
            throw new NullPointerException(JFResource.getString("FLOW_NULL"));
        }
        if (jFEvent != null && jFEvent.getEventGeneratorType().equals("link")) {
            this.addLinkEvent((JFLinkEvent)jFEvent);
        }
        JFEvent[] jFEventArray = new JFEvent[]{jFEvent};
        this.m_activities.add(new Activity(jFFlow.getName(), jFFlow, jFEventArray, 0));
    }

    public void addDynamicFlow(JFDynamicFlow jFDynamicFlow) {
        this.addDynamicFlow(jFDynamicFlow, null);
    }

    public void addDynamicFlow(JFDynamicFlow jFDynamicFlow, JFEvent jFEvent) {
        if (jFDynamicFlow == null) {
            throw new NullPointerException(JFResource.getString("FLOW_NULL"));
        }
        if (jFEvent != null && jFEvent.getEventGeneratorType().equals("link")) {
            this.addLinkEvent((JFLinkEvent)jFEvent);
        }
        JFEvent[] jFEventArray = new JFEvent[]{jFEvent};
        this.m_activities.add(new Activity(jFDynamicFlow.getName(), jFDynamicFlow, jFEventArray, 0));
    }

    public void addFlowArray(JFFlowArray jFFlowArray) {
        this.addFlowArray(jFFlowArray, null);
    }

    public void addFlowArray(JFFlowArray jFFlowArray, JFEvent jFEvent) {
        if (jFEvent != null && jFEvent.getEventGeneratorType().equals("link")) {
            this.addLinkEvent((JFLinkEvent)jFEvent);
        }
        JFEvent[] jFEventArray = new JFEvent[]{jFEvent};
        this.m_activities.add(new Activity(jFFlowArray.getName(), jFFlowArray, jFEventArray, 0));
    }

    public void addDynamicFlowArray(JFDynamicFlowArray jFDynamicFlowArray) {
        this.addDynamicFlowArray(jFDynamicFlowArray, null);
    }

    public void addDynamicFlowArray(JFDynamicFlowArray jFDynamicFlowArray, JFEvent jFEvent) {
        if (jFEvent != null && jFEvent.getEventGeneratorType().equals("link")) {
            this.addLinkEvent((JFLinkEvent)jFEvent);
        }
        JFEvent[] jFEventArray = new JFEvent[]{jFEvent};
        this.m_activities.add(new Activity(jFDynamicFlowArray.getName(), jFDynamicFlowArray, jFEventArray, 0));
    }

    public boolean setUserName(String string) {
        boolean bl = false;
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    JFJob jFJob = activity.getJob();
                    if (!jFJob.setUserName(string)) continue block6;
                    bl = true;
                    continue block6;
                }
                case 3: {
                    JFJobArray jFJobArray = activity.getJobArray();
                    if (!jFJobArray.setUserName(string)) continue block6;
                    bl = true;
                    continue block6;
                }
                case 2: {
                    JFFlow jFFlow = activity.getFlow();
                    if (!jFFlow.setUserName(string)) continue block6;
                    bl = true;
                    continue block6;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().setUserName(string)) continue block6;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void remove(String string) {
        int n;
        boolean bl = false;
        if (string == null) {
            throw new NullPointerException(JFResource.getString("FLOW_NAME_NULL"));
        }
        if (this.m_termActivities != null) {
            for (n = 0; n < this.m_termActivities.size(); ++n) {
                if (!this.m_termActivities.get(n).equals(string)) continue;
                this.m_termActivities.remove(n);
            }
        }
        for (n = 0; n < this.m_activities.size(); ++n) {
            Activity activity = (Activity)this.m_activities.get(n);
            if (!activity.getName().equals(string)) continue;
            bl = true;
            int n2 = activity.getType();
            this.m_activities.remove(n);
            for (int i = 0; i < this.m_activities.size(); ++i) {
                Activity activity2 = (Activity)this.m_activities.get(i);
                if (activity2.getEvents() == null || !activity.getEvents().hasNext()) continue;
                Iterator iterator = activity.getEvents();
                while (iterator.hasNext()) {
                    JFEvent jFEvent = (JFEvent)iterator.next();
                    switch (n2) {
                        case 1: {
                            if (!jFEvent.getEventGeneratorType().equals("lsf") && !jFEvent.getEventGeneratorType().equals("local") && !jFEvent.getEventGeneratorType().equals("manual") && !jFEvent.getEventGeneratorType().equals("otherbatch") || !((JFJobEvent)jFEvent).getEventJob().getName().equals(string)) break;
                            iterator.remove();
                            break;
                        }
                        case 2: {
                            if (!jFEvent.getEventGeneratorType().equals("flow") || !((JFFlowEvent)jFEvent).getEventFlow().getName().equals(string)) break;
                            iterator.remove();
                        }
                    }
                }
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(JFResource.getString("JOB_NOT_FOUND"));
        }
    }

    public void setAttribute(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.m_defProps.setProperty(string, string2);
    }

    public String getAttribute(String string) {
        return this.m_defProps.getProperty(string);
    }

    public void removeAttribute(String string) {
        if (string == null) {
            return;
        }
        this.m_defProps.remove(string);
    }

    public void removeAllAttributes() {
        this.m_defProps = new Properties();
    }

    Properties getAttributes() {
        return this.m_defProps;
    }

    void setAttributes(Properties properties) {
        this.m_defProps = properties;
    }

    public void setFlowVersion(JFFlowVersion jFFlowVersion) {
        this.m_flowVersion = jFFlowVersion;
    }

    public JFFlowVersion getFlowVersion() {
        return this.m_flowVersion;
    }

    public void setTriggerEvents(JFEvent[] jFEventArray, int n) {
        if (jFEventArray == null || jFEventArray.length == 0) {
            this.m_triggerEvents = null;
            return;
        }
        this.m_triggerEvents = new LinkedList();
        for (int i = 0; i < jFEventArray.length; ++i) {
            if (jFEventArray[i] == null || jFEventArray[i].getEventGeneratorType().equals("link")) continue;
            this.m_triggerEvents.add(jFEventArray[i]);
        }
        this.m_triggerCombinationOp = n;
    }

    public JFEvent[] getTriggerEvents() {
        if (this.m_triggerEvents == null) {
            return new JFEvent[0];
        }
        JFEvent[] jFEventArray = new JFEvent[this.m_triggerEvents.size()];
        this.m_triggerEvents.toArray(jFEventArray);
        return jFEventArray;
    }

    public int getTriggerEventsCombinationOp() {
        return this.m_triggerCombinationOp;
    }

    public void removeTriggerEvents() {
        this.m_triggerEvents = null;
        this.m_triggerCombinationOp = 0;
    }

    void setTriggeredEvents(JFEventInstance[] jFEventInstanceArray) {
        this.m_triggeredEventInstances = jFEventInstanceArray;
    }

    public JFEventInstance[] getTriggeredEvents() {
        return this.m_triggeredEventInstances;
    }

    public void setExitConditionIgnoreWaitingActivities(boolean bl) {
        this.setAttribute(EXIT_CONDITION_IGNORE_WAITING_ACTIVITIES, bl ? "Yes" : "");
    }

    public void setExitCondition(String[] stringArray, JFEvent jFEvent) {
        if (stringArray == null || jFEvent == null) {
            throw new NullPointerException(JFResource.getString("NULL_PARAM"));
        }
        this.m_termJob = new JFJob("Terminal_" + this.createUniqueLinkName(), "link");
        StringBuffer stringBuffer = new StringBuffer(64);
        if (stringArray.length < 1) {
            throw new IllegalArgumentException();
        }
        this.m_termActivities = Arrays.asList(stringArray);
        this.addJob(this.m_termJob, jFEvent);
        this.setExitConditionIgnoreWaitingActivities(false);
    }

    public String[] getExitActivities() {
        if (this.m_termActivities == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.m_termActivities.size()];
        this.m_termActivities.toArray(stringArray);
        return stringArray;
    }

    public String[] getExitActivitiesWithType() {
        if (this.m_termActivities == null) {
            return new String[0];
        }
        Object[] objectArray = new String[this.m_termActivities.size()];
        this.m_termActivities.toArray(objectArray);
        for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            Arrays.sort(objectArray);
            int n = Arrays.binarySearch(objectArray, activity.getName());
            if (n < 0) continue;
            int n2 = activity.getType();
            if (n2 == 1 && activity.getJob().getExecutionType().equals("manual")) {
                objectArray[n] = "Manual Job[" + (String)objectArray[n] + "]";
                continue;
            }
            if (n2 == 1) {
                objectArray[n] = "Job[" + (String)objectArray[n] + "]";
                continue;
            }
            if (n2 == 3) {
                objectArray[n] = "Job Array[" + (String)objectArray[n] + "]";
                continue;
            }
            if (n2 == 2) {
                objectArray[n] = "Subflow[" + (String)objectArray[n] + "]";
                continue;
            }
            if (n2 == 5) {
                objectArray[n] = "Dynamic Subflow[" + (String)objectArray[n] + "]";
                continue;
            }
            if (n2 == 4) {
                objectArray[n] = "Flow Array[" + (String)objectArray[n] + "]";
                continue;
            }
            if (n2 != 6) continue;
            objectArray[n] = "Dynamic Flow Array[" + (String)objectArray[n] + "]";
        }
        return objectArray;
    }

    public String[] getAllActivitiesWithType() {
        if (this.m_activities == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            String string = activity.getIsFromForm();
            if (string.equals("Yes")) continue;
            int n = activity.getType();
            if (n == 1 && activity.getJob().getExecutionType().equals("manual")) {
                arrayList.add("Manual Job[" + activity.getName() + "]");
                continue;
            }
            if (n == 1 && activity.getJob().getExecutionType().equals("otherbatch")) continue;
            if (!(n != 1 || activity.getJob().getExecutionType().equals("link") || activity.getJob().getExecutionType().equals("alarm") || activity.getJob().getExecutionType().equals("variable"))) {
                arrayList.add("Job[" + activity.getName() + "]");
                continue;
            }
            if (n == 3) {
                arrayList.add("Job Array[" + activity.getName() + "]");
                continue;
            }
            if (n == 2) {
                arrayList.add("Subflow[" + activity.getName() + "]");
                continue;
            }
            if (n == 5) {
                arrayList.add("Dynamic Subflow[" + activity.getName() + "]");
                continue;
            }
            if (n == 4) {
                arrayList.add("Flow Array[" + activity.getName() + "]");
                continue;
            }
            if (n != 6) continue;
            arrayList.add("Dynamic Flow Array[" + activity.getName() + "]");
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getAvailActivitiesWithType() {
        String[] stringArray = this.getAllActivitiesWithType();
        Object[] objectArray = this.getExitActivitiesWithType();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Arrays.sort(objectArray);
            if (Arrays.binarySearch(objectArray, stringArray[i]) >= 0) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public boolean getExitConditionIgnoreWaitingActivities() {
        return "Yes".equalsIgnoreCase(this.getAttribute(EXIT_CONDITION_IGNORE_WAITING_ACTIVITIES));
    }

    public JFEvent getExitCondition() {
        if (this.m_termJob == null) {
            return null;
        }
        if (this.getJob(this.m_termJob.getName()) != null) {
            return this.getEvent(this.m_termJob.getName());
        }
        return null;
    }

    public void removeExitCondition() {
        if (this.m_termJob == null) {
            return;
        }
        if (this.getJob(this.m_termJob.getName()) != null) {
            this.remove(this.m_termJob.getName());
            this.m_termJob = null;
            this.m_termActivities = null;
        }
    }

    public String getName() {
        return this.m_flowDefName;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("FLOWNAME_NULL"));
        }
        this.m_flowDefName = string;
    }

    public void addPrefix(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("JOBNAME_NULL"));
        }
        JFHandler[] jFHandlerArray = this.getHandlers();
        for (int i = 0; i < jFHandlerArray.length; ++i) {
            JFHandler jFHandler = jFHandlerArray[i];
            if (jFHandler.getAction() != 2) continue;
            jFHandler.getAlarmJob().setName(string + jFHandler.getAlarmJob().getName());
        }
    }

    public JFJob getJob(String string) {
        string = JFXMLSource.getName(string);
        for (Activity activity : this.m_activities) {
            if (activity.getType() != 1 || !activity.getJob().getName().equals(string)) continue;
            return activity.getJob();
        }
        return null;
    }

    public JFJob[] getJobs() {
        JFJob[] jFJobArray2;
        LinkedList<JFJob> linkedList = new LinkedList<JFJob>();
        for (JFJob[] jFJobArray2 : this.m_activities) {
            if (jFJobArray2.getType() != 1 || jFJobArray2.getJob().getExecutionType().equals("link")) continue;
            linkedList.add(jFJobArray2.getJob());
        }
        jFJobArray2 = new JFJob[linkedList.size()];
        linkedList.toArray(jFJobArray2);
        return jFJobArray2;
    }

    public JFFlow getFlow(String string) {
        Iterator iterator = this.m_activities.iterator();
        string = JFXMLSource.getName(string);
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity.getType() != 2 || !activity.getFlow().getName().equals(string)) continue;
            return activity.getFlow();
        }
        return null;
    }

    public JFFlow[] getFlows() {
        JFFlow[] jFFlowArray2;
        LinkedList<JFFlow> linkedList = new LinkedList<JFFlow>();
        for (JFFlow[] jFFlowArray2 : this.m_activities) {
            if (jFFlowArray2.getType() != 2) continue;
            linkedList.add(jFFlowArray2.getFlow());
        }
        jFFlowArray2 = new JFFlow[linkedList.size()];
        linkedList.toArray(jFFlowArray2);
        return jFFlowArray2;
    }

    public JFDynamicFlow getDynamicFlow(String string) {
        Iterator iterator = this.m_activities.iterator();
        string = JFXMLSource.getName(string);
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity.getType() != 5 || !activity.getDynamicFlow().getName().equals(string)) continue;
            return activity.getDynamicFlow();
        }
        return null;
    }

    public JFDynamicFlow[] getDynamicFlows() {
        JFDynamicFlow[] jFDynamicFlowArray2;
        LinkedList<JFDynamicFlow> linkedList = new LinkedList<JFDynamicFlow>();
        for (JFDynamicFlow[] jFDynamicFlowArray2 : this.m_activities) {
            if (jFDynamicFlowArray2.getType() != 5) continue;
            linkedList.add(jFDynamicFlowArray2.getDynamicFlow());
        }
        jFDynamicFlowArray2 = new JFDynamicFlow[linkedList.size()];
        linkedList.toArray(jFDynamicFlowArray2);
        return jFDynamicFlowArray2;
    }

    public JFFlowArray getFlowArray(String string) {
        Iterator iterator = this.m_activities.iterator();
        string = JFXMLSource.getName(string);
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity.getType() != 4 || !activity.getFlowArray().getName().equals(string)) continue;
            return activity.getFlowArray();
        }
        return null;
    }

    public JFFlowArray[] getFlowArrays() {
        JFFlowArray[] jFFlowArrayArray2;
        LinkedList<JFFlowArray> linkedList = new LinkedList<JFFlowArray>();
        for (JFFlowArray[] jFFlowArrayArray2 : this.m_activities) {
            if (jFFlowArrayArray2.getType() != 4) continue;
            linkedList.add(jFFlowArrayArray2.getFlowArray());
        }
        jFFlowArrayArray2 = new JFFlowArray[linkedList.size()];
        linkedList.toArray(jFFlowArrayArray2);
        return jFFlowArrayArray2;
    }

    public JFDynamicFlowArray getDynamicFlowArray(String string) {
        Iterator iterator = this.m_activities.iterator();
        string = JFXMLSource.getName(string);
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity.getType() != 6 || !activity.getDynamicFlowArray().getName().equals(string)) continue;
            return activity.getDynamicFlowArray();
        }
        return null;
    }

    public JFDynamicFlowArray[] getDynamicFlowArrays() {
        JFDynamicFlowArray[] jFDynamicFlowArrayArray2;
        LinkedList<JFDynamicFlowArray> linkedList = new LinkedList<JFDynamicFlowArray>();
        for (JFDynamicFlowArray[] jFDynamicFlowArrayArray2 : this.m_activities) {
            if (jFDynamicFlowArrayArray2.getType() != 6) continue;
            linkedList.add(jFDynamicFlowArrayArray2.getDynamicFlowArray());
        }
        jFDynamicFlowArrayArray2 = new JFDynamicFlowArray[linkedList.size()];
        linkedList.toArray(jFDynamicFlowArrayArray2);
        return jFDynamicFlowArrayArray2;
    }

    public JFJobArray getJobArray(String string) {
        Iterator iterator = this.m_activities.iterator();
        string = JFXMLSource.getName(string);
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            if (activity.getType() != 3 || !activity.getJobArray().getName().equals(string)) continue;
            return activity.getJobArray();
        }
        return null;
    }

    public JFJobArray[] getJobArrays() {
        JFJobArray[] jFJobArrayArray2;
        LinkedList<JFJobArray> linkedList = new LinkedList<JFJobArray>();
        for (JFJobArray[] jFJobArrayArray2 : this.m_activities) {
            if (jFJobArrayArray2.getType() != 3) continue;
            linkedList.add(jFJobArrayArray2.getJobArray());
        }
        jFJobArrayArray2 = new JFJobArray[linkedList.size()];
        linkedList.toArray(jFJobArrayArray2);
        return jFJobArrayArray2;
    }

    public JFEvent getEvent(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("FLOW_NAME_NULL"));
        }
        for (Activity activity : this.m_activities) {
            if (!activity.getName().equals(string)) continue;
            return activity.getEvent();
        }
        return null;
    }

    Iterator getEvents(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("FLOW_NAME_NULL"));
        }
        string = JFXMLSource.getName(string);
        for (Activity activity : this.m_activities) {
            if (!activity.getName().equals(string)) continue;
            return activity.getEvents();
        }
        return null;
    }

    String getScheduleRequestXML() throws JFException {
        String string;
        StringBuffer stringBuffer = new StringBuffer(4098);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<!--XML Jobflow definition -->\n");
        stringBuffer.append("<!--This file has been generated with Process Manager");
        stringBuffer.append(". \n    Modify at your own risk.  Changes may render the definition unusable.   \n    The definition format may change in future versions of Process Manager");
        stringBuffer.append(".    -->\n");
        stringBuffer.append("<!DOCTYPE JobFlowReq SYSTEM \"JobFlowDef30.dtd\">");
        if (!"Yes".equals(this.m_defProps.getProperty("Exclusive"))) {
            this.m_defProps.setProperty("Exclusive", "No");
        }
        this.setAttribute(CLIENT_VERSION, JFConfigManager.getClientVersion().getVersion());
        stringBuffer.append("<JobFlowReq  DTDVersion=\"3.0\"");
        stringBuffer.append("  MainEntry=\"" + this.getName() + "\"");
        Enumeration<?> enumeration = this.m_defProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = this.m_defProps.getProperty(string);
            stringBuffer.append("  " + string + "=\"" + JFXMLSource.convertToXMLAttrString(string2) + "\"");
        }
        stringBuffer.append("  Operation=\"Schedule\" >");
        string = this.getOwner();
        if (string != null && !string.equals("")) {
            stringBuffer.append(this.toXML("", string));
        } else {
            stringBuffer.append(this.toXML("", null));
        }
        stringBuffer.append("\n</JobFlowReq>");
        return stringBuffer.toString();
    }

    String toXML(String string) throws JFException {
        return this.toXML(string, null);
    }

    String toXML(String string, String string2) throws JFException {
        Object object;
        Object object2;
        String string3 = string + (string.equals("") ? "" : ":") + this.getName();
        StringBuffer stringBuffer = new StringBuffer(1024);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (Cloneable cloneable : this.m_activities) {
            if (cloneable == null) continue;
            if (hashtable.get(((Activity)cloneable).getName()) == null) {
                hashtable.put(((Activity)cloneable).getName(), "Used");
                object2 = ((Activity)cloneable).getJob();
                if (object2 != null) {
                    if (!this.isEmbeddedObjectNameListValid(((Activity)cloneable).getJob(), hashtable)) {
                        throw new JFException(JFResource.getString("FLOW_DUPLICATE_NAME"));
                    }
                    if (((JFJob)object2).getExecutionType().equals("link") && string2 != null && !string2.equals("")) {
                        ((JFJob)object2).setUserName(string2);
                    }
                }
                if (object2 != null && object2 == this.m_termJob) {
                    object = new StringBuffer(64);
                    if (this.m_termActivities.get(0) != null) {
                        ((StringBuffer)object).append(string3 + ":" + this.m_termActivities.get(0));
                    }
                    for (int i = 1; i < this.m_termActivities.size(); ++i) {
                        if (this.m_termActivities.get(i) == null) continue;
                        ((StringBuffer)object).append("," + string3 + ":" + this.m_termActivities.get(i));
                    }
                    this.m_termJob.setAttribute("ExitCodeValue", ((StringBuffer)object).toString());
                    if (string2 != null && !string2.equals("")) {
                        this.m_termJob.setUserName(string2);
                    }
                }
                stringBuffer.append(((Activity)cloneable).getDefinitionXML(string3, string2));
                continue;
            }
            throw new JFException(JFResource.getString("FLOW_DUPLICATE_NAME"));
        }
        stringBuffer.append("\n<JobFlowDef  Name=\"" + string3 + "\">");
        if (this.m_triggerEvents != null && this.m_triggerEvents.size() > 0) {
            stringBuffer.append("<Events CombinationType=\"");
            if (this.m_triggerCombinationOp == 0) {
                stringBuffer.append("And");
            } else {
                stringBuffer.append("Or");
            }
            stringBuffer.append("\">");
            for (Cloneable cloneable : this.m_triggerEvents) {
                stringBuffer.append("<Event GeneratorType=\"" + ((JFEvent)cloneable).getEventGeneratorType() + "\"" + this.attributesToXML(((JFEvent)cloneable).getAttributes()) + " >");
                stringBuffer.append(JFXMLSource.convertToXMLAttrString(((JFEvent)cloneable).generateDefinition()) + "</Event>");
            }
            stringBuffer.append("</Events>");
        }
        if (this.m_handlerList != null && this.m_handlerList.size() > 0 && string.equals("")) {
            stringBuffer.append("<Exceptions>");
            Iterator iterator = this.m_handlerList.iterator();
            object2 = new String();
            while (iterator.hasNext()) {
                Cloneable cloneable;
                object = (JFHandler)iterator.next();
                JFEvent jFEvent = ((JFHandler)object).getEvent();
                if (jFEvent == null) continue;
                cloneable = ((JFHandler)object).getAlarmJob();
                if (((JFHandler)object).getAction() == 2) {
                    object2 = "alarm";
                    if (cloneable == null) {
                        throw new JFException("NULL Alarm Definition With Exception Handler.");
                    }
                    if (hashtable.get(((JFJob)cloneable).getName()) != null) {
                        throw new JFException(JFResource.getString("FLOW_DUPLICATE_NAME"));
                    }
                    hashtable.put(((JFJob)cloneable).getName(), "Used");
                } else {
                    object2 = ((JFHandler)object).getAction() == 1 ? "rerun" : "kill";
                }
                if (this.isWorkItemEvent(jFEvent)) {
                    if (jFEvent instanceof JFJobEvent) {
                        ((JFJobEvent)jFEvent).setParentName(this.m_flowDefName);
                    } else if (jFEvent instanceof JFFlowEvent) {
                        ((JFFlowEvent)jFEvent).setParentName(this.m_flowDefName);
                    } else if (jFEvent instanceof JFJobArrayEvent) {
                        ((JFJobArrayEvent)jFEvent).setParentName(this.m_flowDefName);
                    }
                }
                stringBuffer.append("<Exception Type=\"" + (String)object2 + "\" Delay=\"" + ((JFHandler)object).getDelay() + "\" NumberRerun=\"" + ((JFHandler)object).getNumberRerun() + "\">");
                stringBuffer.append("<Event GeneratorType=\"" + jFEvent.getEventGeneratorType() + "\">");
                stringBuffer.append(JFXMLSource.convertToXMLAttrString(jFEvent.generateDefinition()) + "</Event>");
                if (((JFHandler)object).getAction() == 2) {
                    stringBuffer.append(((JFJob)cloneable).toXML(string3));
                }
                stringBuffer.append("</Exception>");
            }
            stringBuffer.append("</Exceptions>");
        }
        for (Cloneable cloneable : this.m_activities) {
            if (cloneable == null) continue;
            stringBuffer.append(((Activity)cloneable).toXML(string3));
        }
        stringBuffer.append("\n</JobFlowDef>");
        return stringBuffer.toString();
    }

    private boolean isWorkItemEvent(JFEvent jFEvent) {
        if (jFEvent instanceof JFJobEvent || jFEvent instanceof JFJobArrayEvent) {
            return true;
        }
        if (jFEvent instanceof JFFlowEvent) {
            return this != ((JFFlowEvent)jFEvent).getEventFlow();
        }
        return false;
    }

    private boolean isEmbeddedObjectNameListValid(JFJob jFJob, Map map) {
        if (jFJob == null || map == null) {
            return false;
        }
        JFHandler[] jFHandlerArray = jFJob.getHandlers();
        for (int i = 0; i < jFHandlerArray.length; ++i) {
            if (jFHandlerArray[i].getAction() != 2) continue;
            JFJob jFJob2 = jFHandlerArray[i].getAlarmJob();
            if (jFJob2 == null) {
                return false;
            }
            if (map.get(jFJob2.getName()) != null) {
                return false;
            }
            map.put(jFJob2.getName(), "Used");
        }
        return true;
    }

    public Object clone() {
        JFFlow jFFlow = null;
        try {
            JFXMLStringSource jFXMLStringSource = new JFXMLStringSource(this.getScheduleRequestXML());
            jFFlow = jFXMLStringSource.createFlow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jFFlow;
    }

    public void clear() {
        this.m_activities = new LinkedList();
        this.m_eventActivities = new Vector();
        this.m_defProps = new Properties();
        this.m_triggerEvents = null;
        this.m_triggerCombinationOp = 0;
        this.m_termJob = null;
        this.m_linkInstanceCnt = 0;
        this.m_handlerList.clear();
    }

    private void addLinkEvent(JFLinkEvent jFLinkEvent) {
        boolean bl = false;
        for (int i = 0; i < this.m_eventActivities.size(); ++i) {
            if (this.m_eventActivities.get(i) != jFLinkEvent) continue;
            bl = true;
            break;
        }
        if (!bl) {
            LinkedList<JFEvent> linkedList = new LinkedList<JFEvent>();
            linkedList.addLast(jFLinkEvent);
            while (linkedList.size() > 0) {
                JFJob jFJob;
                Cloneable cloneable;
                JFLinkEvent jFLinkEvent2 = (JFLinkEvent)linkedList.removeFirst();
                JFEvent[] jFEventArray = jFLinkEvent2.getEvents();
                for (int i = 0; jFEventArray != null && i < jFEventArray.length; ++i) {
                    cloneable = jFEventArray[i];
                    if (!cloneable.getEventGeneratorType().equals("link")) continue;
                    linkedList.addLast((JFEvent)cloneable);
                }
                jFLinkEvent2.m_linkJobRef = jFJob = new JFJob(this.createUniqueLinkName(), "link");
                cloneable = new Activity(jFJob.getName(), jFJob, jFLinkEvent2.m_events.toArray(new JFEvent[0]), jFLinkEvent2.m_combinationOp);
                this.m_activities.add(cloneable);
                this.m_eventActivities.add(jFLinkEvent);
            }
        }
    }

    private String createUniqueLinkName() {
        return "Link_Inst_" + Integer.toString(this.m_linkInstanceCnt++);
    }

    public void addHandler(JFHandler jFHandler) {
        this.m_handlerList.add(jFHandler);
    }

    public void removeHandlers() {
        this.m_handlerList.clear();
    }

    public void removeHandler(JFHandler jFHandler) {
        this.m_handlerList.remove(jFHandler);
    }

    public JFHandler[] getHandlers() {
        JFHandler[] jFHandlerArray = new JFHandler[this.m_handlerList.size()];
        this.m_handlerList.toArray(jFHandlerArray);
        return jFHandlerArray;
    }

    String attributesToXML(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("  " + string + "=\"" + JFXMLSource.convertToXMLAttrString(properties.getProperty(string)) + "\"");
        }
        return stringBuffer.toString();
    }

    public void save(String string) throws IOException, JFException {
        String string2 = JFLoginManager.getUserName();
        this.validate();
        this.validateJobNameLength(490 - string2.length() - 2, string2 + ":");
        String string3 = this.getScheduleRequestXML();
        string3 = JFUTFConverter.toUnicodeEscape(string3);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        bufferedOutputStream.write(string3.getBytes("UTF-8"));
        bufferedOutputStream.close();
    }

    public String toXML() throws JFException {
        String string = JFLoginManager.getUserName();
        this.validate();
        this.validateJobNameLength(490 - string.length() - 2, string + ":");
        return JFUTFConverter.toUnicodeEscape(this.getScheduleRequestXML());
    }

    public static JFFlow load(String string) throws JFException, IOException {
        JFXMLFileSource jFXMLFileSource = new JFXMLFileSource(string);
        return jFXMLFileSource.createFlow();
    }

    public void setProxyLocations(Map map) {
        this.m_proxyLocations = map;
    }

    public Map getProxyLocations() {
        return this.m_proxyLocations;
    }

    void setTimeZoneInfo(String string, String string2) {
        for (Activity activity : this.m_activities) {
            JFFlow jFFlow;
            if (activity == null) continue;
            Iterator iterator = activity.getEvents();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    this.updateEventTimeZoneInfo((JFEvent)iterator.next(), string, string2);
                }
            }
            if (activity.getType() != 2 || (jFFlow = activity.getFlow()) == null) continue;
            jFFlow.setTimeZoneInfo(string, string2);
        }
        if (this.m_triggerEvents != null) {
            Iterator iterator = this.m_triggerEvents.iterator();
            while (iterator.hasNext()) {
                this.updateEventTimeZoneInfo((JFEvent)iterator.next(), string, string2);
            }
        }
    }

    private void updateEventTimeZoneInfo(JFEvent jFEvent, String string, String string2) {
        JFEvent[] jFEventArray;
        if (jFEvent instanceof JFTimeEvent) {
            if (string2 == null) {
                jFEvent.unsetAttribute("ClientTZoffset");
                jFEvent.unsetAttribute("TimeZone");
            } else {
                jFEvent.setAttribute("ClientTZoffset", string2);
                jFEvent.setAttribute("TimeZone", string);
            }
        } else if (jFEvent instanceof JFLinkEvent && (jFEventArray = ((JFLinkEvent)jFEvent).getEvents()) != null) {
            for (int i = 0; i < jFEventArray.length; ++i) {
                if (!(jFEventArray[i] instanceof JFTimeEvent)) continue;
                if (string2 == null) {
                    jFEventArray[i].unsetAttribute("ClientTZoffset");
                    jFEventArray[i].unsetAttribute("TimeZone");
                    continue;
                }
                jFEventArray[i].setAttribute("ClientTZoffset", string2);
                jFEventArray[i].setAttribute("TimeZone", string);
            }
        }
    }

    boolean hasAlarmHandler() {
        Cloneable cloneable;
        int n;
        JFHandler[] jFHandlerArray = this.getHandlers();
        for (n = 0; n < jFHandlerArray.length; ++n) {
            cloneable = jFHandlerArray[n];
            if (((JFHandler)cloneable).getAction() != 2) continue;
            return true;
        }
        for (n = 0; n < this.m_activities.size(); ++n) {
            cloneable = (Activity)this.m_activities.get(n);
            int n2 = ((Activity)cloneable).getType();
            JFJob jFJob = null;
            switch (n2) {
                case 1: {
                    jFJob = ((Activity)cloneable).getJob();
                    break;
                }
                case 3: {
                    jFJob = ((Activity)cloneable).getJobArray().getJobDefinition();
                    break;
                }
                case 2: {
                    if (!((Activity)cloneable).getFlow().hasAlarmHandler()) break;
                    return true;
                }
                case 4: {
                    if (!((Activity)cloneable).getFlowArray().getFlowDefinition().hasAlarmHandler()) break;
                    return true;
                }
            }
            if (jFJob == null || !jFJob.getExecutionType().equals("lsf")) continue;
            JFHandler[] jFHandlerArray2 = jFJob.getHandlers();
            for (int i = 0; i < jFHandlerArray2.length; ++i) {
                JFHandler jFHandler = jFHandlerArray2[i];
                if (jFHandler.getAction() != 2) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasProxyEventTimeDuration() {
        int n;
        Object object;
        Cloneable cloneable;
        int n2;
        if (this.m_triggerEvents != null) {
            for (n2 = 0; n2 < this.m_triggerEvents.size(); ++n2) {
                cloneable = (JFEvent)this.m_triggerEvents.get(n2);
                if (cloneable == null || (object = ((JFEvent)cloneable).getAttribute("TimeDuration")) == null || ((String)object).equals("") || (n = Integer.parseInt((String)object, 10)) <= 0) continue;
                return true;
            }
        }
        block7: for (n2 = 0; n2 < this.m_activities.size(); ++n2) {
            cloneable = (Activity)this.m_activities.get(n2);
            object = ((Activity)cloneable).getEvents();
            if (object == null) {
                return false;
            }
            while (object.hasNext()) {
                int n3;
                String string;
                JFEvent jFEvent = (JFEvent)object.next();
                if (jFEvent == null || (string = jFEvent.getAttribute("TimeDuration")) == null || string.equals("") || (n3 = Integer.parseInt(string, 10)) <= 0) continue;
                return true;
            }
            n = ((Activity)cloneable).getType();
            switch (n) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 2: {
                    if (!((Activity)cloneable).getFlow().hasProxyEventTimeDuration()) continue block7;
                    return true;
                }
                case 4: {
                    if (!((Activity)cloneable).getFlowArray().getFlowDefinition().hasProxyEventTimeDuration()) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasExclusiveSet() {
        if ("Yes".equals(this.getAttribute("Exclusive"))) {
            return true;
        }
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
                case 2: {
                    if (!activity.getFlow().hasExclusiveSet()) continue block6;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasExclusiveSet()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasSequentialFlowArray() {
        block5: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 2: {
                    if (!activity.getFlow().hasSequentialFlowArray()) continue block5;
                    return true;
                }
                case 4: {
                    if ("Yes".equals(activity.getFlowArray().getFlowDefinition().getAttribute("Exclusive"))) {
                        return true;
                    }
                    if (!activity.getFlowArray().getFlowDefinition().hasSequentialFlowArray()) continue block5;
                    return true;
                }
                case 6: {
                    if (!"Yes".equals(activity.getDynamicFlowArray().getFlowDefinition().getAttribute("Exclusive"))) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasZOSJob() {
        block5: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    if (!activity.getJob().getExecutionType().equals("zos")) continue block5;
                    return true;
                }
                case 3: {
                    continue block5;
                }
                case 2: {
                    if (!activity.getFlow().hasZOSJob()) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasScriptJob() {
        block5: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    if (!activity.getJob().getExecutionType().equals("script")) continue block5;
                    return true;
                }
                case 3: {
                    if (!activity.getJobArray().getJobDefinition().getExecutionType().equals("script")) continue block5;
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasScriptJob()) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasVariableEvaluator() {
        block5: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            if (null == activity) continue;
            int n = activity.getType();
            JFFlowArray jFFlowArray = null;
            JFFlow jFFlow = null;
            Object var6_6 = null;
            switch (n) {
                case 1: {
                    if (!activity.getJob().getExecutionType().equals("variable")) continue block5;
                    return true;
                }
                case 2: {
                    jFFlow = activity.getFlow();
                    if (null == jFFlow || !jFFlow.hasVariableEvaluator()) continue block5;
                    return true;
                }
                case 4: {
                    jFFlowArray = activity.getFlowArray();
                    if (null == jFFlowArray || null == (jFFlow = jFFlowArray.getFlowDefinition()) || !jFFlow.hasVariableEvaluator()) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasLocalJob() {
        block5: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            if (null == activity) continue;
            int n = activity.getType();
            JFFlowArray jFFlowArray = null;
            JFFlow jFFlow = null;
            JFJob jFJob = null;
            switch (n) {
                case 1: {
                    jFJob = activity.getJob();
                    if (null == jFJob || !"local".equals(jFJob.getExecutionType())) continue block5;
                    return true;
                }
                case 2: {
                    jFFlow = activity.getFlow();
                    if (null == jFFlow || !jFFlow.hasLocalJob()) continue block5;
                    return true;
                }
                case 4: {
                    jFFlowArray = activity.getFlowArray();
                    if (null == jFFlowArray || null == (jFFlow = jFFlowArray.getFlowDefinition()) || !jFFlow.hasLocalJob()) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasFlowArray() {
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 4: {
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasFlowArray()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasDynamicFlow() {
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 5: {
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasDynamicFlow()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasDynamicFlowArray() {
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 6: {
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasDynamicFlowArray()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasJobEnvVars() {
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    String string = activity.getJob().getAttribute("JobEnvVars");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 3: {
                    String string = activity.getJobArray().getJobDefinition().getAttribute("JobEnvVars");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasJobEnvVars()) continue block6;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasJobEnvVars()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasFlowEnvVars() {
        String string = this.m_defProps.getProperty(FLOW_ENV_VARS);
        if (string != null && !string.equals("")) {
            return true;
        }
        JFFlow[] jFFlowArray = this.getFlows();
        for (int i = 0; i < jFFlowArray.length; ++i) {
            if (!jFFlowArray[i].hasFlowEnvVars()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWorkingDir() {
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    String string = activity.getJob().getAttribute("WorkingDirectory");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 3: {
                    String string = activity.getJobArray().getJobDefinition().getAttribute("WorkingDirectory");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasWorkingDir()) continue block6;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasWorkingDir()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasFlowWorkingDir() {
        String string = null;
        string = this.getAttribute(FLOW_WORKING_DIR);
        if (string != null && !string.equals("")) {
            return true;
        }
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 2: {
                    if (!activity.getFlow().hasFlowWorkingDir()) continue block4;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasFlowWorkingDir()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasMultipleTimeZones() {
        Object object;
        Cloneable cloneable;
        int n;
        if (this.m_triggerEvents != null) {
            for (n = 0; n < this.m_triggerEvents.size(); ++n) {
                cloneable = (JFEvent)this.m_triggerEvents.get(n);
                if (cloneable == null || !(cloneable instanceof JFTimeEvent) || (object = ((JFTimeEvent)cloneable).getTimeZoneID()) == null || ((String)object).equals("")) continue;
                return true;
            }
        }
        block7: for (n = 0; n < this.m_activities.size(); ++n) {
            cloneable = (Activity)this.m_activities.get(n);
            object = ((Activity)cloneable).getEvents();
            if (object == null) {
                return false;
            }
            while (object.hasNext()) {
                String string;
                JFEvent jFEvent = (JFEvent)object.next();
                if (jFEvent == null || !(jFEvent instanceof JFTimeEvent) || (string = ((JFTimeEvent)jFEvent).getTimeZoneID()) == null || string.equals("")) continue;
                return true;
            }
            int n2 = ((Activity)cloneable).getType();
            switch (n2) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 2: {
                    if (!((Activity)cloneable).getFlow().hasMultipleTimeZones()) continue block7;
                    return true;
                }
                case 4: {
                    if (!((Activity)cloneable).getFlowArray().getFlowDefinition().hasMultipleTimeZones()) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasTimeEventNumOccurrences() {
        Object object;
        Cloneable cloneable;
        int n;
        if (this.m_triggerEvents != null) {
            for (n = 0; n < this.m_triggerEvents.size(); ++n) {
                cloneable = (JFEvent)this.m_triggerEvents.get(n);
                if (cloneable == null || !(cloneable instanceof JFTimeEvent) || (object = ((JFTimeEvent)cloneable).getOccurrences()) == null || ((String)object).equals("")) continue;
                return true;
            }
        }
        block7: for (n = 0; n < this.m_activities.size(); ++n) {
            cloneable = (Activity)this.m_activities.get(n);
            object = ((Activity)cloneable).getEvents();
            if (object == null) {
                return false;
            }
            while (object.hasNext()) {
                String string;
                JFEvent jFEvent = (JFEvent)object.next();
                if (jFEvent == null || !(jFEvent instanceof JFTimeEvent) || (string = ((JFTimeEvent)jFEvent).getOccurrences()) == null || string.equals("")) continue;
                return true;
            }
            int n2 = ((Activity)cloneable).getType();
            switch (n2) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 2: {
                    if (!((Activity)cloneable).getFlow().hasTimeEventNumOccurrences()) continue block7;
                    return true;
                }
                case 4: {
                    if (!((Activity)cloneable).getFlowArray().getFlowDefinition().hasTimeEventNumOccurrences()) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    public List dependentCheck(String string, List list) {
        JFEvent jFEvent;
        Object object;
        Object object2;
        Activity activity;
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        String string3 = null;
        block0: for (n = 0; n < this.m_activities.size(); ++n) {
            activity = (Activity)this.m_activities.get(n);
            if (activity.getType() != 1 && activity.getType() != 3 || !activity.getName().equals(string)) continue;
            object2 = activity.getJob();
            if (object2 == null) {
                object2 = activity.getJobArray().getJobDefinition();
            }
            string3 = ((JFJob)object2).getAttribute("UserName");
            object = activity.getEvents();
            if (object == null) {
                return linkedList;
            }
            while (object.hasNext()) {
                JFEvent jFEvent2;
                jFEvent = (JFEvent)object.next();
                if (jFEvent == null) {
                    return linkedList;
                }
                if (jFEvent.getEventGeneratorType().equals("lsf") || jFEvent.getEventGeneratorType().equals("otherbatch") || jFEvent.getEventGeneratorType().equals("local")) {
                    jFEvent2 = (JFJobEvent)jFEvent;
                    for (int i = 0; i < list.size(); ++i) {
                        String string4 = (String)list.get(i);
                        if (!((JFJobEvent)jFEvent2).getJobName().equals(string4)) continue;
                        String string5 = ((JFJobEvent)jFEvent2).getEventJob().getAttribute("UserName");
                        if (!(string3 == null || string3.equals(string5) || JFCommon.containsValidVarRef(string3) || JFCommon.containsValidVarRef(string5))) {
                            linkedList.add("pre_submit_user_error:" + ((JFJobEvent)jFEvent2).getJobName());
                        }
                        if (((JFJobEvent)jFEvent2).getEventType() == 2 || ((JFJobEvent)jFEvent2).getEventType() == 4) continue;
                        linkedList.add("pre_submit_dependent_error:" + this.getName() + ":" + ((JFJobEvent)jFEvent2).getJobName());
                    }
                    return linkedList;
                }
                if (jFEvent.getEventGeneratorType().equals("jobarray")) {
                    jFEvent2 = (JFJobArrayEvent)jFEvent;
                    for (int i = 0; i < list.size(); ++i) {
                        String string6 = (String)list.get(i);
                        if (!((JFJobArrayEvent)jFEvent2).getJobArrayName().equals(string6)) continue;
                        String string7 = ((JFJobArrayEvent)jFEvent2).getEventJobArray().getJobDefinition().getAttribute("UserName");
                        if (!(string3 == null || string3.equals(string7) || JFCommon.containsValidVarRef(string3) || JFCommon.containsValidVarRef(string7))) {
                            linkedList.add("pre_submit_user_error:" + ((JFJobArrayEvent)jFEvent2).getJobArrayName());
                        }
                        if (((JFJobArrayEvent)jFEvent2).getEventType() == 3) continue;
                        linkedList.add("pre_submit_dependent_error:" + this.getName() + ":" + ((JFJobArrayEvent)jFEvent2).getJobArrayName());
                    }
                    return linkedList;
                }
                if (!jFEvent.getEventGeneratorType().equals("link")) continue;
                jFEvent2 = (JFLinkEvent)jFEvent;
                if (((JFLinkEvent)jFEvent2).getEventCombinationOp() != 0) continue block0;
                string2 = ((JFLinkEvent)jFEvent2).getName();
                continue block0;
            }
        }
        if (string2 == null) {
            return linkedList;
        }
        for (n = 0; n < this.m_activities.size(); ++n) {
            activity = (Activity)this.m_activities.get(n);
            if (activity.getType() != 1 || !activity.getName().equals(string2)) continue;
            object2 = activity.getEvents();
            if (object2 == null) {
                return linkedList;
            }
            while (object2.hasNext()) {
                String string8;
                String string9;
                int n2;
                object = (JFEvent)object2.next();
                if (object == null) {
                    return linkedList;
                }
                if (((JFEvent)object).getEventGeneratorType().equals("lsf") || ((JFEvent)object).getEventGeneratorType().equals("otherbatch") || ((JFEvent)object).getEventGeneratorType().equals("local")) {
                    jFEvent = (JFJobEvent)object;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        string9 = (String)list.get(n2);
                        if (!((JFJobEvent)jFEvent).getJobName().equals(string9)) continue;
                        string8 = ((JFJobEvent)jFEvent).getEventJob().getAttribute("UserName");
                        if (!(string3 == null || string3.equals(string8) || JFCommon.containsValidVarRef(string3) || JFCommon.containsValidVarRef(string8))) {
                            linkedList.add("pre_submit_user_error:" + ((JFJobEvent)jFEvent).getJobName());
                        }
                        if (((JFJobEvent)jFEvent).getEventType() == 2 || ((JFJobEvent)jFEvent).getEventType() == 4) continue;
                        linkedList.add("pre_submit_dependent_error:" + this.getName() + ":" + ((JFJobEvent)jFEvent).getJobName());
                    }
                    continue;
                }
                if (!((JFEvent)object).getEventGeneratorType().equals("jobarray")) continue;
                jFEvent = (JFJobArrayEvent)object;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    string9 = (String)list.get(n2);
                    if (!((JFJobArrayEvent)jFEvent).getJobArrayName().equals(string9)) continue;
                    string8 = ((JFJobArrayEvent)jFEvent).getEventJobArray().getJobDefinition().getAttribute("UserName");
                    if (!(string3 == null || string3.equals(string8) || JFCommon.containsValidVarRef(string3) || JFCommon.containsValidVarRef(string8))) {
                        linkedList.add("pre_submit_user_error:" + ((JFJobArrayEvent)jFEvent).getJobArrayName());
                    }
                    if (((JFJobArrayEvent)jFEvent).getEventType() == 3) continue;
                    linkedList.add("pre_submit_dependent_error:" + this.getName() + ":" + ((JFJobArrayEvent)jFEvent).getJobArrayName());
                }
            }
        }
        return linkedList;
    }

    public String getJobString(JFJobEvent jFJobEvent) {
        if (jFJobEvent == null || jFJobEvent.isProxy()) {
            return null;
        }
        String string = jFJobEvent.getJobName();
        JFJob jFJob = this.getJob(string);
        if (jFJob == null || "local".equals(jFJob.getExecutionType())) {
            return null;
        }
        return JFResource.getString("JOB_TYPE") + "[" + string + "]";
    }

    public String getJobArrayString(JFJobArrayEvent jFJobArrayEvent) {
        String string;
        JFJobArray jFJobArray;
        String string2 = null;
        if (jFJobArrayEvent != null && !jFJobArrayEvent.isProxy() && (jFJobArray = this.getJobArray(string = jFJobArrayEvent.getJobArrayName())) != null) {
            string2 = JFResource.getString("JOBARRAY_TYPE") + "[" + string + "]";
        }
        return string2;
    }

    public List availableJobs(String string) {
        Object object;
        JFEvent jFEvent;
        Iterator iterator;
        Activity activity;
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = null;
        block0: for (n = 0; n < this.m_activities.size(); ++n) {
            activity = (Activity)this.m_activities.get(n);
            if (activity.getType() != 1 && activity.getType() != 3 || !activity.getName().equals(string)) continue;
            iterator = activity.getEvents();
            if (iterator == null) {
                return linkedList;
            }
            while (iterator.hasNext()) {
                jFEvent = (JFEvent)iterator.next();
                if (jFEvent == null) {
                    return linkedList;
                }
                if (jFEvent.getEventGeneratorType().equals("lsf") || jFEvent.getEventGeneratorType().equals("local") || jFEvent.getEventGeneratorType().equals("otherbatch") || jFEvent.getEventGeneratorType().equals("jobarray")) {
                    if (jFEvent instanceof JFJobEvent && (object = this.getJobString((JFJobEvent)jFEvent)) != null) {
                        linkedList.add((String)object);
                    }
                    if (jFEvent instanceof JFJobArrayEvent && (object = this.getJobArrayString((JFJobArrayEvent)jFEvent)) != null) {
                        linkedList.add((String)object);
                    }
                    return linkedList;
                }
                if (!jFEvent.getEventGeneratorType().equals("link")) continue;
                object = (JFLinkEvent)jFEvent;
                if (((JFLinkEvent)object).getEventCombinationOp() != 0) continue block0;
                string2 = ((JFLinkEvent)object).getName();
                continue block0;
            }
        }
        if (string2 == null) {
            return linkedList;
        }
        for (n = 0; n < this.m_activities.size(); ++n) {
            activity = (Activity)this.m_activities.get(n);
            if (activity.getType() != 1 || !activity.getName().equals(string2)) continue;
            iterator = activity.getEvents();
            if (iterator == null) {
                return linkedList;
            }
            while (iterator.hasNext()) {
                jFEvent = (JFEvent)iterator.next();
                if (jFEvent == null) {
                    return linkedList;
                }
                if (jFEvent instanceof JFJobEvent) {
                    object = this.getJobString((JFJobEvent)jFEvent);
                    if (object == null) continue;
                    linkedList.add((String)object);
                    continue;
                }
                if (!(jFEvent instanceof JFJobArrayEvent) || (object = this.getJobArrayString((JFJobArrayEvent)jFEvent)) == null) continue;
                linkedList.add((String)object);
            }
        }
        return linkedList;
    }

    public void setOwner(String string) {
        this.setAttribute(MAIN_FLOW_OWNER, string);
    }

    public String getOwner() {
        return this.getAttribute(MAIN_FLOW_OWNER);
    }

    public void validate() throws JFException {
        Cloneable cloneable;
        Object object;
        Object[] objectArray;
        block8: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    activity.getJob().validate();
                    objectArray = activity.getEvents();
                    while (objectArray != null && objectArray.hasNext()) {
                        object = (JFEvent)objectArray.next();
                        if (!(object instanceof JFFileEvent)) continue;
                        cloneable = (JFFileEvent)object;
                        ((JFFileEvent)cloneable).validateName();
                    }
                    continue block8;
                }
                case 3: {
                    activity.getJobArray().validate();
                    continue block8;
                }
                case 5: {
                    activity.getDynamicFlow().validate();
                    continue block8;
                }
                case 6: {
                    activity.getDynamicFlowArray().validate();
                    continue block8;
                }
                case 2: {
                    activity.getFlow().validate();
                    continue block8;
                }
                case 4: {
                    activity.getFlowArray().validate();
                }
            }
        }
        this.validateJobNames();
        this.validateEnvVars();
        this.validateVariableEvents();
        if (END_BEHAVIOUR_FLOW_CONTINUE_DELAY.equals(this.getAttribute("EndBehaviour"))) {
            JFHandler[] jFHandlerArray = this.getHandlers();
            for (int i = 0; i < jFHandlerArray.length; ++i) {
                JFEvent jFEvent = jFHandlerArray[i].getEvent();
                if (!(jFEvent instanceof JFFlowEvent) || ((JFFlowEvent)jFEvent).getEventType() != 11) continue;
                objectArray = new Object[]{this.m_flowDefName};
                object = JFResource.getString("Exclusive_FlowContinueDelay_NumExit");
                cloneable = new MessageFormat((String)object);
                throw new JFException(((Format)cloneable).format(objectArray));
            }
        }
    }

    private void validateVariableEvents() throws JFException {
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            Iterator iterator = activity.getEvents();
            if (n == 1 || n == 3 || n == 2 || n == 4) {
                while (iterator != null && iterator.hasNext()) {
                    JFVariableEvent jFVariableEvent;
                    JFEvent jFEvent = (JFEvent)iterator.next();
                    if (!(jFEvent instanceof JFVariableEvent) || "else".equalsIgnoreCase((jFVariableEvent = (JFVariableEvent)jFEvent).getExpression())) continue;
                    jFVariableEvent.validate();
                }
            }
            switch (n) {
                case 2: {
                    activity.getFlow().validateVariableEvents();
                    continue block4;
                }
                case 4: {
                    activity.getFlowArray().getFlowDefinition().validateVariableEvents();
                }
            }
        }
    }

    private void validateEnvVars() throws JFException {
        String string = this.getAttribute(FLOW_ENV_VARS);
        if (string != null && !JFCommon.checkEnvVars(string)) {
            Object[] objectArray = new Object[]{this.getName()};
            String string2 = JFResource.getString("FLOW_ENV_VARS_INVALID");
            MessageFormat messageFormat = new MessageFormat(string2);
            throw new JFException(messageFormat.format(objectArray));
        }
    }

    public void validateJobNames() throws JFException {
        this.validateJobNameLength(489, "");
    }

    private void validateJobNameLength(int n, String string) throws JFException {
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n2 = activity.getType();
            int n3 = this.m_flowDefName.length();
            switch (n2) {
                case 1: {
                    String string2 = activity.getJob().getName();
                    if (n - string2.length() - n3 - 1 >= 0) continue block6;
                    Object[] objectArray = new Object[]{string + this.m_flowDefName + ":" + string2, new Integer(489)};
                    String string3 = JFResource.getString("AGGREGATED_ITEM_NAME_LENGTH_TOO_LONG");
                    MessageFormat messageFormat = new MessageFormat(string3);
                    throw new JFException(messageFormat.format(objectArray));
                }
                case 3: {
                    String string2 = activity.getJobArray().getJobDefinition().getName();
                    if (n - string2.length() - n3 - 1 >= 0) continue block6;
                    Object[] objectArray = new Object[]{string + this.m_flowDefName + ":" + string2, new Integer(489)};
                    String string4 = JFResource.getString("AGGREGATED_ITEM_NAME_LENGTH_TOO_LONG");
                    MessageFormat messageFormat = new MessageFormat(string4);
                    throw new JFException(messageFormat.format(objectArray));
                }
                case 2: {
                    activity.getFlow().validateJobNameLength(n - n3 - 1, string + this.m_flowDefName + ":");
                    continue block6;
                }
                case 4: {
                    activity.getFlowArray().getFlowDefinition().validateJobNameLength(n - n3 - 1, string + this.m_flowDefName + ":");
                }
            }
        }
    }

    public boolean hasTargetFlowInfo() {
        String string = this.getAttribute("TargetFlowDefName");
        String string2 = this.getAttribute("TargetFlowDefVersion");
        return string != null && string.length() > 0;
    }

    boolean hasOtherOptions() {
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    String string = activity.getJob().getAttribute("OtherOption");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 3: {
                    String string = activity.getJobArray().getJobDefinition().getAttribute("OtherOption");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasOtherOptions()) continue block6;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasOtherOptions()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasPreSubmitOption() {
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    String string = activity.getJob().getAttribute("PreSubmitJob");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 3: {
                    String string = activity.getJobArray().getJobDefinition().getAttribute("PreSubmitJob");
                    if (string == null || string.equals("")) continue block6;
                    return true;
                }
                case 2: {
                    if (!activity.getFlow().hasPreSubmitOption()) continue block6;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasPreSubmitOption()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasExtUsrVar() {
        String[] stringArray = new String[]{"MinMaxCPU", "UserPreExecCmd", "UserGroup", "CPUTimeLimit", "RunTimeLimit", "FileSizeLimit", "PeakMemLimit", "DataSizeLimit", "StackSizeLimit", "CoreSizeLimit"};
        for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            JFJob jFJob = null;
            switch (n) {
                case 1: {
                    jFJob = activity.getJob();
                    break;
                }
                case 3: {
                    jFJob = activity.getJobArray().getJobDefinition();
                    break;
                }
                case 2: {
                    if (!activity.getFlow().hasExtUsrVar()) break;
                    return true;
                }
                case 4: {
                    if (!activity.getFlowArray().getFlowDefinition().hasExtUsrVar()) break;
                    return true;
                }
            }
            if (jFJob == null || !jFJob.getExecutionType().equals("lsf")) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!JFCommon.containsValidVarRef(jFJob.getAttribute(stringArray[j]))) continue;
                return true;
            }
        }
        return false;
    }

    int hasSubmittedOrFailDepType() {
        int n = 0;
        for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n2 = activity.getType();
            if (n2 == 2 && (n = activity.getFlow().hasSubmittedOrFailDepType()) != 0) {
                return n;
            }
            if (n2 == 4 && (n = activity.getFlowArray().getFlowDefinition().hasSubmittedOrFailDepType()) != 0) {
                return n;
            }
            Iterator iterator = this.getEvents(activity.getName());
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                JFEvent jFEvent = (JFEvent)iterator.next();
                if (jFEvent.getEventGeneratorType().equals("lsf") && ((JFJobEvent)jFEvent).getEventType() == 4 || jFEvent.getEventGeneratorType().equals("local") && ((JFJobEvent)jFEvent).getEventType() == 4 || jFEvent.getEventGeneratorType().equals("otherbatch") && ((JFJobEvent)jFEvent).getEventType() == 4 || jFEvent.getEventGeneratorType().equals("jobarray") && ((JFJobArrayEvent)jFEvent).getEventType() == 3) {
                    return 1;
                }
                if (jFEvent.getEventGeneratorType().equals("lsf") && ((JFJobEvent)jFEvent).getEventType() == 5 || jFEvent.getEventGeneratorType().equals("local") && ((JFJobEvent)jFEvent).getEventType() == 5 || jFEvent.getEventGeneratorType().equals("otherbatch") && ((JFJobEvent)jFEvent).getEventType() == 5 || jFEvent.getEventGeneratorType().equals("manual") && ((JFJobEvent)jFEvent).getEventType() == 5 || jFEvent.getEventGeneratorType().equals("jobarray") && ((JFJobArrayEvent)jFEvent).getEventType() == 4 || jFEvent.getEventGeneratorType().equals("flow") && ((JFFlowEvent)jFEvent).getEventType() == 3 || jFEvent.getEventGeneratorType().equals("flowarray") && ((JFFlowArrayEvent)jFEvent).getEventType() == 3) {
                    return 2;
                }
                if (!jFEvent.isProxy() && jFEvent.getEventGeneratorType().equals("manual") && ((JFJobEvent)jFEvent).getEventType() == 1) {
                    return 3;
                }
                if (!jFEvent.isProxy() && jFEvent.getEventGeneratorType().equals("manual") && ((JFJobEvent)jFEvent).getEventType() == 3) {
                    return 4;
                }
                if (!jFEvent.getEventGeneratorType().equals("flow") || ((JFFlowEvent)jFEvent).getEventType() != 0 || ((JFFlowEvent)jFEvent).getComparisonOp() == null) continue;
                return 5;
            }
        }
        return 0;
    }

    int hasJobArrayElementDependencyType() {
        int n = 0;
        for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n2 = activity.getType();
            if (n2 == 2 && (n = activity.getFlow().hasJobArrayElementDependencyType()) != 0) {
                return n;
            }
            if (n2 == 4 && (n = activity.getFlowArray().getFlowDefinition().hasJobArrayElementDependencyType()) != 0) {
                return n;
            }
            Iterator iterator = this.getEvents(activity.getName());
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                int n3;
                JFEvent jFEvent = (JFEvent)iterator.next();
                if (!jFEvent.getEventGeneratorType().equals("jobarray") || (n3 = ((JFJobArrayEvent)jFEvent).getEventType()) != 20 && n3 != 21 && n3 != 22 && n3 != 23) continue;
                return 1;
            }
        }
        return 0;
    }

    int hasNonZeroExitCodesOrExitCodeRule() {
        int n = 0;
        String string = this.getAttribute(EXIT_CODE_RULE);
        if (string != null && string.equals(FROM_LAST_ITEM)) {
            return 2;
        }
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n2 = activity.getType();
            switch (n2) {
                case 1: {
                    String string2 = activity.getJob().getAttribute("NonZeroSuccessExitCodes");
                    if (string2 == null || string2.equals("")) continue block6;
                    return 1;
                }
                case 3: {
                    String string2 = activity.getJobArray().getJobDefinition().getAttribute("NonZeroSuccessExitCodes");
                    if (string2 == null || string2.equals("")) continue block6;
                    return 1;
                }
                case 2: {
                    string = activity.getFlow().getAttribute(EXIT_CODE_RULE);
                    if (string != null && string.equals(FROM_LAST_ITEM)) {
                        return 2;
                    }
                    n = activity.getFlow().hasNonZeroExitCodesOrExitCodeRule();
                    if (n == 0) continue block6;
                    return n;
                }
                case 4: {
                    string = activity.getFlowArray().getFlowDefinition().getAttribute(EXIT_CODE_RULE);
                    if (string != null && string.equals(FROM_LAST_ITEM)) {
                        return 2;
                    }
                    n = activity.getFlowArray().getFlowDefinition().hasNonZeroExitCodesOrExitCodeRule();
                    if (n == 0) continue block6;
                    return n;
                }
            }
        }
        return 0;
    }

    boolean hasMultiExitCodeJobDep() {
        Cloneable cloneable;
        int n;
        JFEvent[] jFEventArray = this.getTriggerEvents();
        for (n = 0; n < jFEventArray.length; ++n) {
            cloneable = jFEventArray[n];
            if (!((JFEvent)cloneable).getEventGeneratorType().equals("lsf") && !((JFEvent)cloneable).getEventGeneratorType().equals("local") && !((JFEvent)cloneable).getEventGeneratorType().equals("otherbatch") && (!((JFEvent)cloneable).getEventGeneratorType().equals("manual") || ((JFEvent)cloneable).isProxy()) || ((JFJobEvent)cloneable).getEventType() != 3 || !((JFJobEvent)cloneable).getComparisonOp().equals("==") && !((JFJobEvent)cloneable).getComparisonOp().equals("!=") || ((JFJobEvent)cloneable).getComparisonValues().length <= 1) continue;
            return true;
        }
        for (n = 0; n < this.m_activities.size(); ++n) {
            cloneable = (Activity)this.m_activities.get(n);
            int n2 = ((Activity)cloneable).getType();
            if (n2 == 2 && ((Activity)cloneable).getFlow().hasMultiExitCodeJobDep()) {
                return true;
            }
            if (n2 == 4 && ((Activity)cloneable).getFlowArray().getFlowDefinition().hasMultiExitCodeJobDep()) {
                return true;
            }
            Iterator iterator = ((Activity)cloneable).getEvents();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                JFEvent jFEvent = (JFEvent)iterator.next();
                if (!jFEvent.getEventGeneratorType().equals("lsf") && !jFEvent.getEventGeneratorType().equals("local") && !jFEvent.getEventGeneratorType().equals("otherbatch") && (!jFEvent.getEventGeneratorType().equals("manual") || jFEvent.isProxy()) || ((JFJobEvent)jFEvent).getEventType() != 3 || !((JFJobEvent)jFEvent).getComparisonOp().equals("==") && !((JFJobEvent)jFEvent).getComparisonOp().equals("!=") || ((JFJobEvent)jFEvent).getComparisonValues().length <= 1) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasLocalJobDisabledSuspension() {
        block6: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    Object object;
                    if (activity.getJob() == null || !"local".equals(activity.getJob().getExecutionType()) || (object = activity.getJob().getAttribute("DisableSuspend")) == null || !((String)object).equals("Yes")) continue block6;
                    return true;
                }
                case 2: {
                    if (activity.getFlow() == null || !activity.getFlow().hasLocalJobDisabledSuspension()) continue block6;
                    return true;
                }
                case 3: {
                    String string;
                    Object object;
                    if (activity.getJobArray() == null || (object = activity.getJobArray().getJobDefinition()) == null || !"local".equals(((JFJob)object).getExecutionType()) || (string = ((JFJob)object).getAttribute("DisableSuspend")) == null || !string.equals("Yes")) continue block6;
                    return true;
                }
                case 4: {
                    if (activity.getFlowArray() == null || activity.getFlowArray().getFlowDefinition() == null || !activity.getFlowArray().getFlowDefinition().hasLocalJobDisabledSuspension()) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasLocalJobOutputFile() {
        block5: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 1: {
                    if (activity.getJob() == null || !"local".equals(activity.getJob().getExecutionType())) continue block5;
                    String string = activity.getJob().getAttribute("Stdout");
                    String string2 = activity.getJob().getAttribute("Stderr");
                    if (string != null && !string.isEmpty()) {
                        return true;
                    }
                    if (string2 == null || string2.isEmpty()) continue block5;
                    return true;
                }
                case 2: {
                    if (activity.getFlow() == null || !activity.getFlow().hasLocalJobOutputFile()) continue block5;
                    return true;
                }
                case 4: {
                    if (activity.getFlowArray() == null || activity.getFlowArray().getFlowDefinition() == null || !activity.getFlowArray().getFlowDefinition().hasLocalJobOutputFile()) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasGlobalStdoutStderr() {
        String string = this.getAttribute(STD_OUT_CREATE);
        String string2 = this.getAttribute(STD_ERR_CREATE);
        if ("Yes".equals(string) || "Yes".equals(string2)) {
            return true;
        }
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 2: {
                    if (activity.getFlow() == null || !activity.getFlow().hasGlobalStdoutStderr()) continue block4;
                    return true;
                }
                case 4: {
                    if (activity.getFlowArray() == null || activity.getFlowArray().getFlowDefinition() == null || !activity.getFlowArray().getFlowDefinition().hasGlobalStdoutStderr()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasExitConditionIgnoreWaitingActivities() {
        if (this.getExitConditionIgnoreWaitingActivities()) {
            return true;
        }
        block4: for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            int n = activity.getType();
            switch (n) {
                case 2: {
                    if (activity.getFlow() == null || !activity.getFlow().hasExitConditionIgnoreWaitingActivities()) continue block4;
                    return true;
                }
                case 4: {
                    if (activity.getFlowArray() == null || activity.getFlowArray().getFlowDefinition() == null || !activity.getFlowArray().getFlowDefinition().hasExitConditionIgnoreWaitingActivities()) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    Activity getActivityByJobName(String string) {
        String string2 = JFXMLSource.getName(string);
        for (int i = 0; i < this.m_activities.size(); ++i) {
            Activity activity = (Activity)this.m_activities.get(i);
            if (activity.getType() != 1 || !activity.getJob().getName().equals(string2)) continue;
            return activity;
        }
        return null;
    }

    JFEvent[] getEvents() {
        JFEvent[] jFEventArray = new JFEvent[this.m_activities.size()];
        for (int i = 0; i < jFEventArray.length; ++i) {
            jFEventArray[i] = ((Activity)this.m_activities.get(i)).getEvent();
        }
        return jFEventArray;
    }

    class Activity
    implements Cloneable {
        public static final int JF_JOB = 1;
        public static final int JF_FLOW = 2;
        public static final int JF_JOBARRAY = 3;
        public static final int JF_FLOWARRAY = 4;
        public static final int JF_DYNAMICFLOW = 5;
        public static final int JF_DYNAMICFLOWARRAY = 6;
        protected int m_type = 0;
        protected String m_name = null;
        protected int m_combinationOp = 0;
        protected List m_events = null;
        protected JFFlow m_flowRef = null;
        protected JFFlowArray m_flowArrayRef = null;
        protected JFJob m_jobRef = null;
        protected JFJobArray m_jobArrayRef = null;
        protected JFDynamicFlow m_dynamicFlowRef = null;
        protected JFDynamicFlowArray m_dynamicFlowArrayRef = null;
        protected String m_isFromForm = "No";

        public Activity(String string, JFJob jFJob, JFEvent[] jFEventArray, int n) {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            if (jFJob == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            this.m_name = string;
            this.m_jobRef = jFJob;
            this.m_type = 1;
            this.m_combinationOp = n;
            if ("submissionForm".equals(jFJob.getExecutionType())) {
                this.m_isFromForm = "Yes";
            }
            this.initializeEvents(jFEventArray);
        }

        public Activity(String string, JFJobArray jFJobArray, JFEvent[] jFEventArray, int n) {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            if (jFJobArray == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            this.m_name = string;
            this.m_jobArrayRef = jFJobArray;
            this.m_type = 3;
            this.m_combinationOp = n;
            this.initializeEvents(jFEventArray);
        }

        public Activity(String string, JFFlow jFFlow2, JFEvent[] jFEventArray, int n) {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            if (jFFlow2 == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            this.m_name = string;
            this.m_flowRef = jFFlow2;
            this.m_type = 2;
            this.m_combinationOp = n;
            this.initializeEvents(jFEventArray);
        }

        public Activity(String string, JFFlowArray jFFlowArray, JFEvent[] jFEventArray, int n) {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            if (jFFlowArray == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            this.m_name = string;
            this.m_flowArrayRef = jFFlowArray;
            this.m_type = 4;
            this.m_combinationOp = n;
            this.initializeEvents(jFEventArray);
        }

        public Activity(String string, JFDynamicFlow jFDynamicFlow, JFEvent[] jFEventArray, int n) {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            if (jFDynamicFlow == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            this.m_name = string;
            this.m_dynamicFlowRef = jFDynamicFlow;
            if ("Yes".equals(jFDynamicFlow.getAttribute("IsSubmissionForm"))) {
                this.m_isFromForm = "Yes";
            }
            this.m_type = 5;
            this.m_combinationOp = n;
            this.initializeEvents(jFEventArray);
        }

        public Activity(String string, JFDynamicFlowArray jFDynamicFlowArray, JFEvent[] jFEventArray, int n) {
            if (string == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            if (jFDynamicFlowArray == null) {
                throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
            }
            this.m_name = string;
            this.m_dynamicFlowArrayRef = jFDynamicFlowArray;
            this.m_type = 6;
            this.m_combinationOp = n;
            this.initializeEvents(jFEventArray);
        }

        private void initializeEvents(JFEvent[] jFEventArray) {
            if (jFEventArray != null) {
                this.m_events = new LinkedList();
                for (int i = 0; i < jFEventArray.length; ++i) {
                    if (jFEventArray[i] == null || this.m_events.contains(jFEventArray[i])) continue;
                    this.m_events.add(jFEventArray[i]);
                }
            }
        }

        public void setEvents(List list) {
            if (list != null) {
                this.m_events = new LinkedList();
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null || this.m_events.contains(list.get(i))) continue;
                    this.m_events.add(list.get(i));
                }
            }
        }

        public int getType() {
            return this.m_type;
        }

        public JFJob getJob() {
            return this.m_jobRef;
        }

        public JFFlow getFlow() {
            return this.m_flowRef;
        }

        public String getIsFromForm() {
            return this.m_isFromForm;
        }

        public JFDynamicFlow getDynamicFlow() {
            return this.m_dynamicFlowRef;
        }

        public JFJobArray getJobArray() {
            return this.m_jobArrayRef;
        }

        public JFFlowArray getFlowArray() {
            return this.m_flowArrayRef;
        }

        public JFDynamicFlowArray getDynamicFlowArray() {
            return this.m_dynamicFlowArrayRef;
        }

        public String getName() {
            switch (this.m_type) {
                case 1: {
                    return this.m_jobRef.getName();
                }
                case 2: {
                    return this.m_flowRef.getName();
                }
                case 5: {
                    return this.m_dynamicFlowRef.getName();
                }
                case 3: {
                    return this.m_jobArrayRef.getName();
                }
                case 4: {
                    return this.m_flowArrayRef.getName();
                }
                case 6: {
                    return this.m_dynamicFlowArrayRef.getName();
                }
            }
            return null;
        }

        public Iterator getEvents() {
            if (this.m_events == null) {
                return null;
            }
            return this.m_events.iterator();
        }

        public JFEvent getEvent() {
            if (this.m_events == null || this.m_events.size() == 0) {
                return null;
            }
            if (this.m_events.size() == 1) {
                return (JFEvent)this.m_events.get(0);
            }
            return null;
        }

        String toXML(String string) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer(200);
            String string2 = string + ":";
            switch (this.m_type) {
                case 1: {
                    string2 = string2 + this.m_jobRef.getName();
                    break;
                }
                case 2: {
                    string2 = string2 + this.m_flowRef.getName();
                    break;
                }
                case 5: {
                    string2 = string2 + this.m_dynamicFlowRef.getName();
                    break;
                }
                case 3: {
                    string2 = string2 + this.m_jobArrayRef.getName();
                    break;
                }
                case 4: {
                    string2 = string2 + this.m_flowArrayRef.getName();
                    break;
                }
                case 6: {
                    string2 = string2 + this.m_dynamicFlowArrayRef.getName();
                }
            }
            stringBuffer.append("\n  <ActivityDef  Name=\"\"");
            if (this.m_type == 2 || this.m_type == 4) {
                stringBuffer.append("  ImplementType=\"SubFlow\"");
            } else if (this.m_type == 5 || this.m_type == 6) {
                stringBuffer.append("  ImplementType=\"DynamicSubFlow\"");
            } else {
                stringBuffer.append("  ImplementType=\"Job\"");
            }
            stringBuffer.append("  ImplementRefer=\"" + string2 + "\"");
            if (this.m_type == 3) {
                stringBuffer.append("  IndexList=\"" + JFXMLSource.convertToXMLAttrString(this.m_jobArrayRef.getArrayIndex()) + "\"");
            }
            if (this.m_type == 4) {
                stringBuffer.append("  FirstElement=\"" + JFXMLSource.convertToXMLAttrString(this.m_flowArrayRef.getFirstElement()) + "\"");
                stringBuffer.append("  LastElement=\"" + JFXMLSource.convertToXMLAttrString(this.m_flowArrayRef.getLastElement()) + "\"");
                object = this.m_flowArrayRef.getFlowDefinition().getAttribute("Exclusive");
                object = object == null ? "No" : object;
                stringBuffer.append("  Exclusive=\"" + JFXMLSource.convertToXMLAttrString((String)object) + "\"");
            }
            if (this.m_type == 6) {
                stringBuffer.append("  FirstElement=\"" + JFXMLSource.convertToXMLAttrString(this.m_dynamicFlowArrayRef.getFirstElement()) + "\"");
                stringBuffer.append("  LastElement=\"" + JFXMLSource.convertToXMLAttrString(this.m_dynamicFlowArrayRef.getLastElement()) + "\"");
            }
            JFHandler[] jFHandlerArray = null;
            switch (this.m_type) {
                case 1: {
                    object = this.m_jobRef.getAttributes();
                    jFHandlerArray = this.m_jobRef.getHandlers();
                    break;
                }
                case 2: {
                    object = this.m_flowRef.getAttributes();
                    jFHandlerArray = this.m_flowRef.getHandlers();
                    break;
                }
                case 5: {
                    object = this.m_dynamicFlowRef.getAttributes();
                    break;
                }
                case 3: {
                    object = this.m_jobArrayRef.m_job.getAttributes();
                    jFHandlerArray = this.m_jobArrayRef.m_job.getHandlers();
                    break;
                }
                case 4: {
                    object = this.m_flowArrayRef.getFlowDefinition().getAttributes();
                    jFHandlerArray = this.m_flowArrayRef.getFlowDefinition().getHandlers();
                    break;
                }
                case 6: {
                    object = this.m_dynamicFlowArrayRef.getFlowDefinition().getAttributes();
                    break;
                }
                default: {
                    object = new Properties();
                }
            }
            if (((Properties)object).getProperty("PositionX") != null && ((Properties)object).getProperty("PositionY") != null) {
                stringBuffer.append("  PositionX=\"" + ((Properties)object).getProperty("PositionX") + "\"" + "  PositionY=\"" + ((Properties)object).getProperty("PositionY") + "\"");
            }
            stringBuffer.append(" Description=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty("Description")) + "\"");
            if (this.m_type == 2 || this.m_type == 4) {
                if (((Properties)object).getProperty(JFFlow.UPDATE_TYPE) != null) {
                    stringBuffer.append(" UpdateType=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.UPDATE_TYPE)) + "\"");
                }
                if (((Properties)object).getProperty("EndBehaviour") != null) {
                    stringBuffer.append(" EndBehaviour=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty("EndBehaviour")) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.EXIT_CONDITION_IGNORE_WAITING_ACTIVITIES) != null) {
                    stringBuffer.append(" ExitConditionIgnoreWaitingActivities=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.EXIT_CONDITION_IGNORE_WAITING_ACTIVITIES)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.FLOW_ENV_VARS) != null && !((Properties)object).getProperty(JFFlow.FLOW_ENV_VARS).equals("")) {
                    stringBuffer.append(" FlowEnvVars=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.FLOW_ENV_VARS)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.FLOW_WORKING_DIR) != null && !((Properties)object).getProperty(JFFlow.FLOW_WORKING_DIR).equals("")) {
                    stringBuffer.append(" FlowWorkingDir=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.FLOW_WORKING_DIR)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.EXIT_CODE_RULE) != null) {
                    stringBuffer.append(" ExitCodeRule=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.EXIT_CODE_RULE)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_OUT) != null) {
                    stringBuffer.append(" FlowStdout=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_OUT)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_ERR) != null) {
                    stringBuffer.append(" FlowStderr=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_ERR)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_OUT_CREATE) != null) {
                    stringBuffer.append(" FlowCreateStdout=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_OUT_CREATE)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_ERR_CREATE) != null) {
                    stringBuffer.append(" FlowCreateStderr=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_ERR_CREATE)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_OUT_OVERRIDE) != null) {
                    stringBuffer.append(" FlowOverrideStdout=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_OUT_OVERRIDE)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_ERR_OVERRIDE) != null) {
                    stringBuffer.append(" FlowOverrideStderr=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_ERR_OVERRIDE)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_OUT_DIR) != null) {
                    stringBuffer.append(" FlowStdoutDir=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_OUT_DIR)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_ERR_DIR) != null) {
                    stringBuffer.append(" FlowStderrDir=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_ERR_DIR)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_OUT_AUTO_JOB_ARRAY_INDEX) != null) {
                    stringBuffer.append(" FlowStdoutAutoIndex=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_OUT_AUTO_JOB_ARRAY_INDEX)) + "\"");
                }
                if (((Properties)object).getProperty(JFFlow.STD_ERR_AUTO_JOB_ARRAY_INDEX) != null) {
                    stringBuffer.append(" FlowStderrAutoIndex=\"" + JFXMLSource.convertToXMLAttrString(((Properties)object).getProperty(JFFlow.STD_ERR_AUTO_JOB_ARRAY_INDEX)) + "\"");
                }
            }
            if (this.m_type == 1 && ((Properties)object).getProperty("OnHold") != null) {
                stringBuffer.append(" OnHold=\"" + ((Properties)object).getProperty("OnHold") + "\"");
            }
            stringBuffer.append(" >");
            if (this.m_events != null && this.m_events.size() > 0) {
                stringBuffer.append("<Events CombinationType=\"");
                if (this.m_combinationOp == 0) {
                    stringBuffer.append("And");
                } else {
                    stringBuffer.append("Or");
                }
                stringBuffer.append("\">");
                for (Object object2 : this.m_events) {
                    String string3 = ((JFEvent)object2).getEventGeneratorType();
                    if (string3.equals("lsf") || string3.equals("local") || string3.equals("manual") || string3.equals("otherbatch")) {
                        ((JFJobEvent)object2).setParentName(string);
                    } else if (string3.equals("variable")) {
                        ((JFVariableEvent)object2).setParentName(string);
                    } else if (string3.equals("flow")) {
                        ((JFFlowEvent)object2).setParentName(string);
                    } else if (string3.equals("dynamicflow")) {
                        ((JFDynamicFlowEvent)object2).setParentName(string);
                    } else if (string3.equals("dynamicflowarray")) {
                        ((JFDynamicFlowArrayEvent)object2).setParentName(string);
                    } else if (string3.equals("jobarray")) {
                        ((JFJobArrayEvent)object2).setParentName(string);
                    } else if (string3.equals("link")) {
                        ((JFLinkEvent)object2).setParentName(string);
                    } else if (string3.equals("job_except")) {
                        ((JFJobExceptionEvent)object2).setParentName(string);
                    } else if (string3.equals("jobarray_except")) {
                        ((JFJobArrayExceptionEvent)object2).setParentName(string);
                    } else if (string3.equals("flow_except")) {
                        ((JFFlowExceptionEvent)object2).setParentName(string);
                    } else if (string3.equals("dynamicflow_except")) {
                        ((JFDynamicFlowExceptionEvent)object2).setParentName(string);
                    } else if (string3.equals("flowarray")) {
                        ((JFFlowArrayEvent)object2).setParentName(string);
                    } else if (string3.equals("flowarray_except")) {
                        ((JFFlowArrayExceptionEvent)object2).setParentName(string);
                    } else if (string3.equals("dynamicflowarray_except")) {
                        ((JFDynamicFlowArrayExceptionEvent)object2).setParentName(string);
                    }
                    stringBuffer.append("<Event GeneratorType=\"" + ((JFEvent)object2).getEventGeneratorType() + "\"" + this.attributesToXML(((JFEvent)object2).getAttributes()) + " >");
                    stringBuffer.append(JFXMLSource.convertToXMLAttrString(((JFEvent)object2).generateDefinition()) + "</Event>");
                }
                stringBuffer.append("</Events>");
            }
            if (jFHandlerArray != null) {
                Object object2;
                stringBuffer.append("<Exceptions>");
                object2 = new String();
                for (int i = 0; i < jFHandlerArray.length; ++i) {
                    JFHandler jFHandler = jFHandlerArray[i];
                    JFJob jFJob = jFHandler.getAlarmJob();
                    int n = jFHandler.getAction();
                    switch (n) {
                        case 2: {
                            object2 = "alarm";
                            break;
                        }
                        case 1: {
                            object2 = "rerun";
                            break;
                        }
                        case 0: {
                            object2 = "kill";
                        }
                    }
                    stringBuffer.append("<Exception Type=\"" + (String)object2 + "\" Delay=\"" + jFHandler.getDelay() + "\" NumberRerun=\"" + jFHandler.getNumberRerun() + "\">");
                    JFEvent jFEvent = jFHandler.getEvent();
                    String string4 = jFEvent.getEventGeneratorType();
                    if (this.isWorkItemEvent(jFEvent)) {
                        if (jFEvent instanceof JFJobEvent) {
                            ((JFJobEvent)jFEvent).setParentName(string2);
                        } else if (jFEvent instanceof JFFlowEvent) {
                            ((JFFlowEvent)jFEvent).setParentName(string2);
                        } else if (jFEvent instanceof JFDynamicFlowEvent) {
                            ((JFDynamicFlowEvent)jFEvent).setParentName(string2);
                        } else if (jFEvent instanceof JFJobArrayEvent) {
                            ((JFJobArrayEvent)jFEvent).setParentName(string2);
                        } else if (jFEvent instanceof JFFlowArrayEvent) {
                            ((JFFlowArrayEvent)jFEvent).setParentName(string2);
                        } else if (jFEvent instanceof JFDynamicFlowArrayEvent) {
                            ((JFDynamicFlowArrayEvent)jFEvent).setParentName(string2);
                        }
                    } else if (string4.equals("lsf") || string4.equals("local") || string4.equals("manual") || string4.equals("otherbatch")) {
                        ((JFJobEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("flow")) {
                        ((JFFlowEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("jobarray")) {
                        ((JFJobArrayEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("job_except")) {
                        ((JFJobExceptionEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("jobarray_except")) {
                        ((JFJobArrayExceptionEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("flow_except")) {
                        ((JFFlowExceptionEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("flowarray_except")) {
                        ((JFFlowArrayExceptionEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("dynamicflow_except")) {
                        ((JFDynamicFlowExceptionEvent)jFEvent).setParentName(string);
                    } else if (string4.equals("dynamicflowarray_except")) {
                        ((JFDynamicFlowArrayExceptionEvent)jFEvent).setParentName(string);
                    }
                    stringBuffer.append("<Event GeneratorType=\"" + jFHandler.getEvent().getEventGeneratorType() + "\">");
                    stringBuffer.append(JFXMLSource.convertToXMLAttrString(jFEvent.generateDefinition()) + "</Event>");
                    if (jFHandler.getAction() == 2) {
                        stringBuffer.append(jFJob.toXML(string));
                    }
                    stringBuffer.append("</Exception>");
                }
                stringBuffer.append("</Exceptions>");
            }
            stringBuffer.append("</ActivityDef>");
            return stringBuffer.toString();
        }

        private boolean isWorkItemEvent(JFEvent jFEvent) {
            if (this.m_type != 2 && this.m_type != 4) {
                return false;
            }
            if (jFEvent instanceof JFJobEvent || jFEvent instanceof JFJobArrayEvent) {
                return true;
            }
            if (jFEvent instanceof JFFlowEvent) {
                if (((JFFlowEvent)jFEvent).getEventFlow() == null || this.m_flowRef == null) {
                    return false;
                }
                return this.m_flowRef != ((JFFlowEvent)jFEvent).getEventFlow();
            }
            return false;
        }

        public String getDefinitionXML(String string) throws JFException {
            return this.getDefinitionXML(string, null);
        }

        public String getDefinitionXML(String string, String string2) throws JFException {
            switch (this.m_type) {
                case 1: {
                    return this.m_jobRef.toXML(string);
                }
                case 2: {
                    return this.m_flowRef.toXML(string, string2);
                }
                case 5: {
                    return this.m_dynamicFlowRef.toXML(string);
                }
                case 3: {
                    this.m_jobArrayRef.m_job.setName(this.m_jobArrayRef.getName());
                    return this.m_jobArrayRef.m_job.toXML(string);
                }
                case 4: {
                    this.m_flowArrayRef.getFlowDefinition().setName(this.m_flowArrayRef.getName());
                    return this.m_flowArrayRef.getFlowDefinition().toXML(string, string2);
                }
                case 6: {
                    this.m_dynamicFlowArrayRef.getFlowDefinition().setName(this.m_dynamicFlowArrayRef.getName());
                    return this.m_dynamicFlowArrayRef.getFlowDefinition().toXML(string);
                }
            }
            return null;
        }

        public Object clone() {
            Activity activity = null;
            try {
                activity = (Activity)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            activity.m_type = this.m_type;
            activity.m_name = this.m_name;
            if (this.m_events != null) {
                try {
                    JFEventFactory jFEventFactory = JFEventFactory.getEventFactory();
                    activity.m_events = new LinkedList();
                    for (JFEvent jFEvent : this.m_events) {
                        JFEvent jFEvent2 = jFEventFactory.createEvent(jFEvent.getEventGeneratorType(), jFEvent.generateDefinition());
                        if (activity.m_events.contains(jFEvent2)) continue;
                        activity.m_events.add(jFEvent2);
                    }
                }
                catch (JFException jFException) {
                    return null;
                }
            }
            switch (this.m_type) {
                case 1: {
                    activity.m_jobRef = (JFJob)this.m_jobRef.clone();
                    break;
                }
                case 2: {
                    activity.m_flowRef = (JFFlow)this.m_flowRef.clone();
                    break;
                }
                case 5: {
                    activity.m_dynamicFlowRef = (JFDynamicFlow)this.m_dynamicFlowRef.clone();
                    break;
                }
                case 3: {
                    activity.m_jobArrayRef = (JFJobArray)this.m_jobArrayRef.clone();
                    break;
                }
                case 4: {
                    activity.m_flowArrayRef = (JFFlowArray)this.m_flowArrayRef.clone();
                    break;
                }
                case 6: {
                    activity.m_dynamicFlowArrayRef = (JFDynamicFlowArray)this.m_dynamicFlowArrayRef.clone();
                }
            }
            return activity;
        }

        String attributesToXML(Properties properties) {
            if (properties == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(64);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("  " + string + "=\"" + JFXMLSource.convertToXMLAttrString(properties.getProperty(string)) + "\"");
            }
            return stringBuffer.toString();
        }

        int getCombinationOp() {
            return this.m_combinationOp;
        }

        JFEvent[] getEventArray() {
            if (this.m_events == null) {
                return null;
            }
            JFEvent[] jFEventArray = new JFEvent[this.m_events.size()];
            for (int i = 0; i < this.m_events.size(); ++i) {
                jFEventArray[i] = (JFEvent)this.m_events.get(i);
            }
            return jFEventArray;
        }

        List getEventList() {
            return this.m_events;
        }
    }
}

