/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDateTimeParser;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventFactory;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFTime;
import com.platform.LSFJobFlow.api.JFVersion;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JFEventInstance {
    JFEvent eventDefinition = null;
    private JFTime time = null;
    private String runtimeInfo = null;
    private String triggerFile = null;
    private boolean m_completedManually = false;

    JFEventInstance() {
    }

    JFTime getTimeObj() {
        return this.time;
    }

    public Date getTime() {
        if (this.time != null) {
            return this.time.getTime();
        }
        return null;
    }

    JFTime getJFTime() {
        return this.time;
    }

    public String getTimeOnServer() {
        if (this.time != null) {
            return this.time.getTimeStringOnServer();
        }
        return null;
    }

    public String getTimeString() {
        if (this.time != null) {
            return this.time.getTimeString();
        }
        return null;
    }

    public String getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public String getTriggerFile() {
        return this.triggerFile;
    }

    public boolean isCompletedManually() {
        return this.m_completedManually;
    }

    void setCompletedManually(boolean bl) {
        this.m_completedManually = bl;
    }

    void setTime(JFTime jFTime) {
        this.time = jFTime;
    }

    public void setRuntimeInfo(String string) {
        this.runtimeInfo = string;
    }

    public void setTriggerFile(String string) {
        this.triggerFile = string;
    }

    public JFEvent getEventDefinition() {
        return this.eventDefinition;
    }

    void setJFEventDefinition(JFEvent jFEvent) {
        this.eventDefinition = jFEvent;
    }

    public String toString() {
        String string = this.getTimeString();
        if (string == null) {
            string = "";
        }
        String string2 = this.eventDefinition.toString() + "     " + string;
        if (this.isCompletedManually()) {
            string2 = string2 + " Completed Manually";
        }
        return string2;
    }

    void fromXML(Node node) throws JFException {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Object object;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeName().equals("Event")) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                String string11;
                String string12;
                String string13;
                this.eventDefinition = JFEventFactory.getEventFactory().createEvent(((Element)node2).getAttribute("GeneratorType"), node2.getFirstChild().getNodeValue());
                object = ((Element)node2).getAttribute("Name");
                if (object != null && !((String)object).equals("") && !((String)object).equals("null")) {
                    this.eventDefinition.setAttribute("Name", (String)object);
                }
                if ((string13 = ((Element)node2).getAttribute("Description")) != null && !string13.equals("") && !string13.equals("null")) {
                    this.eventDefinition.setAttribute("Description", string13);
                }
                if ((string12 = ((Element)node2).getAttribute("PositionX")) != null && !string12.equals("") && !string12.equals("null")) {
                    this.eventDefinition.setAttribute("PositionX", string12);
                }
                if ((string11 = ((Element)node2).getAttribute("PositionY")) != null && !string11.equals("") && !string11.equals("null")) {
                    this.eventDefinition.setAttribute("PositionY", string11);
                }
                if ((string10 = ((Element)node2).getAttribute("IsProxy")) != null && !string10.equals("") && !string10.equals("null")) {
                    this.eventDefinition.setAttribute("IsProxy", string10);
                }
                if ((string9 = ((Element)node2).getAttribute("Source")) != null && !string9.equals("") && !string9.equals("null")) {
                    this.eventDefinition.setAttribute("Source", string9);
                }
                if ((string8 = ((Element)node2).getAttribute("TimeDuration")) != null && !string8.equals("") && !string8.equals("null")) {
                    this.eventDefinition.setAttribute("TimeDuration", string8);
                }
                if ((string7 = ((Element)node2).getAttribute("TimeZone")) != null && !string7.equals("") && !string7.equals("null")) {
                    this.eventDefinition.setAttribute("TimeZone", string7);
                }
                if ((string6 = ((Element)node2).getAttribute("ClientTZoffset")) != null && !string6.equals("") && !string6.equals("null")) {
                    this.eventDefinition.setAttribute("ClientTZoffset", string6);
                }
                if ((string5 = ((Element)node2).getAttribute("ServerTZoffset")) != null && !string5.equals("") && !string5.equals("null")) {
                    this.eventDefinition.setAttribute("ServerTZoffset", string5);
                }
                if ((string4 = ((Element)node2).getAttribute("CalExpr")) != null && !string4.equals("") && !string4.equals("null")) {
                    this.eventDefinition.setAttribute("CalExpr", string4);
                }
                if ((string3 = ((Element)node2).getAttribute("CalDesc")) != null && !string3.equals("") && !string3.equals("null")) {
                    this.eventDefinition.setAttribute("CalDesc", string3);
                }
                if ((string2 = ((Element)node2).getAttribute("CalCreationTime")) != null && !string2.equals("") && !string2.equals("null")) {
                    this.eventDefinition.setAttribute("CalCreationTime", string2);
                }
                if ((string = ((Element)node2).getAttribute("TimeZoneType")) != null && !string.equals("") && !string.equals("null")) {
                    this.eventDefinition.setAttribute("TimeZoneType", string);
                }
            }
            if (node2.getNodeName().equals("time")) {
                object = JFConfigManager.getServerVersion();
                if (object != null && ((JFVersion)object).compareTo("5.5") < 0) {
                    try {
                        this.time = new JFTime(JFDateTimeParser.oldParse(node2.getFirstChild().getNodeValue()));
                    }
                    catch (ParseException parseException) {}
                } else {
                    this.time = new JFTime(node2.getFirstChild());
                }
            }
            if (node2.getNodeName().equals("RuntimeInfo")) {
                this.runtimeInfo = node2.getFirstChild().getNodeValue();
            }
            if (node2.getNodeName().equals("TriggerFile")) {
                this.triggerFile = node2.getFirstChild().getNodeValue();
            }
            if (!node2.getNodeName().equals("CompletedManually") || !"Yes".equals(node2.getFirstChild().getNodeValue())) continue;
            this.m_completedManually = true;
        }
    }

    void fromString(String string) {
        try {
            this.eventDefinition = JFEventFactory.getEventFactory().createEvent(string);
        }
        catch (Exception exception) {
            JFDebug.printStackTrace(exception);
        }
        this.triggerFile = this.findAttribute(string, "TriggerFile");
        this.runtimeInfo = this.findAttribute(string, "RuntimeInfo");
        this.m_completedManually = "Yes".equals(this.findAttribute(string, "CompletedManually"));
        String string2 = this.findAttribute(string, "Time");
        if (string2 != null) {
            this.time = new JFTime(string2);
        }
    }

    private String findAttribute(String string, String string2) {
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf("=");
            if (-1 == n) continue;
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 1, string4.length());
            if (!string5.equals(string2)) continue;
            string3 = string6;
        }
        return string3;
    }
}

