/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFBase64Encoder;
import com.platform.LSFJobFlow.api.JFEncryptionINF;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFResource;
import cryptix.provider.Cryptix;
import cryptix.provider.key.RawSecretKey;
import java.security.Security;
import xjava.security.Cipher;

class JFEncryption128
implements JFEncryptionINF {
    private static Object mutex = new Object();
    private static final String CAST128 = "CAST5";
    private RawSecretKey m_secretKey;
    private RawSecretKey m_secretKey64;
    private static boolean m_key64Flag = false;
    private static Cipher m_algorithm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFEncryption128(byte[] byArray) throws JFException {
        if (m_algorithm == null) {
            Object object = mutex;
            synchronized (object) {
                try {
                    Security.addProvider(new Cryptix());
                    m_algorithm = Cipher.getInstance(CAST128, "Cryptix");
                }
                catch (Exception exception) {
                    throw new JFException(JFResource.getString("ENCRYPT_INIT_FAILED"));
                }
            }
        }
        if (byArray != null) {
            this.setSecretKey(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String marshallChannel(byte[] byArray) throws JFException {
        Object object = mutex;
        synchronized (object) {
            String string;
            int n = 8 - byArray.length % 8;
            int n2 = byArray.length + n;
            byte[] byArray2 = new byte[n2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
            try {
                if (m_key64Flag) {
                    m_algorithm.initEncrypt(this.m_secretKey64);
                } else {
                    m_algorithm.initEncrypt(this.m_secretKey);
                }
                byte[] byArray3 = m_algorithm.crypt(byArray2);
                string = JFBase64Encoder.encode(byArray3);
            }
            catch (Exception exception) {
                throw new JFException(JFResource.getString("ENCRYPT_ENCRYPT_FAILED"));
            }
            return string;
        }
    }

    @Override
    public byte[] unmarshallChannel(String string) throws JFException {
        Object object = mutex;
        synchronized (object) {
            try {
                int n;
                byte[] byArray = JFBase64Encoder.decode(string);
                if (m_key64Flag) {
                    m_algorithm.initDecrypt(this.m_secretKey64);
                } else {
                    m_algorithm.initDecrypt(this.m_secretKey);
                }
                byte[] byArray2 = m_algorithm.crypt(byArray);
                for (n = byArray2.length - 1; n > 0 && byArray2[n] == 0; --n) {
                }
                byte[] byArray3 = new byte[n + 1];
                for (int i = 0; i < n + 1; ++i) {
                    byArray3[i] = byArray2[i];
                }
                return byArray3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new JFException(JFResource.getString("ENCRYPT_DECRYPT_FAILED"));
            }
        }
    }

    private void setSecretKey(byte[] byArray) throws JFException {
        try {
            this.m_secretKey = new RawSecretKey(CAST128, byArray);
            byte[] byArray2 = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray2[i] = byArray[i];
            }
            this.m_secretKey64 = new RawSecretKey(CAST128, byArray2);
        }
        catch (Exception exception) {
            throw new JFException(JFResource.getString("ENVRYPT_INVALID_KEY"));
        }
    }

    static void setKey64(boolean bl) {
        m_key64Flag = bl;
    }

    static boolean isKey64() {
        return m_key64Flag;
    }
}

