/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFXMLSource;
import java.util.Properties;

public class JFDynamicFlow
implements Cloneable {
    private String m_dynamicFlowDefName = null;
    private Properties m_dynamicFlowProps = null;
    private String m_curUser = null;
    private Properties m_dynamicFlowVarProps = null;
    public static final String USE_PARENT = "ParentFlow";
    public static final String USE_INSERTED = "InsertedFlow";
    public static final String USE_OVERRIDE = "Override";
    public static final String AUTOMATIC = "Automatic";
    public static final String MANUAL = "Manual";
    public static final String DEFAULT = "Default";
    public static final String TARGET_FLOWDEF_NAME = "TargetFlowDefName";
    public static final String TARGET_FLOWDEF_VERSION = "TargetFlowDefVersion";
    public static final String UPDATE_TYPE = "UpdateType";
    public static final String USER_NAME = "UserName";
    public static final String VRIABLE_LIST = "VariableList";
    public static final String STD_OUT_TYPE = "FlowUseStdoutFrom";
    public static final String STD_ERR_TYPE = "FlowUseStderrFrom";

    public JFDynamicFlow() {
    }

    public JFDynamicFlow(String string) {
        this.m_dynamicFlowDefName = string;
        this.m_dynamicFlowProps = new Properties();
        this.m_dynamicFlowVarProps = new Properties();
        this.m_curUser = JFLoginManager.getUserName();
        this.m_dynamicFlowProps.setProperty(USER_NAME, this.m_curUser);
    }

    public String getName() {
        return this.m_dynamicFlowDefName;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("FLOWNAME_NULL"));
        }
        this.m_dynamicFlowDefName = string;
    }

    public Object clone() {
        JFDynamicFlow jFDynamicFlow = null;
        try {
            jFDynamicFlow = (JFDynamicFlow)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        jFDynamicFlow.m_dynamicFlowDefName = this.m_dynamicFlowDefName;
        jFDynamicFlow.m_curUser = this.m_curUser;
        jFDynamicFlow.m_dynamicFlowProps = (Properties)this.m_dynamicFlowProps.clone();
        jFDynamicFlow.m_dynamicFlowVarProps = (Properties)this.m_dynamicFlowVarProps.clone();
        return jFDynamicFlow;
    }

    public boolean equals(JFDynamicFlow jFDynamicFlow) {
        return this.m_dynamicFlowProps.equals(jFDynamicFlow.m_dynamicFlowProps) && this.m_dynamicFlowVarProps.equals(jFDynamicFlow.m_dynamicFlowVarProps) && this.m_curUser.equals(jFDynamicFlow.m_curUser) && this.m_dynamicFlowDefName.equals(jFDynamicFlow.m_dynamicFlowDefName);
    }

    public boolean setUserName(String string) {
        String string2 = this.m_dynamicFlowProps.getProperty(USER_NAME);
        if (string2 != null) {
            if (string2.equals(string)) {
                return false;
            }
            if (string2.equalsIgnoreCase(string)) {
                String string3 = JFUser.getServerType();
                if (string3 != null && string3.equals("WIN32")) {
                    return false;
                }
                if (string3 == null && string.indexOf("\\") != -1) {
                    return false;
                }
            }
        }
        this.m_dynamicFlowProps.setProperty(USER_NAME, string);
        return true;
    }

    public void validate() throws JFException {
    }

    String toXML(String string) throws JFException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string2 = this.getName();
        if (string == null) {
            throw new JFException(JFResource.getString("FLOW_NO_PARENT"));
        }
        string2 = string + ":" + string2;
        stringBuffer.append("\n<JobDynamicFlowDef  Name=\"" + string2 + "\">");
        for (String string3 : this.m_dynamicFlowProps.keySet()) {
            if (string3.equals("PositionX") || string3.equals("PositionY")) continue;
            String string4 = this.m_dynamicFlowProps.getProperty(string3);
            this.appendAttribute(stringBuffer, string3, JFXMLSource.convertToXMLAttrString(string4));
        }
        this.appendAttribute(stringBuffer, VRIABLE_LIST, JFXMLSource.convertToXMLAttrString(JFCommon.toVarList_withequal(this.m_dynamicFlowVarProps)));
        stringBuffer.append("\n</JobDynamicFlowDef>");
        if (stringBuffer != null) {
            if (JFDebug.debugMode) {
                System.out.println("buf=" + stringBuffer.toString());
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public void setAttribute(String string, String string2) {
        this.m_dynamicFlowProps.setProperty(string, string2);
    }

    public String getAttribute(String string) {
        return this.m_dynamicFlowProps.getProperty(string);
    }

    public void removeAllAttributes() {
        this.m_dynamicFlowProps = new Properties();
    }

    public Properties getAttributes() {
        return this.m_dynamicFlowProps;
    }

    void setAttributes(Properties properties) {
        this.m_dynamicFlowProps = properties;
    }

    protected void appendAttribute(StringBuffer stringBuffer, String string, String string2) {
        if (string == null || string2 == null || string2.length() == 0) {
            return;
        }
        if (stringBuffer == null) {
            throw new NullPointerException(JFResource.getString("INTERNAL_ERROR"));
        }
        stringBuffer.append("\n  <" + string);
        stringBuffer.append("  Value=\"" + string2 + "\"");
        stringBuffer.append("/>");
    }

    public void setVarProps(Properties properties) {
        this.m_dynamicFlowVarProps = properties;
    }

    public Properties getVarProps() {
        return this.m_dynamicFlowVarProps;
    }
}

