/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JFCalendar
implements Comparable {
    public static final String SYS_USER = "Sys";
    private String m_name;
    private String m_expression;
    private String m_owner;
    private String m_description;

    public JFCalendar(String string, String string2, String string3) throws JFException {
        this.m_owner = JFLoginManager.getUserName();
        if (this.m_owner == null) {
            throw new JFException(JFResource.getString("CAL_NO_USERNAME"));
        }
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        this.setName(string);
        this.m_expression = this.formatExpression(string2);
        this.m_description = string3;
    }

    JFCalendar(Element element) throws JFException {
        if (!"calendar".equals(element.getTagName())) {
            throw new JFException(JFResource.getString("JFERR_INVALID_XML_NODE") + element.getTagName());
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            Node node2 = element2.getFirstChild();
            if (node2 != null & "name".equals(string = element2.getTagName())) {
                this.setName(node2.getNodeValue());
                continue;
            }
            if (node2 != null && "owner".equals(string)) {
                this.m_owner = new JFUser(node2.getNodeValue()).toJSUserName();
                continue;
            }
            if (node2 != null && "expr".equals(string)) {
                this.m_expression = this.formatExpression(node2.getNodeValue());
                continue;
            }
            if (node2 == null || !"descr".equals(string)) continue;
            this.m_description = node2.getNodeValue();
        }
    }

    public JFCalendar(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.setName(string);
        this.m_expression = this.formatExpression(string2);
        this.m_owner = new JFUser(string3).toJSUserName();
        this.m_owner = JFUser.formatString(this.m_owner);
        this.m_description = string4;
    }

    public String getName() {
        return JFUser.deFormatString(this.m_name);
    }

    String getFormattedName() {
        return this.m_name;
    }

    public String getFullName() {
        return this.getName() + "@" + this.getOwner();
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        if (string.length() == 0 || Character.isDigit(string.charAt(0))) {
            throw new IllegalArgumentException(JFResource.getString("CAL_NAME_DIGIT"));
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLetter(c) || c == '.' || c == '\\' || c == '_' || c == '-') continue;
            throw new IllegalArgumentException(JFResource.getString("CAL_NAME_NOT_VALID"));
        }
        this.m_name = JFUser.formatString(string);
    }

    public String getExpression() {
        return this.deFormatExpression(this.m_expression);
    }

    String getFormattedExpression() {
        return this.m_expression;
    }

    public void setExpression(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.m_expression = this.formatExpression(string);
    }

    public String getOwner() {
        return JFUser.deFormatString(this.m_owner);
    }

    String getFormattedOwner() {
        return this.m_owner;
    }

    public void setOwner(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.m_owner = new JFUser(string).toJSUserName();
        this.m_owner = JFUser.formatString(this.m_owner);
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_ARG_NULL"));
        }
        this.m_description = string;
    }

    private String formatExpression(String string) {
        if ((string = string.trim()).length() != 0 && (string.charAt(0) != '(' || string.charAt(string.length() - 1) != ')')) {
            string = "(" + string + ")";
        }
        string = JFUser.formatString(string);
        return string;
    }

    private String deFormatExpression(String string) {
        string = JFUser.deFormatString(string);
        return string;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JFCalendar)) {
            return -1;
        }
        return this.m_name.compareTo(((JFCalendar)object).getName());
    }
}

