/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.CommBrokerINF;
import com.platform.LSFJobFlow.api.JFCharBuffer;
import com.platform.LSFJobFlow.api.JFCharReader;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEncryption128;
import com.platform.LSFJobFlow.api.JFEncryptionINF;
import com.platform.LSFJobFlow.api.JFEncryptor;
import com.platform.LSFJobFlow.api.JFIncompatibleIOException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;

class HTTPcommBroker
implements CommBrokerINF {
    private static final int LEN_PER_READ = 1024;
    private Socket sock = null;
    private BufferedOutputStream out = null;
    private BufferedReader in = null;
    private String URLstr = null;
    private String host = null;
    private int port = 0;
    private int timeout = 0;
    private JFEncryptionINF m_encryption = null;
    private boolean m_bEncrypt = false;
    private boolean m_isJFShutdown = false;
    private static final byte[] key = new byte[]{112, 8, 8, 113, 16, 8, -110, 18, 32, -105, 6, 32, -103, 3, 35, -1};

    @Override
    public boolean equal(String string, int n) {
        if (string == null) {
            return false;
        }
        return this.URLstr.equals(string) && n == 1;
    }

    public HTTPcommBroker(String string, int n) throws MalformedURLException {
        this.URLstr = string;
        URL uRL = new URL(this.URLstr);
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        this.timeout = n;
        try {
            this.m_encryption = JFEncryptor.getEncryptor(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = n;
    }

    @Override
    public void setEncrypt(boolean bl) {
        this.m_bEncrypt = bl;
    }

    @Override
    public void openConnection() throws IOException {
        try {
            this.sock = new Socket(this.host, this.port);
            if (this.timeout > 0) {
                this.sock.setSoTimeout(this.timeout);
            }
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
        }
        catch (UnknownHostException unknownHostException) {
            throw new UnknownHostException(JFResource.getString("UNKNOWN_HOST") + ": " + this.host);
        }
        catch (IOException iOException) {
            String string = this.host + ":" + this.port;
            throw new ConnectException(JFResource.getString("CONN_REFUSED", new Object[]{string}));
        }
    }

    @Override
    public void releaseConnection() {
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (Exception exception) {
            JFDebug.printStackTrace(exception);
        }
    }

    @Override
    public JFCharReader sendRecv(Properties properties) throws IOException {
        try {
            return new JFCharReader(this.sendRecv_(properties));
        }
        catch (JFIncompatibleIOException jFIncompatibleIOException) {
            throw jFIncompatibleIOException;
        }
        catch (IOException iOException) {
            if (iOException instanceof UnknownHostException || iOException instanceof SocketException) {
                throw iOException;
            }
            if (!iOException.getMessage().startsWith(JFResource.getString("COMM_ERR"))) {
                throw new IOException(JFResource.getString("COMM_ERR"));
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File sendRecvByFile(Properties properties) throws IOException {
        try {
            boolean bl = false;
            String string = System.getProperty("java.io.tmpdir") + File.separator + "pm_inst_" + System.currentTimeMillis() + ".tmp";
            char[] cArray = this.sendRecv_(properties);
            File file = null;
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(string);
                fileWriter.write(cArray, 0, cArray.length);
            }
            catch (IOException iOException) {
                bl = true;
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (bl) {
                new File(string).delete();
            } else {
                file = new File(string);
            }
            return file;
        }
        catch (JFIncompatibleIOException jFIncompatibleIOException) {
            throw jFIncompatibleIOException;
        }
        catch (IOException iOException) {
            if (iOException instanceof UnknownHostException || iOException instanceof SocketException) {
                throw iOException;
            }
            if (!iOException.getMessage().startsWith(JFResource.getString("COMM_ERR"))) {
                throw new IOException(JFResource.getString("COMM_ERR"));
            }
            throw iOException;
        }
    }

    private char[] sendRecv_(Properties properties) throws IOException {
        Object object;
        Object[] objectArray;
        Object object2;
        String string;
        String string2;
        Object object3;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        boolean bl = false;
        if (properties == null) {
            throw new NullPointerException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_NULL"));
        }
        string3 = properties.getProperty("method");
        string4 = properties.getProperty("uri");
        if (string4 == null) {
            throw new NullPointerException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_URI_NULL"));
        }
        string5 = properties.getProperty("content-owner");
        if (string5 == null) {
            throw new NullPointerException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_OWN_NULL"));
        }
        String string12 = properties.getProperty("JS-ClientIntVersion");
        string7 = properties.getProperty("JS-User");
        string8 = properties.getProperty("JS-UID");
        string9 = properties.getProperty("JS-GID");
        string10 = properties.getProperty("JS-Credentials");
        String string13 = "FALSE";
        if (JFConfigManager.isExternalLogin()) {
            string13 = "TRUE";
        }
        string11 = properties.getProperty("JS-Domain");
        string6 = properties.getProperty("content");
        if (string6.indexOf("<JF_Shutdown/>") > 0) {
            this.m_isJFShutdown = true;
        }
        String string14 = "]]>&#13;<![CDATA[";
        int n = 0;
        while ((n = string6.indexOf(string14)) > 0) {
            string6 = string6.substring(0, n) + string6.substring(n + string14.length());
        }
        String string15 = JFUTFConverter.toUnicodeEscape(string6);
        if (!(string6.equals(string15) && string15.indexOf("UE_BS_") < 0 || JFConfigManager.getServerVersion().compareTo("6.1") >= 0)) {
            Object[] objectArray2 = new Object[]{JFResource.getString("Localized_input")};
            String string16 = JFResource.getString("OUTDATED_SERVER_DETECTED");
            MessageFormat messageFormat = new MessageFormat(string16);
            throw new JFIncompatibleIOException(messageFormat.format(objectArray2));
        }
        byte[] byArray = this.createUTF8Content(string15);
        if (byArray == null) {
            throw new NullPointerException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_REQ_NULL"));
        }
        String string17 = this.createHTTPReqHeader(string3, string4, string5, string12, string7, string11, string8, string9, string10, string13, byArray.length);
        if (string17 == null) {
            throw new NullPointerException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_REQ_NULL"));
        }
        if (JFDebug.debugMode) {
            object3 = string17.replaceFirst("JS-Credentials.*\n", "JS-Credentials: ***\n");
            JFDebug.println((String)object3);
            string2 = new String(byArray, "UTF-8").replaceAll("<KRBTGT>([<]*)</KRBTGT>", "<KRBTGT>***</KRBTGT>");
            JFDebug.println(string2);
            System.out.println();
        }
        this.openConnection();
        object3 = new ByteArrayOutputStream();
        ((OutputStream)object3).write(string17.getBytes());
        ((OutputStream)object3).write(byArray);
        ((ByteArrayOutputStream)object3).write(0);
        ((ByteArrayOutputStream)object3).writeTo(this.out);
        this.out.flush();
        string2 = null;
        string2 = this.in.readLine();
        if (string2 == null) {
            throw new IOException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_NO_REPLY"));
        }
        JFDebug.println(string2);
        String string18 = this.in.readLine();
        JFDebug.println(string18);
        if (null == JFConfigManager.getServerVersion()) {
            if (!string18.startsWith("JS-ServerIntVersion:")) {
                JFConfigManager.setServerVersion("5.31", false);
                bl = true;
                if (JFDebug.debugMode) {
                    JFDebug.println("set server version to 5.31 for the first time");
                }
                JFEncryption128.setKey64(true);
            } else {
                string = null;
                int n2 = string18.indexOf(58);
                string = string18.substring(n2 + 1);
                JFConfigManager.setServerVersion(string, false);
                JFDebug.println("set server version to " + string);
                JFEncryption128.setKey64(false);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        string = null;
        String string19 = null;
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).startsWith("HTTP/")) {
            throw new ProtocolException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_INV_HDR"));
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("402")) {
                throw new JFIncompatibleIOException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("OLD_SERVER_VERSION"));
            }
            if (string.equals("403")) {
                throw new JFIncompatibleIOException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("OLD_CLIENT_VERSION"));
            }
            if (!string.equals("200") && stringTokenizer.hasMoreTokens()) {
                object2 = new Character('\u0000');
                string = stringTokenizer.nextToken(((Character)object2).toString());
                JFDebug.println("failed reason" + string + bl);
                if (bl && string.endsWith("ACCESS DENIED")) {
                    bl = false;
                    throw new JFIncompatibleIOException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("OLD_CLIENT_VERSION"));
                }
                JFDebug.println("set error msg" + string);
                string19 = string;
            }
        }
        object2 = new char[1025];
        int n3 = 0;
        JFCharBuffer jFCharBuffer = new JFCharBuffer(1025);
        while ((n3 = this.in.read((char[])object2, 0, 1024)) >= 0) {
            if (JFDebug.debugMode) {
                JFDebug.println(new String((char[])object2));
            }
            jFCharBuffer.append((char[])object2, 0, n3);
        }
        this.releaseConnection();
        char[] cArray = jFCharBuffer.array();
        if (this.m_bEncrypt) {
            try {
                objectArray = this.m_encryption.unmarshallChannel(jFCharBuffer.toString());
                object = Charset.forName("UTF-8");
                cArray = ((Charset)object).decode(ByteBuffer.wrap((byte[])objectArray)).array();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        objectArray = JFUTFConverter.fromUnicodeEscape(cArray, cArray.length);
        if (string19 != null) {
            object = String.valueOf(objectArray);
            if (((String)object).contains("JS_LOGIN_REQUIRED")) {
                throw new JFIncompatibleIOException(JFResource.getString("Login_required_setting_conflict"));
            }
            throw new IOException(JFResource.getString("COMM_ERR") + ": " + JFResource.getString("COMM_HTTP_ERR") + ": " + string19);
        }
        return objectArray;
    }

    private byte[] createUTF8Content(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            if (this.m_bEncrypt && this.m_encryption != null) {
                String string2 = this.m_encryption.marshallChannel(byArray);
                return string2.getBytes();
            }
            return byArray;
        }
        catch (Exception exception) {
            JFDebug.printStackTrace(exception);
            return null;
        }
    }

    private String createHTTPReqHeader(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, int n) {
        String string11;
        if (string == null || string2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string + " " + string2 + " " + "HTTP/1.0");
        stringBuffer.append('\n');
        stringBuffer.append("Content-Length: " + String.valueOf(n));
        stringBuffer.append('\n');
        stringBuffer.append("Content-Owner: " + string3);
        if (string4 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-ClientIntVersion: " + string4);
        }
        if (string5 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-UserName: " + string5);
        }
        if (string7 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-UID: " + string7);
        }
        if (string8 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-GID: " + string8);
        }
        if (string9 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-Credentials: " + string9);
        }
        if (string6 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-Domain: " + string6);
        }
        if (string10 != null) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-EXTERNAL-LOGIN: " + string10);
        }
        if (JFLoginManager.m_isSSOLogin) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-SSO-LOGIN: TRUE");
        }
        if (JFLoginManager.m_isPACLogin) {
            stringBuffer.append('\n');
            stringBuffer.append("JS-PAC-LOGIN: TRUE");
        }
        if (this.m_isJFShutdown) {
            stringBuffer.append('\n');
            stringBuffer.append("JF_Shutdown: TRUE");
        }
        try {
            string11 = this.m_bEncrypt && this.m_encryption != null ? this.m_encryption.marshallChannel(stringBuffer.toString().getBytes()) : stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
        return string11 + "\n\n";
    }

    protected void finalize() throws Throwable {
        this.releaseConnection();
    }
}

